/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import org.opensearch.Version;

public enum SerializationFormat {
    JDK,
    CustomSerializer_2_11;

    private static final Version FIRST_CUSTOM_SERIALIZATION_SUPPORTED_OS_VERSION;
    private static final Version CUSTOM_SERIALIZATION_NO_LONGER_SUPPORTED_OS_VERSION;

    public static SerializationFormat determineFormat(Version version) {
        if (version.onOrAfter(FIRST_CUSTOM_SERIALIZATION_SUPPORTED_OS_VERSION) && version.before(CUSTOM_SERIALIZATION_NO_LONGER_SUPPORTED_OS_VERSION)) {
            return CustomSerializer_2_11;
        }
        return JDK;
    }

    static {
        FIRST_CUSTOM_SERIALIZATION_SUPPORTED_OS_VERSION = Version.V_2_11_0;
        CUSTOM_SERIALIZATION_NO_LONGER_SUPPORTED_OS_VERSION = Version.V_2_14_0;
    }
}

