/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;

public class BackupJobInfosRequestWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "BackupJobInfosRequest:::";
    private final String communicationId;
    private final Instant sendedAtInUtc;

    public BackupJobInfosRequestWebsocketMessage(String communicationId) {
        this(communicationId, TimestampUtil.nowInUtc());
    }

    public BackupJobInfosRequestWebsocketMessage(String communicationId, Instant sendedAtInUtc) {
        this.communicationId = communicationId;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public BackupJobInfosRequestWebsocketMessage(Map<String, Object> msgMap) {
        this(MapUtil.getValueAsString(msgMap, (String)"communicationId", null), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("communicationId", "sendedAt"));
    }

    private Map<String, Object> asMap() {
        return MapUtil.mapOf((Object[])new Object[]{"communicationId", this.communicationId, "sendedAt", TimestampUtil.formatAsIsoInstantString((Instant)this.sendedAtInUtc)});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BackupJobInfosRequestWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new BackupJobInfosRequestWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + BackupJobInfosRequestWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "BackupJobInfosRequestWebsocketMessage{communicationId='" + this.communicationId + "', sendedAtInUtc=" + this.sendedAtInUtc + "}";
    }
}

