/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Optional;

final class CommandLineOptions {
    private final ImmutableList<String> files;
    private final boolean inPlace;
    private final ImmutableRangeSet<Integer> lines;
    private final ImmutableList<Integer> offsets;
    private final ImmutableList<Integer> lengths;
    private final boolean aosp;
    private final boolean version;
    private final boolean help;
    private final boolean stdin;
    private final boolean fixImportsOnly;
    private final boolean sortImports;
    private final boolean removeUnusedImports;
    private final boolean dryRun;
    private final boolean setExitIfChanged;
    private final Optional<String> assumeFilename;
    private final boolean reflowLongStrings;
    private final boolean formatJavadoc;

    CommandLineOptions(ImmutableList<String> files, boolean inPlace, ImmutableRangeSet<Integer> lines, ImmutableList<Integer> offsets, ImmutableList<Integer> lengths, boolean aosp, boolean version, boolean help, boolean stdin, boolean fixImportsOnly, boolean sortImports, boolean removeUnusedImports, boolean dryRun, boolean setExitIfChanged, Optional<String> assumeFilename, boolean reflowLongStrings, boolean formatJavadoc) {
        this.files = files;
        this.inPlace = inPlace;
        this.lines = lines;
        this.offsets = offsets;
        this.lengths = lengths;
        this.aosp = aosp;
        this.version = version;
        this.help = help;
        this.stdin = stdin;
        this.fixImportsOnly = fixImportsOnly;
        this.sortImports = sortImports;
        this.removeUnusedImports = removeUnusedImports;
        this.dryRun = dryRun;
        this.setExitIfChanged = setExitIfChanged;
        this.assumeFilename = assumeFilename;
        this.reflowLongStrings = reflowLongStrings;
        this.formatJavadoc = formatJavadoc;
    }

    ImmutableList<String> files() {
        return this.files;
    }

    boolean inPlace() {
        return this.inPlace;
    }

    ImmutableRangeSet<Integer> lines() {
        return this.lines;
    }

    ImmutableList<Integer> offsets() {
        return this.offsets;
    }

    ImmutableList<Integer> lengths() {
        return this.lengths;
    }

    boolean aosp() {
        return this.aosp;
    }

    boolean version() {
        return this.version;
    }

    boolean help() {
        return this.help;
    }

    boolean stdin() {
        return this.stdin;
    }

    boolean fixImportsOnly() {
        return this.fixImportsOnly;
    }

    boolean sortImports() {
        return this.sortImports;
    }

    boolean removeUnusedImports() {
        return this.removeUnusedImports;
    }

    boolean dryRun() {
        return this.dryRun;
    }

    boolean setExitIfChanged() {
        return this.setExitIfChanged;
    }

    Optional<String> assumeFilename() {
        return this.assumeFilename;
    }

    boolean reflowLongStrings() {
        return this.reflowLongStrings;
    }

    boolean isSelection() {
        return !this.lines().isEmpty() || !this.offsets().isEmpty() || !this.lengths().isEmpty();
    }

    boolean formatJavadoc() {
        return this.formatJavadoc;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private final ImmutableList.Builder<String> files = ImmutableList.builder();
        private final RangeSet<Integer> lines = TreeRangeSet.create();
        private final ImmutableList.Builder<Integer> offsets = ImmutableList.builder();
        private final ImmutableList.Builder<Integer> lengths = ImmutableList.builder();
        private boolean inPlace = false;
        private boolean aosp = false;
        private boolean version = false;
        private boolean help = false;
        private boolean stdin = false;
        private boolean fixImportsOnly = false;
        private boolean sortImports = true;
        private boolean removeUnusedImports = true;
        private boolean dryRun = false;
        private boolean setExitIfChanged = false;
        private Optional<String> assumeFilename = Optional.empty();
        private boolean reflowLongStrings = true;
        private boolean formatJavadoc = true;

        Builder() {
        }

        ImmutableList.Builder<String> filesBuilder() {
            return this.files;
        }

        Builder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        RangeSet<Integer> linesBuilder() {
            return this.lines;
        }

        Builder addOffset(Integer offset) {
            this.offsets.add((Object)offset);
            return this;
        }

        Builder addLength(Integer length) {
            this.lengths.add((Object)length);
            return this;
        }

        Builder aosp(boolean aosp) {
            this.aosp = aosp;
            return this;
        }

        Builder version(boolean version) {
            this.version = version;
            return this;
        }

        Builder help(boolean help) {
            this.help = help;
            return this;
        }

        Builder stdin(boolean stdin) {
            this.stdin = stdin;
            return this;
        }

        Builder fixImportsOnly(boolean fixImportsOnly) {
            this.fixImportsOnly = fixImportsOnly;
            return this;
        }

        Builder sortImports(boolean sortImports) {
            this.sortImports = sortImports;
            return this;
        }

        Builder removeUnusedImports(boolean removeUnusedImports) {
            this.removeUnusedImports = removeUnusedImports;
            return this;
        }

        Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        Builder setExitIfChanged(boolean setExitIfChanged) {
            this.setExitIfChanged = setExitIfChanged;
            return this;
        }

        Builder assumeFilename(String assumeFilename) {
            this.assumeFilename = Optional.of(assumeFilename);
            return this;
        }

        Builder reflowLongStrings(boolean reflowLongStrings) {
            this.reflowLongStrings = reflowLongStrings;
            return this;
        }

        Builder formatJavadoc(boolean formatJavadoc) {
            this.formatJavadoc = formatJavadoc;
            return this;
        }

        CommandLineOptions build() {
            return new CommandLineOptions((ImmutableList<String>)this.files.build(), this.inPlace, (ImmutableRangeSet<Integer>)ImmutableRangeSet.copyOf(this.lines), (ImmutableList<Integer>)this.offsets.build(), (ImmutableList<Integer>)this.lengths.build(), this.aosp, this.version, this.help, this.stdin, this.fixImportsOnly, this.sortImports, this.removeUnusedImports, this.dryRun, this.setExitIfChanged, this.assumeFilename, this.reflowLongStrings, this.formatJavadoc);
        }
    }
}

