/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to;

import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class BroadcastReceivedWebsocketMessageToRequest
extends BaseNodesRequest<BroadcastReceivedWebsocketMessageToRequest> {
    private final String initiatedOnNode;
    private final String websocketId;
    private final String serverUUID;
    private final BroadcastToWebsocketMessage broadcastToWebsocketMessage;

    public BroadcastReceivedWebsocketMessageToRequest(String initiatedOnNode, String websocketId, String serverUUID, BroadcastToWebsocketMessage broadcastToWebsocketMessage) {
        super(new String[0]);
        this.initiatedOnNode = initiatedOnNode;
        this.websocketId = websocketId;
        this.serverUUID = serverUUID;
        this.broadcastToWebsocketMessage = broadcastToWebsocketMessage;
    }

    public BroadcastReceivedWebsocketMessageToRequest(StreamInput in) throws IOException {
        super(in);
        this.initiatedOnNode = in.readString();
        this.websocketId = in.readString();
        this.serverUUID = in.readString();
        this.broadcastToWebsocketMessage = (BroadcastToWebsocketMessage)in.readOptionalWriteable(BroadcastToWebsocketMessage::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.initiatedOnNode);
        out.writeString(this.websocketId);
        out.writeString(this.serverUUID);
        out.writeOptionalWriteable((Writeable)this.broadcastToWebsocketMessage);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.initiatedOnNode == null) {
            validationException = ValidateActions.addValidationError((String)"no 'initiatedOnNode' specified", validationException);
        }
        if (this.websocketId == null) {
            validationException = ValidateActions.addValidationError((String)"no 'websocketId' specified", (ActionRequestValidationException)validationException);
        }
        if (this.serverUUID == null) {
            validationException = ValidateActions.addValidationError((String)"no 'serverUUID' specified", (ActionRequestValidationException)validationException);
        }
        if (this.broadcastToWebsocketMessage == null) {
            validationException = ValidateActions.addValidationError((String)"no 'broadcastToWebsocketMessage' specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getInitiatedOnNode() {
        return this.initiatedOnNode;
    }

    public String getWebsocketId() {
        return this.websocketId;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public BroadcastToWebsocketMessage getBroadcastToWebsocketMessage() {
        return this.broadcastToWebsocketMessage;
    }
}

