/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.paxjdbcfeature;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.paxjdbcfeature.PaxJdbcFeaturesMapping;
import de.virtimo.bpc.paxjdbcfeature.PaxJdbcFeaturesToInstall;
import de.virtimo.bpc.util.StringUtil;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;

public class PaxJdbcFeaturesInstaller
implements BundleListener {
    private static final Logger LOGGER = LogManager.getLogger(PaxJdbcFeaturesInstaller.class);
    private static final String KARAF_PAX_JDBC_FEATURES_TO_INSTALL = "KARAF_PAX_JDBC_FEATURES_TO_INSTALL";
    private final BundleContext bundleContext;
    private PaxJdbcFeaturesToInstall paxJdbcFeaturesToInstall;
    private BpcServicesTracker<FeaturesService> featuresServiceTracker;
    private PaxJdbcFeaturesMapping jdbcDriverClassToFeatureMappings;

    public PaxJdbcFeaturesInstaller(BundleContext bundleContext) {
        LOGGER.info("PaxJdbcFeaturesInstaller bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        String commaSeparatedPaxJdbcFeaturesToInstall = System.getenv(KARAF_PAX_JDBC_FEATURES_TO_INSTALL);
        if (!StringUtil.isNullOrEmpty((String)commaSeparatedPaxJdbcFeaturesToInstall)) {
            LOGGER.info("Provided content of the environment variable '{}' = '{}'", (Object)KARAF_PAX_JDBC_FEATURES_TO_INSTALL, (Object)commaSeparatedPaxJdbcFeaturesToInstall);
            try {
                this.featuresServiceTracker = new BpcServicesTracker(bundleContext, FeaturesService.class);
                this.jdbcDriverClassToFeatureMappings = new PaxJdbcFeaturesMapping("pax_jdbc_mapping.properties");
                this.paxJdbcFeaturesToInstall = new PaxJdbcFeaturesToInstall(commaSeparatedPaxJdbcFeaturesToInstall);
                this.installPaxJdbcFeaturesWithoutCustomJdbcDrivers();
                this.checkAllInstalledBundlesForWrappedJdbcDrivers();
                bundleContext.addBundleListener((BundleListener)this);
            }
            catch (Throwable t) {
                LOGGER.error("Something unexpected went wrong while installing pax-jdbc features.", t);
            }
        } else {
            LOGGER.info("No pax-jdbc features to install given. The environment variable '{}' is not set or empty.", (Object)KARAF_PAX_JDBC_FEATURES_TO_INSTALL);
        }
    }

    public void destroy() {
        LOGGER.info("destroy()");
        BpcServicesTracker.stopAll((Object)this);
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
    }

    private void installPaxJdbcFeaturesWithoutCustomJdbcDrivers() {
        LOGGER.info("installPaxJdbcFeaturesWithoutCustomJdbcDrivers");
        if (this.paxJdbcFeaturesToInstall.hasFeaturesToInstallWithoutCustomJdbcDriver()) {
            for (String featureName : this.paxJdbcFeaturesToInstall.getFeaturesToInstallWithoutCustomJdbcDriver()) {
                this.installPaxJdbcFeature(featureName);
            }
        } else {
            LOGGER.info("Nothing to do, there are no pax-jdbc features to install given without a provided JDBC driver.");
        }
    }

    private void checkAllInstalledBundlesForWrappedJdbcDrivers() {
        LOGGER.info("installPaxJdbcFeaturesWithoutCustomJdbcDrivers");
        if (this.paxJdbcFeaturesToInstall.hasFeaturesToInstallWithCustomJdbcDriver()) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!this.isBundleWithWrappedJdbcDriver(bundle)) continue;
                this.installPaxJdbcFeatureForBundle(bundle);
            }
        } else {
            LOGGER.info("Nothing to do, there are no pax-jdbc features to install given with a provided JDBC driver.");
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        LOGGER.debug("bundleChanged bundleEvent={}", (Object)bundleEvent);
        try {
            Bundle bundle;
            if (this.paxJdbcFeaturesToInstall.hasFeaturesToInstallWithCustomJdbcDriver() && bundleEvent.getType() == 2 && this.isBundleWithWrappedJdbcDriver(bundle = bundleEvent.getBundle())) {
                this.installPaxJdbcFeatureForBundle(bundle);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to process the bundle event: {}", (Object)bundleEvent, (Object)ex);
        }
    }

    private boolean isBundleWithWrappedJdbcDriver(Bundle bundle) {
        LOGGER.debug("isBundleWithWrappedJdbcDriver bundle={}", (Object)bundle);
        try {
            ServiceReference[] registeredServices;
            if (bundle != null && bundle.getBundleId() > 0L && (registeredServices = bundle.getRegisteredServices()) != null) {
                for (ServiceReference ref : registeredServices) {
                    Object driverNameObject;
                    if (!this.isDataSourceFactory(ref) || !((driverNameObject = ref.getProperty("osgi.jdbc.driver.name")) instanceof String) || !((String)driverNameObject).endsWith("-native")) continue;
                    return true;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Bundle check if it is a wrapped jdbc driver failed.", t);
        }
        return false;
    }

    private boolean isDataSourceFactory(ServiceReference<?> ref) {
        Object names = ref.getProperty("objectClass");
        if (names instanceof String && DataSourceFactory.class.getName().equals(names)) {
            return true;
        }
        return names instanceof String[] && DataSourceFactory.class.getName().equals(((String[])names)[0]);
    }

    private void installPaxJdbcFeatureForBundle(Bundle bundle) {
        LOGGER.info("installPaxJdbcFeatureForBundle bundle={}", (Object)bundle);
        try {
            ServiceReference[] registeredServices = bundle.getRegisteredServices();
            if (registeredServices != null) {
                for (ServiceReference ref : registeredServices) {
                    if (!this.isDataSourceFactory(ref)) continue;
                    Object driverClassObject = ref.getProperty("osgi.jdbc.driver.class");
                    String featureName = this.jdbcDriverClassToFeatureMappings.getFeatureName(driverClassObject);
                    if (featureName != null) {
                        if (!this.paxJdbcFeaturesToInstall.getFeaturesToInstallWithCustomJdbcDriver().contains(featureName)) continue;
                        this.installPaxJdbcFeature(featureName);
                        continue;
                    }
                    LOGGER.warn("Please inform the BPC developers that there is a feature mapping missing for the JDBC driver class: {}", driverClassObject);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Bundle processing of a wrapped jdbc driver failed.", t);
        }
    }

    private void installPaxJdbcFeature(String featureName) {
        LOGGER.info("installPaxJdbcFeature featureName={}", (Object)featureName);
        try {
            FeaturesService featuresService = (FeaturesService)this.featuresServiceTracker.getService();
            Feature feature = featuresService.getFeature(featureName);
            if (feature == null) {
                LOGGER.warn("The feature '{}' does not exist and cannot be installed.", (Object)featureName);
            } else if (featuresService.isInstalled(feature)) {
                LOGGER.info("Great, the feature '{}' is already installed.", (Object)featureName);
            } else {
                LOGGER.info("Trying to install the missing feature '{}'.", (Object)featureName);
                featuresService.installFeature(featureName);
            }
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Failed to get the FeaturesService to install pax-jdbc features.", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get or install the pax-jdbc feature '{}'.", (Object)featureName, (Object)ex);
        }
    }
}

