/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.opensearch.action.search.QueryPhaseResultConsumer;
import org.opensearch.action.search.SearchProgressListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.dfs.AggregatedDfs;
import org.opensearch.search.dfs.DfsSearchResult;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.internal.InternalSearchResponse;
import org.opensearch.search.profile.ProfileShardResult;
import org.opensearch.search.profile.SearchProfileShardResults;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.sort.SortedWiderNumericSortField;
import org.opensearch.search.suggest.Suggest;
import org.opensearch.search.suggest.completion.CompletionSuggestion;

public final class SearchPhaseController {
    private static final ScoreDoc[] EMPTY_DOCS = new ScoreDoc[0];
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final Function<SearchSourceBuilder, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder;

    public SearchPhaseController(NamedWriteableRegistry namedWriteableRegistry, Function<SearchSourceBuilder, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder) {
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.requestToAggReduceContextBuilder = requestToAggReduceContextBuilder;
    }

    public AggregatedDfs aggregateDfs(Collection<DfsSearchResult> results) {
        HashMap<Term, TermStatistics> termStatistics = new HashMap<Term, TermStatistics>();
        HashMap<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>();
        long aggMaxDoc = 0L;
        for (DfsSearchResult lEntry : results) {
            Term[] terms = lEntry.terms();
            TermStatistics[] stats = lEntry.termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                if (stats[i] == null) continue;
                TermStatistics existing = (TermStatistics)termStatistics.get(terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals((Object)existing.term()));
                    termStatistics.put(terms[i], new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), existing.totalTermFreq() + stats[i].totalTermFreq()));
                    continue;
                }
                termStatistics.put(terms[i], stats[i]);
            }
            assert (!lEntry.fieldStatistics().containsKey(null));
            for (Map.Entry<String, CollectionStatistics> entry : lEntry.fieldStatistics().entrySet()) {
                String key = entry.getKey();
                CollectionStatistics value = entry.getValue();
                if (value == null) continue;
                assert (key != null);
                CollectionStatistics existing = (CollectionStatistics)fieldStatistics.get(key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), existing.docCount() + value.docCount(), existing.sumTotalTermFreq() + value.sumTotalTermFreq(), existing.sumDocFreq() + value.sumDocFreq());
                    fieldStatistics.put(key, merged);
                    continue;
                }
                fieldStatistics.put(key, value);
            }
            aggMaxDoc += (long)lEntry.maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }

    /*
     * WARNING - void declaration
     */
    static SortedTopDocs sortDocs(boolean ignoreFrom, Collection<TopDocs> topDocs, int from, int size, List<CompletionSuggestion> reducedCompletionSuggestions) {
        void var10_16;
        ScoreDoc[] mergedScoreDocs;
        if (topDocs.isEmpty() && reducedCompletionSuggestions.isEmpty()) {
            return SortedTopDocs.EMPTY;
        }
        TopDocs mergedTopDocs = SearchPhaseController.mergeTopDocs(topDocs, size, ignoreFrom ? 0 : from);
        ScoreDoc[] scoreDocs = mergedScoreDocs = mergedTopDocs == null ? EMPTY_DOCS : mergedTopDocs.scoreDocs;
        if (!reducedCompletionSuggestions.isEmpty()) {
            int numSuggestDocs = 0;
            for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                assert (completionSuggestion != null);
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
            scoreDocs = new ScoreDoc[mergedScoreDocs.length + numSuggestDocs];
            System.arraycopy(mergedScoreDocs, 0, scoreDocs, 0, mergedScoreDocs.length);
            int offset = mergedScoreDocs.length;
            for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                    scoreDocs[offset++] = option.getDoc();
                }
            }
        }
        boolean isSortedByField = false;
        SortField[] sortFields = null;
        Object var10_14 = null;
        Object[] collapseValues = null;
        if (mergedTopDocs instanceof TopFieldDocs) {
            TopFieldDocs fieldDocs = (TopFieldDocs)mergedTopDocs;
            sortFields = fieldDocs.fields;
            if (fieldDocs instanceof CollapseTopFieldDocs) {
                isSortedByField = !(fieldDocs.fields.length == 1 && fieldDocs.fields[0].getType() == SortField.Type.SCORE);
                CollapseTopFieldDocs collapseTopFieldDocs = (CollapseTopFieldDocs)fieldDocs;
                String string = collapseTopFieldDocs.field;
                collapseValues = collapseTopFieldDocs.collapseValues;
            } else {
                isSortedByField = true;
            }
        }
        return new SortedTopDocs(scoreDocs, isSortedByField, sortFields, (String)var10_16, collapseValues);
    }

    static TopDocs mergeTopDocs(Collection<TopDocs> results, int topN, int from) {
        Object mergedTopDocs;
        if (results.isEmpty()) {
            return null;
        }
        TopDocs topDocs = results.stream().findFirst().get();
        int numShards = results.size();
        if (numShards == 1 && from == 0) {
            return topDocs;
        }
        if (topDocs instanceof CollapseTopFieldDocs) {
            TopFieldDocs[] shardTopDocs = results.toArray(new CollapseTopFieldDocs[numShards]);
            Sort sort = SearchPhaseController.createSort(shardTopDocs);
            mergedTopDocs = CollapseTopFieldDocs.merge(sort, from, topN, (CollapseTopFieldDocs[])shardTopDocs, false);
        } else if (topDocs instanceof TopFieldDocs) {
            TopFieldDocs[] shardTopDocs = results.toArray(new TopFieldDocs[numShards]);
            Sort sort = SearchPhaseController.createSort(shardTopDocs);
            mergedTopDocs = TopDocs.merge((Sort)sort, (int)from, (int)topN, (TopFieldDocs[])shardTopDocs);
        } else {
            TopDocs[] shardTopDocs = results.toArray(new TopDocs[numShards]);
            mergedTopDocs = TopDocs.merge((int)from, (int)topN, (TopDocs[])shardTopDocs);
        }
        return mergedTopDocs;
    }

    static void setShardIndex(TopDocs topDocs, int shardIndex) {
        assert (topDocs.scoreDocs.length == 0 || topDocs.scoreDocs[0].shardIndex == -1) : "shardIndex is already set";
        for (ScoreDoc doc : topDocs.scoreDocs) {
            doc.shardIndex = shardIndex;
        }
    }

    public ScoreDoc[] getLastEmittedDocPerShard(ReducedQueryPhase reducedQueryPhase, int numShards) {
        ScoreDoc[] lastEmittedDocPerShard = new ScoreDoc[numShards];
        if (!reducedQueryPhase.isEmptyResult) {
            ScoreDoc[] sortedScoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
            long size = Math.min(reducedQueryPhase.fetchHits, (long)reducedQueryPhase.size);
            size = Math.min((long)sortedScoreDocs.length, size);
            int sortedDocsIndex = 0;
            while ((long)sortedDocsIndex < size) {
                ScoreDoc scoreDoc;
                lastEmittedDocPerShard[scoreDoc.shardIndex] = scoreDoc = sortedScoreDocs[sortedDocsIndex];
                ++sortedDocsIndex;
            }
        }
        return lastEmittedDocPerShard;
    }

    public List<Integer>[] fillDocIdsToLoad(int numShards, ScoreDoc[] shardDocs) {
        List[] docIdsToLoad = new ArrayList[numShards];
        for (ScoreDoc shardDoc : shardDocs) {
            ArrayList<Integer> shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex];
            if (shardDocIdsToLoad == null) {
                shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex] = new ArrayList<Integer>();
            }
            shardDocIdsToLoad.add(shardDoc.doc);
        }
        return docIdsToLoad;
    }

    public InternalSearchResponse merge(boolean ignoreFrom, ReducedQueryPhase reducedQueryPhase, Collection<? extends SearchPhaseResult> fetchResults, IntFunction<SearchPhaseResult> resultsLookup) {
        if (reducedQueryPhase.isEmptyResult) {
            return InternalSearchResponse.empty();
        }
        ScoreDoc[] sortedDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
        SearchHits hits = this.getHits(reducedQueryPhase, ignoreFrom, fetchResults, resultsLookup);
        if (reducedQueryPhase.suggest != null && !fetchResults.isEmpty()) {
            int currentOffset = hits.getHits().length;
            for (CompletionSuggestion suggestion : reducedQueryPhase.suggest.filter(CompletionSuggestion.class)) {
                List<CompletionSuggestion.Entry.Option> suggestionOptions = suggestion.getOptions();
                for (int scoreDocIndex = currentOffset; scoreDocIndex < currentOffset + suggestionOptions.size(); ++scoreDocIndex) {
                    ScoreDoc shardDoc = sortedDocs[scoreDocIndex];
                    SearchPhaseResult searchResultProvider = resultsLookup.apply(shardDoc.shardIndex);
                    if (searchResultProvider == null) continue;
                    FetchSearchResult fetchResult = searchResultProvider.fetchResult();
                    int index = fetchResult.counterGetAndIncrement();
                    assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                    SearchHit hit = fetchResult.hits().getHits()[index];
                    CompletionSuggestion.Entry.Option suggestOption = suggestionOptions.get(scoreDocIndex - currentOffset);
                    hit.score(shardDoc.score);
                    hit.shard(fetchResult.getSearchShardTarget());
                    suggestOption.setHit(hit);
                }
                currentOffset += suggestionOptions.size();
            }
            assert (currentOffset == sortedDocs.length) : "expected no more score doc slices";
        }
        return reducedQueryPhase.buildResponse(hits);
    }

    /*
     * WARNING - void declaration
     */
    private SearchHits getHits(ReducedQueryPhase reducedQueryPhase, boolean ignoreFrom, Collection<? extends SearchPhaseResult> fetchResults, IntFunction<SearchPhaseResult> resultsLookup) {
        SortedTopDocs sortedTopDocs = reducedQueryPhase.sortedTopDocs;
        int sortScoreIndex = -1;
        if (sortedTopDocs.isSortedByField) {
            void var8_10;
            SortField[] sortFields = sortedTopDocs.sortFields;
            boolean bl = false;
            while (var8_10 < sortFields.length) {
                if (sortFields[var8_10].getType() == SortField.Type.SCORE) {
                    sortScoreIndex = var8_10;
                }
                ++var8_10;
            }
        }
        for (SearchPhaseResult searchPhaseResult : fetchResults) {
            searchPhaseResult.fetchResult().initCounter();
        }
        int from = ignoreFrom ? 0 : reducedQueryPhase.from;
        int n2 = (int)Math.min(reducedQueryPhase.fetchHits - (long)from, (long)reducedQueryPhase.size);
        n2 = Math.min(sortedTopDocs.scoreDocs.length, n2);
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        if (!fetchResults.isEmpty()) {
            for (int i = 0; i < n2; ++i) {
                ScoreDoc shardDoc = sortedTopDocs.scoreDocs[i];
                SearchPhaseResult fetchResultProvider = resultsLookup.apply(shardDoc.shardIndex);
                if (fetchResultProvider == null) continue;
                FetchSearchResult fetchResult = fetchResultProvider.fetchResult();
                int index = fetchResult.counterGetAndIncrement();
                assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                SearchHit searchHit = fetchResult.hits().getHits()[index];
                searchHit.shard(fetchResult.getSearchShardTarget());
                if (sortedTopDocs.isSortedByField) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields, reducedQueryPhase.sortValueFormats);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                } else {
                    searchHit.score(shardDoc.score);
                }
                hits.add(searchHit);
            }
        }
        return new SearchHits(hits.toArray(new SearchHit[0]), reducedQueryPhase.totalHits, reducedQueryPhase.maxScore, sortedTopDocs.sortFields, sortedTopDocs.collapseField, sortedTopDocs.collapseValues);
    }

    ReducedQueryPhase reducedScrollQueryPhase(Collection<? extends SearchPhaseResult> queryResults) {
        InternalAggregation.ReduceContextBuilder aggReduceContextBuilder = new InternalAggregation.ReduceContextBuilder(){

            @Override
            public InternalAggregation.ReduceContext forPartialReduction() {
                throw new UnsupportedOperationException("Scroll requests don't have aggs");
            }

            @Override
            public InternalAggregation.ReduceContext forFinalReduction() {
                throw new UnsupportedOperationException("Scroll requests don't have aggs");
            }
        };
        TopDocsStats topDocsStats = new TopDocsStats(Integer.MAX_VALUE);
        ArrayList<TopDocs> topDocs = new ArrayList<TopDocs>();
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            QuerySearchResult queryResult = searchPhaseResult.queryResult();
            TopDocsAndMaxScore td = queryResult.consumeTopDocs();
            assert (td != null);
            topDocsStats.add(td, queryResult.searchTimedOut(), queryResult.terminatedEarly());
            if (td.topDocs.scoreDocs.length <= 0) continue;
            SearchPhaseController.setShardIndex(td.topDocs, queryResult.getShardIndex());
            topDocs.add(td.topDocs);
        }
        return this.reducedQueryPhase(queryResults, Collections.emptyList(), topDocs, topDocsStats, 0, true, aggReduceContextBuilder, true);
    }

    ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, List<InternalAggregations> bufferedAggs, List<TopDocs> bufferedTopDocs, TopDocsStats topDocsStats, int numReducePhases, boolean isScrollRequest, InternalAggregation.ReduceContextBuilder aggReduceContextBuilder, boolean performFinalReduce) {
        List<CompletionSuggestion> reducedCompletionSuggestions;
        Suggest reducedSuggest;
        assert (numReducePhases >= 0) : "num reduce phases must be >= 0 but was: " + numReducePhases;
        ++numReducePhases;
        if (queryResults.isEmpty()) {
            TotalHits totalHits = topDocsStats.getTotalHits();
            return new ReducedQueryPhase(totalHits, topDocsStats.fetchHits, topDocsStats.getMaxScore(), false, null, null, null, null, SortedTopDocs.EMPTY, null, numReducePhases, 0, 0, true);
        }
        int total = queryResults.size();
        queryResults = queryResults.stream().filter(res -> !res.queryResult().isNull()).collect(Collectors.toList());
        String errorMsg = "must have at least one non-empty search result, got 0 out of " + total;
        assert (!queryResults.isEmpty()) : errorMsg;
        if (queryResults.isEmpty()) {
            throw new IllegalStateException(errorMsg);
        }
        SearchPhaseController.validateMergeSortValueFormats(queryResults);
        QuerySearchResult firstResult = ((SearchPhaseResult)((Object)queryResults.stream().findFirst().get())).queryResult();
        boolean hasSuggest = firstResult.suggest() != null;
        boolean hasProfileResults = firstResult.hasProfileResults();
        HashMap<String, List<Suggest.Suggestion>> groupedSuggestions = hasSuggest ? new HashMap<String, List<Suggest.Suggestion>>() : Collections.emptyMap();
        HashMap<String, ProfileShardResult> profileResults = hasProfileResults ? new HashMap<String, ProfileShardResult>(queryResults.size()) : Collections.emptyMap();
        int from = 0;
        int size = 0;
        for (SearchPhaseResult entry : queryResults) {
            QuerySearchResult result = entry.queryResult();
            from = result.from();
            size = Math.max(result.size(), size);
            if (hasSuggest) {
                assert (result.suggest() != null);
                for (Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion : result.suggest()) {
                    List suggestionList = groupedSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList());
                    suggestionList.add(suggestion);
                    if (!(suggestion instanceof CompletionSuggestion)) continue;
                    CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggestion;
                    completionSuggestion.setShardIndex(result.getShardIndex());
                }
            }
            if (!bufferedTopDocs.isEmpty()) assert (result.hasConsumedTopDocs()) : "firstResult has no aggs but we got non null buffered aggs?";
            if (!hasProfileResults) continue;
            String key = result.getSearchShardTarget().toString();
            profileResults.put(key, result.consumeProfileResult());
        }
        if (groupedSuggestions.isEmpty()) {
            reducedSuggest = null;
            reducedCompletionSuggestions = Collections.emptyList();
        } else {
            reducedSuggest = new Suggest(Suggest.reduce(groupedSuggestions));
            reducedCompletionSuggestions = reducedSuggest.filter(CompletionSuggestion.class);
        }
        InternalAggregations aggregations = SearchPhaseController.reduceAggs(aggReduceContextBuilder, performFinalReduce, bufferedAggs);
        SearchProfileShardResults shardResults = profileResults.isEmpty() ? null : new SearchProfileShardResults(profileResults);
        SortedTopDocs sortedTopDocs = SearchPhaseController.sortDocs(isScrollRequest, bufferedTopDocs, from, size, reducedCompletionSuggestions);
        TotalHits totalHits = topDocsStats.getTotalHits();
        return new ReducedQueryPhase(totalHits, topDocsStats.fetchHits, topDocsStats.getMaxScore(), topDocsStats.timedOut, topDocsStats.terminatedEarly, reducedSuggest, aggregations, shardResults, sortedTopDocs, firstResult.sortValueFormats(), numReducePhases, size, from, false);
    }

    private static InternalAggregations reduceAggs(InternalAggregation.ReduceContextBuilder aggReduceContextBuilder, boolean performFinalReduce, List<InternalAggregations> toReduce) {
        return toReduce.isEmpty() ? null : InternalAggregations.topLevelReduce(toReduce, performFinalReduce ? aggReduceContextBuilder.forFinalReduction() : aggReduceContextBuilder.forPartialReduction());
    }

    private static void validateMergeSortValueFormats(Collection<? extends SearchPhaseResult> queryResults) {
        boolean[] ulFormats = null;
        boolean firstResult = true;
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            int i;
            DocValueFormat[] formats = searchPhaseResult.queryResult().sortValueFormats();
            if (formats == null) {
                return;
            }
            if (firstResult) {
                firstResult = false;
                ulFormats = new boolean[formats.length];
                for (i = 0; i < formats.length; ++i) {
                    ulFormats[i] = formats[i] == DocValueFormat.UNSIGNED_LONG_SHIFTED || formats[i] == DocValueFormat.UNSIGNED_LONG;
                }
                continue;
            }
            for (i = 0; i < formats.length; ++i) {
                if (!(ulFormats[i] ^ (formats[i] == DocValueFormat.UNSIGNED_LONG_SHIFTED || formats[i] == DocValueFormat.UNSIGNED_LONG))) continue;
                throw new IllegalArgumentException("Can't do sort across indices, as a field has [unsigned_long] type in one index, and different type in another index!");
            }
        }
    }

    private static Sort createSort(TopFieldDocs[] topFieldDocs) {
        SortField[] firstTopDocFields = topFieldDocs[0].fields;
        SortField[] newFields = new SortField[firstTopDocFields.length];
        for (int fieldIndex = 0; fieldIndex < firstTopDocFields.length; ++fieldIndex) {
            SortField.Type firstType = SearchPhaseController.getSortType(firstTopDocFields[fieldIndex]);
            newFields[fieldIndex] = firstTopDocFields[fieldIndex];
            if (!SortedWiderNumericSortField.isTypeSupported(firstType)) continue;
            boolean requireWiden = false;
            boolean isFloat = firstType == SortField.Type.FLOAT || firstType == SortField.Type.DOUBLE;
            for (int shardIndex = 1; shardIndex < topFieldDocs.length; ++shardIndex) {
                SortField sortField = topFieldDocs[shardIndex].fields[fieldIndex];
                SortField.Type sortType = SearchPhaseController.getSortType(sortField);
                if (!SortedWiderNumericSortField.isTypeSupported(sortType)) {
                    requireWiden = false;
                    break;
                }
                requireWiden = requireWiden || sortType != firstType;
                isFloat = isFloat || sortType == SortField.Type.FLOAT || sortType == SortField.Type.DOUBLE;
            }
            if (!requireWiden) continue;
            newFields[fieldIndex] = new SortedWiderNumericSortField(firstTopDocFields[fieldIndex].getField(), isFloat ? SortField.Type.DOUBLE : SortField.Type.LONG, firstTopDocFields[fieldIndex].getReverse());
        }
        return new Sort(newFields);
    }

    private static SortField.Type getSortType(SortField sortField) {
        if (sortField.getComparatorSource() instanceof IndexFieldData.XFieldComparatorSource) {
            return ((IndexFieldData.XFieldComparatorSource)sortField.getComparatorSource()).reducedType();
        }
        return sortField instanceof SortedNumericSortField ? ((SortedNumericSortField)sortField).getNumericType() : sortField.getType();
    }

    static int getTopDocsSize(SearchRequest request) {
        if (request.source() == null) {
            return 10;
        }
        SearchSourceBuilder source = request.source();
        return (source.size() == -1 ? 10 : source.size()) + (source.from() == -1 ? 0 : source.from());
    }

    InternalAggregation.ReduceContextBuilder getReduceContext(SearchRequest request) {
        return this.requestToAggReduceContextBuilder.apply(request.source());
    }

    QueryPhaseResultConsumer newSearchPhaseResults(Executor executor, CircuitBreaker circuitBreaker, SearchProgressListener listener, SearchRequest request, int numShards, Consumer<Exception> onPartialMergeFailure) {
        return new QueryPhaseResultConsumer(request, executor, circuitBreaker, this, listener, this.namedWriteableRegistry, numShards, onPartialMergeFailure);
    }

    static final class SortedTopDocs {
        static final SortedTopDocs EMPTY = new SortedTopDocs(EMPTY_DOCS, false, null, null, null);
        final ScoreDoc[] scoreDocs;
        final boolean isSortedByField;
        final SortField[] sortFields;
        final String collapseField;
        final Object[] collapseValues;

        SortedTopDocs(ScoreDoc[] scoreDocs, boolean isSortedByField, SortField[] sortFields, String collapseField, Object[] collapseValues) {
            this.scoreDocs = scoreDocs;
            this.isSortedByField = isSortedByField;
            this.sortFields = sortFields;
            this.collapseField = collapseField;
            this.collapseValues = collapseValues;
        }
    }

    public static final class ReducedQueryPhase {
        final TotalHits totalHits;
        final long fetchHits;
        final float maxScore;
        final boolean timedOut;
        final Boolean terminatedEarly;
        final Suggest suggest;
        final InternalAggregations aggregations;
        final SearchProfileShardResults shardResults;
        final int numReducePhases;
        final SortedTopDocs sortedTopDocs;
        final int size;
        final boolean isEmptyResult;
        final int from;
        final DocValueFormat[] sortValueFormats;

        ReducedQueryPhase(TotalHits totalHits, long fetchHits, float maxScore, boolean timedOut, Boolean terminatedEarly, Suggest suggest, InternalAggregations aggregations, SearchProfileShardResults shardResults, SortedTopDocs sortedTopDocs, DocValueFormat[] sortValueFormats, int numReducePhases, int size, int from, boolean isEmptyResult) {
            if (numReducePhases <= 0) {
                throw new IllegalArgumentException("at least one reduce phase must have been applied but was: " + numReducePhases);
            }
            this.totalHits = totalHits;
            this.fetchHits = fetchHits;
            this.maxScore = maxScore;
            this.timedOut = timedOut;
            this.terminatedEarly = terminatedEarly;
            this.suggest = suggest;
            this.aggregations = aggregations;
            this.shardResults = shardResults;
            this.numReducePhases = numReducePhases;
            this.sortedTopDocs = sortedTopDocs;
            this.size = size;
            this.from = from;
            this.isEmptyResult = isEmptyResult;
            this.sortValueFormats = sortValueFormats;
        }

        public InternalSearchResponse buildResponse(SearchHits hits) {
            return new InternalSearchResponse(hits, this.aggregations, this.suggest, this.shardResults, this.timedOut, this.terminatedEarly, this.numReducePhases);
        }
    }

    static final class TopDocsStats {
        final int trackTotalHitsUpTo;
        long totalHits;
        private TotalHits.Relation totalHitsRelation;
        long fetchHits;
        private float maxScore = Float.NEGATIVE_INFINITY;
        boolean timedOut;
        Boolean terminatedEarly;

        TopDocsStats(int trackTotalHitsUpTo) {
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            this.totalHits = 0L;
            this.totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        }

        float getMaxScore() {
            return Float.isInfinite(this.maxScore) ? Float.NaN : this.maxScore;
        }

        TotalHits getTotalHits() {
            if (this.trackTotalHitsUpTo == -1) {
                return null;
            }
            if (this.trackTotalHitsUpTo == Integer.MAX_VALUE) {
                assert (this.totalHitsRelation == TotalHits.Relation.EQUAL_TO);
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            if (this.totalHits <= (long)this.trackTotalHitsUpTo) {
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            return new TotalHits((long)this.trackTotalHitsUpTo, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
        }

        void add(TopDocsAndMaxScore topDocs, boolean timedOut, Boolean terminatedEarly) {
            if (this.trackTotalHitsUpTo != -1) {
                this.totalHits += topDocs.topDocs.totalHits.value;
                if (topDocs.topDocs.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                    this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                }
            }
            this.fetchHits += (long)topDocs.topDocs.scoreDocs.length;
            if (!Float.isNaN(topDocs.maxScore)) {
                this.maxScore = Math.max(this.maxScore, topDocs.maxScore);
            }
            if (timedOut) {
                this.timedOut = true;
            }
            if (terminatedEarly != null) {
                if (this.terminatedEarly == null) {
                    this.terminatedEarly = terminatedEarly;
                } else if (terminatedEarly.booleanValue()) {
                    this.terminatedEarly = true;
                }
            }
        }
    }
}

