/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.inject.Provider;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.IndexStoreListener;
import org.opensearch.index.store.remote.filecache.FileCache;

public class FileCacheCleaner
implements IndexStoreListener {
    private static final Logger logger = LogManager.getLogger(FileCacheCleaner.class);
    private final Provider<FileCache> fileCacheProvider;

    public FileCacheCleaner(Provider<FileCache> fileCacheProvider) {
        this.fileCacheProvider = fileCacheProvider;
    }

    @Override
    public void beforeShardPathDeleted(ShardId shardId, IndexSettings indexSettings, NodeEnvironment nodeEnvironment) {
        if (indexSettings.isRemoteSnapshot()) {
            ShardPath shardPath = ShardPath.loadFileCachePath(nodeEnvironment, shardId);
            this.cleanupShardFileCache(shardPath);
            this.deleteShardFileCacheDirectory(shardPath);
        }
    }

    private void cleanupShardFileCache(ShardPath shardPath) {
        try {
            FileCache fc = this.fileCacheProvider.get();
            assert (fc != null);
            Path localStorePath = shardPath.getDataPath().resolve("RemoteLocalStore");
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(localStorePath);){
                for (Path subPath : ds) {
                    fc.remove(subPath.toRealPath(new LinkOption[0]));
                }
            }
        }
        catch (IOException ioe) {
            logger.error(() -> new ParameterizedMessage("Error removing items from cache during shard deletion {}", (Object)shardPath.getShardId()), (Throwable)ioe);
        }
    }

    private void deleteShardFileCacheDirectory(ShardPath shardPath) {
        Path path = shardPath.getDataPath();
        try {
            if (Files.exists(path, new LinkOption[0])) {
                IOUtils.rm((Path[])new Path[]{path});
            }
        }
        catch (IOException e) {
            logger.error(() -> new ParameterizedMessage("Failed to delete cache path for shard {}", (Object)shardPath.getShardId()), (Throwable)e);
        }
    }

    @Override
    public void beforeIndexPathDeleted(Index index, IndexSettings indexSettings, NodeEnvironment nodeEnvironment) {
        Path indexCachePath;
        if (indexSettings.isRemoteSnapshot() && Files.exists(indexCachePath = nodeEnvironment.fileCacheNodePath().fileCachePath.resolve(index.getUUID()), new LinkOption[0])) {
            try {
                IOUtils.rm((Path[])new Path[]{indexCachePath});
            }
            catch (IOException e) {
                logger.error(() -> new ParameterizedMessage("Failed to delete cache path for index {}", (Object)index), (Throwable)e);
            }
        }
    }
}

