/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionEntryDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class BackupJobScheduleActionDTO
implements OpenSearchPluginDTO,
Iterable<BackupJobScheduleActionEntryDTO> {
    private final String initiatedOnServerUUID;
    private final String initiatedByUser;
    private final List<BackupJobScheduleActionEntryDTO> entries;

    public BackupJobScheduleActionDTO(String initiatedOnServerUUID, String initiatedByUser) {
        Objects.requireNonNull(initiatedOnServerUUID, "initiatedOnServerUUID cannot be null");
        this.initiatedOnServerUUID = initiatedOnServerUUID;
        this.initiatedByUser = initiatedByUser;
        this.entries = new ArrayList<BackupJobScheduleActionEntryDTO>();
    }

    public BackupJobScheduleActionDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"initiatedOnServerUUID", null), MapUtil.getValueAsString(actionMap, (String)"initiatedByUser", null));
        this.checkForWellKnownKeys(actionMap);
        this.entries.addAll(MapUtil.getArrayValueAsListOfObjects(actionMap, (String)"entries", BackupJobScheduleActionEntryDTO.class));
    }

    private void checkForWellKnownKeys(Map<String, Object> actionMap) {
        MapUtil.checkForWellKnownKeys(actionMap, Set.of("initiatedOnServerUUID", "initiatedByUser", "entries"));
    }

    public BackupJobScheduleActionDTO(StreamInput in) throws IOException {
        this(in.readString(), in.readOptionalString());
        this.entries.addAll(in.readList(BackupJobScheduleActionEntryDTO::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.initiatedOnServerUUID);
        out.writeOptionalString(this.initiatedByUser);
        out.writeList(this.entries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("initiatedOnServerUUID", this.initiatedOnServerUUID);
        builder.field("initiatedByUser", this.initiatedByUser);
        builder.startArray("entries");
        for (BackupJobScheduleActionEntryDTO entry : this.entries) {
            entry.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public BackupJobScheduleActionDTO fromXContent(XContentParser parser) throws IOException {
        return new BackupJobScheduleActionDTO(parser.map());
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public BackupJobScheduleActionEntryDTO get(int index) {
        return this.entries.get(index);
    }

    public List<BackupJobScheduleActionEntryDTO> getEntries() {
        return new ArrayList<BackupJobScheduleActionEntryDTO>(this.entries);
    }

    public BackupJobScheduleActionEntryDTO getEntryForBackupJobIdentifier(String backupJobIdentifier) {
        if (backupJobIdentifier != null) {
            for (BackupJobScheduleActionEntryDTO entry : this.entries) {
                if (!backupJobIdentifier.equals(entry.getBackupJobIdentifier())) continue;
                return entry;
            }
        }
        return null;
    }

    public void setEntry(String backupJobIdentifier, Map<String, Object> backupSetting) {
        this.setEntry(new BackupJobScheduleActionEntryDTO(backupJobIdentifier, backupSetting));
    }

    public void setEntry(BackupJobScheduleActionEntryDTO entry) {
        if (entry != null) {
            BackupJobScheduleActionEntryDTO existingEntries = this.getEntryForBackupJobIdentifier(entry.getBackupJobIdentifier());
            if (existingEntries != null && existingEntries.equals(entry)) {
                return;
            }
            if (existingEntries != null) {
                this.entries.remove(existingEntries);
            }
            this.entries.add(entry);
        }
    }

    public String getInitiatedOnServerUUID() {
        return this.initiatedOnServerUUID;
    }

    public boolean isInitiatedByUser() {
        return !StringUtil.isNullOrEmpty((String)this.initiatedByUser);
    }

    public String getInitiatedByUser() {
        return this.initiatedByUser;
    }

    @Override
    public Iterator<BackupJobScheduleActionEntryDTO> iterator() {
        return this.entries.iterator();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobScheduleActionDTO that = (BackupJobScheduleActionDTO)o;
        return Objects.equals(this.initiatedOnServerUUID, that.initiatedOnServerUUID) && Objects.equals(this.initiatedByUser, that.initiatedByUser) && Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.initiatedOnServerUUID, this.initiatedByUser, this.entries);
    }

    public String toString() {
        return "BackupJobScheduleActionDTO{initiatedOnServerUUID='" + this.initiatedOnServerUUID + "', initiatedByUser='" + this.initiatedByUser + "', entries=" + this.entries + "}";
    }
}

