/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.EventHandlerEvent;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.Broadcast;
import java.lang.reflect.Field;
import java.util.Dictionary;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;

public interface EventManager {
    public static final Logger LOGGER = LogManager.getLogger(EventManager.class);

    public void fireEvent(String var1, EventHandlerEvent var2);

    public void fireEvent(String var1, Map<String, ?> var2);

    @Deprecated(since="4.2.11", forRemoval=true)
    public void fireEvent(String var1, Dictionary<String, ?> var2);

    public void fireEvent(String var1, String var2, Object var3);

    public void fireMaintenanceModeAcknowledgedEvent(String var1, String var2);

    public Broadcast broadcast() throws ServiceNotFoundException;

    public static void unregisterAllEventHandler(Object from) {
        if (from != null) {
            EventManager.unregisterAllEventHandler(from, from.getClass());
        }
    }

    public static void unregisterAllEventHandler(Object from, Class<?> clazz) {
        if (from != null && clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(from);
                    if (!(fieldValue instanceof ServiceRegistration)) continue;
                    ServiceRegistration serviceRegistration = (ServiceRegistration)fieldValue;
                    EventManager.unregisterEventHandler(serviceRegistration);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to unregister the event handler: {} ({})", (Object)field, from);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterEventHandler(ServiceRegistration serviceRegistration) {
        if (serviceRegistration != null) {
            boolean canBeUnregistered = false;
            ServiceReference serviceRegistrationReference = serviceRegistration.getReference();
            if (serviceRegistrationReference != null) {
                BundleContext bundleContext = null;
                try {
                    bundleContext = serviceRegistrationReference.getBundle().getBundleContext();
                    Object service = bundleContext.getService(serviceRegistrationReference);
                    if (service instanceof EventHandler) {
                        canBeUnregistered = true;
                    }
                }
                finally {
                    if (bundleContext != null) {
                        bundleContext.ungetService(serviceRegistrationReference);
                    }
                }
            }
            if (canBeUnregistered) {
                serviceRegistration.unregister();
            }
        }
    }
}

