/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WebsocketRecipients {
    public static final String JSON_ID = "_websocketRecipients";
    public static final String TYPE_USERS = "users";
    public static final String TYPE_ROLES = "roles";
    public static final String TYPE_ORGANIZATIONS = "organizations";
    private Set<String> users = new HashSet<String>();
    private Set<String> roles = new HashSet<String>();
    private Set<String> organizations = new HashSet<String>();

    public WebsocketRecipients() {
    }

    public WebsocketRecipients(Map<String, Object> map) {
        this();
        if (map != null) {
            Object organizationsObject;
            Object rolesObject;
            Object usersObject = map.get(TYPE_USERS);
            if (usersObject instanceof Collection) {
                this.users.addAll((Collection)usersObject);
            }
            if ((rolesObject = map.get(TYPE_ROLES)) instanceof Collection) {
                this.roles.addAll((Collection)rolesObject);
            }
            if ((organizationsObject = map.get(TYPE_ORGANIZATIONS)) instanceof Collection) {
                this.organizations.addAll((Collection)organizationsObject);
            }
        }
    }

    public boolean isEmpty() {
        return this.users.isEmpty() && this.roles.isEmpty() && this.organizations.isEmpty();
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public WebsocketRecipients addUser(String user) {
        this.users.add(user);
        return this;
    }

    public WebsocketRecipients addUsers(Collection<String> users) {
        if (users != null) {
            this.users.addAll(users);
        }
        return this;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public WebsocketRecipients addRole(String role) {
        this.roles.add(role);
        return this;
    }

    public WebsocketRecipients addRoles(Collection<String> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
        return this;
    }

    public Set<String> getOrganizations() {
        return this.organizations;
    }

    public WebsocketRecipients addOrganization(String organization) {
        this.organizations.add(organization);
        return this;
    }

    public WebsocketRecipients addOrganizations(Collection<String> organizations) {
        if (organizations != null) {
            this.organizations.addAll(organizations);
        }
        return this;
    }

    public Map<String, Set<String>> asMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put(TYPE_USERS, new HashSet<String>(this.users));
        result.put(TYPE_ROLES, new HashSet<String>(this.roles));
        result.put(TYPE_ORGANIZATIONS, new HashSet<String>(this.organizations));
        return result;
    }

    public String toString() {
        return "WebsocketRecipients{users=" + this.users + ", roles=" + this.roles + ", organizations=" + this.organizations + "}";
    }
}

