/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.backup;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnapshotName {
    private static final DateTimeFormatter TIMESTAMP_WITHOUT_MILLISECONDS_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").withZone(ZoneOffset.systemDefault());
    private static final DateTimeFormatter TIMESTAMP_WITH_MILLISECONDS_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss_SSS").withZone(ZoneOffset.systemDefault());
    private static final DateTimeFormatter UTC_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss_SSS'z'").withZone(ZoneOffset.UTC);
    private final String prefixPart;
    private final String namePart;
    private final String createdDatePart;
    private final Instant createdDate;

    public static SnapshotName createForName(String name) {
        return new SnapshotName("snapshot", name, UTC_TIMESTAMP_FORMATTER.format(Instant.now()), DetectedDateTimeFormat.UTC_TIMESTAMP);
    }

    public static SnapshotName parse(String snapshotNameAsString) {
        SnapshotName snapshotName = null;
        if (snapshotName == null) {
            snapshotName = SnapshotName.parse(snapshotNameAsString, "^([^-]+)-(.+)-([0-9]{8}-[0-9]{6}_[0-9]{1,3}z)$", DetectedDateTimeFormat.UTC_TIMESTAMP);
        }
        if (snapshotName == null) {
            snapshotName = SnapshotName.parse(snapshotNameAsString, "^([^-]+)-(.+)-([0-9]{8}-[0-9]{6}_[0-9]{1,3})$", DetectedDateTimeFormat.LOCAL_TIMESTAMP_WITH_MILLISECONDS);
        }
        if (snapshotName == null) {
            snapshotName = SnapshotName.parse(snapshotNameAsString, "^([^-]+)-(.+)-([0-9]{8}-[0-9]{6})$", DetectedDateTimeFormat.LOCAL_TIMESTAMP_WITHOUT_MILLISECONDS);
        }
        if (snapshotName != null) {
            return snapshotName;
        }
        throw new IllegalArgumentException("Invalid BPC related OpenSearch snapshot name: " + snapshotNameAsString);
    }

    private static SnapshotName parse(String snapshotName, String regex, DetectedDateTimeFormat detectedDateTimeFormat) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(snapshotName);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            String name = matcher.group(2);
            String createdDate = matcher.group(3);
            return new SnapshotName(prefix, name, createdDate, detectedDateTimeFormat);
        }
        return null;
    }

    SnapshotName(String prefix, String name, String createdDate, DetectedDateTimeFormat detectedDateTimeFormat) {
        this.prefixPart = prefix;
        this.namePart = name;
        this.createdDatePart = createdDate;
        this.createdDate = SnapshotName.parseCreatedDatePart(createdDate, detectedDateTimeFormat);
    }

    static Instant parseCreatedDatePart(String createdDatePart, DetectedDateTimeFormat detectedDateTimeFormat) {
        return switch (detectedDateTimeFormat) {
            default -> throw new IncompatibleClassChangeError();
            case DetectedDateTimeFormat.UTC_TIMESTAMP -> ZonedDateTime.parse(createdDatePart, UTC_TIMESTAMP_FORMATTER).toInstant();
            case DetectedDateTimeFormat.LOCAL_TIMESTAMP_WITH_MILLISECONDS -> ZonedDateTime.parse(createdDatePart, TIMESTAMP_WITH_MILLISECONDS_FORMATTER).toInstant();
            case DetectedDateTimeFormat.LOCAL_TIMESTAMP_WITHOUT_MILLISECONDS -> ZonedDateTime.parse(createdDatePart, TIMESTAMP_WITHOUT_MILLISECONDS_FORMATTER).toInstant();
        };
    }

    public String getPrefixPart() {
        return this.prefixPart;
    }

    public String getPrefix() {
        return this.prefixPart + "-" + this.namePart + "-";
    }

    public boolean hasPrefix(String snapshotNamePrefix) {
        return this.asString().startsWith(snapshotNamePrefix);
    }

    public String getNamePart() {
        return this.namePart;
    }

    public String getCreatedDatePart() {
        return this.createdDatePart;
    }

    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public String asString() {
        return this.getPrefix() + this.createdDatePart;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotName that = (SnapshotName)o;
        return Objects.equals(this.prefixPart, that.prefixPart) && Objects.equals(this.namePart, that.namePart) && Objects.equals(this.createdDatePart, that.createdDatePart) && Objects.equals(this.createdDate, that.createdDate);
    }

    public int hashCode() {
        return Objects.hash(this.prefixPart, this.namePart, this.createdDatePart, this.createdDate);
    }

    public String toString() {
        return this.asString();
    }

    static enum DetectedDateTimeFormat {
        UTC_TIMESTAMP,
        LOCAL_TIMESTAMP_WITH_MILLISECONDS,
        LOCAL_TIMESTAMP_WITHOUT_MILLISECONDS;

    }
}

