/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.exception;

import de.virtimo.bpc.api.WebErrorCode;
import javax.ws.rs.core.Response;

public enum BpcErrorCode implements WebErrorCode
{
    MAINTENANCE_MODE_ENABLED(2, Response.Status.SERVICE_UNAVAILABLE),
    JSON_GENERATION_FAILED(5, Response.Status.INTERNAL_SERVER_ERROR),
    SERVICE_NOT_FOUND(6, Response.Status.NOT_FOUND),
    FRONTEND_WARNING(8, Response.Status.ACCEPTED),
    MODULE_NOT_FOUND(20, Response.Status.NOT_FOUND),
    MODULE_INSTANCE_NOT_FOUND(21, Response.Status.NOT_FOUND),
    MODULE_INSTANCE_EXISTS_ALREADY(22, Response.Status.INTERNAL_SERVER_ERROR),
    MODULE_INSTANCE_CREATE_FAILED(23, Response.Status.INTERNAL_SERVER_ERROR),
    MODULE_NOT_INSTANTIABLE(24, Response.Status.NOT_ACCEPTABLE),
    MODULE_CONFIGURATION_MISSING(25, Response.Status.NOT_FOUND),
    AUTHENTICATION_APIKEY_PROBLEM(541, Response.Status.UNAUTHORIZED),
    VALIDATION_MISSING_INPUT(10000, Response.Status.BAD_REQUEST),
    VALIDATION_INVALID_INPUT(10010, Response.Status.BAD_REQUEST),
    DATABASE_DATASOURCE_NOT_FOUND(11010, Response.Status.NOT_FOUND),
    OPENSEARCH_FAILED(7, Response.Status.INTERNAL_SERVER_ERROR),
    OPENSEARCH_EXCEPTION(12000, Response.Status.INTERNAL_SERVER_ERROR),
    OPENSEARCH_MAPPING(12010, Response.Status.INTERNAL_SERVER_ERROR),
    OPENSEARCH_INDEX_NOT_FOUND(12020, Response.Status.NOT_FOUND),
    OPENSEARCH_INDEX_MAPPING_NOT_FOUND(12030, Response.Status.NOT_FOUND),
    BACKUP_REPOSITORY_NOT_FOUND(25000, Response.Status.NOT_FOUND),
    BACKUP_NOT_FOUND(25010, Response.Status.NOT_FOUND),
    BACKUP_INDEX_NOT_FOUND(25015, Response.Status.NOT_FOUND),
    BACKUP_CREATION_FAILED(25050, Response.Status.INTERNAL_SERVER_ERROR),
    BACKUP_REPOSITORY_FAILURE(25060, Response.Status.INTERNAL_SERVER_ERROR),
    BACKUP_JOB_NOT_FOUND(25080, Response.Status.NOT_FOUND),
    STORAGE_PREPARE_STORE_FAILED(26020, Response.Status.INTERNAL_SERVER_ERROR),
    STORAGE_ITEM_EXISTS_ALREADY(26015, Response.Status.FORBIDDEN),
    STORAGE_JSON_PROCESSING_EXCEPTION(26040, Response.Status.INTERNAL_SERVER_ERROR),
    STORAGE_ITEM_NOT_FOUND(26010, Response.Status.NOT_FOUND),
    STORAGE_ACCESS_RIGHTS_NOT_SUFFICIENT(26050, Response.Status.FORBIDDEN),
    STORAGE_ITEM_VALIDATION_FAILED(26016, Response.Status.NOT_ACCEPTABLE),
    STORAGE_STORE_NOT_FOUND(26000, Response.Status.NOT_FOUND),
    STORAGE_JSON_PARSE_EXCEPTION(26030, Response.Status.INTERNAL_SERVER_ERROR),
    IM_UNSUPPORTED_OPERATION(33001, Response.Status.SERVICE_UNAVAILABLE),
    NO_SUITABLE_CONNECTION_TESTER_EXISTS(35100, Response.Status.NOT_IMPLEMENTED),
    CONNECTION_TEST_FAILED(35101, Response.Status.INTERNAL_SERVER_ERROR);

    private final int number;
    private final Response.Status responseStatus;

    private BpcErrorCode(int number, Response.Status responseStatus) {
        this.number = number;
        this.responseStatus = responseStatus;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Response.Status getResponseStatus() {
        return this.responseStatus;
    }
}

