/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.storage.StoreItemRestriction;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=false)
public class StoreItem {
    private final String id;
    private final String moduleId;
    private final String moduleInstanceId;
    private final String name;
    private final Object value;
    private final boolean favorite;
    private final StoreItemRestriction readRestriction;
    private final StoreItemRestriction writeRestriction;
    private final Map<String, Object> customFields;

    private StoreItem(StoreItemBuilder storeItemBuilder) {
        this.id = storeItemBuilder.id;
        this.moduleId = storeItemBuilder.moduleId;
        this.moduleInstanceId = storeItemBuilder.moduleInstanceId;
        this.name = storeItemBuilder.name;
        this.value = storeItemBuilder.value;
        this.favorite = storeItemBuilder.favorite;
        this.readRestriction = storeItemBuilder.readRestriction;
        this.writeRestriction = storeItemBuilder.writeRestriction;
        this.customFields = storeItemBuilder.customFields;
    }

    public static StoreItemBuilder withId(String id) {
        return StoreItemBuilder.newInstance().withId(id);
    }

    public static StoreItemBuilder withModuleId(String moduleId) {
        return StoreItemBuilder.newInstance().withModuleId(moduleId);
    }

    public static StoreItemBuilder withModuleInstanceId(String moduleInstanceId) {
        return StoreItemBuilder.newInstance().withModuleInstanceId(moduleInstanceId);
    }

    public static StoreItemBuilder withName(String name) {
        return StoreItemBuilder.newInstance().withName(name);
    }

    public static StoreItemBuilder withValue(Object value) {
        return StoreItemBuilder.newInstance().withValue(value);
    }

    public static StoreItemBuilder withFavorite(boolean favorite) {
        return StoreItemBuilder.newInstance().withFavorite(favorite);
    }

    public static StoreItemBuilder withReadRestriction(StoreItemRestriction readRestriction) {
        return StoreItemBuilder.newInstance().withReadRestriction(readRestriction);
    }

    public static StoreItemBuilder withWriteRestriction(StoreItemRestriction writeRestriction) {
        return StoreItemBuilder.newInstance().withWriteRestriction(writeRestriction);
    }

    public static StoreItemBuilder withCustomFields(Map<String, Object> customFields) {
        return StoreItemBuilder.newInstance().withCustomFields(customFields);
    }

    public String getId() {
        return this.id;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getModuleInstanceId() {
        return this.moduleInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public StoreItemRestriction getReadRestriction() {
        return this.readRestriction;
    }

    public StoreItemRestriction getWriteRestriction() {
        return this.writeRestriction;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreItem storeItem = (StoreItem)o;
        return this.favorite == storeItem.favorite && this.id.equals(storeItem.id) && Objects.equals(this.moduleId, storeItem.moduleId) && Objects.equals(this.moduleInstanceId, storeItem.moduleInstanceId) && Objects.equals(this.name, storeItem.name) && this.value.equals(storeItem.value) && Objects.equals(this.readRestriction, storeItem.readRestriction) && Objects.equals(this.writeRestriction, storeItem.writeRestriction) && Objects.equals(this.customFields, storeItem.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.moduleId, this.moduleInstanceId, this.name, this.value, this.favorite, this.readRestriction, this.writeRestriction, this.customFields);
    }

    public String toString() {
        return "StoreItem{id='" + this.id + "', moduleId='" + this.moduleId + "', moduleInstanceId='" + this.moduleInstanceId + "', name='" + this.name + "', value=" + this.value + ", favorite=" + this.favorite + ", readRestriction=" + this.readRestriction + ", writeRestriction=" + this.writeRestriction + ", customFields=" + this.customFields + "}";
    }

    public boolean isReadableBy(UserSession userSession) {
        if (userSession == null) {
            return false;
        }
        if (userSession.hasRole("bpcadmin")) {
            return true;
        }
        return this.readRestriction != null && this.readRestriction.hasAccess(userSession);
    }

    public boolean isWriteableBy(UserSession userSession) {
        if (userSession == null) {
            return false;
        }
        if (userSession.hasRole("bpcadmin")) {
            return true;
        }
        return this.writeRestriction != null && this.writeRestriction.hasAccess(userSession);
    }

    public boolean isDeletableBy(UserSession userSession) {
        if (userSession == null) {
            return false;
        }
        if (userSession.hasRole("bpcadmin")) {
            return true;
        }
        return this.writeRestriction != null && this.writeRestriction.hasAccess(userSession);
    }

    public String asJsonString() throws StoreItemJsonException {
        try {
            return JsonUtil.getInstance().convertPojoToJsonString(this);
        }
        catch (JsonProcessingException ex) {
            throw new StoreItemJsonException("Failed to convert the store item with the ID '${itemId}' to JSON: ${error}", MapUtil.mapOf("itemId", this.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
    }

    public Map asJsonMap() throws StoreItemJsonException {
        try {
            return JsonUtil.getInstance().jsonStringAsMap(JsonUtil.getInstance().convertPojoToJsonString(this));
        }
        catch (IOException ex) {
            throw new StoreItemJsonException("Failed to convert the store item with the ID '${itemId}' to JSON: ${error}", MapUtil.mapOf("itemId", this.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
    }

    public static class StoreItemBuilder {
        private String id;
        private String moduleId;
        private String moduleInstanceId;
        private String name;
        private Object value;
        private boolean favorite;
        private StoreItemRestriction readRestriction;
        private StoreItemRestriction writeRestriction;
        private Map<String, Object> customFields;

        private StoreItemBuilder() {
        }

        private static StoreItemBuilder newInstance() {
            return new StoreItemBuilder();
        }

        public StoreItemBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public StoreItemBuilder withModuleId(String moduleId) {
            this.moduleId = moduleId;
            return this;
        }

        public StoreItemBuilder withModuleInstanceId(String moduleInstanceId) {
            this.moduleInstanceId = moduleInstanceId;
            return this;
        }

        public StoreItemBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public StoreItemBuilder withValue(Object value) {
            this.value = value;
            return this;
        }

        public StoreItemBuilder withFavorite(boolean favorite) {
            this.favorite = favorite;
            return this;
        }

        public StoreItemBuilder withReadRestriction(StoreItemRestriction readRestriction) {
            this.readRestriction = readRestriction;
            return this;
        }

        public StoreItemBuilder withWriteRestriction(StoreItemRestriction writeRestriction) {
            this.writeRestriction = writeRestriction;
            return this;
        }

        public StoreItemBuilder withCustomFields(Map<String, Object> customFields) {
            this.customFields = customFields;
            return this;
        }

        public StoreItem build() {
            if (this.id == null) {
                throw new IllegalStateException("id required");
            }
            if (this.value == null) {
                throw new IllegalStateException("value required");
            }
            if (this.readRestriction == null) {
                throw new IllegalStateException("readRestriction required");
            }
            if (this.writeRestriction == null) {
                throw new IllegalStateException("writeRestriction required");
            }
            return new StoreItem(this);
        }
    }
}

