/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.module.simple.CustomFieldsImpl;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingFactory {
    private static final Logger LOGGER = LogManager.getLogger(SettingFactory.class);

    public static Setting parseJsonSetting(byte[] jsonArray) throws SettingException {
        LOGGER.debug("parseJsonSetting jsonArray=...");
        if (jsonArray == null || jsonArray.length == 0) {
            return null;
        }
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            JsonNode rootNode = objectMapper.readTree(jsonArray);
            Setting setting = SettingFactory.parseJsonNodeSetting(rootNode, objectMapper);
            return setting;
        }
        catch (IOException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to parse the byte array based JSON as Setting.", ex);
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    public static Setting parseJsonSetting(String jsonString) throws SettingException {
        LOGGER.debug("parseJsonSetting jsonString={}", (Object)jsonString);
        if (StringUtil.isNullOrEmpty(jsonString)) {
            return null;
        }
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            JsonNode rootNode = objectMapper.readTree(jsonString);
            Setting setting = SettingFactory.parseJsonNodeSetting(rootNode, objectMapper);
            return setting;
        }
        catch (IOException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to parse the String based JSON as Setting.", ex);
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    public static Setting parseMapSetting(Map<String, Object> map) {
        LOGGER.debug("parseMapSetting map={}", map);
        if (map == null) {
            return null;
        }
        MapBasedFieldValuesExtractor fve = new MapBasedFieldValuesExtractor(map);
        return new SimpleSettingImpl(fve.asObject("value"), fve.asString("name"), fve.asString("type"), fve.asString("moduleId"), fve.asString("instanceId"), fve.asString("instanceType"), new CustomFieldsImpl(map));
    }

    public static Setting parseJsonNodeSetting(JsonNode jsonNode, ObjectMapper objectMapper) {
        LOGGER.debug("parseJsonNodeSetting jsonNode=..., objectMapper=...");
        if (jsonNode == null) {
            return null;
        }
        JsonNodeBasedFieldValuesExtractor fve = new JsonNodeBasedFieldValuesExtractor(jsonNode, objectMapper);
        return new SimpleSettingImpl(fve.asObject("value"), fve.asString("name"), fve.asString("type"), fve.asString("moduleId"), fve.asString("instanceId"), fve.asString("instanceType"), new CustomFieldsImpl(fve.getAllFields()));
    }

    public static Map<String, Object> migrateFlatSettingMap(Map<String, Object> flatSettingMap) {
        if (flatSettingMap == null) {
            return null;
        }
        if (flatSettingMap.containsKey("customFields") && flatSettingMap.get("customFields") instanceof Map) {
            return flatSettingMap;
        }
        HashMap<String, Object> migratedSettingMap = new HashMap<String, Object>();
        HashMap customFieldsMap = new HashMap();
        flatSettingMap.forEach((fieldName, fieldValue) -> {
            if (SimpleSettingImpl.ReservedFieldNames.contains(fieldName)) {
                migratedSettingMap.put((String)fieldName, fieldValue);
            } else {
                customFieldsMap.put(fieldName, fieldValue);
            }
        });
        migratedSettingMap.put("customFields", customFieldsMap);
        return migratedSettingMap;
    }

    private static class MapBasedFieldValuesExtractor {
        Map<String, Object> map;

        MapBasedFieldValuesExtractor(Map<String, Object> map) {
            this.map = map;
        }

        Object asObject(String fieldName) {
            return this.map.get(fieldName);
        }

        String asString(String fieldName) {
            Object object = this.map.get(fieldName);
            if (object instanceof String) {
                return (String)object;
            }
            return null;
        }
    }

    private static class JsonNodeBasedFieldValuesExtractor {
        private final JsonNode jsonNode;
        private final ObjectMapper objectMapper;

        JsonNodeBasedFieldValuesExtractor(JsonNode jsonNode, ObjectMapper objectMapper) {
            this.jsonNode = jsonNode;
            this.objectMapper = objectMapper;
        }

        Object asObject(String fieldName) {
            if (this.jsonNode.hasNonNull(fieldName)) {
                return this.objectMapper.convertValue((Object)this.jsonNode.get(fieldName), Object.class);
            }
            return null;
        }

        String asString(String fieldName) {
            if (this.jsonNode.hasNonNull(fieldName)) {
                return this.jsonNode.get(fieldName).asText();
            }
            return null;
        }

        boolean asBoolean(String fieldName, boolean defaultValue) {
            if (this.jsonNode.hasNonNull(fieldName)) {
                return this.jsonNode.get(fieldName).asBoolean(defaultValue);
            }
            return defaultValue;
        }

        Map<String, Object> getAllFields() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Iterator fieldNamesIterator = this.jsonNode.fieldNames();
            while (fieldNamesIterator.hasNext()) {
                String fieldName = (String)fieldNamesIterator.next();
                if (fieldName == null) continue;
                JsonNode fieldNode = this.jsonNode.get(fieldName);
                Object fieldValue = this.objectMapper.convertValue((Object)fieldNode, Object.class);
                result.put(fieldName, fieldValue);
            }
            return result;
        }
    }
}

