/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupDoneEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupStartEventHandler;
import de.virtimo.bpc.api.AbstractServerModeChangedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupCreationException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupIndexNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupJobNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryCreationException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.opensearch.SearchScrollIterator;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.backup.BackupActivatedInfoImpl;
import de.virtimo.bpc.core.backup.BackupJobsManager;
import de.virtimo.bpc.core.backup.BackupRestoredInfoImpl;
import de.virtimo.bpc.core.backup.BackupSnapshotInfoImpl;
import de.virtimo.bpc.core.backup.CleanupBpcBackupRepositoryJob;
import de.virtimo.bpc.core.backup.SnapshotIndexModelVersionManager;
import de.virtimo.bpc.core.backup.Snapshotter;
import de.virtimo.bpc.core.backup.TemporaryIndices;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceHandler;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.resource.response.SettingsBasedConfigImpl;
import de.virtimo.bpc.core.service.EventManagerImpl;
import de.virtimo.bpc.core.service.QuartzSchedulerService;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfosDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionEntryDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupSnapshotInfoDTO;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobDeleteWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobInfosRequestWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobScheduleWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobStartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class BackupManagerImpl
implements BackupManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(BackupManagerImpl.class);
    public static final String BACKUP_EVENT_TOPIC_CREATED = "de/virtimo/bpc/core/backup/backupCreated";
    public static final String BACKUP_EVENT_TOPIC_DELETED = "de/virtimo/bpc/core/backup/backupDeleted";
    public static final String BACKUP_EVENT_TOPIC_ACTIVATED = "de/virtimo/bpc/core/backup/backupActivated";
    public static final String BACKUP_EVENT_TOPIC_RESTORED = "de/virtimo/bpc/core/backup/backupRestored";
    public static final String SNAPSHOTS_REPOSITORY_NAME = "bpc_backup";
    private final BackupJobsManager backupJobsManager;
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private final BpcServicesTracker<QuartzSchedulerService> quartzSchedulerServiceTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private final EventRegistration eventRegistration;

    public BackupManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.backupJobsManager = new BackupJobsManager(bundleContext);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(bundleContext, OpenSearchBpcPluginManager.class);
        this.quartzSchedulerServiceTracker = new BpcServicesTracker<QuartzSchedulerService>(bundleContext, QuartzSchedulerService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(bundleContext, ErrorResponseService.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forModuleUpdatedEvents("_core", "backupRepository", new BackupRepositoryUpdatedEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new GetBackupJobInfosActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new DeleteBackupJobActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new StartBackupJobActionEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new ScheduleBackupJobActionEventHandler());
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        try {
            this.quartzSchedulerServiceTracker.getService().deleteAllJobsOfGroup("backup_repository_cleanup");
        }
        catch (Exception ex) {
            LOGGER.error("Error deleting the scheduled backup repository cleanup jobs.", (Throwable)ex);
        }
        this.backupJobsManager.destroy();
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    private boolean isMasterServer() {
        LOGGER.debug("isMasterServer");
        try {
            return this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class).isMasterServer();
        }
        catch (ServiceNotFoundException e) {
            return false;
        }
        catch (ModuleNotFoundException ex) {
            return false;
        }
    }

    @Override
    public BackupJobInfosDTO getBackupJobInfos() throws ServiceNotFoundException {
        LOGGER.debug("getBackupJobInfos");
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        BackupJobInfosDTO backupJobInfosFromMasterServer = openSearchBpcPluginManager.getBackupJobInfosFromMasterServer();
        return backupJobInfosFromMasterServer;
    }

    @Override
    public Set<String> getIdentifiersOfBackupJobs() throws ServiceNotFoundException {
        LOGGER.debug("getIdentifiersOfBackupJobs");
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        BackupJobInfosDTO backupJobInfosFromMasterServer = openSearchBpcPluginManager.getBackupJobInfosFromMasterServer();
        return backupJobInfosFromMasterServer.getBackupJobIdentifiers();
    }

    @Override
    public void scheduleBackupJobs(List<BackupJobScheduleActionEntryDTO> entries) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("scheduleBackupJobs entries=...");
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        openSearchBpcPluginManager.sendScheduleBackupJobsAction(entries);
    }

    @Override
    public void deleteBackupJob(String backupJobIdentifier) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.debug("deleteBackupJob backupJobIdentifier={}", (Object)backupJobIdentifier);
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        openSearchBpcPluginManager.sendDeleteBackupJobAction(backupJobIdentifier);
    }

    @Override
    public BackupSnapshotInfo startBackupJob(String backupJobIdentifier) throws ServiceNotFoundException, JsonGenerationException, SystemException {
        LOGGER.debug("startBackupJob backupJobIdentifier={}", (Object)backupJobIdentifier);
        OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
        BackupSnapshotInfoDTO backupSnapshotInfoDTOFromBpcMasterServer = openSearchBpcPluginManager.sendStartBackupJobAction(backupJobIdentifier);
        if (!backupSnapshotInfoDTOFromBpcMasterServer.hasException()) {
            BackupSnapshotInfoImpl backupSnapshotInfoFromBpcMasterServer = new BackupSnapshotInfoImpl(backupSnapshotInfoDTOFromBpcMasterServer);
            return backupSnapshotInfoFromBpcMasterServer;
        }
        Map exceptionAsResponseMap = backupSnapshotInfoDTOFromBpcMasterServer.getExceptionAsResponseMap();
        SystemException systemExceptionFromErrorResponse = this.errorResponseServiceTracker.getService().createSystemExceptionFromErrorResponse(exceptionAsResponseMap, List.of(CoreErrorCode.class, BpcErrorCode.class));
        throw systemExceptionFromErrorResponse;
    }

    @Override
    public List<BackupSnapshotInfo> getAllBackups() throws ServiceNotFoundException, BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOGGER.info("getAllBackups");
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        List<BackupSnapshotInfo> snapshotInfos = snapshotter.getAllSnapshots(SNAPSHOTS_REPOSITORY_NAME);
        SnapshotIndexModelVersionManager snapshotIndexModelVersionManager = new SnapshotIndexModelVersionManager(oss);
        snapshotIndexModelVersionManager.setModelVersionsTo(snapshotInfos);
        return snapshotInfos;
    }

    @Override
    public BackupSnapshotInfo getBackupInfo(String snapshotNameAsString) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("getBackupInfo snapshotNameAsString={}", (Object)snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        SnapshotIndexModelVersionManager snapshotIndexModelVersionManager = new SnapshotIndexModelVersionManager(oss);
        snapshotIndexModelVersionManager.setModelVersionTo(snapshotInfo);
        return snapshotInfo;
    }

    @Override
    public BackupSnapshotInfo createBackup(SnapshotName snapshotName, Set<String> indicesToBackup) throws BackupRepositoryNotFoundException, BackupRepositoryCreationException, BackupCreationException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException {
        LOGGER.info("createBackup snapshotName={}, indicesToBackup={}", (Object)snapshotName, indicesToBackup);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        this.checkIfBackupRepositoryExistsAndCreateIfNot(snapshotter);
        BackupSnapshotInfo snapshotInfo = snapshotter.createSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName, indicesToBackup);
        if (snapshotInfo == null) {
            throw new BackupCreationException(snapshotName.asString());
        }
        SnapshotIndexModelVersionManager snapshotIndexModelVersionManager = new SnapshotIndexModelVersionManager(oss);
        Integer indexModelVersion = snapshotIndexModelVersionManager.addIndexModelVersionToCache(snapshotInfo);
        snapshotInfo.setIndexModelVersion(indexModelVersion);
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_CREATED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
        return snapshotInfo;
    }

    @Override
    public BackupSnapshotInfo createBackupForBackupJob(BackupJob backupJob) throws BackupRepositoryNotFoundException, BackupRepositoryCreationException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException {
        List<BackupSnapshotInfo> deletedSnapshots;
        LOGGER.info("createBackupForBackupJob backupJob={}", (Object)backupJob);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        String backupJobIdentifier = backupJob.getBackupJobIdentifier();
        Snapshotter snapshotter = new Snapshotter(oss);
        this.checkIfBackupRepositoryExistsAndCreateIfNot(snapshotter);
        List<BackupSnapshotInfo> snapshots = snapshotter.getAllSnapshotsWithPrefix(SNAPSHOTS_REPOSITORY_NAME, backupJob.getSnapshotNamePrefix());
        if (snapshots == null || snapshots.isEmpty()) {
            LOGGER.info("{}: No snapshots exist", (Object)backupJobIdentifier);
            backupJob.setTimestampOfLatestBackup(0L);
        } else {
            long timestampOfLatestBackup = snapshotter.getTimestampOfLatestSnapshot(snapshots);
            LOGGER.info("{}: Snapshots exist; date of latest:{}", (Object)backupJobIdentifier, (Object)new Date(timestampOfLatestBackup));
            backupJob.setTimestampOfLatestBackup(timestampOfLatestBackup);
        }
        if (!backupJob.getBackupSetting().isEnabled()) {
            LOGGER.info("{}: Skipping backup job execution ... job is disabled.", (Object)backupJobIdentifier);
            return null;
        }
        BackupSnapshotInfo snapshotInfo = null;
        if (backupJob.isItTimeToCreateABackup()) {
            LOGGER.info("{}: Snapshot must be created", (Object)backupJobIdentifier);
            snapshotInfo = snapshotter.createSnapshot(SNAPSHOTS_REPOSITORY_NAME, backupJob.createNewSnapshotName(), backupJob.getBackupSetting().getIndicesToBackup());
            if (snapshotInfo != null) {
                backupJob.setTimestampOfLatestBackup(snapshotInfo.getStartTimeInMillis());
                SystemAuditLog.info("BackupCreated", "Backup with the snapshot name '" + snapshotInfo.getSnapshotName() + "' created");
                SnapshotIndexModelVersionManager snapshotIndexModelVersionManager = new SnapshotIndexModelVersionManager(oss);
                Integer indexModelVersion = snapshotIndexModelVersionManager.addIndexModelVersionToCache(snapshotInfo);
                snapshotInfo.setIndexModelVersion(indexModelVersion);
                clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_CREATED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
            }
        } else {
            LOGGER.info("{}: Creating a snapshot is not necessary at the moment", (Object)backupJobIdentifier);
        }
        if (!(deletedSnapshots = snapshotter.deleteOldSnapshots(SNAPSHOTS_REPOSITORY_NAME, snapshots, backupJob.getBackupSetting().getKeepBackupsDurationInSeconds())).isEmpty()) {
            HashSet<SnapshotName> namesOfDeletedSnapshots = new HashSet<SnapshotName>();
            ArrayList<Map<String, Object>> websocketMessageContent = new ArrayList<Map<String, Object>>();
            for (BackupSnapshotInfo deletedSnapshot : deletedSnapshots) {
                SystemAuditLog.info("BackupDeleted", "Backup with the snapshot name '" + deletedSnapshot.getSnapshotName() + "' deleted");
                namesOfDeletedSnapshots.add(deletedSnapshot.getSnapshotName());
                websocketMessageContent.add(JsonUtil.getInstance().convertPojoToMap(deletedSnapshot));
            }
            SnapshotIndexModelVersionManager snapshotIndexModelVersionManager = new SnapshotIndexModelVersionManager(oss);
            snapshotIndexModelVersionManager.deleteIndexModelVersionsFromCache(namesOfDeletedSnapshots);
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_DELETED, websocketMessageContent);
        }
        return snapshotInfo;
    }

    private void checkIfBackupRepositoryExistsAndCreateIfNot(Snapshotter snapshotter) throws BackupRepositoryCreationException, ServiceNotFoundException, ModuleNotFoundException {
        LOGGER.info("checkIfBackupRepositoryExistsAndCreateIfNot snapshotter=...");
        try {
            if (!snapshotter.existsBackupRepository(SNAPSHOTS_REPOSITORY_NAME)) {
                CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
                Setting backupRepositorySetting = coreModule.getConfiguration().getSetting("backupRepository");
                Map backupRepositoryDefinition = backupRepositorySetting.getSettingValue().asMap();
                snapshotter.createBackupRepository(SNAPSHOTS_REPOSITORY_NAME, backupRepositoryDefinition);
            }
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackupRepositoryCreationException(SNAPSHOTS_REPOSITORY_NAME, (Throwable)ex);
        }
    }

    @Override
    public BackupSnapshotInfo deleteBackup(String snapshotNameAsString) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("deleteBackup snapshotNameAsString={}", (Object)snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        snapshotter.deleteSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        SnapshotIndexModelVersionManager snapshotIndexModelVersionManager = new SnapshotIndexModelVersionManager(oss);
        snapshotIndexModelVersionManager.deleteIndexModelVersionFromCache(snapshotName);
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_DELETED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
        return snapshotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackupActivatedInfo activateBackup(String snapshotNameAsString) throws BackupRepositoryNotFoundException, BackupNotFoundException, BackupConflictException, BackupIndexNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        boolean bl;
        LOGGER.info("activateBackup snapshotNameAsString={}", (Object)snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        if (snapshotInfo.isBpcConfigurationIndex()) {
            SnapshotIndexModelVersionManager snapshotIndexModelVersionManager = new SnapshotIndexModelVersionManager(oss);
            snapshotIndexModelVersionManager.setModelVersionTo(snapshotInfo);
            if (snapshotInfo.hasIndexModelVersion() && !snapshotInfo.isBpcConfigurationIndexRestorable().booleanValue()) {
                throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_ACTIVATION_FAILED, "Backup activation failed. The model version of the bpc-configuration index to restore does not fit.", MapUtil.mapOf("modelVersionOfIndexToRestore", snapshotInfo.getIndexModelVersion(), "lowestSupportedModelVersion", this.getLowestSupportedModelVersionOfBpcConfigurationIndex(), "modelVersionOfThisCoreVersion", this.getModelVersionOfBpcConfigurationIndexForThisCoreVersion(), "snapshot", snapshotName));
            }
        }
        List<String> backupIndexNames = snapshotInfo.getIndices();
        for (String string : backupIndexNames) {
            Set<String> existingIndexNames;
            String aliasOfIndex = oss.aliasFromBpcIndexName(string);
            if (aliasOfIndex == null || (existingIndexNames = oss.getIndexNamesWithAlias(aliasOfIndex)).size() <= 1) continue;
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_ACTIVATION_FAILED, "Backup activation failed due to inconsistency. There are ${numberOfIndicesWithAlias} indices with the alias '${alias}': ${indexNames}", MapUtil.mapOf("numberOfIndicesWithAlias", existingIndexNames.size(), "alias", aliasOfIndex, "indexNames", "" + Arrays.asList(existingIndexNames.toArray(new String[0])), "snapshot", snapshotName));
        }
        ArrayList<String> aliasesOfBackupIndices = new ArrayList<String>();
        for (String backupIndexName : backupIndexNames) {
            String aliasOfBackupIndexName = oss.aliasFromBpcIndexName(backupIndexName);
            if (aliasOfBackupIndexName != null) {
                aliasesOfBackupIndices.add(aliasOfBackupIndexName);
                continue;
            }
            aliasesOfBackupIndices.add(backupIndexName);
        }
        boolean bl2 = false;
        ArrayList<Map<String, Object>> summary = new ArrayList<Map<String, Object>>();
        boolean startEventSent = this.sendBackupRestoreStartEvent(snapshotName, aliasesOfBackupIndices, backupIndexNames);
        try {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String backupIndexName : backupIndexNames) {
                HashMap<String, String> summaryEntry = new HashMap<String, String>();
                summaryEntry.put("backupIndexName", backupIndexName);
                String aliasOfIndex = oss.aliasFromBpcIndexName(backupIndexName);
                if (aliasOfIndex != null) {
                    summaryEntry.put("alias", aliasOfIndex);
                    Set<String> existingIndexNames = oss.getIndexNamesWithAlias(aliasOfIndex);
                    if (existingIndexNames.size() > 1) {
                        throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_ACTIVATION_FAILED, "Backup activation failed due to inconsistency. There are ${numberOfIndicesWithAlias} indices with the alias '${alias}': ${indexNames}", MapUtil.mapOf("numberOfIndicesWithAlias", existingIndexNames.size(), "alias", "bpc-configuration", "indexNames", "" + Arrays.asList(existingIndexNames.toArray(new String[0])), "snapshot", snapshotName));
                    }
                    String newIndexName = oss.existsIndex(backupIndexName) ? oss.newIndexNameForAlias(aliasOfIndex) : backupIndexName;
                    LOGGER.info("Activating backup index '{}' to new index '{}'", (Object)backupIndexName, (Object)newIndexName);
                    snapshotter.restoreSingleSnapshotIndex(SNAPSHOTS_REPOSITORY_NAME, snapshotName, backupIndexName, newIndexName, false);
                    summaryEntry.put("restoredToIndexName", newIndexName);
                    if (existingIndexNames.size() == 1) {
                        String currentIndexName = existingIndexNames.iterator().next();
                        oss.moveAlias(currentIndexName, newIndexName);
                        oss.closeIndex(currentIndexName);
                    } else if (existingIndexNames.size() == 0) {
                        oss.addAliasToIndex(aliasOfIndex, newIndexName);
                    }
                    if ("bpc-configuration".equalsIgnoreCase(aliasOfIndex)) {
                        bl = true;
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcConfigurationIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOGGER.error("Could not migrate the '" + aliasOfIndex + "' index", (Throwable)ex);
                        }
                        try {
                            this.moduleManagerTracker.getService().reloadAllModules();
                        }
                        catch (SettingException ex) {
                            LOGGER.error("Could not reload all modules due to a setting problem.", (Throwable)ex);
                        }
                    } else if ("bpc-notification".equalsIgnoreCase(aliasOfIndex)) {
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcNotificationIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOGGER.error("Could not migrate the '" + aliasOfIndex + "' index", (Throwable)ex);
                        }
                    } else if ("bpc-auditlog".equalsIgnoreCase(aliasOfIndex)) {
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcAuditlogIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOGGER.error("Could not migrate the '" + aliasOfIndex + "' index", (Throwable)ex);
                        }
                    }
                } else {
                    if (oss.existsIndex(backupIndexName)) {
                        oss.deleteIndex(backupIndexName);
                    }
                    LOGGER.info("Activating backup index '{}", (Object)backupIndexName);
                    snapshotter.restoreSingleSnapshotIndex(SNAPSHOTS_REPOSITORY_NAME, snapshotName, backupIndexName, backupIndexName, false);
                    summaryEntry.put("restoredToIndexName", backupIndexName);
                }
                summary.add(summaryEntry);
            }
        }
        finally {
            if (startEventSent) {
                this.sendBackupRestoreDoneEvent(snapshotName, aliasesOfBackupIndices, summary);
            }
        }
        BackupActivatedInfoImpl backupActivatedInfo = new BackupActivatedInfoImpl(snapshotName.asString(), bl ? Boolean.TRUE : Boolean.FALSE);
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_ACTIVATED, MapUtil.mapOf("BackupName", backupActivatedInfo.getBackupName(), "BpcConfigurationIndex", backupActivatedInfo.isBpcConfigurationIndex()));
        if (bl) {
            EventManager eventManager = this.eventManagerTracker.getService();
            BroadcastWebsocketMessage broadcastWebsocketMessage = new BroadcastWebsocketMessage(((EventManagerImpl)eventManager).getServerUUID(), LocalDateTime.now(), "BpcConfigurationIndexRestored", null);
            eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-broadcast-message-to-all", "msg", broadcastWebsocketMessage);
        }
        return backupActivatedInfo;
    }

    private boolean sendBackupRestoreStartEvent(SnapshotName snapshotName, List<String> aliasesOfBackupIndices, List<String> backupIndexNames) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backup/restore/start", new AbstractRestoreBackupStartEventHandler.RestoreBackupStartEvent(snapshotName.asString(), aliasesOfBackupIndices, backupIndexNames));
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to send the backup restore start event.", (Throwable)ex);
            return false;
        }
    }

    private boolean sendBackupRestoreDoneEvent(SnapshotName snapshotName, List<String> aliasesOfBackupIndices, List<Map<String, Object>> summary) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backup/restore/done", new AbstractRestoreBackupDoneEventHandler.RestoreBackupDoneEvent(snapshotName.asString(), aliasesOfBackupIndices, summary));
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to send the backup restore done event.", (Throwable)ex);
            return false;
        }
    }

    @Override
    public BackupRestoredInfo restoreBackup(String snapshotNameAsString, String givenIndexName) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("restoreBackup snapshotNameAsString={}, givenIndexName={}", (Object)snapshotNameAsString, (Object)givenIndexName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        List<String> indices = snapshotInfo.getIndices();
        if (indices.size() == 1) {
            String restoreToIndexName;
            String backupIndexName = indices.get(0);
            String string = restoreToIndexName = StringUtil.isNullOrEmpty(givenIndexName) ? backupIndexName : givenIndexName;
            if (oss.existsIndex(restoreToIndexName)) {
                throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Restore not possible. There is already an index with the name '${index}'.", MapUtil.mapOf("index", restoreToIndexName));
            }
            LOGGER.info("Restoring backup index: {} to new index {}", (Object)backupIndexName, (Object)restoreToIndexName);
            snapshotter.restoreSingleSnapshotIndex(SNAPSHOTS_REPOSITORY_NAME, snapshotName, backupIndexName, restoreToIndexName, false);
            BackupRestoredInfoImpl backupRestoredInfo = new BackupRestoredInfoImpl(snapshotName.asString(), backupIndexName, restoreToIndexName);
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_RESTORED, MapUtil.mapOf("BackupName", backupRestoredInfo.getBackupName(), "RestoredFromIndex", backupRestoredInfo.getRestoredFromIndex(), "RestoredToIndex", backupRestoredInfo.getRestoredToIndex()));
            return backupRestoredInfo;
        }
        for (String index : indices) {
            if (!oss.existsIndex(index)) continue;
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Restore not possible. There is already an index with the name '${index}'.", MapUtil.mapOf("index", index));
        }
        try {
            snapshotter.restoreAllSnapshotIndices(SNAPSHOTS_REPOSITORY_NAME, snapshotName, false);
            BackupRestoredInfoImpl backupRestoredInfo = new BackupRestoredInfoImpl(snapshotName.asString());
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_RESTORED, MapUtil.mapOf("BackupName", backupRestoredInfo.getBackupName()));
            return backupRestoredInfo;
        }
        catch (OpenSearchRelatedException ex) {
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Could not restore the indices of the snapshot '${snapshotName}'.", MapUtil.mapOf("snapshotName", snapshotName), (Throwable)ex);
        }
    }

    @Override
    public StreamingOutput downloadSnapshotContent(String snapshotNameAsString) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("downloadSnapshotContent snapshotNameAsString={}", (Object)snapshotNameAsString);
        final OpenSearchService oss = this.openSearchServiceTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        List<String> indices = snapshotInfo.getIndices();
        final TemporaryIndices temporaryIndices = new TemporaryIndices(oss, indices);
        if (temporaryIndices.existsAtLeastOneOfThem()) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. There is already an index with the temporary name '${index}'.", MapUtil.mapOf("index", temporaryIndices.getNameOfExistingTmpIndex()));
        }
        LOGGER.info("Temporary restoring backup indices ...");
        try {
            snapshotter.restoreSnapshotIndices(SNAPSHOTS_REPOSITORY_NAME, snapshotName, "(.+)", temporaryIndices.getPrefix() + "$1", false);
        }
        catch (Exception ex) {
            temporaryIndices.deleteAll();
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. Could not restore the content to temporary indices.", ex);
        }
        return new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
                int i = 0;
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));){
                    bw.write("[");
                    bw.newLine();
                    for (String tmpIndexName : temporaryIndices) {
                        String indexName = temporaryIndices.getIndexName(tmpIndexName);
                        SearchRequest searchReq = new SearchRequest().indices(tmpIndexName).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
                        bw.write("  {");
                        bw.newLine();
                        bw.write("    \"index\": \"" + indexName + "\"");
                        bw.write(",");
                        bw.newLine();
                        bw.write("    \"data\": ");
                        bw.write("[");
                        bw.newLine();
                        int rowIdx = 0;
                        try (SearchScrollIterator searchScrollIterator = new SearchScrollIterator(oss, searchReq);){
                            while (searchScrollIterator.hasNext()) {
                                SearchHits searchHits = searchScrollIterator.next();
                                for (SearchHit hit : searchHits) {
                                    Map<String, Object> sourceValues = hit.getSourceAsMap();
                                    bw.write("      ");
                                    bw.write(mapper.writeValueAsString(sourceValues));
                                    if ((long)(++rowIdx) < searchScrollIterator.getTotalHitsCount()) {
                                        bw.write(",");
                                        bw.newLine();
                                    }
                                    if (rowIdx % 5000 != 0) continue;
                                    bw.flush();
                                }
                            }
                        }
                        bw.newLine();
                        bw.write("    ]");
                        bw.newLine();
                        bw.write("  }");
                        if (++i >= temporaryIndices.size()) continue;
                        bw.write(",");
                        bw.newLine();
                    }
                    bw.newLine();
                    bw.write("]");
                }
                catch (IOException | OpenSearchException ex) {
                    LOGGER.error("Failed to read the index content.", (Throwable)ex);
                }
                catch (Exception ex) {
                    LOGGER.error("Could not write the index content to the download stream.", (Throwable)ex);
                }
                finally {
                    if (mapper != null) {
                        ObjectMapperPool.getInstance().restore((Object)mapper);
                    }
                    temporaryIndices.deleteAll();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalConfig exportBpcConfiguration(String snapshotNameAsString) throws BackupException, BackupConflictException, ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("exportBpcConfiguration snapshotNameAsString={}", (Object)snapshotNameAsString);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        SnapshotName snapshotName = SnapshotName.parse(snapshotNameAsString);
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot(SNAPSHOTS_REPOSITORY_NAME, snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException(SNAPSHOTS_REPOSITORY_NAME, snapshotName.asString());
        }
        List<String> indices = snapshotInfo.getIndices();
        if (indices.size() != 1 || !indices.get(0).startsWith("bpc-configuration")) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Export not possible. Only snapshots of the bpc-configuration index can be exported.");
        }
        String bpcConfigurationIndexName = indices.get(0);
        TemporaryIndices temporaryIndices = new TemporaryIndices(oss, indices);
        if (temporaryIndices.existsAtLeastOneOfThem()) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Export not possible. There is already an index with the temporary name '${index}'.", MapUtil.mapOf("index", temporaryIndices.getNameOfExistingTmpIndex()));
        }
        String restoredBpcConfigurationIndexName = temporaryIndices.getTmpIndexName(bpcConfigurationIndexName);
        try {
            LOGGER.info("Temporary restoring backup indices ...");
            try {
                snapshotter.restoreSnapshotIndices(SNAPSHOTS_REPOSITORY_NAME, snapshotName, "(.+)", temporaryIndices.getPrefix() + "$1", false);
            }
            catch (OpenSearchRelatedException ex) {
                throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. Could not restore the content to temporary indices.", ex);
            }
            int modelVersion = oss.getModelVersion(restoredBpcConfigurationIndexName);
            BpcIndexInfo restoredBpcIndexInfo = oss.getBpcIndexInfoUsingIndexName(restoredBpcConfigurationIndexName);
            Settings allSettings = ModuleConfigurationPersistenceHandler.readAllSettingsFromBpcConfigurationIndex(oss, restoredBpcConfigurationIndexName);
            SettingsBasedConfigImpl settingsBasedConfigImpl = new SettingsBasedConfigImpl(this.moduleManagerTracker.getService(), restoredBpcIndexInfo, modelVersion, allSettings);
            return settingsBasedConfigImpl;
        }
        catch (BackupException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to read the settings from the temporarily restored bpc-configuration index: " + restoredBpcConfigurationIndexName, (Throwable)ex);
        }
        finally {
            temporaryIndices.deleteAll();
        }
        return null;
    }

    @Override
    public Integer getLowestSupportedModelVersionOfBpcConfigurationIndex() {
        return BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex();
    }

    @Override
    public Integer getModelVersionOfBpcConfigurationIndexForThisCoreVersion() {
        return BpcIndicesMigrator.getCurrentModelVersionOfBpcConfigurationIndex();
    }

    @Override
    public void sortSnapshotInfosByStartTime(List<BackupSnapshotInfo> snapshotInfos, final boolean ascending) {
        if (snapshotInfos != null && !snapshotInfos.isEmpty()) {
            snapshotInfos.sort(new Comparator<BackupSnapshotInfo>(){

                @Override
                public int compare(BackupSnapshotInfo bi1, BackupSnapshotInfo bi2) {
                    long o2StartTime;
                    long o1StartTime = bi1.getStartTimeInMillis();
                    if (o1StartTime == (o2StartTime = bi2.getStartTimeInMillis())) {
                        return 0;
                    }
                    if (ascending) {
                        return o1StartTime < o2StartTime ? -1 : 1;
                    }
                    return o1StartTime < o2StartTime ? 1 : -1;
                }
            });
        }
    }

    private void scheduleBpcBackupRepositoryCleanupJob() throws ServiceNotFoundException, SchedulerException {
        LOGGER.info("scheduleBpcBackupRepositoryCleanupJob");
        String backupRepositoryName = SNAPSHOTS_REPOSITORY_NAME;
        String cronPattern = this.coreBundleConfigurationTracker.getService().getOpenSearchBackupRepositoryCleanupCronPattern();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.setAllowsTransientData(true);
        jobDataMap.put("backupRepository", backupRepositoryName);
        JobDetail cleanupBackupRepositoryJob = JobBuilder.newJob(CleanupBpcBackupRepositoryJob.class).withIdentity(JobKey.jobKey((String)backupRepositoryName, (String)"backup_repository_cleanup")).usingJobData(jobDataMap).build();
        CronTrigger cleanupBackupRepositoryJobTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)backupRepositoryName, (String)"backup_repository_cleanup_trigger")).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronPattern)).forJob(cleanupBackupRepositoryJob).build();
        this.quartzSchedulerServiceTracker.getService().scheduleJob(cleanupBackupRepositoryJob, (Trigger)cleanupBackupRepositoryJobTrigger);
    }

    private void deleteBpcBackupRepositoryCleanupJob() throws ServiceNotFoundException, SchedulerException {
        LOGGER.info("deleteBpcBackupRepositoryCleanupJob");
        this.quartzSchedulerServiceTracker.getService().deleteJob(SNAPSHOTS_REPOSITORY_NAME, "backup_repository_cleanup");
    }

    private class BackupRepositoryUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private BackupRepositoryUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting backupRepositorySetting) {
            LOGGER.info("{}.processSetting backupRepositorySetting=...", (Object)this.getClass().getSimpleName());
            try {
                OpenSearchService oss = BackupManagerImpl.this.openSearchServiceTracker.getService();
                Snapshotter snapshotter = new Snapshotter(oss);
                Map backupRepositoryDefinition = backupRepositorySetting.getSettingValue().asMap();
                snapshotter.createBackupRepository(BackupManagerImpl.SNAPSHOTS_REPOSITORY_NAME, backupRepositoryDefinition);
            }
            catch (Exception ex) {
                LOGGER.error(this.getClass().getSimpleName() + ": Failed to register the backup repository in OpenSearch.", (Throwable)ex);
            }
        }
    }

    private class GetBackupJobInfosActionEventHandler
    extends AbstractEventHandler {
        private GetBackupJobInfosActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("GetBackupJobInfosAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                BackupJobInfosRequestWebsocketMessage websocketMessage = (BackupJobInfosRequestWebsocketMessage)event.getProperty("GetBackupJobInfosAction");
                BackupJobInfosDTO backupJobInfos = BackupManagerImpl.this.isMasterServer() ? BackupManagerImpl.this.backupJobsManager.getBackupJobInfos() : null;
                BackupManagerImpl.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin-send-backupjob-infos-message", MapUtil.mapOf("communicationId", websocketMessage.getCommunicationId(), "backupJobInfos", backupJobInfos));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a get backup job infos event.", (Throwable)ex);
            }
        }
    }

    private class DeleteBackupJobActionEventHandler
    extends AbstractEventHandler {
        private DeleteBackupJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("DeleteBackupJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                BackupJobDeleteWebsocketMessage websocketMessage = (BackupJobDeleteWebsocketMessage)event.getProperty("DeleteBackupJobAction");
                if (BackupManagerImpl.this.isMasterServer()) {
                    String backupJobIdentifier = websocketMessage.getDeleteAction().getBackupJobIdentifier();
                    BackupManagerImpl.this.backupJobsManager.deleteBackupJob(backupJobIdentifier);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a delete backup job event.", (Throwable)ex);
            }
        }
    }

    private class StartBackupJobActionEventHandler
    extends AbstractEventHandler {
        private StartBackupJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("StartBackupJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            BackupJobStartWebsocketMessage websocketMessage = (BackupJobStartWebsocketMessage)event.getProperty("StartBackupJobAction");
            String communicationId = websocketMessage.getCommunicationId();
            try {
                BackupJobStartActionDTO backupJobStartAction = websocketMessage.getStartAction();
                BackupSnapshotInfoDTO backupSnapshotInfoToSendBackToPlugin = null;
                if (BackupManagerImpl.this.isMasterServer()) {
                    String backupJobIdentifier = backupJobStartAction.getBackupJobIdentifier();
                    BackupJob backupJob = BackupManagerImpl.this.backupJobsManager.getBackupJob(backupJobIdentifier);
                    if (backupJob == null) {
                        throw new BackupJobNotFoundException(backupJobIdentifier);
                    }
                    BackupSnapshotInfo backupSnapshotInfo = BackupManagerImpl.this.createBackup(backupJob.createNewSnapshotName(), backupJob.getBackupSetting().getIndicesToBackup());
                    backupJob.setTimestampOfLatestBackup(backupSnapshotInfo.getStartTimeInMillis());
                    backupSnapshotInfoToSendBackToPlugin = new BackupSnapshotInfoDTO(backupSnapshotInfo.getSnapshotName().asString(), backupSnapshotInfo.getStartTime(), backupSnapshotInfo.getState(), backupSnapshotInfo.isBpcConfigurationIndex(), backupSnapshotInfo.getIndices(), null);
                }
                BackupManagerImpl.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin-send-backup-created-info-message", MapUtil.mapOf("communicationId", communicationId, "backupSnapshotInfo", backupSnapshotInfoToSendBackToPlugin, "exception", null));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a start backup job event.", (Throwable)ex);
                try {
                    BackupManagerImpl.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin-send-backup-created-info-message", MapUtil.mapOf("communicationId", communicationId, "backupSnapshotInfo", null, "exception", ex));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to inform the os-bpc-plugin about an exception.", (Throwable)e);
                }
            }
        }
    }

    private class ScheduleBackupJobActionEventHandler
    extends AbstractEventHandler {
        private ScheduleBackupJobActionEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("ScheduleBackupJobAction");
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                if (!BackupManagerImpl.this.isMasterServer()) {
                    return;
                }
                BackupJobScheduleWebsocketMessage websocketMessage = (BackupJobScheduleWebsocketMessage)event.getProperty("ScheduleBackupJobAction");
                BackupJobScheduleActionDTO backupJobScheduleAction = websocketMessage.getScheduleAction();
                for (BackupJobScheduleActionEntryDTO entry : backupJobScheduleAction.getEntries()) {
                    String backupJobIdentifier = entry.getBackupJobIdentifier();
                    BackupSetting backupSetting = BackupSetting.createFrom(entry.getBackupSetting());
                    BackupManagerImpl.this.backupJobsManager.scheduleBackupJobWithSettings(backupJobIdentifier, backupSetting);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a schedule backup job event.", (Throwable)ex);
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractServerModeChangedEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        public void processThisIsNowTheMasterServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowTheMasterServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            try {
                BackupManagerImpl.this.scheduleBpcBackupRepositoryCleanupJob();
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to process the set this server as master event.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }

        @Override
        public void processThisIsNowASlaveServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowASlaveServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            try {
                BackupManagerImpl.this.deleteBpcBackupRepositoryCleanupJob();
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to process the set this server as slave event.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }
    }
}

