/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.backup.Snapshotter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.repositories.RepositoryCleanupResult;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CleanupBpcBackupRepositoryJob
implements Job {
    private static final Logger LOGGER = LogManager.getLogger(CleanupBpcBackupRepositoryJob.class);
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String backupRepository = (String)jobDataMap.get((Object)"backupRepository");
        LOGGER.info("{}: execute context={}", (Object)backupRepository, (Object)context);
        BundleContext bundleContext = FrameworkUtil.getBundle(CleanupBpcBackupRepositoryJob.class).getBundleContext();
        try {
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
            this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            if (coreBundleConfiguration.isMaintenanceModeEnabled()) {
                LOGGER.info("Skipping the cleanup of the backup repository '" + backupRepository + "' due to enabled maintenance mode.");
                SystemAuditLog.info("BackupRepositoryCleanup", "Cleanup of the backup repository '" + backupRepository + "' has been skipped due to enabled maintenance mode.");
            } else {
                Snapshotter snapshotter = new Snapshotter(oss);
                RepositoryCleanupResult repositoryCleanupResult = snapshotter.cleanupRepository(backupRepository);
                SystemAuditLog.info("BackupRepositoryCleanup", "The backup repository '" + backupRepository + "' has been cleaned. Deleted blobs: " + repositoryCleanupResult.blobs() + ", deleted bytes: " + repositoryCleanupResult.bytes());
            }
        }
        catch (Exception ex) {
            LOGGER.error("{}: failed to perform the backup repository cleanup", (Object)backupRepository, (Object)ex);
            SystemAuditLog.error("BackupRepositoryCleanup", "Cleanup of the backup repository '" + backupRepository + "' failed: " + ex.getMessage());
        }
        finally {
            BpcServicesTracker.stopAll(this);
        }
    }
}

