/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationData;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.Notifications;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.ZonedDateTime;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="notification")
@Tag(name="Notification API", description="These are the notification endpoints.")
public class NotificationEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(NotificationEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<NotificationManager> notificationManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public NotificationEndpoint(BundleContext bundleContext) {
        LOGGER.info("NotificationEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.notificationManagerTracker = new BpcServicesTracker<NotificationManager>(this.bundleContext, NotificationManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @OperationDescription(summary="Add a notification.", description="To add a notification, send a JSON message with the following structure:\n\n.Minimal example\n[source,json]\n----\n{\n   \"subject\": \"Replication problem\",\n   \"message\": \"The database 'postgresql' is not reachable\",\n   \"recipients\": [ \"bpcadmin\" ],\n   \"recipientsType\": \"role\"\n}\n----\n\n.More complex example\n[source,json]\n----\n{\n     \"priority\": 10,\n     \"subject\": \"API expires soon\",\n     \"message\": \"API Key API-39e889a expires soon. Please contact your administrator.\",\n     \"recipients\": [ \"bpcadmin\" ],\n     \"recipientsType\": \"role\",\n     \"icon\": \"fa-file-certificate\",\n     \"type\": \"link\",\n     \"typeSpecificData\": {\n         \"targetModule\": \"_core\",\n         \"route\" : [\"_core\", \"apiKeys\", \"api\", \"API-39e889a\"]\n     }\n}\n----\n\n**Fields**\n\n`id` (optional) :: ID of the notification. A random UUID gets set when not given.\n`priority` (optional) :: Delivery priority of the notification. Can be one of the following values: 0 (Silent), 5 (Toast), 10 (Popup). 5 gets used when not given.\n`subject` (required) :: The subject of the notification.\n`message` (optional) :: The message of the notification.\n`recipients` (required) :: The recipients of the notification. Depends on the used `recipientsType`.\n`recipientsType` (required) :: The recipients type of the notification. Can be one of the following values: `user`, `role` or `organisation`.\n`originator` (optional) :: The originator of the notification. The login name of the user session gets used when not given.\n`icon` (optional) :: The Font Awesome icon which should be used when showing the notification.\n`type` (optional) :: The type of the notification. The type 'info' gets used when not given. Other possibility are 'warn', 'error', 'link', etc. Depending on the type, the notification is displayed accordingly in the GUI (see also xref:core:dev/notification_type_view.adoc[]).\n`typeSpecificData` (optional) :: The additional type specific data of the notification.\n")
    @ReturnDescription(value="The added notification as JSON. Contains additionally the 'date' and 'version' fields which get automatically set/updated.")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_ADD", message="Not allowed to add notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response addNotification(@Context HttpHeaders hh, @Context UserSession userSession, NotificationData postData) {
        LOGGER.info("addNotification");
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = new Notification.Builder(postData).date(ZonedDateTime.now()).originator(postData.originator == null ? userSession.getLoginName() : postData.originator).build();
            Notification addedNotification = notificationManager.addNotification(notification);
            return Response.ok((Object)addedNotification).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to add notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Update a notification.", description="To update a notification, send a JSON message with the following structure:\n\n.Minimal example\n[source,json]\n----\n{\n   \"subject\": \"Replication problem\",\n   \"message\": \"The database 'postgresql' is not reachable\",\n   \"recipients\": [ \"bpcadmin\" ],\n   \"recipientsType\": \"role\"\n}\n----\n\n.More complex example\n[source,json]\n----\n{\n     \"priority\": 10,\n     \"subject\": \"API expires soon\",\n     \"message\": \"API Key API-39e889a expires soon. Please contact your administrator.\",\n     \"recipients\": [ \"bpcadmin\" ],\n     \"recipientsType\": \"role\",\n     \"icon\": \"fa-file-certificate\",\n     \"type\": \"link\",\n     \"typeSpecificData\": {\n         \"targetModule\": \"_core\",\n         \"route\" : [\"_core\", \"apiKeys\", \"api\", \"API-39e889a\"]\n     }\n}\n----\n\n**Fields**\n\n`priority` (optional) :: Delivery priority of the notification. Can be one of the following values: 0 (Silent), 5 (Toast), 10 (Popup). 5 gets used when not given.\n`subject` (required) :: The subject of the notification.\n`message` (optional) :: The message of the notification.\n`recipients` (required) :: The recipients of the notification. Depends on the used `recipientsType`.\n`recipientsType` (required) :: The recipients type of the notification. Can be one of the following values: `user`, `role` or `organisation`.\n`originator` (optional) :: The originator of the notification. The login name of the user session gets used when not given.\n`icon` (optional) :: The Font Awesome icon which should be used when showing the notification.\n`type` (optional) :: The type of the notification. The type 'info' gets used when not given. Other possibility are 'warn', 'error', 'link', etc. Depending on the type, the notification is displayed accordingly in the GUI (see also xref:core:dev/notification_type_view.adoc[]).\n`typeSpecificData` (optional) :: The additional type specific data of the notification.\n")
    @ReturnDescription(value="The updated notification as JSON. Contains additionally the 'date' and 'version' fields which get automatically set/updated.")
    @PUT
    @Path(value="/{notificationId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_UPDATE", message="Not allowed to update notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response updateNotification(@Parameter(description="the ID of the notification to update") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession, NotificationData postData) {
        LOGGER.info("updateNotification notificationId={}", (Object)notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = new Notification.Builder(postData).id(notificationId).date(ZonedDateTime.now()).originator(postData.originator == null ? userSession.getLoginName() : postData.originator).build();
            Notification updatedNotification = notificationManager.updateNotification(notification);
            return Response.ok((Object)updatedNotification).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to update notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_DELETE", message="Not allowed to delete notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* Required service was not found\n* Requested notification was not found\n"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="Delete a specific notification.", description="Delete a specific notification.")
    @ReturnDescription(value="The deleted notification as JSON.")
    public Response deleteNotification(@Parameter(description="the ID of the notification to delete") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("deleteNotification notificationId={}", (Object)notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification deletedNotification = notificationManager.deleteNotificationById(notificationId);
            return Response.ok((Object)deletedNotification).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to delete notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* Required service was not found\n* Requested notification was not found or no access rights\n"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="Get the data of a notification.", description="Get the data of a notification.")
    @ReturnDescription(value="The data of the requested notification as JSON.")
    public Response getNotification(@Parameter(description="the ID of the notification to get the data for") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("getNotification notificationId={}", (Object)notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = notificationManager.getNotification(notificationId);
            if (notification != null && notification.hasAccessRight(userSession)) {
                return Response.ok((Object)notification).build();
            }
            throw new NotificationNotFoundException(notificationId);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="Get the notification of the requesting user.", description="Get the notification of the requesting user.")
    @ReturnDescription(value="The requested notifications of the user as JSON.")
    public Response getNotifications(@Parameter(description="paging start parameter") @QueryParam(value="start") @DefaultValue(value="0") Integer start, @Parameter(description="number of notifications to get") @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("getNotifications");
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notifications notifications = notificationManager.getNotifications(userSession, start, limit);
            return Response.ok((Object)notifications).build();
        }
        catch (MaintenanceModeEnabledException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get notifications.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

