/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.DbColumnNamesToOpenSearchFieldNamesConverter;
import de.virtimo.bpc.core.replicator.DbLowerLimitTimestampEvaluator;
import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.core.replicator.DbResultSetToJsonConverter;
import de.virtimo.bpc.core.replicator.LastUpdateTimestampOnRestartHandler;
import de.virtimo.bpc.core.replicator.OpenSearchIndexMappingUpdater;
import de.virtimo.bpc.core.replicator.OpenSearchRecordID;
import de.virtimo.bpc.core.replicator.ReplicationJobCallback;
import de.virtimo.bpc.core.replicator.ReplicationJobException;
import de.virtimo.bpc.core.replicator.ReplicationJobSettings;
import de.virtimo.bpc.core.replicator.ReplicationJobStats;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.VamSpecificXmlTypeProcessor;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheck;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobLogData;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.tailsync.TailSync;
import de.virtimo.bpc.core.resource.ConfigurationEndpoint;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.XContentBuilder;

public class ReplicationJob
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationJob.class);
    public static final String REPLICATION_ENABLED_FIELD = "replicationEnabled";
    public static final boolean DEFAULT_REPLICATION_ENABLED = true;
    private final String id;
    private final String name;
    private final boolean enabled;
    private final ReplicationJobStats stats;
    private final ReplicationJobSettings settings;
    private final ReplicationSource source;
    private final ReplicationTarget target;
    private Timestamp lastUpdateTimestamp;
    private Timestamp lastUpdateTimestampOnRestart;
    private boolean forcedLastUpdateTimestampOnRestartReset;
    private Date lastDataRecordTimestamp;
    private ReplicationJobCallback callback;
    private final OpenSearchIndexMappingUpdater indexMappingUpdater;
    private final ShadowCopy shadowCopy;
    private final TailSync tailSync;
    private final ConsistencyCheck consistencyCheck;

    public ReplicationJob(String moduleInstanceId, String moduleInstanceName, boolean enabled, ReplicationJobSettings settings, ReplicationSource source, ReplicationTarget target, ShadowCopy shadowCopy, TailSync tailSync, ConsistencyCheck consistencyCheck) {
        this.id = moduleInstanceId;
        this.name = moduleInstanceName;
        this.enabled = enabled;
        this.stats = new ReplicationJobStats();
        this.settings = settings;
        this.source = source;
        this.target = target;
        this.callback = null;
        this.indexMappingUpdater = new OpenSearchIndexMappingUpdater(this.id, target);
        this.lastUpdateTimestamp = new Timestamp(settings.getReplicationStartDateAsDate().getTime());
        this.lastUpdateTimestampOnRestart = null;
        this.forcedLastUpdateTimestampOnRestartReset = false;
        this.shadowCopy = shadowCopy;
        this.tailSync = tailSync;
        this.consistencyCheck = consistencyCheck;
    }

    public ReplicationJob(String moduleInstanceId, ModuleConfiguration jobConfig) {
        this(moduleInstanceId, ConfigurationEndpoint.getModuleInstanceName(jobConfig), jobConfig.getSettingValue(REPLICATION_ENABLED_FIELD).asBoolean(true), new ReplicationJobSettings(jobConfig), new ReplicationSource(jobConfig), new ReplicationTarget(jobConfig), new ShadowCopy(jobConfig), new TailSync(jobConfig), new ConsistencyCheck(jobConfig));
    }

    public void destroy() {
        LOGGER.info("{}: destroy", (Object)this.id);
        this.callback = null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ReplicationJobStats getStats() {
        return this.stats;
    }

    public ReplicationJobSettings getSettings() {
        return this.settings;
    }

    public Timestamp getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public Timestamp getLastUpdateTimestampOnRestart() {
        return this.lastUpdateTimestampOnRestart;
    }

    public void resetLastUpdateTimestampOnRestart() throws ServiceNotFoundException, OpenSearchRelatedException {
        LOGGER.info("resetLastUpdateTimestampOnRestart");
        if (!this.stats.isRunning()) {
            LastUpdateTimestampOnRestartHandler lastUpdateTimestampOnRestartHandler = new LastUpdateTimestampOnRestartHandler(this.id, this.callback.getOpenSearchService(), this.target.getIndex());
            lastUpdateTimestampOnRestartHandler.deleteFromIndex();
            this.lastUpdateTimestampOnRestart = null;
        }
        this.forcedLastUpdateTimestampOnRestartReset = true;
    }

    public ReplicationSource getSource() {
        return this.source;
    }

    public ReplicationTarget getTarget() {
        return this.target;
    }

    public Date getLastDataRecordTimestamp() {
        return this.lastDataRecordTimestamp;
    }

    public void setCallback(ReplicationJobCallback callback) {
        this.callback = callback;
    }

    public ShadowCopy getShadowCopy() {
        return this.shadowCopy;
    }

    public TailSync getTailSync() {
        return this.tailSync;
    }

    public ConsistencyCheck getConsistencyCheck() {
        return this.consistencyCheck;
    }

    public boolean isReplicatingLatestRecords() {
        if (this.lastUpdateTimestamp == null) {
            return false;
        }
        Timestamp currentUpperDateLimit = this.computeUpperDateLimit(this.lastUpdateTimestamp);
        return this.isReplicatingLatestRecords(currentUpperDateLimit);
    }

    private Timestamp computeUpperDateLimit(Timestamp lastUpdateTimestamp) {
        return DateUtil.addDaysToTimestamp(this.settings.getBlockDayRange(), lastUpdateTimestamp);
    }

    private boolean isReplicatingLatestRecords(Timestamp currentUpperDateLimit) {
        if (this.stats.getJobCount() == 0) {
            return false;
        }
        return currentUpperDateLimit.getTime() >= this.stats.getLastRunStartDate().getTime();
    }

    public DbResultSetToJsonConverter createDbResultSetToJsonConverter(OpenSearchService oss) {
        LookupJoins lookupJoins = this.callback.getLookupJoins(this);
        return ReplicationJob.createDbResultSetToJsonConverter(oss, this.settings, this.target, lookupJoins);
    }

    public static DbResultSetToJsonConverter createDbResultSetToJsonConverter(OpenSearchService oss, ReplicationJobSettings replicationJobSettings, ReplicationTarget replicationTarget, LookupJoins lookupJoins) {
        DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter = replicationTarget.getDbColumnNamesToOpenSearchFieldNamesConverter();
        VamSpecificXmlTypeProcessor vamSpecificXmlTypeProcessor = null;
        if (replicationJobSettings.getVamOrganizationId() != null) {
            vamSpecificXmlTypeProcessor = new VamSpecificXmlTypeProcessor(oss, replicationTarget.getIndex(), dbColumnNamesToOpenSearchFieldNamesConverter);
        }
        return new DbResultSetToJsonConverter(oss, dbColumnNamesToOpenSearchFieldNamesConverter, lookupJoins, vamSpecificXmlTypeProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.enabled) {
            LOGGER.debug("{}: Replication job is disabled", (Object)this.id);
            return;
        }
        if (this.shadowCopy != null && this.shadowCopy.isEnabled() && this.shadowCopy.isRunning()) {
            LOGGER.warn("{}: Replication job is suspended while a shadow copy task is running", (Object)this.id);
            return;
        }
        if (this.consistencyCheck != null && this.consistencyCheck.isEnabled() && this.consistencyCheck.isRunning()) {
            LOGGER.warn("{}: Replication job is suspended while a consistency check task is running", (Object)this.id);
            return;
        }
        if (this.stats.isRunning()) {
            LOGGER.info("{}: Replication job is already running", (Object)this.id);
            return;
        }
        this.stats.start();
        ReplicationJobLogData logData = new ReplicationJobLogData(this);
        ResultSet rs = null;
        Connection connection = null;
        Statement preparedStatement = null;
        int overallCounter = 0;
        try {
            LOGGER.info("{}: Started replication {} - {}", (Object)this.id, (Object)this.stats.getJobCount(), (Object)this.stats.getLastRunStartDate());
            LOGGER.info("{}: Block size: {}", (Object)this.id, (Object)this.settings.getBlockSize());
            LOGGER.info("{}: Sync files: {}", (Object)this.id, (Object)this.settings.isSyncFiles());
            LOGGER.info("{}: Unzip synced files: {}", (Object)this.id, (Object)this.settings.isUnzipSyncedFiles());
            LOGGER.info("{}: Restart replication where left off: {}", (Object)this.id, (Object)this.settings.isRestartReplicationWhereLeftOff());
            LOGGER.info("{}: Adjust upper date limit in seconds: {}", (Object)this.id, (Object)this.settings.getAdjustUpperDateLimitInSeconds());
            OpenSearchService oss = this.callback.getOpenSearchService();
            LastUpdateTimestampOnRestartHandler lastUpdateTimestampOnRestartHandler = new LastUpdateTimestampOnRestartHandler(this.id, oss, this.target.getIndex());
            if (this.forcedLastUpdateTimestampOnRestartReset) {
                this.forcedLastUpdateTimestampOnRestartReset = false;
                lastUpdateTimestampOnRestartHandler.deleteFromIndex();
                this.lastUpdateTimestampOnRestart = null;
                this.lastUpdateTimestamp = new Timestamp(this.settings.getReplicationStartDateAsDate().getTime());
                this.stats.reset();
            }
            BpcIndexState indexState = oss.getIndexState(this.target.getIndex());
            indexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    String indexName = oss.createIndex(ReplicationJob.this.target.getIndex(), ReplicationJob.this.target.hasIndexCreationSettings() ? ReplicationJob.this.target.getIndexCreationSettings() : oss.getDefaultIndexCreationSettings(), ReplicationJob.this.target.hasIndexMappings() ? ReplicationJob.this.target.getIndexMappings() : null);
                    ReplicationJob.this.indexMappingUpdater.reset();
                    ReplicationJob.this.lastUpdateTimestampOnRestart = null;
                    ReplicationJob.this.lastUpdateTimestamp = new Timestamp(ReplicationJob.this.settings.getReplicationStartDateAsDate().getTime());
                    ReplicationJob.this.stats.reset();
                    return indexName;
                }
            });
            if (this.stats.isFirstRun()) {
                this.lastUpdateTimestampOnRestart = lastUpdateTimestampOnRestartHandler.readFromIndex();
                if (this.lastUpdateTimestampOnRestart != null && this.lastUpdateTimestampOnRestart.before(this.lastUpdateTimestamp)) {
                    this.lastUpdateTimestampOnRestart = null;
                }
            }
            if (this.stats.isFirstRun()) {
                long t1 = System.currentTimeMillis();
                try {
                    if (!oss.waitForOpenSearch(60, new String[]{this.target.getIndex()})) {
                        indexState.reset();
                        throw new Exception("Replication job '" + this.id + "' failed. The target index '" + this.target.getIndex() + "' is not in an useable state.");
                    }
                }
                finally {
                    LOGGER.info("{}: Waiting for OpenSearch index '{}' took {} ms", (Object)this.id, (Object)this.target.getIndex(), (Object)(System.currentTimeMillis() - t1));
                }
            }
            connection = this.callback.getDatabaseConnection(this);
            connection.setAutoCommit(false);
            if (this.stats.isFirstRun()) {
                LOGGER.info("{}: firstRun - detecting lower date limit", (Object)this.id);
                if (this.settings.isRestartReplicationWhereLeftOff() && this.lastUpdateTimestampOnRestart != null) {
                    this.lastUpdateTimestamp = new Timestamp(this.lastUpdateTimestampOnRestart.getTime());
                    LOGGER.info("{}: Using the restart timestamp: {}", (Object)this.id, (Object)this.lastUpdateTimestamp);
                } else {
                    Timestamp lowerLimitTimestamp = this.getLowerLimitTimestamp(connection, this.lastUpdateTimestamp);
                    if (lowerLimitTimestamp != null && lowerLimitTimestamp.after(this.lastUpdateTimestamp)) {
                        LOGGER.info("{}: Fittet start date to oldest record found in range. Old limit: {} new limit: {}", (Object)this.id, (Object)this.lastUpdateTimestamp.toLocalDateTime(), (Object)lowerLimitTimestamp.toLocalDateTime());
                        this.lastUpdateTimestamp = lowerLimitTimestamp;
                    } else {
                        LOGGER.info("{}: No lower limit fitting needed", (Object)this.id);
                    }
                }
                this.stats.setFirstRun(false);
            }
            Calendar lastUpdateColumnCalendar = this.source.getLastUpdateColumnTimeZoneCalendar();
            Timestamp lowerDateLimit = DateUtil.cloneTimestampWithNanos(this.lastUpdateTimestamp);
            Timestamp upperDateLimit = this.computeUpperDateLimit(this.lastUpdateTimestamp);
            boolean replicatingLatestRecords = this.isReplicatingLatestRecords(upperDateLimit);
            Timestamp upperDateLimitToReplicateLatestRecords = new Timestamp(System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(this.settings.getAdjustUpperDateLimitInSeconds()));
            if (replicatingLatestRecords) {
                query = new DbQueryBuilder(connection).withCommonTableExpressionQuery(this.source.getTable(), this.source.getCommonTableExpressionQuery()).withQuery("SELECT * FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN <= ? ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$TABLE", this.source.getTable(), "$LASTUPDATE_COLUMN", this.source.getLastUpdateColumn())).build();
                preparedStatement = connection.prepareStatement(query, 1003, 1007);
                LOGGER.info("{}: replicating latest records query with {} seconds adjustment in '{}' timezone - {} (from:{}, to: {})", (Object)this.id, (Object)this.settings.getAdjustUpperDateLimitInSeconds(), (Object)this.source.getLastUpdateColumnTimeZoneId(), (Object)query, (Object)lowerDateLimit.toLocalDateTime(), (Object)upperDateLimitToReplicateLatestRecords.toLocalDateTime());
                if (lastUpdateColumnCalendar != null) {
                    preparedStatement.setTimestamp(1, lowerDateLimit, lastUpdateColumnCalendar);
                    preparedStatement.setTimestamp(2, upperDateLimitToReplicateLatestRecords, lastUpdateColumnCalendar);
                } else {
                    preparedStatement.setTimestamp(1, lowerDateLimit);
                    preparedStatement.setTimestamp(2, upperDateLimitToReplicateLatestRecords);
                }
                logData.setQueryFromDate(lowerDateLimit);
                logData.setQueryToDate(upperDateLimitToReplicateLatestRecords);
            } else {
                query = new DbQueryBuilder(connection).withCommonTableExpressionQuery(this.source.getTable(), this.source.getCommonTableExpressionQuery()).withQuery("SELECT * FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN <= ? ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$TABLE", this.source.getTable(), "$LASTUPDATE_COLUMN", this.source.getLastUpdateColumn())).build();
                preparedStatement = connection.prepareStatement(query, 1003, 1007);
                LOGGER.info("{}: regular query - {} (from:{}, to: {})", (Object)this.id, (Object)query, (Object)lowerDateLimit.toLocalDateTime(), (Object)upperDateLimit.toLocalDateTime());
                if (lastUpdateColumnCalendar != null) {
                    preparedStatement.setTimestamp(1, lowerDateLimit, lastUpdateColumnCalendar);
                    preparedStatement.setTimestamp(2, upperDateLimit, lastUpdateColumnCalendar);
                } else {
                    preparedStatement.setTimestamp(1, lowerDateLimit);
                    preparedStatement.setTimestamp(2, upperDateLimit);
                }
                logData.setQueryFromDate(lowerDateLimit);
                logData.setQueryToDate(upperDateLimit);
            }
            preparedStatement.setFetchSize(this.settings.getBlockSize());
            if (this.source.getQueryTimeoutInSeconds() >= 0) {
                preparedStatement.setQueryTimeout(this.source.getQueryTimeoutInSeconds());
            }
            long beforeQueryTimestamp = System.currentTimeMillis();
            rs = preparedStatement.executeQuery();
            LOGGER.info("{}: Query executed in {} ms", (Object)this.id, (Object)(System.currentTimeMillis() - beforeQueryTimestamp));
            if (!indexState.isValid()) {
                throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
            }
            this.indexMappingUpdater.using(oss, rs);
            RestHighLevelClient osClient = oss.getClient();
            Set<Percolator> percolatorsFromIndex = this.callback.getAllValidPercolatorsFromIndex(oss, this.target.getIndex());
            PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, this.target.getIndex(), percolatorsFromIndex);
            DbResultSetToJsonConverter dbResultSetToJsonConverter = this.createDbResultSetToJsonConverter(oss);
            Timestamp lastDate = new Timestamp(this.stats.getLastRunStartDate().getTime());
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            boolean firstIteration = true;
            while (rs.next()) {
                if (this.settings.getVamOrganizationId() != null && (!"0".equals(rs.getString("DELETED")) || !this.settings.getVamOrganizationId().equals(rs.getString("ORGANIZATIONID")))) continue;
                lastDate = this.source.getLastUpdateColumnTimeZoneCalendar() != null ? rs.getTimestamp(this.source.getLastUpdateColumn(), this.source.getLastUpdateColumnTimeZoneCalendar()) : rs.getTimestamp(this.source.getLastUpdateColumn());
                this.lastDataRecordTimestamp = lastDate;
                String recordId = OpenSearchRecordID.create(rs, this.source.getIdColumns());
                if (firstIteration) {
                    firstIteration = false;
                    String replicationEndlessLoopCheckSystemPropertyName = "bpc.replication.endlessLoopCheck";
                    String replicationEndlessLoopCheckValue = System.getProperty(replicationEndlessLoopCheckSystemPropertyName, "enabled");
                    if (Set.of("enabled", "active", "true", "yes", "1").contains(replicationEndlessLoopCheckValue.toLowerCase())) {
                        LOGGER.info("{}: recordId={}, recordIdFromFirstReplicatedRecordOfPreviousReplicationJobRun={}", (Object)this.id, (Object)recordId, (Object)this.stats.getRecordIdFromFirstReplicatedRecordOfPreviousReplicationJobRun());
                        if (this.stats.replicatesTheSameRecordAgain(recordId, lastDate.toInstant())) {
                            LOGGER.error("{}: endless loop detected. I will now cancel this replication job run.", (Object)this.id);
                            throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_ENDLESS_LOOP_DETECTED, "Endless loop detected in replication job with the id '${replicationJobId}'. Hint: If the database knows the time zone of the 'LastUpdate'-column, this does not need to be specified again in the replication job.", MapUtil.mapOf("replicationJobId", this.id, "recordId", recordId));
                        }
                    } else {
                        LOGGER.warn("{}: the endless loop check is disabled due the system property: {}={}", (Object)this.id, (Object)replicationEndlessLoopCheckSystemPropertyName, (Object)replicationEndlessLoopCheckValue);
                    }
                }
                XContentBuilder jdbcResultSetContentBuilder = dbResultSetToJsonConverter.resultToJsonObject(rs, this.settings.isSyncFiles(), this.settings.isUnzipSyncedFiles(), this.source.getDateFieldColumnsTimeZoneCalendar(), this.source.getLastUpdateColumn(), this.source.getLastUpdateColumnTimeZoneCalendar());
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(this.target.getIndex())).id(recordId).source(jdbcResultSetContentBuilder);
                if (this.settings.isSyncFiles()) {
                    indexRequest.setPipeline(oss.getAttachmentsPipelineName(this.target.getIndex()));
                }
                bulkRequest.add(indexRequest);
                if (bulkRequest.numberOfActions() == this.settings.getBlockSize()) {
                    LOGGER.debug("{}: Blocksize reached. Send data to OpenSearch.", (Object)this.id);
                    if (!indexState.isValid()) {
                        throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
                    }
                    BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                    LOGGER.debug("{}: OpenSearch call done", (Object)this.id);
                    overallCounter += this.getNumberOfSuccessfullyIndexedDocuments(bulkResponse);
                    if (bulkResponse.hasFailures()) {
                        throw new Exception(bulkResponse.buildFailureMessage());
                    }
                    this.lastUpdateTimestamp = lastDate;
                    percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
                    bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                }
                if (!this.forcedLastUpdateTimestampOnRestartReset) continue;
                LOGGER.info("{}: Cancelling running replication job due to user request.", (Object)this.id);
                break;
            }
            if (bulkRequest.numberOfActions() > 0) {
                if (!indexState.isValid()) {
                    throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
                }
                BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                LOGGER.debug("{}: OpenSearch call done", (Object)this.id);
                overallCounter += this.getNumberOfSuccessfullyIndexedDocuments(bulkResponse);
                if (bulkResponse.hasFailures()) {
                    throw new Exception(bulkResponse.buildFailureMessage());
                }
                this.lastUpdateTimestamp = lastDate;
                percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
            }
            LOGGER.info("{}: call percolator", (Object)this.id);
            percolatorsProcessor.process();
            if (overallCounter == 0) {
                if (replicatingLatestRecords) {
                    Timestamp adjustedUpperDateLimit = new Timestamp(upperDateLimitToReplicateLatestRecords.getTime() - TimeUnit.MINUTES.toMillis(15L));
                    if (this.lastUpdateTimestamp != null && adjustedUpperDateLimit.getTime() < this.lastUpdateTimestamp.getTime()) {
                        LOGGER.debug("{}: No data found in latest records range. Do not shift next fetch date lower limit, otherwise the replication will be stuck in an endless loop: {}", (Object)this.id, (Object)this.lastUpdateTimestamp);
                    } else {
                        this.lastUpdateTimestamp = adjustedUpperDateLimit;
                        LOGGER.info("{}: No data found in latest records range. Shift next fetch date lower limit to adjusted current time (minus 15 minutes): {}", (Object)this.id, (Object)this.lastUpdateTimestamp);
                    }
                } else {
                    Timestamp timestampOfNextRecord = this.getLowerLimitTimestamp(connection, upperDateLimit);
                    if (timestampOfNextRecord != null) {
                        this.lastUpdateTimestamp = DateUtil.cloneTimestampWithNanos(timestampOfNextRecord);
                        LOGGER.info("{}: No data found in regular range. Shift next fetch date lower limit close to the next existing db record {}", (Object)this.id, (Object)this.lastUpdateTimestamp);
                    } else {
                        this.lastUpdateTimestamp = DateUtil.cloneTimestampWithNanos(upperDateLimit);
                        LOGGER.info("{}: No data found in regular range. Shift next fetch date lower limit to {}", (Object)this.id, (Object)this.lastUpdateTimestamp);
                    }
                }
            }
            LOGGER.info("{}: Stop replication number {} - {}", (Object)this.id, (Object)this.stats.getJobCount(), (Object)new Date());
            LOGGER.info("{}: Replicated {} records in {}ms", (Object)this.id, (Object)overallCounter, (Object)this.stats.runningTimeInMillis());
            if (this.lastUpdateTimestamp != null && (this.lastUpdateTimestampOnRestart == null || this.lastUpdateTimestampOnRestart.getTime() != this.lastUpdateTimestamp.getTime())) {
                this.lastUpdateTimestampOnRestart = DateUtil.cloneTimestampWithNanos(this.lastUpdateTimestamp);
                lastUpdateTimestampOnRestartHandler.saveToIndex(this.lastUpdateTimestampOnRestart);
            }
            if (this.callback != null) {
                this.callback.onFinished("replication", this, percolatorsProcessor);
            }
            this.stats.resetLastOccurredException();
        }
        catch (ServiceNotFoundException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOGGER.error(this.id + ": Failed to start the replication job. " + ex.getMessage(), (Throwable)ex);
        }
        catch (SQLRecoverableException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOGGER.error(this.id + ": Could be that setting the pool properties like pool.testOnBorrow, ... can solve this error (Timeout, BPC-1893): " + ex.getMessage(), (Throwable)ex);
        }
        catch (SQLException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOGGER.error(this.id + ": SQL error: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (IOException | OpenSearchException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOGGER.error(this.id + ": OpenSearch error: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOGGER.error(this.id + ": Unexpected Exception!", (Throwable)ex);
        }
        catch (Throwable ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOGGER.error(this.id + ": Unexpected Throwable!", ex);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException ex) {
                    LOGGER.error(this.id + ": Closing prepared statement failed.", (Throwable)ex);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOGGER.error(this.id + ": Closing ResultSet failed.", (Throwable)ex);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOGGER.error(this.id + ": Closing database connection failed.", (Throwable)ex);
                }
            }
            this.stats.stop(overallCounter);
            logData.setValues(this.stats);
            if (this.settings.isLoggingEnabled()) {
                this.callback.persistReplicationJobLogData(logData);
            }
        }
    }

    private Timestamp getLowerLimitTimestamp(Connection connection, Timestamp startFromTimestamp) {
        try {
            return DbLowerLimitTimestampEvaluator.getLowerLimitTimestamp(connection, this.source.getQueryTimeoutInSeconds(), this.source.getCommonTableExpressionQuery(), this.source.getTable(), this.source.getLastUpdateColumn(), this.source.getLastUpdateColumnTimeZoneCalendar(), startFromTimestamp);
        }
        catch (SQLException ex) {
            LOGGER.error("{}: Could not get lower limit timestamp from database.", (Object)this.id, (Object)ex);
            return null;
        }
    }

    private int getNumberOfSuccessfullyIndexedDocuments(BulkResponse bulkResponse) {
        int result = 0;
        if (bulkResponse != null) {
            for (BulkItemResponse response : bulkResponse.getItems()) {
                if (response.isFailed()) continue;
                ++result;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationJob)) {
            return false;
        }
        ReplicationJob that = (ReplicationJob)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ReplicationJob{id=" + this.id + ", enabled=" + this.enabled + ", settings=" + this.settings + ", source=" + this.source + ", target=" + this.target + ", lastUpdateTimestamp=" + this.lastUpdateTimestamp + ", shadowCopy=" + this.shadowCopy + ", tailSync=" + this.tailSync + ", consistencyCheck=" + this.consistencyCheck + "}";
    }
}

