/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.StringUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationJobSettings {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationJobSettings.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd' 'HH:mm:ss.SSS";
    public static final String REPLICATION_DELAY = "replicationDelay";
    public static final String REPLICATION_INTERVAL = "replicationInterval";
    public static final String REPLICATION_START_DATE = "replicationStartDate";
    public static final String REPLICATION_BLOCK_SIZE = "replicationBlockSize";
    public static final String REPLICATION_BLOCK_DAY_RANGE = "replicationBlockDayRange";
    public static final String REPLICATION_SYNC_FILES = "replicationSyncFiles";
    public static final String REPLICATION_UNZIP_SYNCED_FILES = "replicationUnzipSyncedFiles";
    public static final String REPLICATION_RESTART_WHERE_LEFT_OFF = "restartReplicationWhereLeftOff";
    public static final String REPLICATION_ADJUST_UPPER_DATE_LIMIT_IN_SECONDS = "adjustUpperDateLimitInSeconds";
    public static final String REPLICATION_VAM_ORGANIZATION_ID = "vamOrganizationId";
    public static final String REPLICATION_LOGGING_ENABLED = "replicationLoggingEnabled";
    public static final int DEFAULT_REPLICATION_DELAY = 60;
    public static final int DEFAULT_REPLICATION_INTERVAL = 10;
    public static final String DEFAULT_REPLICATION_START_DATE = "2010-01-01 00:00:00.000";
    public static final int DEFAULT_BLOCK_SIZE = 2500;
    public static final int DEFAULT_BLOCK_DAY_RANGE = 10;
    public static final boolean DEFAULT_SYNC_FILES = false;
    public static final boolean DEFAULT_UNZIP_SYNCED_FILES = true;
    public static final boolean DEFAULT_REPLICATION_RESTART_WHERE_LEFT_OFF = true;
    public static final int DEFAULT_ADJUST_UPPER_DATE_LIMIT_IN_SECONDS = 0;
    public static final String DEFAULT_VAM_ORGANIZATION_ID = null;
    public static final boolean DEFAULT_REPLICATION_LOGGING_ENABLED = false;
    private final int replicationDelay;
    private final int replicationInterval;
    private final int blockSize;
    private final int blockDayRange;
    private final int adjustUpperDateLimitInSeconds;
    private final boolean syncFiles;
    private final boolean unzipSyncedFiles;
    private final boolean restartReplicationWhereLeftOff;
    private final String replicationStartDate;
    private final String vamOrganizationId;
    private final boolean loggingEnabled;
    private final transient DateFormat dateFormatter;

    private static String getNullWhenEmpty(String value) {
        return StringUtil.isNullOrEmpty(value) ? null : value;
    }

    public ReplicationJobSettings(ModuleConfiguration jobConfig) {
        this.replicationDelay = jobConfig.getSettingValue(REPLICATION_DELAY).asInt(60);
        this.replicationInterval = jobConfig.getSettingValue(REPLICATION_INTERVAL).asInt(10);
        this.replicationStartDate = jobConfig.getSettingValue(REPLICATION_START_DATE).asString(DEFAULT_REPLICATION_START_DATE);
        this.blockSize = jobConfig.getSettingValue(REPLICATION_BLOCK_SIZE).asInt(2500);
        this.blockDayRange = jobConfig.getSettingValue(REPLICATION_BLOCK_DAY_RANGE).asInt(10);
        this.syncFiles = jobConfig.getSettingValue(REPLICATION_SYNC_FILES).asBoolean(false);
        this.unzipSyncedFiles = jobConfig.getSettingValue(REPLICATION_UNZIP_SYNCED_FILES).asBoolean(true);
        this.restartReplicationWhereLeftOff = jobConfig.getSettingValue(REPLICATION_RESTART_WHERE_LEFT_OFF).asBoolean(true);
        this.adjustUpperDateLimitInSeconds = jobConfig.getSettingValue(REPLICATION_ADJUST_UPPER_DATE_LIMIT_IN_SECONDS).asInt(0);
        this.vamOrganizationId = ReplicationJobSettings.getNullWhenEmpty(jobConfig.getSettingValue(REPLICATION_VAM_ORGANIZATION_ID).asString(DEFAULT_VAM_ORGANIZATION_ID));
        this.loggingEnabled = jobConfig.getSettingValue(REPLICATION_LOGGING_ENABLED).asBoolean(false);
        this.dateFormatter = new SimpleDateFormat(DATE_FORMAT);
    }

    private ReplicationJobSettings(Builder builder) {
        this.replicationDelay = builder.replicationDelay;
        this.replicationInterval = builder.replicationInterval;
        this.blockSize = builder.blockSize;
        this.blockDayRange = builder.blockDayRange;
        this.adjustUpperDateLimitInSeconds = builder.adjustUpperDateLimitInSeconds;
        this.syncFiles = builder.syncFiles;
        this.unzipSyncedFiles = builder.unzipSyncedFiles;
        this.restartReplicationWhereLeftOff = builder.restartReplicationWhereLeftOff;
        this.replicationStartDate = builder.replicationStartDate;
        this.vamOrganizationId = ReplicationJobSettings.getNullWhenEmpty(builder.vamOrganizationId);
        this.loggingEnabled = builder.loggingEnabled;
        this.dateFormatter = new SimpleDateFormat(DATE_FORMAT);
    }

    public int getReplicationDelay() {
        return this.replicationDelay;
    }

    public int getReplicationInterval() {
        return this.replicationInterval;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getBlockDayRange() {
        return this.blockDayRange;
    }

    public int getAdjustUpperDateLimitInSeconds() {
        return this.adjustUpperDateLimitInSeconds;
    }

    public boolean isSyncFiles() {
        return this.syncFiles;
    }

    public boolean isUnzipSyncedFiles() {
        return this.unzipSyncedFiles;
    }

    public boolean isRestartReplicationWhereLeftOff() {
        return this.restartReplicationWhereLeftOff;
    }

    public String getReplicationStartDate() {
        return this.replicationStartDate;
    }

    public String getVamOrganizationId() {
        return this.vamOrganizationId;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public Date getReplicationStartDateAsDate() {
        Date result;
        try {
            result = this.dateFormatter.parse(this.replicationStartDate);
        }
        catch (ParseException e) {
            LOGGER.info("replicationStartDate ignored. Can't parse replicationStartDate ({}) with format yyyy-MM-dd' 'HH:mm:ss.SSS. Trying to parse it as an relative value.", (Object)this.replicationStartDate);
            try {
                result = DateUtil.getDateForRelativeValue(this.replicationStartDate);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("replicationStartDate ignored. replicationStartDate ({}) is not a relative value ({}).", (Object)this.replicationStartDate, (Object)ex.getMessage());
                result = new Date(0L);
            }
        }
        return result;
    }

    public DateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReplicationJobSettings)) {
            return false;
        }
        ReplicationJobSettings that = (ReplicationJobSettings)o;
        return this.replicationDelay == that.replicationDelay && this.replicationInterval == that.replicationInterval && this.blockSize == that.blockSize && this.blockDayRange == that.blockDayRange && this.adjustUpperDateLimitInSeconds == that.adjustUpperDateLimitInSeconds && this.syncFiles == that.syncFiles && this.unzipSyncedFiles == that.unzipSyncedFiles && this.restartReplicationWhereLeftOff == that.restartReplicationWhereLeftOff && this.loggingEnabled == that.loggingEnabled && Objects.equals(this.replicationStartDate, that.replicationStartDate) && Objects.equals(this.vamOrganizationId, that.vamOrganizationId);
    }

    public int hashCode() {
        return Objects.hash(this.replicationDelay, this.replicationInterval, this.blockSize, this.blockDayRange, this.adjustUpperDateLimitInSeconds, this.syncFiles, this.unzipSyncedFiles, this.restartReplicationWhereLeftOff, this.replicationStartDate, this.vamOrganizationId, this.loggingEnabled);
    }

    public String toString() {
        return "ReplicationJobSettings{replicationDelay=" + this.replicationDelay + ", replicationInterval=" + this.replicationInterval + ", blockSize=" + this.blockSize + ", blockDayRange=" + this.blockDayRange + ", adjustUpperDateLimitInSeconds=" + this.adjustUpperDateLimitInSeconds + ", syncFiles=" + this.syncFiles + ", unzipSyncedFiles=" + this.unzipSyncedFiles + ", restartReplicationWhereLeftOff=" + this.restartReplicationWhereLeftOff + ", replicationStartDate='" + this.replicationStartDate + "', vamOrganizationId='" + this.vamOrganizationId + "', loggingEnabled=" + this.loggingEnabled + ", dateFormatter=" + this.dateFormatter + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int replicationDelay = 60;
        private int replicationInterval = 10;
        private String replicationStartDate = "2010-01-01 00:00:00.000";
        private int blockSize = 2500;
        private int blockDayRange = 10;
        private boolean syncFiles = false;
        private boolean unzipSyncedFiles = true;
        private boolean restartReplicationWhereLeftOff = true;
        private int adjustUpperDateLimitInSeconds = 0;
        private String vamOrganizationId = null;
        private boolean loggingEnabled = false;

        private Builder() {
        }

        public Builder replicationDelay(int replicationDelay) {
            this.replicationDelay = replicationDelay;
            return this;
        }

        public Builder replicationInterval(int replicationInterval) {
            this.replicationInterval = replicationInterval;
            return this;
        }

        public Builder replicationStartDate(String replicationStartDate) {
            this.replicationStartDate = replicationStartDate;
            return this;
        }

        public Builder blockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder blockDayRange(int blockDayRange) {
            this.blockDayRange = blockDayRange;
            return this;
        }

        public Builder syncFiles(boolean syncFiles) {
            this.syncFiles = syncFiles;
            return this;
        }

        public Builder unzipSyncedFiles(boolean unzipSyncedFiles) {
            this.unzipSyncedFiles = unzipSyncedFiles;
            return this;
        }

        public Builder restartReplicationWhereLeftOff(boolean restartReplicationWhereLeftOff) {
            this.restartReplicationWhereLeftOff = restartReplicationWhereLeftOff;
            return this;
        }

        public Builder adjustUpperDateLimitInSeconds(int adjustUpperDateLimitInSeconds) {
            this.adjustUpperDateLimitInSeconds = adjustUpperDateLimitInSeconds;
            return this;
        }

        public Builder vamOrganizationId(String vamOrganizationId) {
            this.vamOrganizationId = vamOrganizationId;
            return this;
        }

        public Builder loggingEnabled(boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public ReplicationJobSettings build() {
            return new ReplicationJobSettings(this);
        }
    }
}

