/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckResult;
import java.util.Date;
import java.util.Objects;

public class ConsistencyCheck {
    public static final String REPLICATION_CONSISTENCY_CHECK_FREQUENCY_FIELD = "replicationConsistencyCheckFrequency";
    public static final int DEFAULT_REPLICATION_CONSISTENCY_CHECK_FREQUENCY = 0;
    private final int consistencyCheckFrequency;
    private transient boolean sourceAndTargetConsistent = true;
    private transient boolean running;
    private transient long runCount;
    private transient long errorCount;
    private transient Date lastRunStart;
    private transient Date lastRunEnd;
    private transient long lastRunSourceDocsCount;
    private transient long lastRunTargetDocsCount;

    public ConsistencyCheck(ModuleConfiguration jobConfig) {
        this.consistencyCheckFrequency = jobConfig.getSettingValue(REPLICATION_CONSISTENCY_CHECK_FREQUENCY_FIELD).asInt(0);
    }

    private ConsistencyCheck(Builder builder) {
        this.consistencyCheckFrequency = builder.consistencyCheckFrequency;
    }

    public void started() {
        this.running = true;
        this.lastRunStart = new Date();
        this.lastRunEnd = null;
    }

    public void increaseRunCount() {
        ++this.runCount;
    }

    public void increaseErrorCount() {
        ++this.errorCount;
    }

    public void setLastRunResult(ConsistencyCheckResult consistencyCheckResult) {
        this.sourceAndTargetConsistent = consistencyCheckResult.areSourceAndTargetConsistent();
        this.lastRunSourceDocsCount = consistencyCheckResult.getNumberOfSourceRows();
        this.lastRunTargetDocsCount = consistencyCheckResult.getNumberOfTargetDocuments();
    }

    public void stopped() {
        this.running = false;
        this.lastRunEnd = new Date();
    }

    public boolean areSourceAndTargetConsistent() {
        return this.sourceAndTargetConsistent;
    }

    public int getConsistencyCheckFrequency() {
        return this.consistencyCheckFrequency;
    }

    public boolean isEnabled() {
        return this.consistencyCheckFrequency > 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getRunCount() {
        return this.runCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public Date getLastRunStart() {
        return this.lastRunStart;
    }

    public Date getLastRunEnd() {
        return this.lastRunEnd;
    }

    public long getLastRunSourceDocsCount() {
        return this.lastRunSourceDocsCount;
    }

    public long getLastRunTargetDocsCount() {
        return this.lastRunTargetDocsCount;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConsistencyCheck)) {
            return false;
        }
        ConsistencyCheck that = (ConsistencyCheck)o;
        return this.consistencyCheckFrequency == that.consistencyCheckFrequency;
    }

    public int hashCode() {
        return Objects.hash(this.consistencyCheckFrequency);
    }

    public String toString() {
        return "ConsistencyCheck{consistencyCheckFrequency=" + this.consistencyCheckFrequency + ", sourceAndTargetConsistent=" + this.sourceAndTargetConsistent + ", running=" + this.running + ", runCount=" + this.runCount + ", errorCount=" + this.errorCount + ", lastRunStart=" + this.lastRunStart + ", lastRunEnd=" + this.lastRunEnd + ", lastRunSourceDocsCount=" + this.lastRunSourceDocsCount + ", lastRunTargetDocsCount=" + this.lastRunTargetDocsCount + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int consistencyCheckFrequency = 0;

        private Builder() {
        }

        public Builder consistencyCheckFrequency(int consistencyCheckFrequency) {
            this.consistencyCheckFrequency = consistencyCheckFrequency;
            return this;
        }

        public ConsistencyCheck build() {
            return new ConsistencyCheck(this);
        }
    }
}

