/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.DbColumnNamesToOpenSearchFieldNamesConverter;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.search.builder.SearchSourceBuilder;

class TailSyncOpenSearchHandler {
    private static final Logger LOGGER = LogManager.getLogger(TailSyncOpenSearchHandler.class);
    private final OpenSearchService oss;
    private final String osIndex;
    private final DbColumnNamesToOpenSearchFieldNamesConverter dbColumnNamesToOpenSearchFieldNamesConverter;
    private final String replicationJobId;

    TailSyncOpenSearchHandler(OpenSearchService oss, ReplicationTarget replicationTarget, String replicationJobId) {
        this.oss = oss;
        this.osIndex = replicationTarget.getIndex();
        this.dbColumnNamesToOpenSearchFieldNamesConverter = replicationTarget.getDbColumnNamesToOpenSearchFieldNamesConverter();
        this.replicationJobId = replicationJobId;
    }

    void destroy() {
        LOGGER.info("{}: destroy", (Object)this.replicationJobId);
    }

    void deleteDocumentsOlderThan(String dbLastUpdateColumnName, Timestamp startTimestamp) throws OpenSearchRelatedException {
        LOGGER.info("{}: deleteDocumentsOlderThan dbLastUpdateColumnName={}, startTimestamp={}", (Object)this.replicationJobId, (Object)dbLastUpdateColumnName, (Object)startTimestamp);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            String lastUpdateFieldInOpenSearch = this.dbColumnNamesToOpenSearchFieldNamesConverter.convert(dbLastUpdateColumnName);
            DeleteByQueryRequest deleteByQueryRequest = (DeleteByQueryRequest)new DeleteByQueryRequest(this.osIndex).setQuery(QueryBuilders.rangeQuery(lastUpdateFieldInOpenSearch).lt(startTimestamp.getTime())).setRefresh(true);
            BulkByScrollResponse dbqrsp = osClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            LOGGER.info("{}: Deleted {} documents older than {} from '{}'", (Object)this.replicationJobId, (Object)dbqrsp.getDeleted(), (Object)startTimestamp, (Object)this.osIndex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GetDataResult getRecordData(String[] dbIdColumnNames, String dbLastUpdateColumnName, Timestamp lowerDateLimit, Timestamp upperDateLimit) {
        LOGGER.info("{}: getRecordData dbIdColumnNames={}, dbLastUpdateColumnName={}, lowerDateLimit={}, upperDateLimit={}", (Object)this.replicationJobId, (Object)dbIdColumnNames, (Object)dbLastUpdateColumnName, (Object)lowerDateLimit, (Object)upperDateLimit);
        long startTimestamp = System.currentTimeMillis();
        try {
            HashMap<String, RecordData> result = new HashMap<String, RecordData>();
            List<String> openSearchFieldNamesToFetch = this.getFieldNamesToFetchFromOpenSearch(dbIdColumnNames, dbLastUpdateColumnName);
            String lastUpdateFieldInOpenSearch = this.dbColumnNamesToOpenSearchFieldNamesConverter.convert(dbLastUpdateColumnName);
            SearchRequest searchRequest = new SearchRequest().indices(this.osIndex).source(new SearchSourceBuilder().fetchSource(openSearchFieldNamesToFetch.toArray(new String[0]), null).size(10000).query(QueryBuilders.rangeQuery(lastUpdateFieldInOpenSearch).gt(lowerDateLimit.getTime()).lte(upperDateLimit.getTime())));
            this.oss.search(searchRequest, searchHit -> {
                Map<String, Object> source = searchHit.getSourceAsMap();
                LinkedHashMap<String, Object> idColumnNamesAndValues = new LinkedHashMap<String, Object>();
                for (String dbIdColumnName : dbIdColumnNames) {
                    String openSearchIdFieldName = this.dbColumnNamesToOpenSearchFieldNamesConverter.convert(dbIdColumnName);
                    idColumnNamesAndValues.put(dbIdColumnName, source.get(openSearchIdFieldName));
                }
                Object lastUpdateFieldValueObject = source.get(lastUpdateFieldInOpenSearch);
                if (lastUpdateFieldValueObject instanceof String) {
                    String lastUpdateFieldValue = (String)lastUpdateFieldValueObject;
                    Calendar calendar = DatatypeConverter.parseDateTime((String)lastUpdateFieldValue);
                    RecordData recordData = new RecordData(idColumnNamesAndValues, calendar.getTime());
                    result.put(recordData.getRecordId(), recordData);
                } else {
                    LOGGER.error("{}: Unhandled type of lastUpdateFieldValueObject ({}):{}", (Object)this.replicationJobId, lastUpdateFieldValueObject, (Object)lastUpdateFieldValueObject.getClass().getName());
                }
            });
            GetDataResult getDataResult = new GetDataResult(result);
            return getDataResult;
        }
        catch (Throwable throwable) {
            GetDataResult getDataResult = new GetDataResult(throwable);
            return getDataResult;
        }
        finally {
            LOGGER.info("{}: getRecordData time: {} ms", (Object)this.replicationJobId, (Object)(System.currentTimeMillis() - startTimestamp));
        }
    }

    private List<String> getFieldNamesToFetchFromOpenSearch(String[] dbIdColumnNames, String dbLastUpdateColumnName) {
        ArrayList<String> result = new ArrayList<String>();
        if (dbIdColumnNames != null) {
            for (String dbIdColumnName : dbIdColumnNames) {
                result.add(this.dbColumnNamesToOpenSearchFieldNamesConverter.convert(dbIdColumnName));
            }
        }
        if (dbLastUpdateColumnName != null) {
            result.add(this.dbColumnNamesToOpenSearchFieldNamesConverter.convert(dbLastUpdateColumnName));
        }
        return result;
    }
}

