/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.ExtOpenSearchService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class ExtOpenSearchServiceImpl
implements ExtOpenSearchService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(ExtOpenSearchServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;

    public ExtOpenSearchServiceImpl(BundleContext bundleContext) {
        LOGGER.info("ExtOpenSearchServiceImpl bundleContext=...");
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIndex(String indexName, Object initiator) throws ServiceNotFoundException, OpenSearchRelatedException, ModuleNotFoundException, OpenSearchIndexNotFoundException {
        LOGGER.info("deleteIndex indexName={}, initiator=...", (Object)indexName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ModuleManager moduleManager = this.moduleManagerTracker.getService();
        ReplicationModule replicationModule = moduleManager.getModuleByClass(ReplicationModule.class);
        Set<String> aliasesOfIndexName = oss.getAliasesForIndexName(indexName);
        List<ReplicationJob> relatedReplicationJobs = replicationModule.getReplicationJobsUsingTargetIndexAliases(aliasesOfIndexName);
        HashSet<String> relatedReplicationJobIDs = new HashSet<String>();
        for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
            relatedReplicationJobIDs.add(relatedReplicationJob.getId());
        }
        if (!relatedReplicationJobIDs.isEmpty()) {
            try {
                replicationModule.sendReplicationJobsToPluginForOrchestrationForJobsToStopTemporarily(relatedReplicationJobIDs, true);
                SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started due to the jobs '" + relatedReplicationJobIDs + "' that must be temporarily stopped. Caused by deletion of index '" + indexName + "'.");
                replicationModule.waitUntilReplicationJobsAreStopped(relatedReplicationJobIDs);
            }
            catch (Exception ex) {
                LOGGER.error("Replication jobs orchestration failed on deletion of index '{}' to stop related jobs temporarily.", (Object)indexName, (Object)ex);
            }
        }
        try {
            Object alias;
            oss.deleteIndexWithException(indexName);
            if (initiator instanceof String) {
                UserAuditLog.info((String)initiator, "OpenSearchIndexDeleted", "OpenSearch index '" + indexName + "' deleted.");
            } else if (initiator instanceof UserSession) {
                UserAuditLog.info((UserSession)initiator, "OpenSearchIndexDeleted", "OpenSearch index '" + indexName + "' deleted.");
            }
            if (aliasesOfIndexName.size() == 1 && oss.existsAttachmentsPipeline((String)(alias = aliasesOfIndexName.iterator().next()))) {
                oss.deleteAttachmentsPipeline((String)alias);
            }
            if (aliasesOfIndexName.size() >= 1) {
                for (String aliasOfIndexName : aliasesOfIndexName) {
                    if (!oss.hasIndexState(aliasOfIndexName)) continue;
                    BpcIndexState indexState = oss.getIndexState(aliasOfIndexName);
                    indexState.handleDeletedIndex(indexName);
                }
            }
        }
        finally {
            if (!relatedReplicationJobIDs.isEmpty()) {
                try {
                    replicationModule.sendReplicationJobsToPluginForOrchestrationForJobsToStopTemporarily(relatedReplicationJobIDs, false);
                    SystemAuditLog.info("ReplicationJobsOrchestration", "Replication jobs orchestration started due to the jobs '" + relatedReplicationJobIDs + "' that must be restarted. Caused by deletion of index '" + indexName + "'.");
                    replicationModule.waitUntilReplicationJobsAreRunning(relatedReplicationJobIDs);
                }
                catch (Exception ex) {
                    LOGGER.error("Replication jobs orchestration failed on deletion of index '{}' to restart the temporarily stopped jobs .", (Object)indexName, (Object)ex);
                }
            }
        }
    }
}

