/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.core.service.MetricsService;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import io.prometheus.client.Collector;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.osgi.framework.BundleContext;

public class MetricsServiceImpl
implements MetricsService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(MetricsServiceImpl.class);
    public static final String INDEX_NAME = "bpc-metrics";
    private final BlockingQueue<Map<String, Object>> metricsToBeWrittenQueue = new LinkedBlockingDeque<Map<String, Object>>();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private ScheduledExecutorService metricsCollectorExecutorService;
    private ScheduledFuture<?> metricsCollectorExecutorHandle;
    private ScheduledExecutorService metricsWriterExecutorService;
    private ScheduledFuture<?> metricsWriterHandle;
    private List<CollectorWithRuntimeInfos> collectorsWithRuntimeInfos;

    public MetricsServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.collectorsWithRuntimeInfos = new ArrayList<CollectorWithRuntimeInfos>();
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.metricsCollectorExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-metrics-executor"));
        this.metricsWriterExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-metrics-writer"));
        this.metricsCollectorExecutorHandle = this.metricsCollectorExecutorService.scheduleWithFixedDelay(new MetricsCollectorRunnable(), 15L, 1L, TimeUnit.SECONDS);
        this.metricsWriterHandle = this.metricsWriterExecutorService.scheduleWithFixedDelay(new MetricsWriterRunnable(), 15L, 15L, TimeUnit.SECONDS);
        this.startMetricsIndexCleanupTask();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        this.stopMetricsIndexCleanupTask();
        if (this.metricsCollectorExecutorHandle != null) {
            if (this.metricsCollectorExecutorHandle.cancel(true)) {
                LOGGER.info("Running metrics collector cancelled");
            } else {
                LOGGER.warn("Failed to stop/cancel the running metrics collector");
            }
            this.metricsCollectorExecutorHandle = null;
        }
        if (this.metricsCollectorExecutorService != null) {
            try {
                this.metricsCollectorExecutorService.shutdownNow();
                this.metricsCollectorExecutorService = null;
            }
            catch (RuntimeException ex) {
                LOGGER.error("Failed to shutdown the metrics collector executor");
            }
        }
        if (this.metricsWriterHandle != null) {
            if (this.metricsWriterHandle.cancel(false)) {
                LOGGER.info("Running metrics writer cancelled");
            } else {
                LOGGER.warn("Failed to stop/cancel the running metrics writer");
            }
            this.metricsWriterHandle = null;
        }
        if (this.metricsWriterExecutorService != null) {
            try {
                this.metricsWriterExecutorService.shutdownNow();
                this.metricsWriterExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.metricsWriterExecutorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOGGER.error("Failed to shutdown the metrics writer executor");
            }
        }
        this.collectorsWithRuntimeInfos.clear();
        this.collectorsWithRuntimeInfos = null;
        BpcServicesTracker.stopAll(this);
    }

    private void startMetricsIndexCleanupTask() {
        LOGGER.info("startMetricsIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, "timestamp", "1 year ago", 4, TimeUnit.HOURS);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to schedule the index cleanup task for the index 'bpc-metrics'.", (Throwable)ex);
        }
    }

    private void stopMetricsIndexCleanupTask() {
        LOGGER.info("stopMetricsIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to stop/cancel the running cleanup task for the index 'bpc-metrics'.", (Throwable)ex);
        }
    }

    @Override
    public void registerCollector(String name, Collector collector, long collectEveryNumberOfSeconds) {
        LOGGER.info("registerCollector name={}, collector={}, collectEveryNumberOfSeconds={}", (Object)name, (Object)collector, (Object)collectEveryNumberOfSeconds);
        if (collector == null) {
            return;
        }
        CollectorWithRuntimeInfos existingCollectorWithRuntimeInfos = null;
        for (CollectorWithRuntimeInfos collectorWithRuntimeInfos : this.collectorsWithRuntimeInfos) {
            if (!collectorWithRuntimeInfos.isSameCollector(collector)) continue;
            existingCollectorWithRuntimeInfos = collectorWithRuntimeInfos;
            break;
        }
        if (existingCollectorWithRuntimeInfos != null) {
            this.collectorsWithRuntimeInfos.remove(existingCollectorWithRuntimeInfos);
        }
        this.collectorsWithRuntimeInfos.add(new CollectorWithRuntimeInfos(name, collector, collectEveryNumberOfSeconds));
    }

    class MetricsCollectorRunnable
    implements Runnable {
        MetricsCollectorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (CollectorWithRuntimeInfos collectorWithRuntimeInfos : MetricsServiceImpl.this.collectorsWithRuntimeInfos) {
                if (!collectorWithRuntimeInfos.mustRun()) continue;
                try {
                    Map<String, Object> openSearchSourceValue = collectorWithRuntimeInfos.collectAndConvertToOpenSearchSourceValue();
                    if (openSearchSourceValue == null) continue;
                    MetricsServiceImpl.this.metricsToBeWrittenQueue.add(openSearchSourceValue);
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to execute a collector.", t);
                }
                finally {
                    collectorWithRuntimeInfos.setAsJustRun();
                }
            }
        }
    }

    class MetricsWriterRunnable
    implements Runnable {
        MetricsWriterRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.info("{}: Starting ...", (Object)this.getClass().getSimpleName());
            long startTime = System.currentTimeMillis();
            try {
                Map entryToWrite;
                ZonedDateTime now = ZonedDateTime.now().minus(500L, ChronoUnit.MILLIS);
                ArrayList<Map> entriesToWrite = new ArrayList<Map>();
                while ((entryToWrite = (Map)MetricsServiceImpl.this.metricsToBeWrittenQueue.poll()) != null) {
                    entriesToWrite.add(entryToWrite);
                    ZonedDateTime logEntryDateTime = ZonedDateTime.parse((String)entryToWrite.get("timestamp"), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    if (!logEntryDateTime.isAfter(now)) continue;
                    break;
                }
                LOGGER.info("{}: {} entries to index ({} entries still in the queue)", (Object)this.getClass().getSimpleName(), (Object)entriesToWrite.size(), (Object)MetricsServiceImpl.this.metricsToBeWrittenQueue.size());
                if (!entriesToWrite.isEmpty()) {
                    OpenSearchService oss = MetricsServiceImpl.this.openSearchServiceTracker.getService();
                    BulkRequest bulkRequest = new BulkRequest();
                    bulkRequest.timeout(TimeValue.timeValueSeconds(60L));
                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    for (Map entryToWrite2 : entriesToWrite) {
                        bulkRequest.add(((IndexRequest)new IndexRequest().index(MetricsServiceImpl.INDEX_NAME)).source(entryToWrite2, (MediaType)XContentType.JSON));
                    }
                    BulkResponse bulkResponse = oss.bulk(bulkRequest, RequestOptions.DEFAULT);
                    if (bulkResponse.hasFailures()) {
                        throw new Exception("Metrics indexing failed: " + bulkResponse.buildFailureMessage());
                    }
                    MetricsServiceImpl.this.percolatorsManagerTracker.getService().informClientsAboutReplicatedData(oss, MetricsServiceImpl.INDEX_NAME, bulkResponse);
                }
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to write the metrics in batch.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
            finally {
                LOGGER.info("{}: Finished after {} milliseconds", (Object)this.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    static class CollectorWithRuntimeInfos {
        private final String name;
        private final Collector collector;
        private final long collectEveryNumberOfSeconds;
        private long lastRunWasAtTimeInMillis;

        public CollectorWithRuntimeInfos(String name, Collector collector, long collectEveryNumberOfSeconds) {
            this.name = name;
            this.collector = collector;
            this.collectEveryNumberOfSeconds = collectEveryNumberOfSeconds;
            this.lastRunWasAtTimeInMillis = -1L;
        }

        public boolean isSameCollector(Collector collector) {
            return this.collector.getClass().equals(collector.getClass());
        }

        public boolean mustRun() {
            if (this.collectEveryNumberOfSeconds <= 0L) {
                return false;
            }
            if (this.lastRunWasAtTimeInMillis <= -1L) {
                return true;
            }
            return this.lastRunWasAtTimeInMillis + TimeUnit.SECONDS.toMillis(this.collectEveryNumberOfSeconds) <= System.currentTimeMillis();
        }

        public void setAsJustRun() {
            this.lastRunWasAtTimeInMillis = System.currentTimeMillis();
        }

        public Map<String, Object> collectAndConvertToOpenSearchSourceValue() {
            List metricSamples = this.collector.collect();
            return this.convertToOpenSearchSource(metricSamples);
        }

        private Map<String, Object> convertToOpenSearchSource(List<Collector.MetricFamilySamples> metricSamples) {
            String now = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            HashMap<String, Double> values = new HashMap<String, Double>();
            for (Collector.MetricFamilySamples metricSample : metricSamples) {
                if (metricSample.type == Collector.Type.GAUGE) {
                    values.put(metricSample.name, ((Collector.MetricFamilySamples.Sample)metricSample.samples.get((int)0)).value);
                    continue;
                }
                LOGGER.error("Please get in touch with the BPC developers. There is a implementation missing for the metric type: " + metricSample.type);
            }
            if (values.isEmpty()) {
                return null;
            }
            HashMap<String, Object> openSearchSourceValue = new HashMap<String, Object>();
            openSearchSourceValue.put("name", this.name);
            openSearchSourceValue.put("value", values);
            openSearchSourceValue.put("timestamp", now);
            return openSearchSourceValue;
        }
    }
}

