/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.core.service.QuartzSchedulerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzSchedulerServiceImpl
implements QuartzSchedulerService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(QuartzSchedulerServiceImpl.class);
    private final BundleContext bundleContext;
    private Scheduler scheduler;

    public QuartzSchedulerServiceImpl(BundleContext bundleContext) {
        LOGGER.debug("QuartzSchedulerServiceImpl bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        this.initializeScheduler();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.debug("shutdownService");
        this.shutdownScheduler();
    }

    private void initializeScheduler() {
        LOGGER.debug("initializeScheduler");
        if (this.scheduler == null) {
            try {
                this.scheduler = StdSchedulerFactory.getDefaultScheduler();
                this.scheduler.start();
            }
            catch (SchedulerException ex) {
                LOGGER.error("Failed to initialize the quartz scheduler.", (Throwable)ex);
            }
        }
    }

    private void shutdownScheduler() {
        LOGGER.debug("shutdownScheduler");
        if (this.scheduler != null) {
            try {
                if (!this.scheduler.isShutdown()) {
                    this.scheduler.shutdown(false);
                }
            }
            catch (SchedulerException ex) {
                LOGGER.error("Failed to stop/shutdown the quartz scheduler.", (Throwable)ex);
            }
            finally {
                this.scheduler = null;
            }
        }
    }

    @Override
    public void scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        LOGGER.debug("scheduleJob jobDetail={}, trigger={}", (Object)jobDetail, (Object)trigger);
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    @Override
    public void deleteJob(String jobName, String jobGroup) throws SchedulerException {
        LOGGER.debug("deleteJob jobName={}, jobGroup={}", (Object)jobName, (Object)jobGroup);
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        this.deleteJob(jobKey);
    }

    @Override
    public void deleteJob(JobKey jobKey) throws SchedulerException {
        LOGGER.debug("deleteJob jobKey={}", (Object)jobKey);
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.interrupt(jobKey);
            this.scheduler.deleteJob(jobKey);
        }
    }

    @Override
    public void deleteAllJobsOfGroup(String group) throws SchedulerException {
        LOGGER.debug("deleteAllJobsOfGroup group={}", (Object)group);
        Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)group));
        for (JobKey jobKey : jobKeys) {
            this.deleteJob(jobKey);
        }
    }

    @Override
    public List<String> getJobGroupNames() throws SchedulerException {
        LOGGER.debug("getJobGroupNames");
        return this.scheduler.getJobGroupNames();
    }

    @Override
    public List<String> getJobNames(String jobGroup) throws SchedulerException {
        LOGGER.debug("getJobNames jobGroup={}", (Object)jobGroup);
        ArrayList<String> jobNames = new ArrayList<String>();
        Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)jobGroup));
        for (JobKey jobKey : jobKeys) {
            jobNames.add(jobKey.getName());
        }
        return jobNames;
    }
}

