/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.util.StringUtil;
import javax.ws.rs.core.HttpHeaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IguasuHelper {
    private static final Logger LOGGER = LogManager.getLogger(IguasuHelper.class);

    public static ExternalReferenceData extractIguasuSpecificHeaderValues(HttpHeaders httpHeaders) {
        LOGGER.debug("extractIguasuSpecificHeaderValues httpHeaders={}", (Object)httpHeaders);
        if (httpHeaders == null) {
            return null;
        }
        String iguasuSystemId = httpHeaders.getHeaderString("IGUASU-System-ID");
        String iguasuInstanceId = httpHeaders.getHeaderString("IGUASU-Instance-ID");
        String iguasuProcessorId = httpHeaders.getHeaderString("IGUASU-Processor-ID");
        String iguasuServiceId = httpHeaders.getHeaderString("IGUASU-Service-ID");
        if (StringUtil.isNullOrEmpty(iguasuSystemId)) {
            return null;
        }
        return new ExternalReferenceData("iguasu").add("system", iguasuSystemId).add("instance", iguasuInstanceId).add("processor", iguasuProcessorId).add("service", iguasuServiceId);
    }
}

