/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.close;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.LegacyESVersion;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.replication.ReplicationOperation;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportVerifyShardBeforeCloseAction
extends TransportReplicationAction<ShardRequest, ShardRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/close[s]";
    protected Logger logger = LogManager.getLogger(this.getClass());

    @Inject
    public TransportVerifyShardBeforeCloseAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction stateAction, ActionFilters actionFilters) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, stateAction, actionFilters, ShardRequest::new, ShardRequest::new, "management");
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void acquirePrimaryOperationPermit(IndexShard primary, ShardRequest request, ActionListener<Releasable> onAcquired) {
        primary.acquireAllPrimaryOperationsPermits(onAcquired, request.timeout());
    }

    @Override
    protected void acquireReplicaOperationPermit(IndexShard replica, ShardRequest request, ActionListener<Releasable> onAcquired, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdateOrDeletes) {
        replica.acquireAllReplicaOperationsPermits(primaryTerm, globalCheckpoint, maxSeqNoOfUpdateOrDeletes, onAcquired, request.timeout());
    }

    @Override
    protected void shardOperationOnPrimary(ShardRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            this.executeShardOperation(shardRequest, primary);
            return new TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
        });
    }

    @Override
    protected void shardOperationOnReplica(ShardRequest shardRequest, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            this.executeShardOperation(shardRequest, replica);
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    private void executeShardOperation(ShardRequest request, IndexShard indexShard) throws IOException {
        ShardId shardId = indexShard.shardId();
        if (indexShard.getActiveOperationsCount() != -1) {
            throw new IllegalStateException("Index shard " + String.valueOf(shardId) + " is not blocking all operations during closing");
        }
        ClusterBlocks clusterBlocks = this.clusterService.state().blocks();
        if (!clusterBlocks.hasIndexBlock(shardId.getIndexName(), request.clusterBlock())) {
            throw new IllegalStateException("Index shard " + String.valueOf(shardId) + " must be blocked by " + String.valueOf(request.clusterBlock()) + " before closing");
        }
        if (request.isPhase1()) {
            indexShard.sync();
        } else {
            indexShard.verifyShardBeforeIndexClosing();
            indexShard.flush(new FlushRequest(new String[0]).force(true).waitIfOngoing(true));
            this.logger.trace("{} shard is ready for closing", (Object)shardId);
        }
    }

    @Override
    protected ReplicationOperation.Replicas<ShardRequest> newReplicasProxy() {
        return new VerifyShardBeforeCloseActionReplicasProxy();
    }

    public static class ShardRequest
    extends ReplicationRequest<ShardRequest> {
        private final ClusterBlock clusterBlock;
        private final boolean phase1;

        ShardRequest(StreamInput in) throws IOException {
            super(in);
            this.clusterBlock = new ClusterBlock(in);
            this.phase1 = in.getVersion().onOrAfter(LegacyESVersion.V_7_3_0) ? in.readBoolean() : false;
        }

        public ShardRequest(ShardId shardId, ClusterBlock clusterBlock, boolean phase1, TaskId parentTaskId) {
            super(shardId);
            this.clusterBlock = Objects.requireNonNull(clusterBlock);
            this.phase1 = phase1;
            this.setParentTask(parentTaskId);
        }

        @Override
        public String toString() {
            return "verify shard " + String.valueOf(this.shardId) + " before close with block " + String.valueOf(this.clusterBlock);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.clusterBlock.writeTo(out);
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_3_0)) {
                out.writeBoolean(this.phase1);
            }
        }

        public ClusterBlock clusterBlock() {
            return this.clusterBlock;
        }

        public boolean isPhase1() {
            return this.phase1;
        }
    }

    class VerifyShardBeforeCloseActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        VerifyShardBeforeCloseActionReplicasProxy() {
            super(TransportVerifyShardBeforeCloseAction.this);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportVerifyShardBeforeCloseAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }
}

