/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import java.util.concurrent.TimeUnit;
import org.opensearch.OpenSearchException;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.BaseFuture;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.common.util.concurrent.UncategorizedExecutionException;
import org.opensearch.core.action.ActionListener;

public abstract class AdapterActionFuture<T, L>
extends BaseFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    @Override
    public T actionGet() {
        try {
            return FutureUtils.get(this);
        }
        catch (OpenSearchException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    @Override
    public T actionGet(String timeout) {
        return this.actionGet(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".actionGet.timeout"));
    }

    @Override
    public T actionGet(long timeoutMillis) {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(TimeValue timeout) {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout, TimeUnit unit) {
        try {
            return FutureUtils.get(this, timeout, unit);
        }
        catch (OpenSearchException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    @Override
    public void onResponse(L result) {
        this.set(this.convert(result));
    }

    @Override
    public void onFailure(Exception e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);

    private static RuntimeException unwrapEsException(OpenSearchException esEx) {
        Throwable root = esEx.unwrapCause();
        if (root instanceof RuntimeException) {
            return (RuntimeException)root;
        }
        return new UncategorizedExecutionException("Failed execution", root);
    }
}

