/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.client.tasks.TaskId;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ObjectParser;

public class TaskInfo {
    private TaskId taskId;
    private String type;
    private String action;
    private String description;
    private long startTime;
    private long runningTimeNanos;
    private boolean cancellable;
    private boolean cancelled;
    private Long cancellationStartTime;
    private TaskId parentTaskId;
    private final Map<String, Object> status = new HashMap<String, Object>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, Object> resourceStats = new HashMap<String, Object>();
    public static final ObjectParser.NamedObjectParser<TaskInfo, Void> PARSER;

    public TaskInfo(TaskId taskId) {
        this.taskId = taskId;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public String getNodeId() {
        return this.taskId.nodeId;
    }

    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    public String getAction() {
        return this.action;
    }

    void setAction(String action) {
        this.action = action;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getRunningTimeNanos() {
        return this.runningTimeNanos;
    }

    void setRunningTimeNanos(long runningTimeNanos) {
        this.runningTimeNanos = runningTimeNanos;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    void setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Long getCancellationStartTime() {
        return this.cancellationStartTime;
    }

    public void setCancellationStartTime(Long cancellationStartTime) {
        this.cancellationStartTime = cancellationStartTime;
    }

    public TaskId getParentTaskId() {
        return this.parentTaskId;
    }

    void setParentTaskId(String parentTaskId) {
        this.parentTaskId = new TaskId(parentTaskId);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    void setStatus(Map<String, Object> status) {
        this.status.putAll(status);
    }

    public Map<String, Object> getStatus() {
        return this.status;
    }

    void setResourceStats(Map<String, Object> resourceStats) {
        this.resourceStats.putAll(resourceStats);
    }

    public Map<String, Object> getResourceStats() {
        return this.resourceStats;
    }

    private void noOpParse(Object s) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo taskInfo = (TaskInfo)o;
        return this.getStartTime() == taskInfo.getStartTime() && this.getRunningTimeNanos() == taskInfo.getRunningTimeNanos() && this.isCancellable() == taskInfo.isCancellable() && this.isCancelled() == taskInfo.isCancelled() && Objects.equals(this.getTaskId(), taskInfo.getTaskId()) && Objects.equals(this.getType(), taskInfo.getType()) && Objects.equals(this.getAction(), taskInfo.getAction()) && Objects.equals(this.getDescription(), taskInfo.getDescription()) && Objects.equals(this.getParentTaskId(), taskInfo.getParentTaskId()) && Objects.equals(this.status, taskInfo.status) && Objects.equals(this.getHeaders(), taskInfo.getHeaders()) && Objects.equals(this.getResourceStats(), taskInfo.getResourceStats()) && Objects.equals(this.getCancellationStartTime(), taskInfo.cancellationStartTime);
    }

    public int hashCode() {
        return Objects.hash(this.getTaskId(), this.getType(), this.getAction(), this.getDescription(), this.getStartTime(), this.getRunningTimeNanos(), this.isCancellable(), this.isCancelled(), this.getParentTaskId(), this.status, this.getHeaders(), this.getResourceStats(), this.getCancellationStartTime());
    }

    public String toString() {
        return "TaskInfo{taskId=" + String.valueOf(this.taskId) + ", type='" + this.type + "', action='" + this.action + "', description='" + this.description + "', startTime=" + this.startTime + ", runningTimeNanos=" + this.runningTimeNanos + ", cancellable=" + this.cancellable + ", cancelled=" + this.cancelled + ", parentTaskId=" + String.valueOf(this.parentTaskId) + ", status=" + String.valueOf(this.status) + ", headers=" + String.valueOf(this.headers) + ", resource_stats=" + String.valueOf(this.resourceStats) + ", cancellationStartTime=" + this.cancellationStartTime + "}";
    }

    static {
        ObjectParser<TaskInfo, Void> parser = new ObjectParser<TaskInfo, Void>("tasks", true, null);
        parser.declareString(TaskInfo::noOpParse, new ParseField("node", new String[0]));
        parser.declareLong(TaskInfo::noOpParse, new ParseField("id", new String[0]));
        parser.declareString(TaskInfo::setType, new ParseField("type", new String[0]));
        parser.declareString(TaskInfo::setAction, new ParseField("action", new String[0]));
        parser.declareObject(TaskInfo::setStatus, (p, c) -> p.map(), new ParseField("status", new String[0]));
        parser.declareString(TaskInfo::setDescription, new ParseField("description", new String[0]));
        parser.declareLong(TaskInfo::setStartTime, new ParseField("start_time_in_millis", new String[0]));
        parser.declareLong(TaskInfo::setRunningTimeNanos, new ParseField("running_time_in_nanos", new String[0]));
        parser.declareBoolean(TaskInfo::setCancellable, new ParseField("cancellable", new String[0]));
        parser.declareBoolean(TaskInfo::setCancelled, new ParseField("cancelled", new String[0]));
        parser.declareString(TaskInfo::setParentTaskId, new ParseField("parent_task_id", new String[0]));
        parser.declareObject(TaskInfo::setHeaders, (p, c) -> p.mapStrings(), new ParseField("headers", new String[0]));
        parser.declareObject(TaskInfo::setResourceStats, (p, c) -> p.map(), new ParseField("resource_stats", new String[0]));
        parser.declareLong(TaskInfo::setCancellationStartTime, new ParseField("cancellation_time_millis", new String[0]));
        PARSER = (p, v, name) -> parser.parse(p, new TaskInfo(new TaskId(name)), null);
    }
}

