/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.ExceptionsHelper;
import org.opensearch.Version;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRefCounted;
import org.opensearch.common.util.concurrent.RefCounted;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.common.util.iterable.Iterables;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.env.ShardLock;
import org.opensearch.env.ShardLockObtainFailedException;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.engine.CombinedDeletionPolicy;
import org.opensearch.index.seqno.SequenceNumbers;
import org.opensearch.index.shard.AbstractIndexShardComponent;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.ByteSizeCachingDirectory;
import org.opensearch.index.store.DirectoryFileTransferTracker;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.store.StoreStats;
import org.opensearch.index.store.VerifyingIndexOutput;
import org.opensearch.index.translog.Translog;

@PublicApi(since="1.0.0")
public class Store
extends AbstractIndexShardComponent
implements Closeable,
RefCounted {
    public static final Setting<Boolean> FORCE_RAM_TERM_DICT = Setting.boolSetting("index.force_memory_term_dictionary", false, Setting.Property.IndexScope, Setting.Property.Deprecated);
    static final String CODEC = "store";
    static final int CORRUPTED_MARKER_CODEC_VERSION = 2;
    public static final String CORRUPTED_MARKER_NAME_PREFIX = "corrupted_";
    public static final Setting<TimeValue> INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.store.stats_refresh_interval", TimeValue.timeValueSeconds(10L), Setting.Property.IndexScope);
    @Deprecated(forRemoval=true)
    public static final IOContext READONCE_CHECKSUM = new IOContext(IOContext.READONCE.context);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final StoreDirectory directory;
    private final ReentrantReadWriteLock metadataLock = new ReentrantReadWriteLock();
    private final ShardLock shardLock;
    private final OnClose onClose;
    private final ShardPath shardPath;
    private final AbstractRefCounted refCounter = new AbstractRefCounted("store"){

        @Override
        protected void closeInternal() {
            Store.this.closeInternal();
        }
    };

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock) {
        this(shardId, indexSettings, directory, shardLock, OnClose.EMPTY, null);
    }

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock, OnClose onClose, ShardPath shardPath) {
        super(shardId, indexSettings);
        TimeValue refreshInterval = indexSettings.getValue(INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING);
        this.logger.debug("store stats are refreshed with refresh_interval [{}]", (Object)refreshInterval);
        ByteSizeCachingDirectory sizeCachingDir = new ByteSizeCachingDirectory(directory, refreshInterval);
        this.directory = new StoreDirectory(sizeCachingDir, Loggers.getLogger("index.store.deletes", shardId));
        this.shardLock = shardLock;
        this.onClose = onClose;
        this.shardPath = shardPath;
        assert (onClose != null);
        assert (shardLock != null);
        assert (shardLock.getShardId().equals(shardId));
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public ShardPath shardPath() {
        return this.shardPath;
    }

    public SegmentInfos readLastCommittedSegmentsInfo() throws IOException {
        this.failIfCorrupted();
        try {
            if (this.indexSettings.isRemoteSnapshot() && this.indexSettings.getExtendedCompatibilitySnapshotVersion() != null) {
                return Store.readSegmentInfosExtendedCompatibility(this.directory(), this.indexSettings.getExtendedCompatibilitySnapshotVersion());
            }
            return Store.readSegmentsInfo(null, this.directory());
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            this.markStoreCorrupted(ex);
            throw ex;
        }
    }

    private static SegmentInfos readSegmentsInfo(IndexCommit commit, Directory directory) throws IOException {
        assert (commit == null || commit.getDirectory() == directory);
        try {
            return commit == null ? Lucene.readSegmentInfos(directory) : Lucene.readSegmentInfos(commit);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", "commit(" + String.valueOf(commit) + ")", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", "commit(" + String.valueOf(commit) + ")", (Throwable)ex);
        }
    }

    private static SegmentInfos readSegmentInfosExtendedCompatibility(Directory directory, Version minimumVersion) throws IOException {
        try {
            return Lucene.readSegmentInfos(directory, minimumVersion);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", "<latest-commit>", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", "<latest-commit>", (Throwable)ex);
        }
    }

    final void ensureOpen() {
        if (this.refCounter.refCount() <= 0) {
            throw new AlreadyClosedException("store is already closed");
        }
    }

    public MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        return this.getMetadata(commit, false);
    }

    public MetadataSnapshot getMetadata() throws IOException {
        return this.getMetadata(null, false);
    }

    public MetadataSnapshot getMetadata(IndexCommit commit, boolean lockDirectory) throws IOException {
        this.ensureOpen();
        this.failIfCorrupted();
        assert (!lockDirectory || commit == null) : "IW lock should not be obtained if there is a commit point available";
        java.util.concurrent.locks.Lock lock = lockDirectory ? this.metadataLock.writeLock() : this.metadataLock.readLock();
        lock.lock();
        try {
            MetadataSnapshot metadataSnapshot;
            block12: {
                Closeable ignored = lockDirectory ? this.directory.obtainLock("write.lock") : () -> {};
                try {
                    metadataSnapshot = new MetadataSnapshot(commit, (Directory)this.directory, this.logger);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        this.markStoreCorrupted(ex);
                        throw ex;
                    }
                }
                ignored.close();
            }
            return metadataSnapshot;
        }
        finally {
            lock.unlock();
        }
    }

    public MetadataSnapshot getMetadata(SegmentInfos segmentInfos) throws IOException {
        return new MetadataSnapshot(segmentInfos, (Directory)this.directory, this.logger);
    }

    public Map<String, StoreFileMetadata> getSegmentMetadataMap(SegmentInfos segmentInfos) throws IOException {
        assert (this.indexSettings.isSegRepEnabledOrRemoteNode());
        this.failIfCorrupted();
        try {
            return MetadataSnapshot.loadMetadata((SegmentInfos)segmentInfos, (Directory)this.directory, (Logger)this.logger, (boolean)true).fileMetadata;
        }
        catch (NoSuchFileException | CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            this.markStoreCorrupted(ex);
            throw ex;
        }
    }

    public static RecoveryDiff segmentReplicationDiff(Map<String, StoreFileMetadata> source, Map<String, StoreFileMetadata> target) {
        ArrayList<StoreFileMetadata> identical = new ArrayList<StoreFileMetadata>();
        ArrayList<StoreFileMetadata> different = new ArrayList<StoreFileMetadata>();
        ArrayList<StoreFileMetadata> missing = new ArrayList<StoreFileMetadata>();
        for (StoreFileMetadata value : source.values()) {
            if (value.name().startsWith("segments")) continue;
            if (!target.containsKey(value.name())) {
                missing.add(value);
                continue;
            }
            StoreFileMetadata fileMetadata = target.get(value.name());
            if (fileMetadata.checksum().equals(value.checksum())) {
                identical.add(value);
                continue;
            }
            different.add(value);
        }
        return new RecoveryDiff(Collections.unmodifiableList(identical), Collections.unmodifiableList(different), Collections.unmodifiableList(missing));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTempFilesSafe(Map<String, String> tempFileMap) throws IOException {
        Map.Entry[] entries = tempFileMap.entrySet().toArray(new Map.Entry[0]);
        ArrayUtil.timSort(entries, (o1, o2) -> {
            String left = (String)o1.getValue();
            String right = (String)o2.getValue();
            if (left.startsWith("segments") || right.startsWith("segments")) {
                if (!left.startsWith("segments")) {
                    return -1;
                }
                if (!right.startsWith("segments")) {
                    return 1;
                }
            }
            return left.compareTo(right);
        });
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory().obtainLock("write.lock");){
            for (Map.Entry entry : entries) {
                String tempFile = (String)entry.getKey();
                String origFile = (String)entry.getValue();
                try {
                    this.directory.deleteFile(origFile);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                }
                catch (Exception ex) {
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)origFile), (Throwable)ex);
                }
                this.directory.rename(tempFile, origFile);
                String remove = tempFileMap.remove(tempFile);
                assert (remove != null);
            }
            this.directory.syncMetaData();
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public CheckIndex.Status checkIndex(PrintStream out) throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            CheckIndex.Status status;
            try (CheckIndex checkIndex = new CheckIndex(this.directory);){
                checkIndex.setInfoStream(out);
                status = checkIndex.checkIndex();
            }
            return status;
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public StoreStats stats(long reservedBytes) throws IOException {
        this.ensureOpen();
        return new StoreStats(this.directory.estimateSize(), reservedBytes);
    }

    @Override
    public final void incRef() {
        this.refCounter.incRef();
    }

    @Override
    public final boolean tryIncRef() {
        return this.refCounter.tryIncRef();
    }

    @Override
    public final boolean decRef() {
        return this.refCounter.decRef();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.decRef();
            this.logger.debug("store reference count on close: {}", (Object)this.refCounter.refCount());
        }
    }

    public boolean isClosing() {
        return this.isClosed.get();
    }

    private void closeInternal() {
        try (ShardLock c = this.shardLock;){
            try {
                this.directory.innerClose();
            }
            finally {
                this.onClose.accept(this.shardLock);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static MetadataSnapshot readMetadataSnapshot(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException {
        try (ShardLock lock2 = shardLocker.lock(shardId, "read metadata snapshot", TimeUnit.SECONDS.toMillis(5L));){
            MetadataSnapshot metadataSnapshot;
            try (NIOFSDirectory dir = new NIOFSDirectory(indexLocation);){
                Store.failIfCorrupted(dir);
                metadataSnapshot = new MetadataSnapshot((IndexCommit)null, (Directory)dir, logger);
            }
            return metadataSnapshot;
        }
        catch (IndexNotFoundException lock2) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.info("Failed to open / find files while reading metadata snapshot", (Throwable)ex);
        }
        catch (ShardLockObtainFailedException ex) {
            logger.info(() -> new ParameterizedMessage("{}: failed to obtain shard lock", (Object)shardId), (Throwable)ex);
        }
        return MetadataSnapshot.EMPTY;
    }

    public static void tryOpenIndex(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException, ShardLockObtainFailedException {
        try (ShardLock lock = shardLocker.lock(shardId, "open index", TimeUnit.SECONDS.toMillis(5L));
             NIOFSDirectory dir = new NIOFSDirectory(indexLocation);){
            Store.failIfCorrupted(dir);
            SegmentInfos segInfo = Lucene.readSegmentInfos(dir);
            logger.trace("{} loaded segment info [{}]", (Object)shardId, (Object)segInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexOutput createVerifyingOutput(String fileName, StoreFileMetadata metadata, IOContext context) throws IOException {
        IndexOutput output = this.directory().createOutput(fileName, context);
        boolean success = false;
        try {
            assert (metadata.writtenBy() != null);
            output = new LuceneVerifyingIndexOutput(metadata, output);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)output);
            }
        }
        return output;
    }

    public static void verify(IndexOutput output) throws IOException {
        if (output instanceof VerifyingIndexOutput) {
            ((VerifyingIndexOutput)output).verify();
        }
    }

    public IndexInput openVerifyingInput(String filename, IOContext context, StoreFileMetadata metadata) throws IOException {
        assert (metadata.writtenBy() != null);
        return new VerifyingIndexInput(this.directory().openInput(filename, context));
    }

    public static void verify(IndexInput input) throws IOException {
        if (input instanceof VerifyingIndexInput) {
            ((VerifyingIndexInput)input).verify();
        }
    }

    public boolean checkIntegrityNoException(StoreFileMetadata md) {
        return Store.checkIntegrityNoException(md, this.directory());
    }

    public static boolean checkIntegrityNoException(StoreFileMetadata md, Directory directory) {
        try {
            Store.checkIntegrity(md, directory);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void checkIntegrity(StoreFileMetadata md, Directory directory) throws IOException {
        try (IndexInput input = directory.openInput(md.name(), IOContext.READONCE);){
            if (input.length() != md.length()) {
                throw new CorruptIndexException("expected length=" + md.length() + " != actual length: " + input.length() + " : file truncated?", input);
            }
            String checksum = Store.digestToString(CodecUtil.checksumEntireFile(input));
            if (!checksum.equals(md.checksum())) {
                throw new CorruptIndexException("inconsistent metadata: lucene checksum=" + checksum + ", metadata checksum=" + md.checksum(), input);
            }
        }
    }

    public boolean isMarkedCorrupted() throws IOException {
        String[] files;
        this.ensureOpen();
        for (String file : files = this.directory().listAll()) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public void removeCorruptionMarker() throws IOException {
        String[] files;
        this.ensureOpen();
        Directory directory = this.directory();
        IOException firstException = null;
        for (String file : files = directory.listAll()) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            try {
                directory.deleteFile(file);
            }
            catch (IOException ex) {
                if (firstException == null) {
                    firstException = ex;
                    continue;
                }
                firstException.addSuppressed(ex);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void failIfCorrupted() throws IOException {
        this.ensureOpen();
        Store.failIfCorrupted(this.directory);
    }

    private static void failIfCorrupted(Directory directory) throws IOException {
        String[] files = directory.listAll();
        ArrayList<CorruptIndexException> ex = new ArrayList<CorruptIndexException>();
        for (String file : files) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            try (ChecksumIndexInput input = directory.openChecksumInput(file, IOContext.READONCE);){
                CodecUtil.checkHeader(input, CODEC, 2, 2);
                int size = input.readVInt();
                byte[] buffer = new byte[size];
                input.readBytes(buffer, 0, buffer.length);
                StreamInput in = StreamInput.wrap(buffer);
                Object t = in.readException();
                if (t instanceof CorruptIndexException) {
                    ex.add((CorruptIndexException)t);
                } else {
                    ex.add(new CorruptIndexException(((Throwable)t).getMessage(), "preexisting_corruption", (Throwable)t));
                }
                CodecUtil.checkFooter(input);
            }
        }
        if (!ex.isEmpty()) {
            ExceptionsHelper.rethrowAndSuppress(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAndVerify(String reason, MetadataSnapshot sourceMetadata) throws IOException {
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory.obtainLock("write.lock");){
            for (String existingFile : this.directory.listAll()) {
                if (Store.isAutogenerated(existingFile) || sourceMetadata.contains(existingFile)) continue;
                try {
                    this.directory.deleteFile(reason, existingFile);
                }
                catch (IOException ex) {
                    if (existingFile.startsWith("segments") || existingFile.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) {
                        throw new IllegalStateException("Can't delete " + existingFile + " - cleanup failed", ex);
                    }
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)existingFile), (Throwable)ex);
                }
            }
            this.directory.syncMetaData();
            MetadataSnapshot metadataOrEmpty = this.getMetadata();
            this.verifyAfterCleanup(sourceMetadata, metadataOrEmpty);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public SegmentInfos buildSegmentInfos(byte[] infosBytes, long segmentsGen) throws IOException {
        try (ChecksumIndexInput input = this.toIndexInput(infosBytes);){
            SegmentInfos segmentInfos = SegmentInfos.readCommit((Directory)this.directory, input, segmentsGen);
            return segmentInfos;
        }
    }

    private ChecksumIndexInput toIndexInput(byte[] input) {
        return new BufferedChecksumIndexInput(new ByteArrayIndexInput("Snapshot of SegmentInfos", input));
    }

    final void verifyAfterCleanup(MetadataSnapshot sourceMetadata, MetadataSnapshot targetMetadata) {
        RecoveryDiff recoveryDiff = targetMetadata.recoveryDiff(sourceMetadata);
        if (recoveryDiff.identical.size() != recoveryDiff.size()) {
            if (recoveryDiff.missing.isEmpty()) {
                for (StoreFileMetadata meta : recoveryDiff.different) {
                    StoreFileMetadata remote;
                    StoreFileMetadata local = targetMetadata.get(meta.name());
                    if (local.isSame(remote = sourceMetadata.get(meta.name()))) continue;
                    this.logger.debug("Files are different on the recovery target: {} ", (Object)recoveryDiff);
                    throw new IllegalStateException("local version: " + String.valueOf(local) + " is different from remote version after recovery: " + String.valueOf(remote), null);
                }
            } else {
                this.logger.debug("Files are missing on the recovery target: {} ", (Object)recoveryDiff);
                throw new IllegalStateException("Files are missing on the recovery target: [different=" + String.valueOf(recoveryDiff.different) + ", missing=" + String.valueOf(recoveryDiff.missing) + "]", null);
            }
        }
    }

    public int refCount() {
        return this.refCounter.refCount();
    }

    public void beforeClose() {
        this.shardLock.setDetails("closing shard");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitSegmentInfos(SegmentInfos latestSegmentInfos, long maxSeqNo, long processedCheckpoint) throws IOException {
        assert (this.indexSettings.isSegRepEnabledOrRemoteNode() || this.indexSettings.isAssignedOnRemoteNode());
        this.metadataLock.writeLock().lock();
        try {
            HashMap<String, String> userData = new HashMap<String, String>(latestSegmentInfos.getUserData());
            userData.put("local_checkpoint", String.valueOf(processedCheckpoint));
            userData.put("max_seq_no", Long.toString(maxSeqNo));
            latestSegmentInfos.setUserData(userData, false);
            latestSegmentInfos.commit(this.directory());
            this.directory.sync(latestSegmentInfos.files(true));
            this.directory.syncMetaData();
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public DirectoryFileTransferTracker getDirectoryFileTransferTracker() {
        return this.directory.getDirectoryFileTransferTracker();
    }

    public static boolean isAutogenerated(String name) {
        return "write.lock".equals(name);
    }

    public static String digestToString(long digest) {
        return Long.toString(digest, 36);
    }

    public void deleteQuiet(String ... files) {
        this.ensureOpen();
        StoreDirectory directory = this.directory;
        for (String file : files) {
            try {
                directory.deleteFile("Store.deleteQuiet", file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void markStoreCorrupted(IOException exception) throws IOException {
        this.ensureOpen();
        if (!this.isMarkedCorrupted()) {
            String corruptionMarkerName = CORRUPTED_MARKER_NAME_PREFIX + UUIDs.randomBase64UUID();
            try (IndexOutput output = this.directory().createOutput(corruptionMarkerName, IOContext.DEFAULT);){
                CodecUtil.writeHeader(output, CODEC, 2);
                BytesStreamOutput out = new BytesStreamOutput();
                out.writeException(exception);
                BytesReference bytes = out.bytes();
                output.writeVInt(bytes.length());
                BytesRef ref = bytes.toBytesRef();
                output.writeBytes(ref.bytes, ref.offset, ref.length);
                CodecUtil.writeFooter(output);
            }
            catch (IOException ex) {
                this.logger.warn("Can't mark store as corrupted", (Throwable)ex);
            }
            this.directory().sync(Collections.singleton(corruptionMarkerName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmpty(org.apache.lucene.util.Version luceneVersion, String translogUUID) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newEmptyIndexWriter(this.directory, luceneVersion);){
            HashMap<String, String> map = new HashMap<String, String>();
            if (translogUUID != null) {
                map.put("translog_uuid", translogUUID);
            }
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(-1L));
            map.put("max_seq_no", Long.toString(-1L));
            map.put("max_unsafe_auto_id_timestamp", "-1");
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public void createEmpty(org.apache.lucene.util.Version luceneVersion) throws IOException {
        this.createEmpty(luceneVersion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory() throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            Map<String, String> userData = this.readLastCommittedSegmentsInfo().getUserData();
            long maxSeqNo = Long.parseLong(userData.get("max_seq_no"));
            long localCheckpoint = Long.parseLong(userData.get("local_checkpoint"));
            this.bootstrapNewHistory(localCheckpoint, maxSeqNo);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory(long localCheckpoint, long maxSeqNo) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newAppendingIndexWriter(this.directory, null);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(localCheckpoint));
            map.put("max_seq_no", Long.toString(maxSeqNo));
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateIndexWithNewTranslog(String translogUUID) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newAppendingIndexWriter(this.directory, null);){
            if (translogUUID.equals(Store.getUserData(writer).get("translog_uuid"))) {
                throw new IllegalArgumentException("a new translog uuid can't be equal to existing one. got [" + translogUUID + "]");
            }
            Store.updateCommitData(writer, Collections.singletonMap("translog_uuid", translogUUID));
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureIndexHasHistoryUUID() throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newAppendingIndexWriter(this.directory, null);){
            Map<String, String> userData = Store.getUserData(writer);
            if (!userData.containsKey("history_uuid")) {
                Store.updateCommitData(writer, Collections.singletonMap("history_uuid", UUIDs.randomBase64UUID()));
            }
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnsafeCommits(Path translogPath) throws IOException {
        block11: {
            this.metadataLock.writeLock().lock();
            try {
                long lastSyncedGlobalCheckpoint;
                IndexCommit startingIndexCommit;
                List<IndexCommit> existingCommits = DirectoryReader.listCommits(this.directory);
                assert (!existingCommits.isEmpty()) : "No index found to trim";
                IndexCommit lastIndexCommit = existingCommits.get(existingCommits.size() - 1);
                String translogUUID = lastIndexCommit.getUserData().get("translog_uuid");
                if (!translogUUID.equals((startingIndexCommit = CombinedDeletionPolicy.findSafeCommitPoint(existingCommits, lastSyncedGlobalCheckpoint = Translog.readGlobalCheckpoint(translogPath, translogUUID))).getUserData().get("translog_uuid"))) {
                    throw new IllegalStateException("starting commit translog uuid [" + startingIndexCommit.getUserData().get("translog_uuid") + "] is not equal to last commit's translog uuid [" + translogUUID + "]");
                }
                if (startingIndexCommit.equals(lastIndexCommit)) break block11;
                try (IndexWriter writer = Store.newAppendingIndexWriter(this.directory, startingIndexCommit);){
                    writer.setLiveCommitData(startingIndexCommit.getUserData().entrySet());
                    writer.commit();
                }
            }
            finally {
                this.metadataLock.writeLock().unlock();
            }
        }
    }

    public Optional<SequenceNumbers.CommitInfo> findSafeIndexCommit(long globalCheckpoint) throws IOException {
        List<IndexCommit> commits = DirectoryReader.listCommits(this.directory);
        assert (!commits.isEmpty()) : "no commit found";
        IndexCommit safeCommit = CombinedDeletionPolicy.findSafeCommitPoint(commits, globalCheckpoint);
        SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(safeCommit.getUserData().entrySet());
        if (commitInfo.maxSeqNo <= globalCheckpoint) {
            return Optional.of(commitInfo);
        }
        return Optional.empty();
    }

    private static void updateCommitData(IndexWriter writer, Map<String, String> keysToUpdate) throws IOException {
        Map<String, String> userData = Store.getUserData(writer);
        userData.putAll(keysToUpdate);
        writer.setLiveCommitData(userData.entrySet());
        writer.commit();
    }

    private static Map<String, String> getUserData(IndexWriter writer) {
        HashMap<String, String> userData = new HashMap<String, String>();
        writer.getLiveCommitData().forEach(e -> userData.put((String)e.getKey(), (String)e.getValue()));
        return userData;
    }

    private static IndexWriter newAppendingIndexWriter(Directory dir, IndexCommit commit) throws IOException {
        IndexWriterConfig iwc = Store.newIndexWriterConfig().setIndexCommit(commit).setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        return new IndexWriter(dir, iwc);
    }

    private static IndexWriter newEmptyIndexWriter(Directory dir, org.apache.lucene.util.Version luceneVersion) throws IOException {
        IndexWriterConfig iwc = Store.newIndexWriterConfig().setOpenMode(IndexWriterConfig.OpenMode.CREATE).setIndexCreatedVersionMajor(luceneVersion.major);
        return new IndexWriter(dir, iwc);
    }

    private static IndexWriterConfig newIndexWriterConfig() {
        return new IndexWriterConfig(null).setSoftDeletesField("__soft_deletes").setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE);
    }

    public static interface OnClose
    extends Consumer<ShardLock> {
        public static final OnClose EMPTY = new OnClose(){

            @Override
            public void accept(ShardLock Lock2) {
            }
        };
    }

    static final class StoreDirectory
    extends FilterDirectory {
        private final Logger deletesLogger;
        public final DirectoryFileTransferTracker directoryFileTransferTracker;

        StoreDirectory(ByteSizeCachingDirectory delegateDirectory, Logger deletesLogger) {
            super(delegateDirectory);
            this.deletesLogger = deletesLogger;
            this.directoryFileTransferTracker = new DirectoryFileTransferTracker();
        }

        long estimateSize() throws IOException {
            return ((ByteSizeCachingDirectory)this.getDelegate()).estimateSizeInBytes();
        }

        @Override
        public void close() {
            assert (false) : "Nobody should close this directory except of the Store itself";
        }

        public void deleteFile(String msg, String name) throws IOException {
            this.deletesLogger.trace("{}: delete file {}", (Object)msg, (Object)name);
            super.deleteFile(name);
        }

        @Override
        public void deleteFile(String name) throws IOException {
            this.deleteFile("StoreDirectory.deleteFile", name);
        }

        private void innerClose() throws IOException {
            super.close();
        }

        @Override
        public String toString() {
            return "store(" + this.in.toString() + ")";
        }

        @Override
        public Set<String> getPendingDeletions() throws IOException {
            return StoreDirectory.unwrap(this).getPendingDeletions();
        }

        public DirectoryFileTransferTracker getDirectoryFileTransferTracker() {
            return this.directoryFileTransferTracker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
            long fileSize = from.fileLength(src);
            this.beforeDownload(fileSize);
            boolean success = false;
            long startTime = System.currentTimeMillis();
            try {
                super.copyFrom(from, src, dest, context);
                success = true;
                this.afterDownload(fileSize, startTime);
            }
            finally {
                if (!success) {
                    this.downloadFailed(fileSize, startTime);
                }
            }
        }

        private void beforeDownload(long fileSize) {
            this.directoryFileTransferTracker.addTransferredBytesStarted(fileSize);
        }

        private void afterDownload(long fileSize, long startTimeInMs) {
            this.directoryFileTransferTracker.addTransferredBytesSucceeded(fileSize, startTimeInMs);
        }

        private void downloadFailed(long fileSize, long startTimeInMs) {
            this.directoryFileTransferTracker.addTransferredBytesFailed(fileSize, startTimeInMs);
        }
    }

    @PublicApi(since="1.0.0")
    public static final class MetadataSnapshot
    implements Iterable<StoreFileMetadata>,
    Writeable {
        private final Map<String, StoreFileMetadata> metadata;
        public static final MetadataSnapshot EMPTY = new MetadataSnapshot();
        private final Map<String, String> commitUserData;
        private final long numDocs;
        private static final String DEL_FILE_EXTENSION = "del";
        private static final String LIV_FILE_EXTENSION = "liv";
        private static final String SEGMENT_INFO_EXTENSION = "si";

        public MetadataSnapshot(Map<String, StoreFileMetadata> metadata, Map<String, String> commitUserData, long numDocs) {
            this.metadata = metadata;
            this.commitUserData = commitUserData;
            this.numDocs = numDocs;
        }

        MetadataSnapshot() {
            this.metadata = Collections.emptyMap();
            this.commitUserData = Collections.emptyMap();
            this.numDocs = 0L;
        }

        MetadataSnapshot(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            this(MetadataSnapshot.loadMetadata(commit, directory, logger));
        }

        MetadataSnapshot(SegmentInfos segmentInfos, Directory directory, Logger logger) throws IOException {
            this(MetadataSnapshot.loadMetadata(segmentInfos, directory, logger));
        }

        private MetadataSnapshot(LoadedMetadata loadedMetadata) {
            this.metadata = loadedMetadata.fileMetadata;
            this.commitUserData = loadedMetadata.userData;
            this.numDocs = loadedMetadata.numDocs;
            assert (this.metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        public MetadataSnapshot(StreamInput in) throws IOException {
            int num;
            int size = in.readVInt();
            HashMap<String, StoreFileMetadata> metadata = new HashMap<String, StoreFileMetadata>();
            for (int i = 0; i < size; ++i) {
                StoreFileMetadata meta = new StoreFileMetadata(in);
                metadata.put(meta.name(), meta);
            }
            HashMap<String, String> commitUserData = new HashMap<String, String>();
            for (int i = num = in.readVInt(); i > 0; --i) {
                commitUserData.put(in.readString(), in.readString());
            }
            this.metadata = Collections.unmodifiableMap(metadata);
            this.commitUserData = Collections.unmodifiableMap(commitUserData);
            this.numDocs = in.readLong();
            assert (metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.metadata.size());
            for (StoreFileMetadata storeFileMetadata : this) {
                storeFileMetadata.writeTo(out);
            }
            out.writeVInt(this.commitUserData.size());
            for (Map.Entry entry : this.commitUserData.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeString((String)entry.getValue());
            }
            out.writeLong(this.numDocs);
        }

        public long getNumDocs() {
            return this.numDocs;
        }

        static LoadedMetadata loadMetadata(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            try {
                SegmentInfos segmentCommitInfos = Store.readSegmentsInfo(commit, directory);
                return MetadataSnapshot.loadMetadata(segmentCommitInfos, directory, logger);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException | IndexNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                try {
                    logger.warn(() -> new ParameterizedMessage("failed to build store metadata. checking segment info integrity (with commit [{}])", (Object)(commit == null ? "no" : "yes")), (Throwable)ex);
                    Lucene.checkSegmentInfoIntegrity(directory);
                }
                catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException cex) {
                    cex.addSuppressed(ex);
                    throw cex;
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    throw inner;
                }
                throw ex;
            }
        }

        static LoadedMetadata loadMetadata(SegmentInfos segmentInfos, Directory directory, Logger logger) throws IOException {
            return MetadataSnapshot.loadMetadata(segmentInfos, directory, logger, false);
        }

        static LoadedMetadata loadMetadata(SegmentInfos segmentInfos, Directory directory, Logger logger, boolean ignoreSegmentsFile) throws IOException {
            long numDocs = Lucene.getNumDocs(segmentInfos);
            HashMap<String, String> commitUserDataBuilder = new HashMap<String, String>();
            commitUserDataBuilder.putAll(segmentInfos.getUserData());
            HashMap<String, StoreFileMetadata> builder = new HashMap<String, StoreFileMetadata>();
            org.apache.lucene.util.Version maxVersion = segmentInfos.getMinSegmentLuceneVersion();
            for (SegmentCommitInfo info : segmentInfos) {
                org.apache.lucene.util.Version version = info.info.getVersion();
                if (version == null) {
                    throw new IllegalArgumentException("expected valid version value: " + info.info.toString());
                }
                if (maxVersion == null || version.onOrAfter(maxVersion)) {
                    maxVersion = version;
                }
                for (String file : info.files()) {
                    MetadataSnapshot.checksumFromLuceneFile(directory, file, builder, logger, version, SEGMENT_INFO_EXTENSION.equals(IndexFileNames.getExtension(file)));
                }
            }
            if (maxVersion == null) {
                maxVersion = Version.CURRENT.minimumIndexCompatibilityVersion().luceneVersion;
            }
            if (!ignoreSegmentsFile) {
                String segmentsFile = segmentInfos.getSegmentsFileName();
                MetadataSnapshot.checksumFromLuceneFile(directory, segmentsFile, builder, logger, maxVersion, true);
            }
            return new LoadedMetadata(Collections.unmodifiableMap(builder), Collections.unmodifiableMap(commitUserDataBuilder), numDocs);
        }

        private static void checksumFromLuceneFile(Directory directory, String file, Map<String, StoreFileMetadata> builder, Logger logger, org.apache.lucene.util.Version version, boolean readFileAsHash) throws IOException {
            BytesRefBuilder fileHash = new BytesRefBuilder();
            try (IndexInput in = directory.openInput(file, IOContext.READONCE);){
                String checksum;
                long length;
                try {
                    length = in.length();
                    if (length < (long)CodecUtil.footerLength()) {
                        throw new CorruptIndexException("Can't retrieve checksum from file: " + file + " file length must be >= " + CodecUtil.footerLength() + " but was: " + in.length(), in);
                    }
                    if (readFileAsHash) {
                        VerifyingIndexInput verifyingIndexInput = new VerifyingIndexInput(in);
                        MetadataSnapshot.hashFile(fileHash, new InputStreamIndexInput(verifyingIndexInput, length), length);
                        checksum = Store.digestToString(verifyingIndexInput.verify());
                    } else {
                        checksum = Store.digestToString(CodecUtil.retrieveChecksum(in));
                    }
                }
                catch (Exception ex) {
                    logger.debug(() -> new ParameterizedMessage("Can retrieve checksum from file [{}]", (Object)file), (Throwable)ex);
                    throw ex;
                }
                builder.put(file, new StoreFileMetadata(file, length, checksum, version, fileHash.get()));
            }
        }

        public static void hashFile(BytesRefBuilder fileHash, InputStream in, long size) throws IOException {
            int len = (int)Math.min(0x100000L, size);
            fileHash.grow(len);
            fileHash.setLength(len);
            int readBytes = in.readNBytes(fileHash.bytes(), 0, len);
            assert (readBytes == len) : Integer.toString(readBytes) + " != " + Integer.toString(len);
            assert (fileHash.length() == len) : Integer.toString(fileHash.length()) + " != " + Integer.toString(len);
        }

        @Override
        public Iterator<StoreFileMetadata> iterator() {
            return this.metadata.values().iterator();
        }

        public StoreFileMetadata get(String name) {
            return this.metadata.get(name);
        }

        public Map<String, StoreFileMetadata> asMap() {
            return this.metadata;
        }

        private Iterable<List<StoreFileMetadata>> getGroupedFilesIterable() {
            HashMap<String, List> perSegment = new HashMap<String, List>();
            ArrayList<StoreFileMetadata> perCommitStoreFiles = new ArrayList<StoreFileMetadata>();
            for (StoreFileMetadata meta : this) {
                String segmentId = IndexFileNames.parseSegmentName(meta.name());
                String extension = IndexFileNames.getExtension(meta.name());
                if ("segments".equals(segmentId) || DEL_FILE_EXTENSION.equals(extension) || LIV_FILE_EXTENSION.equals(extension)) {
                    perCommitStoreFiles.add(meta);
                    continue;
                }
                perSegment.computeIfAbsent(segmentId, k -> new ArrayList()).add(meta);
            }
            return Iterables.concat(perSegment.values(), Collections.singleton(perCommitStoreFiles));
        }

        public RecoveryDiff recoveryDiff(MetadataSnapshot recoveryTargetSnapshot) {
            ArrayList identical = new ArrayList();
            ArrayList<StoreFileMetadata> different = new ArrayList<StoreFileMetadata>();
            ArrayList<StoreFileMetadata> missing = new ArrayList<StoreFileMetadata>();
            ArrayList<StoreFileMetadata> identicalFiles = new ArrayList<StoreFileMetadata>();
            for (List<StoreFileMetadata> segmentFiles : this.getGroupedFilesIterable()) {
                identicalFiles.clear();
                boolean consistent = true;
                for (StoreFileMetadata meta : segmentFiles) {
                    StoreFileMetadata storeFileMetadata = recoveryTargetSnapshot.get(meta.name());
                    if (storeFileMetadata == null) {
                        consistent = false;
                        missing.add(meta);
                        continue;
                    }
                    if (!storeFileMetadata.isSame(meta)) {
                        consistent = false;
                        different.add(meta);
                        continue;
                    }
                    identicalFiles.add(meta);
                }
                if (consistent) {
                    identical.addAll(identicalFiles);
                    continue;
                }
                different.addAll(identicalFiles);
            }
            RecoveryDiff recoveryDiff = new RecoveryDiff(Collections.unmodifiableList(identical), Collections.unmodifiableList(different), Collections.unmodifiableList(missing));
            assert (recoveryDiff.size() == this.metadata.size()) : "some files are missing recoveryDiff size: [" + recoveryDiff.size() + "] metadata size: [" + this.metadata.size() + "]";
            return recoveryDiff;
        }

        public int size() {
            return this.metadata.size();
        }

        public Map<String, String> getCommitUserData() {
            return this.commitUserData;
        }

        public String getHistoryUUID() {
            return this.commitUserData.get("history_uuid");
        }

        public boolean contains(String existingFile) {
            return this.metadata.containsKey(existingFile);
        }

        public StoreFileMetadata getSegmentsFile() {
            for (StoreFileMetadata file : this) {
                if (!file.name().startsWith("segments")) continue;
                return file;
            }
            assert (this.metadata.isEmpty());
            return null;
        }

        private int numSegmentFiles() {
            int count = 0;
            for (StoreFileMetadata file : this) {
                if (!file.name().startsWith("segments")) continue;
                ++count;
            }
            return count;
        }

        public String getSyncId() {
            return this.commitUserData.get("sync_id");
        }

        static class LoadedMetadata {
            final Map<String, StoreFileMetadata> fileMetadata;
            final Map<String, String> userData;
            final long numDocs;

            LoadedMetadata(Map<String, StoreFileMetadata> fileMetadata, Map<String, String> userData, long numDocs) {
                this.fileMetadata = fileMetadata;
                this.userData = userData;
                this.numDocs = numDocs;
            }
        }
    }

    @PublicApi(since="1.0.0")
    public static final class RecoveryDiff {
        public final List<StoreFileMetadata> identical;
        public final List<StoreFileMetadata> different;
        public final List<StoreFileMetadata> missing;

        RecoveryDiff(List<StoreFileMetadata> identical, List<StoreFileMetadata> different, List<StoreFileMetadata> missing) {
            this.identical = identical;
            this.different = different;
            this.missing = missing;
        }

        public int size() {
            return this.identical.size() + this.different.size() + this.missing.size();
        }

        public String toString() {
            return "RecoveryDiff{identical=" + String.valueOf(this.identical) + ", different=" + String.valueOf(this.different) + ", missing=" + String.valueOf(this.missing) + "}";
        }
    }

    public static class LuceneVerifyingIndexOutput
    extends VerifyingIndexOutput {
        private final StoreFileMetadata metadata;
        private long writtenBytes;
        private final long checksumPosition;
        private String actualChecksum;
        private final byte[] footerChecksum = new byte[8];

        public LuceneVerifyingIndexOutput(StoreFileMetadata metadata, IndexOutput out) {
            super(out);
            this.metadata = metadata;
            this.checksumPosition = metadata.length() - 8L;
        }

        @Override
        public void verify() throws IOException {
            String footerDigest = null;
            if (this.metadata.checksum().equals(this.actualChecksum) && this.writtenBytes == this.metadata.length()) {
                ByteArrayIndexInput indexInput = new ByteArrayIndexInput("checksum", this.footerChecksum);
                footerDigest = Store.digestToString(CodecUtil.readBELong(indexInput));
                if (this.metadata.checksum().equals(footerDigest)) {
                    return;
                }
            }
            throw new CorruptIndexException("verification failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " footer=" + footerDigest + " writtenLength=" + this.writtenBytes + " expectedLength=" + this.metadata.length() + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
        }

        @Override
        public void writeByte(byte b) throws IOException {
            long writtenBytes;
            if ((writtenBytes = this.writtenBytes++) >= this.checksumPosition) {
                int index;
                if (writtenBytes == this.checksumPosition) {
                    this.readAndCompareChecksum();
                }
                if ((index = Math.toIntExact(writtenBytes - this.checksumPosition)) < this.footerChecksum.length) {
                    this.footerChecksum[index] = b;
                    if (index == this.footerChecksum.length - 1) {
                        this.verify();
                    }
                } else {
                    this.verify();
                    throw new AssertionError((Object)("write past EOF expected length: " + this.metadata.length() + " writtenBytes: " + writtenBytes));
                }
            }
            this.out.writeByte(b);
        }

        private void readAndCompareChecksum() throws IOException {
            this.actualChecksum = Store.digestToString(this.getChecksum());
            if (!this.metadata.checksum().equals(this.actualChecksum)) {
                throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
            }
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            if (this.writtenBytes + (long)length > this.checksumPosition) {
                for (int i = 0; i < length; ++i) {
                    this.writeByte(b[offset + i]);
                }
            } else {
                this.out.writeBytes(b, offset, length);
                this.writtenBytes += (long)length;
            }
        }
    }

    static class VerifyingIndexInput
    extends ChecksumIndexInput {
        private final IndexInput input;
        private final Checksum digest;
        private final long checksumPosition;
        private final byte[] checksum = new byte[8];
        private long verifiedPosition = 0L;

        VerifyingIndexInput(IndexInput input) {
            this(input, new BufferedChecksum(new CRC32()));
        }

        VerifyingIndexInput(IndexInput input, Checksum digest) {
            super("VerifyingIndexInput(" + String.valueOf(input) + ")");
            this.input = input;
            this.digest = digest;
            this.checksumPosition = input.length() - 8L;
        }

        @Override
        public byte readByte() throws IOException {
            long pos = this.input.getFilePointer();
            byte b = this.input.readByte();
            if (++pos > this.verifiedPosition) {
                if (pos <= this.checksumPosition) {
                    this.digest.update(b);
                } else {
                    this.checksum[(int)(pos - this.checksumPosition - 1L)] = b;
                }
                this.verifiedPosition = pos;
            }
            return b;
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long pos = this.input.getFilePointer();
            this.input.readBytes(b, offset, len);
            if (pos + (long)len > this.verifiedPosition) {
                int alreadyVerified = (int)Math.max(0L, this.verifiedPosition - pos);
                if (pos < this.checksumPosition) {
                    if (pos + (long)len < this.checksumPosition) {
                        this.digest.update(b, offset + alreadyVerified, len - alreadyVerified);
                    } else {
                        int checksumOffset = (int)(this.checksumPosition - pos);
                        if (checksumOffset - alreadyVerified > 0) {
                            this.digest.update(b, offset + alreadyVerified, checksumOffset - alreadyVerified);
                        }
                        System.arraycopy(b, offset + checksumOffset, this.checksum, 0, len - checksumOffset);
                    }
                } else {
                    assert (pos - this.checksumPosition < 8L);
                    System.arraycopy(b, offset, this.checksum, (int)(pos - this.checksumPosition), len);
                }
                this.verifiedPosition = pos + (long)len;
            }
        }

        @Override
        public long getChecksum() {
            return this.digest.getValue();
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos < this.verifiedPosition) {
                this.input.seek(pos);
            } else if (this.verifiedPosition > this.getFilePointer()) {
                this.input.seek(this.verifiedPosition);
                super.seek(pos);
            } else {
                super.seek(pos);
            }
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        @Override
        public long getFilePointer() {
            return this.input.getFilePointer();
        }

        @Override
        public long length() {
            return this.input.length();
        }

        @Override
        public IndexInput clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getStoredChecksum() {
            try {
                return CodecUtil.readBELong(new ByteArrayDataInput(this.checksum));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public long verify() throws CorruptIndexException, IOException {
            long storedChecksum = this.getStoredChecksum();
            if (this.getChecksum() == storedChecksum) {
                return storedChecksum;
            }
            throw new CorruptIndexException("verification failed : calculated=" + Store.digestToString(this.getChecksum()) + " stored=" + Store.digestToString(storedChecksum), this);
        }
    }
}

