/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.filecache.FileCachedIndexInput;

@ExperimentalApi
public class FullFileCachedIndexInput
extends FileCachedIndexInput {
    private static final Logger logger = LogManager.getLogger(FullFileCachedIndexInput.class);
    private final Set<FullFileCachedIndexInput> clones = new HashSet<FullFileCachedIndexInput>();

    public FullFileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput) {
        this(cache, filePath, underlyingIndexInput, false);
    }

    public FullFileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput, boolean isClone) {
        super(cache, filePath, underlyingIndexInput, isClone);
    }

    @Override
    public FullFileCachedIndexInput clone() {
        FullFileCachedIndexInput clonedIndexInput = new FullFileCachedIndexInput(this.cache, this.filePath, this.luceneIndexInput.clone(), true);
        this.cache.incRef(this.filePath);
        this.clones.add(clonedIndexInput);
        return clonedIndexInput;
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + String.valueOf(this));
        }
        IndexInput slicedLuceneIndexInput = this.luceneIndexInput.slice(sliceDescription, offset, length);
        FullFileCachedIndexInput slicedIndexInput = new FullFileCachedIndexInput(this.cache, this.filePath, slicedLuceneIndexInput, true);
        this.clones.add(slicedIndexInput);
        this.cache.incRef(this.filePath);
        return slicedIndexInput;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.isClone) {
                this.cache.decRef(this.filePath);
            }
            this.clones.forEach(indexInput -> {
                try {
                    indexInput.close();
                }
                catch (Exception e) {
                    logger.trace("Exception while closing clone - {}", (Object)e.getMessage());
                }
            });
            try {
                this.luceneIndexInput.close();
            }
            catch (AlreadyClosedException e) {
                logger.trace("FullFileCachedIndexInput already closed");
            }
            this.luceneIndexInput = null;
            this.clones.clear();
            this.closed = true;
        }
    }
}

