/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.admin.indices.shrink.ResizeAction;
import org.opensearch.action.admin.indices.shrink.ResizeRequest;
import org.opensearch.action.admin.indices.shrink.ResizeResponse;
import org.opensearch.action.admin.indices.shrink.ResizeType;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Booleans;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.tasks.LoggingTaskListener;

public abstract class RestResizeHandler
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestResizeHandler.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(logger.getName());

    RestResizeHandler() {
    }

    @Override
    public abstract String getName();

    abstract ResizeType getResizeType();

    @Override
    public final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Boolean copySettings;
        ResizeRequest resizeRequest = new ResizeRequest(request.param("target"), request.param("index"));
        resizeRequest.setResizeType(this.getResizeType());
        assert (Version.CURRENT.major < 8);
        String rawCopySettings = request.param("copy_settings");
        if (rawCopySettings == null) {
            copySettings = resizeRequest.getCopySettings();
        } else {
            if (rawCopySettings.isEmpty()) {
                copySettings = true;
            } else {
                copySettings = Booleans.parseBoolean(rawCopySettings);
                if (!copySettings.booleanValue()) {
                    throw new IllegalArgumentException("parameter [copy_settings] can not be explicitly set to [false]");
                }
            }
            deprecationLogger.deprecate("resize_deprecated_parameter", "parameter [copy_settings] is deprecated and will be removed in 3.0.0", new Object[0]);
        }
        resizeRequest.setCopySettings(copySettings);
        request.applyContentParser(resizeRequest::fromXContent);
        resizeRequest.timeout(request.paramAsTime("timeout", resizeRequest.timeout()));
        resizeRequest.getTargetIndexRequest().timeout(resizeRequest.timeout());
        resizeRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", resizeRequest.clusterManagerNodeTimeout()));
        RestResizeHandler.parseDeprecatedMasterTimeoutParameter(resizeRequest, request);
        resizeRequest.getTargetIndexRequest().clusterManagerNodeTimeout(resizeRequest.clusterManagerNodeTimeout());
        resizeRequest.setWaitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        if (request.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.admin().indices().resizeIndex(resizeRequest, new RestToXContentListener<ResizeResponse>((RestChannel)channel));
        }
        resizeRequest.setShouldStoreResult(true);
        resizeRequest.getTargetIndexRequest().timeout(request.paramAsTime("task_execution_timeout", AcknowledgedRequest.DEFAULT_TASK_EXECUTION_TIMEOUT));
        ActionRequestValidationException validationException = resizeRequest.validate();
        if (validationException != null) {
            throw validationException;
        }
        return this.sendTask(client.getLocalNodeId(), client.executeLocally(ResizeAction.INSTANCE, resizeRequest, LoggingTaskListener.instance()));
    }

    public static class RestCloneIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_clone/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_clone/{target}")));
        }

        @Override
        public String getName() {
            return "clone_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.CLONE;
        }
    }

    public static class RestSplitIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_split/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_split/{target}")));
        }

        @Override
        public String getName() {
            return "split_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SPLIT;
        }
    }

    public static class RestShrinkIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_shrink/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_shrink/{target}")));
        }

        @Override
        public String getName() {
            return "shrink_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SHRINK;
        }
    }
}

