/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import org.apache.lucene.util.ArrayUtil;

final class Ranges {
    byte[][] lowers;
    byte[][] uppers;
    int size;
    int byteLen;
    static ArrayUtil.ByteArrayComparator comparator;

    Ranges(byte[][] lowers, byte[][] uppers) {
        this.lowers = lowers;
        this.uppers = uppers;
        assert (lowers.length == uppers.length);
        this.size = lowers.length;
        this.byteLen = lowers[0].length;
        comparator = ArrayUtil.getUnsignedComparator(this.byteLen);
    }

    public int firstRangeIndex(byte[] globalMin, byte[] globalMax) {
        if (Ranges.compareByteValue(this.lowers[0], globalMax) > 0) {
            return -1;
        }
        int i = 0;
        while (Ranges.compareByteValue(this.uppers[i], globalMin) <= 0) {
            if (++i < this.size) continue;
            return -1;
        }
        return i;
    }

    public static int compareByteValue(byte[] value1, byte[] value2) {
        return comparator.compare(value1, 0, value2, 0);
    }

    public static boolean withinLowerBound(byte[] value, byte[] lowerBound) {
        return Ranges.compareByteValue(value, lowerBound) >= 0;
    }

    public static boolean withinUpperBound(byte[] value, byte[] upperBound) {
        return Ranges.compareByteValue(value, upperBound) < 0;
    }
}

