/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.misc.search.DiversifiedTopDocsCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.ParseField;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregator;
import org.opensearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedBytesHashSamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedMapSamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedOrdinalsSamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.InternalSampler;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class SamplerAggregator
extends DeferableBucketAggregator
implements SingleBucketAggregator {
    public static final ParseField SHARD_SIZE_FIELD = new ParseField("shard_size", new String[0]);
    public static final ParseField MAX_DOCS_PER_VALUE_FIELD = new ParseField("max_docs_per_value", new String[0]);
    public static final ParseField EXECUTION_HINT_FIELD = new ParseField("execution_hint", new String[0]);
    static final long SCOREDOCKEY_SIZE = RamUsageEstimator.shallowSizeOfInstance(DiversifiedTopDocsCollector.ScoreDocKey.class);
    protected final int shardSize;
    protected BestDocsDeferringCollector bdd;

    SamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.shardSize = Math.min(shardSize, context.searcher().getIndexReader().maxDoc());
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new BestDocsDeferringCollector(this.shardSize, this.context.bigArrays(), x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        return this.bdd;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalSampler(this.name, this.bdd == null ? 0L : (long)this.bdd.getDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSampler(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.bdd == null) {
            throw new AggregationExecutionException("Sampler aggregation must be used with child aggregations.");
        }
        return this.bdd.getLeafCollector(ctx);
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bdd);
        super.doClose();
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new DiversifiedMapSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        BYTES_HASH(new ParseField("bytes_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new DiversifiedBytesHashSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new DiversifiedOrdinalsSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!mode.parseField.match(value, LoggingDeprecationHandler.INSTANCE)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + Arrays.toString((Object[])ExecutionMode.values()));
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, int var3, int var4, ValuesSourceConfig var5, SearchContext var6, Aggregator var7, Map<String, Object> var8) throws IOException;

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

