/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.WeightedAvg;

public class ParsedWeightedAvg
extends ParsedSingleValueNumericMetricsAggregation
implements WeightedAvg {
    private static final ObjectParser<ParsedWeightedAvg, Void> PARSER = new ObjectParser(ParsedWeightedAvg.class.getSimpleName(), true, ParsedWeightedAvg::new);

    @Override
    public double getValue() {
        return this.value();
    }

    @Override
    public String getType() {
        return "weighted_avg";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = this.value != Double.POSITIVE_INFINITY;
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    public static ParsedWeightedAvg fromXContent(XContentParser parser, String name) {
        ParsedWeightedAvg avg = PARSER.apply(parser, null);
        avg.setName(name);
        return avg;
    }

    static {
        ParsedWeightedAvg.declareSingleValueFields(PARSER, Double.POSITIVE_INFINITY);
    }
}

