/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.suggest.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.text.Text;
import org.opensearch.search.suggest.Suggester;
import org.opensearch.search.suggest.SuggestionSearchContext;
import org.opensearch.search.suggest.phrase.DirectCandidateGenerator;
import org.opensearch.search.suggest.term.TermSuggestion;
import org.opensearch.search.suggest.term.TermSuggestionContext;

public final class TermSuggester
extends Suggester<TermSuggestionContext> {
    public static final TermSuggester INSTANCE = new TermSuggester();

    private TermSuggester() {
    }

    public TermSuggestion innerExecute(String name, TermSuggestionContext suggestion, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        DirectSpellChecker directSpellChecker = suggestion.getDirectSpellCheckerSettings().createDirectSpellChecker();
        IndexReader indexReader = searcher.getIndexReader();
        TermSuggestion response = new TermSuggestion(name, suggestion.getSize(), suggestion.getDirectSpellCheckerSettings().sort());
        List<Token> tokens = TermSuggester.queryTerms(suggestion, spare);
        for (Token token : tokens) {
            SuggestWord[] suggestedWords = directSpellChecker.suggestSimilar(token.term, suggestion.getShardSize(), indexReader, suggestion.getDirectSpellCheckerSettings().suggestMode());
            Text key = new Text(new BytesArray(token.term.bytes()));
            TermSuggestion.Entry resultEntry = new TermSuggestion.Entry(key, token.startOffset, token.endOffset - token.startOffset);
            for (SuggestWord suggestWord : suggestedWords) {
                Text word = new Text(suggestWord.string);
                resultEntry.addOption(new TermSuggestion.Entry.Option(word, suggestWord.freq, suggestWord.score));
            }
            response.addTerm(resultEntry);
        }
        return response;
    }

    private static List<Token> queryTerms(SuggestionSearchContext.SuggestionContext suggestion, CharsRefBuilder spare) throws IOException {
        final ArrayList<Token> result = new ArrayList<Token>();
        final String field = suggestion.getField();
        DirectCandidateGenerator.analyze(suggestion.getAnalyzer(), suggestion.getText(), field, new DirectCandidateGenerator.TokenConsumer(){

            @Override
            public void nextToken() {
                Term term = new Term(field, BytesRef.deepCopyOf(this.fillBytesRef(new BytesRefBuilder())));
                result.add(new Token(term, this.offsetAttr.startOffset(), this.offsetAttr.endOffset()));
            }
        }, spare);
        return result;
    }

    protected TermSuggestion emptySuggestion(String name, TermSuggestionContext suggestion, CharsRefBuilder spare) throws IOException {
        TermSuggestion termSuggestion = new TermSuggestion(name, suggestion.getSize(), suggestion.getDirectSpellCheckerSettings().sort());
        List<Token> tokens = TermSuggester.queryTerms(suggestion, spare);
        for (Token token : tokens) {
            Text key = new Text(new BytesArray(token.term.bytes()));
            TermSuggestion.Entry resultEntry = new TermSuggestion.Entry(key, token.startOffset, token.endOffset - token.startOffset);
            termSuggestion.addTerm(resultEntry);
        }
        return termSuggestion;
    }

    private static class Token {
        public final Term term;
        public final int startOffset;
        public final int endOffset;

        private Token(Term term, int startOffset, int endOffset) {
            this.term = term;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

