/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nativeprotocol;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.io.stream.ReleasableBytesStreamOutput;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.OutboundHandler;
import org.opensearch.transport.ProtocolOutboundHandler;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.StatsTracker;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportMessageListener;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.nativeprotocol.NativeOutboundMessage;

public final class NativeOutboundHandler
extends ProtocolOutboundHandler {
    private final String nodeName;
    private final Version version;
    private final String[] features;
    private final StatsTracker statsTracker;
    private final ThreadPool threadPool;
    private final BigArrays bigArrays;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;
    private final OutboundHandler handler;

    public NativeOutboundHandler(String nodeName, Version version, String[] features, StatsTracker statsTracker, ThreadPool threadPool, BigArrays bigArrays, OutboundHandler handler) {
        this.nodeName = nodeName;
        this.version = version;
        this.features = features;
        this.statsTracker = statsTracker;
        this.threadPool = threadPool;
        this.bigArrays = bigArrays;
        this.handler = handler;
    }

    @Override
    public void sendRequest(DiscoveryNode node, TcpChannel channel, long requestId, String action, TransportRequest request, TransportRequestOptions options, Version channelVersion, boolean compressRequest, boolean isHandshake) throws IOException, TransportException {
        Version version = Version.min(this.version, channelVersion);
        NativeOutboundMessage.Request message = new NativeOutboundMessage.Request(this.threadPool.getThreadContext(), this.features, request, version, action, requestId, isHandshake, compressRequest);
        ActionListener<Void> listener = ActionListener.wrap(() -> this.messageListener.onRequestSent(node, requestId, action, request, options));
        this.sendMessage(channel, message, listener);
    }

    @Override
    public void sendResponse(Version nodeVersion, Set<String> features, TcpChannel channel, long requestId, String action, TransportResponse response, boolean compress, boolean isHandshake) throws IOException {
        Version version = Version.min(this.version, nodeVersion);
        NativeOutboundMessage.Response message = new NativeOutboundMessage.Response(this.threadPool.getThreadContext(), features, response, version, requestId, isHandshake, compress);
        ActionListener<Void> listener = ActionListener.wrap(() -> this.messageListener.onResponseSent(requestId, action, response));
        this.sendMessage(channel, message, listener);
    }

    @Override
    public void sendErrorResponse(Version nodeVersion, Set<String> features, TcpChannel channel, long requestId, String action, Exception error) throws IOException {
        Version version = Version.min(this.version, nodeVersion);
        TransportAddress address = new TransportAddress(channel.getLocalAddress());
        RemoteTransportException tx = new RemoteTransportException(this.nodeName, address, action, error);
        NativeOutboundMessage.Response message = new NativeOutboundMessage.Response(this.threadPool.getThreadContext(), features, tx, version, requestId, false, false);
        ActionListener<Void> listener = ActionListener.wrap(() -> this.messageListener.onResponseSent(requestId, action, error));
        this.sendMessage(channel, message, listener);
    }

    private void sendMessage(TcpChannel channel, NativeOutboundMessage networkMessage, ActionListener<Void> listener) throws IOException {
        MessageSerializer serializer = new MessageSerializer(networkMessage, this.bigArrays);
        OutboundHandler.SendContext sendContext = new OutboundHandler.SendContext(this.statsTracker, channel, serializer, listener, serializer);
        this.handler.sendBytes(channel, sendContext);
    }

    public void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    private static class MessageSerializer
    implements CheckedSupplier<BytesReference, IOException>,
    Releasable {
        private final NativeOutboundMessage message;
        private final BigArrays bigArrays;
        private volatile ReleasableBytesStreamOutput bytesStreamOutput;

        private MessageSerializer(NativeOutboundMessage message, BigArrays bigArrays) {
            this.message = message;
            this.bigArrays = bigArrays;
        }

        @Override
        public BytesReference get() throws IOException {
            this.bytesStreamOutput = new ReleasableBytesStreamOutput(this.bigArrays);
            return this.message.serialize(this.bytesStreamOutput);
        }

        @Override
        public void close() {
            IOUtils.closeWhileHandlingException((Closeable)this.bytesStreamOutput);
        }
    }
}

