/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class FilterDTO
implements OpenSearchPluginDTO {
    private final String index;
    private final boolean sendIndexEventsOnlyForModifiedSources;

    public FilterDTO(String index, boolean sendIndexEventsOnlyForModifiedSources) {
        Objects.requireNonNull(index, "'index' must not be null");
        this.index = index;
        this.sendIndexEventsOnlyForModifiedSources = sendIndexEventsOnlyForModifiedSources;
    }

    public FilterDTO(Map<String, Object> filterMap) {
        this.checkForWellKnownKeys(filterMap);
        this.index = MapUtil.getValueAsString(filterMap, (String)"index", null);
        this.sendIndexEventsOnlyForModifiedSources = MapUtil.getValueAsBoolean(filterMap, (String)"sendIndexEventsOnlyForModifiedSources", (boolean)false);
    }

    private void checkForWellKnownKeys(Map<String, Object> filterMap) {
        MapUtil.checkForWellKnownKeys(filterMap, Set.of("index", "sendIndexEventsOnlyForModifiedSources"));
    }

    public FilterDTO(StreamInput in) throws IOException {
        this.index = in.readString();
        this.sendIndexEventsOnlyForModifiedSources = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeBoolean(this.sendIndexEventsOnlyForModifiedSources);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.getIndex());
        builder.field("sendIndexEventsOnlyForModifiedSources", this.isSendIndexEventsOnlyForModifiedSources());
        builder.endObject();
        return builder;
    }

    public static FilterDTO fromXContent(XContentParser parser) throws IOException {
        return new FilterDTO(parser.map());
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isSendIndexEventsOnlyForModifiedSources() {
        return this.sendIndexEventsOnlyForModifiedSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterDTO filterDTO = (FilterDTO)o;
        return this.sendIndexEventsOnlyForModifiedSources == filterDTO.sendIndexEventsOnlyForModifiedSources && Objects.equals(this.index, filterDTO.index);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.sendIndexEventsOnlyForModifiedSources);
    }

    public String toString() {
        return "FilterDTO{index='" + this.index + "', sendIndexEventsOnlyForModifiedSources=" + this.sendIndexEventsOnlyForModifiedSources + "}";
    }
}

