/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.BpcConnections;
import de.virtimo.bpc.opensearch.plugin.BpcPlugin;
import de.virtimo.bpc.opensearch.plugin.BpcPluginModelInitDTO;
import de.virtimo.bpc.opensearch.plugin.BpcWebsocketRequestsCoordinator;
import de.virtimo.bpc.opensearch.plugin.ChangesFilter;
import de.virtimo.bpc.opensearch.plugin.ChangesFilters;
import de.virtimo.bpc.opensearch.plugin.ClusterObserver;
import de.virtimo.bpc.opensearch.plugin.MasterServerInfo;
import de.virtimo.bpc.opensearch.plugin.NodesInfo;
import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobsOrchestrator;
import de.virtimo.bpc.opensearch.plugin.WebSocket;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobDeleteActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfosDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfosGetActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupSnapshotInfoDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterAddActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveAllActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobActionAcknowledgementDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobForcedStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRestartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobStatsGetActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsClearLookupJoinCachesActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromAllServersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.delete.BackupJobDeleteAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.delete.BackupJobDeleteRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.delete.BackupJobDeleteResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.schedule.BackupJobScheduleAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.schedule.BackupJobScheduleRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.schedule.BackupJobScheduleResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.acknowledged.ReplicationJobActionAcknowledgedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.acknowledged.ReplicationJobActionAcknowledgedRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.acknowledged.ReplicationJobActionAcknowledgedResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.ReplicationJobForcedStartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.ReplicationJobForcedStartRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.ReplicationJobForcedStartResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.ReplicationJobRestartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.ReplicationJobRestartRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.ReplicationJobRestartResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.ReplicationJobStartActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.ReplicationJobStartActionsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.ReplicationJobStartActionsResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.ReplicationJobStopActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.ReplicationJobStopActionsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.ReplicationJobStopActionsResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.ReplicationJobsSetModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.ReplicationJobsSetModelRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.ReplicationJobsSetModelResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.ReplicationJobsClearLookupJoinCachesAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.ReplicationJobsClearLookupJoinCachesRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.ReplicationJobsClearLookupJoinCachesResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.ReplicationJobRefreshLookupJoinsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.ReplicationJobRefreshLookupJoinsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.ReplicationJobRefreshLookupJoinsResponse;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.ReplicationJobsRefreshAllLookupJoinsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.ReplicationJobsRefreshAllLookupJoinsRequest;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.ReplicationJobsRefreshAllLookupJoinsResponse;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.SetUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobDeleteWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobInfosRequestWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobInfosResponseWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobScheduleWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobStartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupSnapshotCreatedInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ClearLookupJoinCachesOfReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexCreatedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexDeletedWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.IndexOperationWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.PlainTextWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.RefreshLookupJoinsOfReplicationJobWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobForcedStartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobForcedStartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobRestartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobRestartWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStartActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsRequestWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsResponseWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStopAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStopActionWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.SetAsMasterServerWebsocketMessage;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.websocket.DeploymentException;
import org.apache.logging.log4j.Logger;
import org.glassfish.tyrus.server.Server;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.engine.Engine;

public class Manager
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = Loggers.getLogger(Manager.class, (String[])new String[]{"os-bpc-plugin"});
    public static final int REPLICATION_JOBS_ORCHESTRATION_CHECKER_INITIAL_DELAY_IN_SECONDS = 10;
    public static final int REPLICATION_JOBS_ORCHESTRATION_CHECKER_RUNS_EVERY_SECONDS = 1;
    public static final int PROCESS_UPDATED_CONNECTIONS_DELAY_IN_SECONDS = 15;
    private final Client client;
    private final ClusterService clusterService;
    private final NodesInfo nodesInfo;
    private final ClusterObserver clusterObserver;
    private MasterServerInfo masterServerInfo;
    private BpcConnections connections;
    private ChangesFilters changesFilters;
    private ReplicationJobs currentReplicationJobs;
    private long replicationJobsTransferredTimestamp;
    private boolean transferReplicationJobsToOtherNodesRunning;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private long connectionsLastUpdatedProcessedByChecker;
    private boolean replicationJobsOrchestrationRunning;
    private ReplicationJobs queuedReplicationJobs;
    private final BpcWebsocketRequestsCoordinator<ReplicationJobsWithRuntimeStatsFromServerDTO> replicationJobStatsRequestsCoordinator;
    private final BpcWebsocketRequestsCoordinator<BackupJobInfosDTO> backupJobInfosRequestsCoordinator;
    private final BpcWebsocketRequestsCoordinator<BackupSnapshotInfoDTO> backupJobStartRequestsCoordinator;
    private final int websocketServerPort;
    private final Server websocketServer;
    private static final Object MASTER_SERVER_LOCK = new Object();

    public Manager(Client client, ClusterService clusterService, Settings settings) {
        LOGGER.debug("Manager client={}, clusterService={}, settings={}", (Object)client, (Object)clusterService, (Object)settings);
        this.client = client;
        this.clusterService = clusterService;
        this.nodesInfo = new NodesInfo(client, clusterService);
        this.clusterObserver = new ClusterObserver(clusterService, this);
        this.masterServerInfo = null;
        this.connections = new BpcConnections();
        this.changesFilters = new ChangesFilters();
        this.currentReplicationJobs = new ReplicationJobs();
        this.replicationJobsTransferredTimestamp = 0L;
        this.transferReplicationJobsToOtherNodesRunning = false;
        this.replicationJobStatsRequestsCoordinator = new BpcWebsocketRequestsCoordinator();
        this.backupJobInfosRequestsCoordinator = new BpcWebsocketRequestsCoordinator();
        this.backupJobStartRequestsCoordinator = new BpcWebsocketRequestsCoordinator();
        this.connectionsLastUpdatedProcessedByChecker = -1L;
        this.replicationJobsOrchestrationRunning = false;
        this.queuedReplicationJobs = null;
        this.websocketServerPort = BpcPlugin.getSettingsValueAsInt(settings, "os-bpc-plugin.websocket.port", BpcPlugin.DEFAULT_WEBSOCKET_PORT);
        this.websocketServer = new Server("localhost", this.websocketServerPort, "/ws", MapUtil.mapOf((Object[])new Object[]{"manager", this}), new Class[]{WebSocket.class});
    }

    protected void doStart() {
        try {
            LOGGER.info("Starting WebSocket server");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        Manager.this.websocketServer.start();
                        return null;
                    }
                    catch (DeploymentException e) {
                        throw new RuntimeException("Failed to start server", e);
                    }
                }
            });
            LOGGER.info("WebSocket server started");
        }
        catch (Exception e) {
            LOGGER.error("Failed to start WebSocket server. Please restart OpenSearch to try it again or check why it is not possible to start a websocket server on port '{}'.", (Object)this.websocketServerPort, (Object)e);
            throw new RuntimeException(e);
        }
        try {
            this.clusterObserver.doStart();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to start the cluster observer.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        try {
            this.executorService = Executors.newSingleThreadScheduledExecutor();
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(new ReplicationJobsOrchestrationCheckerRunnable(), 10L, 1L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to start the replication jobs orchestration checker.", (Throwable)ex);
        }
    }

    protected void doStop() {
        this.websocketServer.stop();
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOGGER.debug("Running replications jobs orchestration checker cancelled.");
            } else {
                LOGGER.warn("Failed to cancel the running replication jobs orchestration checker.");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.clusterObserver.doStop();
    }

    protected void doClose() throws IOException {
    }

    public void initializePluginModel(String sendFromOpenSearchNode, BpcPluginModelInitDTO initPluginModelDTO) {
        LOGGER.info("initializePluginModel sendFromOpenSearchNode={}, initPluginModelDTO={}", (Object)sendFromOpenSearchNode, (Object)initPluginModelDTO);
        this.masterServerInfo = initPluginModelDTO.getMasterServerInfo();
        this.connections.processBpcConnectionsSetting(initPluginModelDTO.getConnections().getAll());
        this.changesFilters = initPluginModelDTO.getChangesFilters();
        this.currentReplicationJobs = initPluginModelDTO.getReplicationJobs();
    }

    public NodesInfo getNodesInfo() {
        return this.nodesInfo;
    }

    public MasterServerInfo getMasterServerInfo() {
        return this.masterServerInfo;
    }

    public BpcConnections getConnections() {
        return this.connections;
    }

    public ChangesFilters getChangesFilters() {
        return this.changesFilters;
    }

    public ReplicationJobs getCurrentReplicationJobs() {
        return this.currentReplicationJobs;
    }

    public void setCurrentReplicationJobs(String sendFromOpenSearchNode, ReplicationJobs currentReplicationJobs) {
        LOGGER.debug("setCurrentReplicationJobs sendFromOpenSearchNode={}, currentReplicationJobs={}", (Object)sendFromOpenSearchNode, (Object)currentReplicationJobs);
        this.currentReplicationJobs = currentReplicationJobs;
    }

    public void registerWebSocket(WebSocket webSocket) {
        LOGGER.debug("registerWebSocket webSocket={}", (Object)webSocket);
        String thisNodeName = this.nodesInfo.getLocalNodeName();
        BpcConnection connection = this.connections.addConnection(thisNodeName, webSocket);
        this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(thisNodeName, connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

            public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a BPC connection added message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a BPC connection added message to all nodes. Response: " + bpcConnectionAddedOrUpdatedResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast a BPC connection added message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void unregisterWebSocket(String webSocketId) {
        LOGGER.debug("unregisterWebSocket webSocketId={}", (Object)webSocketId);
        BpcConnection existingConnection = this.connections.getConnectionByWebsocketId(webSocketId);
        this._unregisterConnection(existingConnection);
    }

    private void _unregisterConnection(BpcConnection existingConnection) {
        LOGGER.info("_unregisterConnection existingConnection={}", (Object)existingConnection);
        if (existingConnection != null) {
            this.client.execute((ActionType)BpcConnectionRemovedAction.INSTANCE, (ActionRequest)new BpcConnectionRemovedRequest(this.nodesInfo.getLocalNodeName(), existingConnection), (ActionListener)new ActionListener<BpcConnectionRemovedResponse>(){

                public void onResponse(BpcConnectionRemovedResponse bpcConnectionRemovedResponse) {
                    if (bpcConnectionRemovedResponse.hasFailures()) {
                        LOGGER.error("Failed to broadcast a BPC connection removed message to all nodes.", (Throwable)bpcConnectionRemovedResponse.createAggregatedException());
                    } else {
                        LOGGER.debug("Done broadcasting a BPC connection removed message to all nodes. Response: {}", (Object)bpcConnectionRemovedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOGGER.error("Failed to broadcast a BPC connection removed message to all nodes.", (Throwable)ex);
                }
            });
        }
    }

    public void unregisterRemovedOpenSearchNodes(Set<String> namesOfRemovedNodes) {
        LOGGER.debug("unregisterRemovedOpenSearchNodes namesOfRemovedNodes={}", namesOfRemovedNodes);
        List<BpcConnection> connectionsToUnregister = this.connections.getConnectionsByOpenSearchNodeNames(namesOfRemovedNodes);
        for (BpcConnection connectionToUnregister : connectionsToUnregister) {
            this._unregisterConnection(connectionToUnregister);
        }
    }

    public void handleJustAddedOpenSearchNodes(List<DiscoveryNode> addedNodes) {
        LOGGER.debug("handleJustAddedOpenSearchNodes addedNodes={}", addedNodes);
        this.nodesInfo.ifThisNodeIsTheMasterNodeOrElse(() -> this._handleJustAddedOpenSearchNodes(addedNodes), () -> LOGGER.debug("Skipping, the plugin model initialization must be processed on the master node only."));
    }

    public void _handleJustAddedOpenSearchNodes(List<DiscoveryNode> addedNodes) {
        LOGGER.debug("_handleJustAddedOpenSearchNodes addedNodes={}", addedNodes);
        BpcPluginModelInitDTO initPluginModelDTO = new BpcPluginModelInitDTO(this.masterServerInfo, this.connections, this.changesFilters, this.currentReplicationJobs);
        this.client.execute((ActionType)InitializeModelAction.INSTANCE, (ActionRequest)new InitializeModelRequest(this.nodesInfo.getLocalNodeName(), addedNodes, initPluginModelDTO), (ActionListener)new ActionListener<InitializeModelResponse>(){

            public void onResponse(InitializeModelResponse initializeModelResponse) {
                if (initializeModelResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast the initialize model message to the just added nodes.", (Throwable)initializeModelResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting the initialize model message to the just added nodes. Response: {}", (Object)initializeModelResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the init plugin model message to the just added nodes.", (Throwable)ex);
            }
        });
    }

    public void processReceivedServerStateInfoWebsocketMessage(String websocketId, ServerStateInfoWebsocketMessage serverStateInfoWebsocketMessage) {
        LOGGER.debug("processReceivedServerStateInfoWebsocketMessage websocketId={}, serverStateInfoWebsocketMessage={}", (Object)websocketId, (Object)serverStateInfoWebsocketMessage);
        BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
        if (connection != null) {
            ServerStateInfoDTO serverStateInfo = serverStateInfoWebsocketMessage.getServerStateInfo();
            connection.setServerStateInfo(serverStateInfo);
            this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(this.nodesInfo.getLocalNodeName(), connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

                public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                    if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                        LOGGER.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                    } else {
                        LOGGER.debug("Done broadcasting a BPC connection updated message to all nodes. Response: {}", (Object)bpcConnectionAddedOrUpdatedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOGGER.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)ex);
                }
            });
        } else {
            LOGGER.warn("There must be something wrong. Received a server state info websocket message, but there is no websocket session registered on this node.");
        }
    }

    public void processReceivedServerLoadedModulesWebsocketMessage(String websocketId, ServerLoadedModulesWebsocketMessage serverLoadedModulesWebsocketMessage) {
        LOGGER.debug("processReceivedServerLoadedModulesWebsocketMessage websocketId={}, serverLoadedModulesWebsocketMessage={}", (Object)websocketId, (Object)serverLoadedModulesWebsocketMessage);
        BpcConnection connection = this.connections.getConnectionByWebsocketId(websocketId);
        if (connection != null) {
            LoadedModulesDTO serverLoadedModules = serverLoadedModulesWebsocketMessage.getServerLoadedModules();
            connection.setServerLoadedModules(serverLoadedModules);
            this.client.execute((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, (ActionRequest)new BpcConnectionAddedOrUpdatedRequest(this.nodesInfo.getLocalNodeName(), connection), (ActionListener)new ActionListener<BpcConnectionAddedOrUpdatedResponse>(){

                public void onResponse(BpcConnectionAddedOrUpdatedResponse bpcConnectionAddedOrUpdatedResponse) {
                    if (bpcConnectionAddedOrUpdatedResponse.hasFailures()) {
                        LOGGER.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)bpcConnectionAddedOrUpdatedResponse.createAggregatedException());
                    } else {
                        LOGGER.debug("Done broadcasting a BPC connection updated message to all nodes. Response: {}", (Object)bpcConnectionAddedOrUpdatedResponse);
                    }
                }

                public void onFailure(Exception ex) {
                    LOGGER.error("Failed to broadcast a BPC connection updated message to all nodes.", (Throwable)ex);
                }
            });
        } else {
            LOGGER.warn("There must be something wrong. Received a server loaded modules websocket message, but there is no websocket session registered on this node.");
        }
    }

    private void setNextAvailableServerAsMaster(ActionListener<MasterServerInfo> afterExecution) {
        String nextServerUUID;
        LOGGER.debug("setNextAvailableServerAsMaster afterExecution=...");
        ServerStateInfoDTO serverStateInfo = this.connections.evaluateNextAvailableMasterServer();
        if (serverStateInfo != null) {
            LOGGER.debug("setNextAvailableServerAsMaster serverStateInfo={}", (Object)serverStateInfo);
            nextServerUUID = serverStateInfo.getServerUUID();
        } else {
            LOGGER.info("setNextAvailableServerAsMaster: There is no BPC server available");
            nextServerUUID = "<<NONE>>";
        }
        this.setAsMasterServer(nextServerUUID, afterExecution);
    }

    public void setAsMasterServer(String masterServerUUID, final ActionListener<MasterServerInfo> afterExecution) {
        LOGGER.debug("setAsMasterServer masterServerUUID={}, afterExecution={}", (Object)masterServerUUID, afterExecution);
        final MasterServerInfo masterServerInfo = new MasterServerInfo(masterServerUUID);
        this.client.execute((ActionType)MasterServerSetAction.INSTANCE, (ActionRequest)new MasterServerSetRequest(this.nodesInfo.getLocalNodeName(), masterServerInfo), (ActionListener)new ActionListener<MasterServerSetResponse>(){

            public void onResponse(MasterServerSetResponse masterServerSetResponse) {
                if (afterExecution != null) {
                    if (masterServerSetResponse.hasFailures()) {
                        OpenSearchException aggregatedException = masterServerSetResponse.createAggregatedException();
                        LOGGER.error("Failed to set master server on all nodes.", (Throwable)aggregatedException);
                        afterExecution.onFailure((Exception)aggregatedException);
                    } else {
                        afterExecution.onResponse((Object)masterServerInfo);
                    }
                } else if (masterServerSetResponse.hasFailures()) {
                    LOGGER.error("Failed to set master server on all nodes.", (Throwable)masterServerSetResponse.createAggregatedException());
                }
            }

            public void onFailure(Exception ex) {
                if (afterExecution != null) {
                    afterExecution.onFailure(ex);
                } else {
                    LOGGER.error("Failed to broadcast the master server info message to all nodes.", (Throwable)ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMasterServerInfoSetting(String sendFromOpenSearchNode, MasterServerInfo masterServerInfo) {
        LOGGER.debug("processMasterServerInfoSetting sendFromOpenSearchNode={}, masterServerInfo={}", (Object)sendFromOpenSearchNode, (Object)masterServerInfo);
        Object object = MASTER_SERVER_LOCK;
        synchronized (object) {
            if (masterServerInfo == null || !masterServerInfo.isMasterServerSet()) {
                LOGGER.info("No more BPC master server");
                this.masterServerInfo = null;
            } else if (this.masterServerInfo == null || !this.masterServerInfo.getServerUUID().equals(masterServerInfo.getServerUUID())) {
                LOGGER.info("Setting the BPC server with the following UUID as master: {}", (Object)masterServerInfo.getServerUUID());
                this.masterServerInfo = masterServerInfo;
                SetAsMasterServerWebsocketMessage setAsMasterServerWebsocketMessage = new SetAsMasterServerWebsocketMessage(masterServerInfo.getServerUUID());
                this.connections.sendWebsocketMessage((WebsocketMessage)setAsMasterServerWebsocketMessage, null);
            } else {
                LOGGER.info("The BPC server with the following UUID is already set as master: {}", (Object)masterServerInfo.getServerUUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAddedOrUpdatedConnection(String sendFromOpenSearchNode, BpcConnection connection) {
        LOGGER.debug("processAddedOrUpdatedConnection sendFromOpenSearchNode={}, connection={}", (Object)sendFromOpenSearchNode, (Object)connection);
        if (connection != null) {
            this.connections.addOrUpdateConnection(connection);
            Object object = MASTER_SERVER_LOCK;
            synchronized (object) {
                if (this.masterServerInfo == null && connection.hasServerStateInfo()) {
                    this.nodesInfo.ifThisNodeIsTheMasterNode(() -> this.setNextAvailableServerAsMaster(new ActionListener<MasterServerInfo>(){

                        public void onResponse(MasterServerInfo masterServerInfo) {
                            LOGGER.info("'{}' has been set as the new master server (processAddedOrUpdatedConnection).", (Object)masterServerInfo.getServerUUID());
                        }

                        public void onFailure(Exception ex) {
                            LOGGER.error("Failed to set next available server as the new master server (processAddedOrUpdatedConnection).", (Throwable)ex);
                        }
                    }));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemovedConnection(String sendFromOpenSearchNode, BpcConnection connection) {
        LOGGER.info("processRemovedConnection sendFromOpenSearchNode={}, connection={}", (Object)sendFromOpenSearchNode, (Object)connection);
        if (connection != null) {
            BpcConnection existingConnection;
            String unregisteredServerUUID;
            ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
            String string = unregisteredServerUUID = serverStateInfo != null ? serverStateInfo.getServerUUID() : null;
            if (unregisteredServerUUID != null) {
                ChangesFilterRemoveAllActionDTO removeAllFiltersAction = new ChangesFilterRemoveAllActionDTO(unregisteredServerUUID);
                this.removeAllChangesFilters(removeAllFiltersAction, true);
            }
            if ((existingConnection = this.connections.getConnectionByWebsocketId(connection.getWebsocketId())) != null) {
                this.connections.removeConnection(existingConnection);
                if (serverStateInfo != null) {
                    this.currentReplicationJobs.setThoseAsStoppedUsingServerUUIDs(SetUtil.setOf((Object[])new String[]{serverStateInfo.getServerUUID()}));
                }
            }
            Object object = MASTER_SERVER_LOCK;
            synchronized (object) {
                if (this.masterServerInfo == null || this.masterServerInfo.getServerUUID().equals(unregisteredServerUUID)) {
                    this.nodesInfo.ifThisNodeIsTheMasterNode(() -> this.setNextAvailableServerAsMaster(new ActionListener<MasterServerInfo>(){

                        public void onResponse(MasterServerInfo masterServerInfo) {
                            LOGGER.info("'{}' has been set as the new master server (processRemovedConnection).", (Object)masterServerInfo.getServerUUID());
                        }

                        public void onFailure(Exception ex) {
                            LOGGER.error("Failed to set next available server as the new master server (processRemovedConnection).", (Throwable)ex);
                        }
                    }));
                }
            }
        }
    }

    public void addChangesFilter(ChangesFilterAddActionDTO addFilterAction, boolean informOtherNodes) {
        LOGGER.debug("addChangesFilter addFilterAction={}, informOtherNodes={}", (Object)addFilterAction, (Object)informOtherNodes);
        boolean added = this.changesFilters.add(addFilterAction.getServerUUID(), addFilterAction.getIndex(), addFilterAction.isSendIndexEventsOnlyForModifiedSources());
        if (!added) {
            LOGGER.info("Adding the following changes filter failed somehow: {}", (Object)addFilterAction);
            return;
        }
        if (!informOtherNodes) {
            LOGGER.debug("Nothing to do ... the other nodes must not be informed.");
            return;
        }
        List<DiscoveryNode> allOtherNodes = this.nodesInfo.getAllOtherNodes();
        if (allOtherNodes == null || allOtherNodes.isEmpty()) {
            LOGGER.debug("Nothing to do ... there are no other nodes beside the master node to send the replication jobs to");
            return;
        }
        this.client.execute((ActionType)ChangesFilterAddAction.INSTANCE, (ActionRequest)new ChangesFilterAddRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, addFilterAction), (ActionListener)new ActionListener<ChangesFilterAddResponse>(){

            public void onResponse(ChangesFilterAddResponse changesFilterAddResponse) {
                if (changesFilterAddResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a add changes filter message to all other nodes.", (Throwable)changesFilterAddResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a add changes filter message to all other nodes. Response: {}", (Object)changesFilterAddResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast a add changes filter message to all other nodes.", (Throwable)ex);
            }
        });
    }

    public void removeAllChangesFilters(ChangesFilterRemoveAllActionDTO removeAllFilterAction, boolean informOtherNodes) {
        LOGGER.debug("removeAllChangesFilters removeAllFilterAction={}, informOtherNodes={}", (Object)removeAllFilterAction, (Object)informOtherNodes);
        if (!this.changesFilters.removeAll(removeAllFilterAction.getServerUUID())) {
            LOGGER.info("Removing all changes filters failed somehow.");
            return;
        }
        if (!informOtherNodes) {
            LOGGER.debug("Nothing to do ... the other nodes must not be informed.");
            return;
        }
        List<DiscoveryNode> allOtherNodes = this.nodesInfo.getAllOtherNodes();
        if (allOtherNodes == null || allOtherNodes.isEmpty()) {
            LOGGER.debug("Nothing to do ... there are no other nodes beside the master node to send the replication jobs to");
            return;
        }
        this.client.execute((ActionType)ChangesFilterRemoveAllAction.INSTANCE, (ActionRequest)new ChangesFilterRemoveAllRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, removeAllFilterAction), (ActionListener)new ActionListener<ChangesFilterRemoveAllResponse>(){

            public void onResponse(ChangesFilterRemoveAllResponse changesFilterRemoveAllResponse) {
                if (changesFilterRemoveAllResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a remove all changes filters message to all other nodes.", (Throwable)changesFilterRemoveAllResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a remove all changes filters message to all other nodes. Response: {}", (Object)changesFilterRemoveAllResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast a remove all changes filters message to all other nodes.", (Throwable)ex);
            }
        });
    }

    public boolean removeChangesFilter(ChangesFilterRemoveActionDTO removeFilterAction, boolean informOtherNodes) {
        LOGGER.debug("removeChangesFilter removeFilterAction={}, informOtherNodes={}", (Object)removeFilterAction, (Object)informOtherNodes);
        if (!this.changesFilters.remove(removeFilterAction.getServerUUID(), removeFilterAction.getIndex())) {
            LOGGER.info("Removing the following changes filter failed somehow: {}", (Object)removeFilterAction);
            return false;
        }
        if (!informOtherNodes) {
            LOGGER.debug("Nothing to do ... the other nodes must not be informed.");
            return true;
        }
        List<DiscoveryNode> allOtherNodes = this.nodesInfo.getAllOtherNodes();
        if (allOtherNodes == null || allOtherNodes.isEmpty()) {
            LOGGER.debug("Nothing to do ... there are no other nodes beside the master node to send the replication jobs to");
            return true;
        }
        this.client.execute((ActionType)ChangesFilterRemoveAction.INSTANCE, (ActionRequest)new ChangesFilterRemoveRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, removeFilterAction), (ActionListener)new ActionListener<ChangesFilterRemoveResponse>(){

            public void onResponse(ChangesFilterRemoveResponse changesFilterRemoveResponse) {
                if (changesFilterRemoveResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a remove changes filter message to all other nodes.", (Throwable)changesFilterRemoveResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a remove changes filter message to all other nodes. Response: {}", (Object)changesFilterRemoveResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast a remove changes filter message to all other nodes.", (Throwable)ex);
            }
        });
        return true;
    }

    public void processAddChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterAddActionDTO addFilterActionDTO) {
        LOGGER.debug("processAddChangesFilterActionDTO sendFromOpenSearchNode={}, addFilterActionDTO={}", (Object)sendFromOpenSearchNode, (Object)addFilterActionDTO);
        this.addChangesFilter(addFilterActionDTO, false);
    }

    public void processRemoveAllChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterRemoveAllActionDTO removeAllFilterActionDTO) {
        LOGGER.debug("processRemoveAllChangesFilterActionDTO sendFromOpenSearchNode={}, removeAllFilterActionDTO={}", (Object)sendFromOpenSearchNode, (Object)removeAllFilterActionDTO);
        this.removeAllChangesFilters(removeAllFilterActionDTO, false);
    }

    public void processRemoveChangesFilterActionDTO(String sendFromOpenSearchNode, ChangesFilterRemoveActionDTO removeFilterActionDTO) {
        LOGGER.debug("processRemoveChangesFilterActionDTO sendFromOpenSearchNode={}, removeFilterActionDTO={}", (Object)sendFromOpenSearchNode, (Object)removeFilterActionDTO);
        this.removeChangesFilter(removeFilterActionDTO, false);
    }

    private Set<String> getAliasesOfIndex(String indexName) {
        return new HashSet<String>(this.clusterService.state().metadata().index(indexName).getAliases().keySet());
    }

    public void onIndexDeleted(String indexName) {
        LOGGER.debug("onIndexDeleted indexName={}", (Object)indexName);
        if (this.connections.hasEntries()) {
            IndexDeletedWebsocketMessage indexDeletedWebsocketMessage = new IndexDeletedWebsocketMessage(indexName);
            this.connections.sendWebsocketMessage((WebsocketMessage)indexDeletedWebsocketMessage, null);
        }
    }

    public void onIndexCreated(String indexName) {
        LOGGER.debug("onIndexCreated indexName={}", (Object)indexName);
        if (this.connections.hasEntries()) {
            IndexCreatedWebsocketMessage indexCreatedWebsocketMessage = new IndexCreatedWebsocketMessage(indexName);
            this.connections.sendWebsocketMessage((WebsocketMessage)indexCreatedWebsocketMessage, null);
        }
    }

    public Boolean onPreIndexDocumentOperation(String indexName, Engine.Index index) {
        LOGGER.debug("onPreIndexDocumentOperation indexName={}, index=...", (Object)indexName);
        Boolean identicalSources = null;
        if (this.connections.hasEntries()) {
            Set<String> aliasesOfIndex = this.getAliasesOfIndex(indexName);
            String documentId = index.id();
            ChangesFilter filter = this.changesFilters.getFilter(indexName, aliasesOfIndex);
            if (filter != null && filter.isSendIndexEventsOnlyForModifiedSources()) {
                byte[] currentSourceBytes = this.getCurrentDocumentSourceAsBytes(index);
                byte[] previousSourceBytes = this.getPreviousDocumentSourceAsBytes(indexName, documentId);
                identicalSources = this.areDocumentSourcesIdentical(currentSourceBytes, previousSourceBytes);
            }
        }
        return identicalSources;
    }

    private byte[] getCurrentDocumentSourceAsBytes(Engine.Index index) {
        return BytesReference.toBytes((BytesReference)index.source());
    }

    private byte[] getPreviousDocumentSourceAsBytes(String indexName, String documentId) {
        byte[] previousSourceBytes = null;
        try {
            GetResponse getResponse = (GetResponse)this.client.prepareGet(indexName, documentId).execute().actionGet();
            if (getResponse != null) {
                previousSourceBytes = getResponse.getSourceAsBytes();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not get the current document.", (Throwable)ex);
        }
        return previousSourceBytes;
    }

    private boolean areDocumentSourcesIdentical(byte[] currentSource, byte[] previousSource) {
        if (currentSource == null && previousSource == null) {
            return true;
        }
        if (currentSource != null && previousSource == null) {
            return false;
        }
        if (currentSource == null && previousSource != null) {
            return false;
        }
        return Arrays.equals(currentSource, previousSource);
    }

    public void onPostIndexDocumentOperation(String indexName, Engine.Index index, Boolean identicalSources) {
        Set<String> aliasesOfIndex;
        ChangesFilter filter;
        LOGGER.debug("onPostIndexDocumentOperation indexName={}, index=..., identicalSources={}", (Object)indexName, (Object)identicalSources);
        if (this.connections.hasEntries() && (filter = this.changesFilters.getFilter(indexName, aliasesOfIndex = this.getAliasesOfIndex(indexName))) != null) {
            boolean sendChangesEvent = filter.isSendIndexEventsOnlyForModifiedSources() ? (identicalSources != null ? identicalSources == false : false) : true;
            if (sendChangesEvent) {
                IndexOperationDTO indexOperation = new IndexOperationDTO(indexName, aliasesOfIndex, index.id(), IndexOperationDTO.Operation.INDEX, index.version(), (Map)XContentHelper.convertToMap((BytesReference)index.source(), (boolean)false, (XContentType)XContentType.JSON).v2());
                this.processIndexOperation(indexOperation);
            }
        }
    }

    public void onDeleteDocumentOperation(String indexName, String documentId, long documentVersion) {
        Set<String> aliasesOfIndex;
        ChangesFilter filter;
        LOGGER.debug("onDeleteDocumentOperation indexName={}, documentId={}, documentVersion={}", (Object)indexName, (Object)documentId, (Object)documentVersion);
        if (this.connections.hasEntries() && (filter = this.changesFilters.getFilter(indexName, aliasesOfIndex = this.getAliasesOfIndex(indexName))) != null) {
            IndexOperationDTO indexOperation = new IndexOperationDTO(indexName, aliasesOfIndex, documentId, IndexOperationDTO.Operation.DELETE, documentVersion, null);
            this.processIndexOperation(indexOperation);
        }
    }

    private void processIndexOperation(IndexOperationDTO indexOperation) {
        LOGGER.debug("processIndexOperation indexOperation={}", (Object)indexOperation);
        this.client.execute((ActionType)IndexOperationAction.INSTANCE, (ActionRequest)new IndexOperationRequest(this.nodesInfo.getLocalNodeName(), indexOperation), (ActionListener)new ActionListener<IndexOperationResponse>(){

            public void onResponse(IndexOperationResponse indexOperationResponse) {
                if (indexOperationResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a index operation message to all nodes.", (Throwable)indexOperationResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a index operation message to all nodes. Response: {}", (Object)indexOperationResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast an IndexOperation to all nodes.", (Throwable)ex);
            }
        });
    }

    public void sendIndexOperationToConnectedServers(String sendFromOpenSearchNode, IndexOperationDTO indexOperation) {
        LOGGER.debug("sendIndexOperationToConnectedServers sendFromOpenSearchNode={}, indexOperation={}", (Object)sendFromOpenSearchNode, (Object)indexOperation);
        IndexOperationWebsocketMessage indexOperationWebsocketMessage = new IndexOperationWebsocketMessage(indexOperation);
        this.connections.sendWebsocketMessage((WebsocketMessage)indexOperationWebsocketMessage, null);
    }

    public void processReceivedBroadcastToAllWebsocketMessage(String websocketId, String serverUUID, BroadcastToAllWebsocketMessage websocketMessage) {
        LOGGER.debug("processReceivedBroadcastToAllWebsocketMessage websocketId={}, serverUUID={}, websocketMessage={}", (Object)websocketId, (Object)serverUUID, (Object)websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAllAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToAllRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToAllResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToAllResponse broadcastReceivedWebsocketMessageToAllResponse) {
                if (broadcastReceivedWebsocketMessageToAllResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToAllResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a received websocket message to all nodes. Response: {}", (Object)broadcastReceivedWebsocketMessageToAllResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage) {
        LOGGER.debug("forwardWebsocketMessageToConnectedServers sendFromOpenSearchNode={}, broadcastToAllWebsocketMessage={}", (Object)sendFromOpenSearchNode, (Object)broadcastToAllWebsocketMessage);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(broadcastToAllWebsocketMessage.getMessage());
        this.connections.sendWebsocketMessage((WebsocketMessage)websocketMessageToSend, null);
    }

    public void processReceivedBroadcastToAllExceptSenderWebsocketMessage(String websocketId, String serverUUID, BroadcastToAllExceptSenderWebsocketMessage websocketMessage) {
        LOGGER.debug("processReceivedBroadcastToAllExceptSenderWebsocketMessage websocketId={}, serverUUID={}, websocketMessage={}", (Object)websocketId, (Object)serverUUID, (Object)websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAllExceptSenderAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToAllExceptSenderRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToAllExceptSenderResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToAllExceptSenderResponse broadcastReceivedWebsocketMessageToAllExceptSenderResponse) {
                if (broadcastReceivedWebsocketMessageToAllExceptSenderResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToAllExceptSenderResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a received websocket message to all nodes. Response: {}", (Object)broadcastReceivedWebsocketMessageToAllExceptSenderResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to send a broadcast to all except sender websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToAllExceptSenderWebsocketMessage websocketMessage, String senderServerUUID) {
        LOGGER.debug("forwardWebsocketMessageToConnectedServers sendFromOpenSearchNode={}, websocketMessage={}, senderServerUUID={}", (Object)sendFromOpenSearchNode, (Object)websocketMessage, (Object)senderServerUUID);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(websocketMessage.getMessage());
        this.connections.sendWebsocketMessage((WebsocketMessage)websocketMessageToSend, Collections.singletonList(senderServerUUID));
    }

    public void processReceivedBroadcastToWebsocketMessage(String websocketId, String serverUUID, BroadcastToWebsocketMessage websocketMessage) {
        LOGGER.debug("processReceivedBroadcastToWebsocketMessage websocketId={}, serverUUID={}, websocketMessage={}", (Object)websocketId, (Object)serverUUID, (Object)websocketMessage);
        this.client.execute((ActionType)BroadcastReceivedWebsocketMessageToAction.INSTANCE, (ActionRequest)new BroadcastReceivedWebsocketMessageToRequest(this.nodesInfo.getLocalNodeName(), websocketId, serverUUID, websocketMessage), (ActionListener)new ActionListener<BroadcastReceivedWebsocketMessageToResponse>(){

            public void onResponse(BroadcastReceivedWebsocketMessageToResponse broadcastReceivedWebsocketMessageToResponse) {
                if (broadcastReceivedWebsocketMessageToResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a received websocket message to all nodes.", (Throwable)broadcastReceivedWebsocketMessageToResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a received websocket message to all nodes. Response: {}", (Object)broadcastReceivedWebsocketMessageToResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to send a broadcast to websocket message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void forwardWebsocketMessageToConnectedServers(String sendFromOpenSearchNode, BroadcastToWebsocketMessage websocketMessage) {
        LOGGER.debug("forwardWebsocketMessageToConnectedServer sendFromOpenSearchNode={}, websocketMessage={}", (Object)sendFromOpenSearchNode, (Object)websocketMessage);
        PlainTextWebsocketMessage websocketMessageToSend = new PlainTextWebsocketMessage(websocketMessage.getMessage());
        this.connections.sendWebsocketMessageToServerUUIDs((WebsocketMessage)websocketMessageToSend, websocketMessage.getReceivers());
    }

    public void queueAsLatestReplicationJobs(String sendFromOpenSearchNode, ReplicationJobs latestJobs) {
        LOGGER.debug("queueAsLatestReplicationJobs sendFromOpenSearchNode={}, latestJobs={}", (Object)sendFromOpenSearchNode, (Object)latestJobs);
        if (latestJobs != null) {
            this.queuedReplicationJobs = latestJobs;
        }
    }

    private void sendReplicationJobsToAllOtherNodes(ReplicationJobs replicationJobs, List<DiscoveryNode> allOtherNodes, final ActionListener<ReplicationJobsSetModelResponse> afterExecution) {
        LOGGER.debug("sendReplicationJobsToAllOtherNodes replicationJobs=..., allOtherNodes=..., afterExecution=...");
        this.client.execute((ActionType)ReplicationJobsSetModelAction.INSTANCE, (ActionRequest)new ReplicationJobsSetModelRequest(this.nodesInfo.getLocalNodeName(), allOtherNodes, replicationJobs), (ActionListener)new ActionListener<ReplicationJobsSetModelResponse>(){

            public void onResponse(ReplicationJobsSetModelResponse replicationJobsSetModelResponse) {
                if (afterExecution != null) {
                    if (replicationJobsSetModelResponse.hasFailures()) {
                        OpenSearchException aggregatedException = replicationJobsSetModelResponse.createAggregatedException();
                        LOGGER.error("Failed to broadcast the replication jobs message to all nodes.", (Throwable)aggregatedException);
                        afterExecution.onFailure((Exception)aggregatedException);
                    } else {
                        afterExecution.onResponse((Object)replicationJobsSetModelResponse);
                    }
                } else if (replicationJobsSetModelResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast the replication jobs message to all nodes.", (Throwable)replicationJobsSetModelResponse.createAggregatedException());
                }
            }

            public void onFailure(Exception ex) {
                if (afterExecution != null) {
                    afterExecution.onFailure(ex);
                } else {
                    LOGGER.error("Failed to broadcast the replication jobs message to all nodes.", (Throwable)ex);
                }
            }
        });
    }

    public void processReceivedReplicationJobs(ReplicationJobs latestJobs, final ActionListener<ReplicationJobsSetResponse> afterExecution) {
        LOGGER.debug("processReceivedReplicationJobs latestJobs={}, afterExecution={}", (Object)latestJobs, afterExecution);
        this.client.execute((ActionType)ReplicationJobsSetAction.INSTANCE, (ActionRequest)new ReplicationJobsSetRequest(this.nodesInfo.getLocalNodeName(), latestJobs), (ActionListener)new ActionListener<ReplicationJobsSetResponse>(){

            public void onResponse(ReplicationJobsSetResponse replicationJobsSetResponse) {
                if (replicationJobsSetResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobsSetResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the replication jobs to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobsSetResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the replication jobs to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void stopReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobStopActions stopActions) {
        LOGGER.debug("stopReplicationJobsOnConnectedServers sendFromOpenSearchNode={}, stopActions={}", (Object)sendFromOpenSearchNode, (Object)stopActions);
        String transactionId = stopActions.getTransactionId();
        for (ReplicationJobStopAction stopAction : stopActions) {
            String replicationJobId = stopAction.getReplicationJobId();
            String serverUUID = stopAction.getServerUUID();
            this.currentReplicationJobs.setReplicationJobStateToStopRequested(replicationJobId);
            ReplicationJobStopActionWebsocketMessage replicationJobStopActionWebsocketMessage = new ReplicationJobStopActionWebsocketMessage(replicationJobId, serverUUID, transactionId);
            LOGGER.info("{}: Sending a websocket message to the BPC server with the UUID '{}' to stop the replication job with the ID '{}'.", (Object)transactionId, (Object)serverUUID, (Object)replicationJobId);
            this.connections.sendWebsocketMessageToServerUUID((WebsocketMessage)replicationJobStopActionWebsocketMessage, serverUUID);
        }
    }

    public void startReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobStartActions startActions) {
        LOGGER.debug("startReplicationJobsOnConnectedServers sendFromOpenSearchNode={}, startActions={}", (Object)sendFromOpenSearchNode, (Object)startActions);
        String transactionId = startActions.getTransactionId();
        for (ReplicationJobStartAction startAction : startActions) {
            String replicationJobId = startAction.getReplicationJobId();
            String serverUUID = startAction.getServerUUID();
            this.currentReplicationJobs.setReplicationJobStateToStartRequested(replicationJobId, serverUUID);
            ReplicationJobStartActionWebsocketMessage replicationJobStartActionWebsocketMessage = new ReplicationJobStartActionWebsocketMessage(replicationJobId, serverUUID, transactionId);
            LOGGER.info("{}: Sending a websocket message to the BPC server with the UUID '{}' to start the replication job with the ID '{}'.", (Object)transactionId, (Object)serverUUID, (Object)replicationJobId);
            this.connections.sendWebsocketMessageToServerUUID((WebsocketMessage)replicationJobStartActionWebsocketMessage, serverUUID);
        }
    }

    public void onForcedStartOfReplicationJobAction(ReplicationJobForcedStartActionDTO forcedStartAction, final ActionListener<ReplicationJobForcedStartResponse> afterExecution) {
        LOGGER.debug("onForcedStartOfReplicationJobAction forcedStartAction={}, afterExecution={}", (Object)forcedStartAction, afterExecution);
        this.client.execute((ActionType)ReplicationJobForcedStartAction.INSTANCE, (ActionRequest)new ReplicationJobForcedStartRequest(this.nodesInfo.getLocalNodeName(), forcedStartAction), (ActionListener)new ActionListener<ReplicationJobForcedStartResponse>(){

            public void onResponse(ReplicationJobForcedStartResponse replicationJobForcedStartResponse) {
                if (replicationJobForcedStartResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobForcedStartResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the forced start of a replication job action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobForcedStartResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the forced start of a replication job action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void forcedStartOfReplicationJobOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobForcedStartActionDTO forcedStartAction) {
        LOGGER.debug("forcedStartOfReplicationJobOnConnectedServers sendFromOpenSearchNode={}, forcedStartAction={}", (Object)sendFromOpenSearchNode, (Object)forcedStartAction);
        ReplicationJobForcedStartWebsocketMessage replicationJobForcedStartWebsocketMessage = new ReplicationJobForcedStartWebsocketMessage(forcedStartAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)replicationJobForcedStartWebsocketMessage, null);
    }

    public void onRestartOfReplicationJobAction(ReplicationJobRestartActionDTO restartAction, final ActionListener<ReplicationJobRestartResponse> afterExecution) {
        LOGGER.debug("onRestartOfReplicationJobAction restartAction={}, afterExecution={}", (Object)restartAction, afterExecution);
        this.client.execute((ActionType)ReplicationJobRestartAction.INSTANCE, (ActionRequest)new ReplicationJobRestartRequest(this.nodesInfo.getLocalNodeName(), restartAction), (ActionListener)new ActionListener<ReplicationJobRestartResponse>(){

            public void onResponse(ReplicationJobRestartResponse replicationJobRestartResponse) {
                if (replicationJobRestartResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobRestartResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the replication job restart action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobRestartResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the replication job restart action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void restartOfReplicationJobOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobRestartActionDTO restartAction) {
        LOGGER.debug("restartOfReplicationJobOnConnectedServers sendFromOpenSearchNode={}, restartAction={}", (Object)sendFromOpenSearchNode, (Object)restartAction);
        ReplicationJobRestartWebsocketMessage replicationJobRestartWebsocketMessage = new ReplicationJobRestartWebsocketMessage(restartAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)replicationJobRestartWebsocketMessage, null);
    }

    public void onRefreshLookupJoinsOfReplicationJobAction(ReplicationJobRefreshLookupJoinsActionDTO refreshLookupJoinsAction, final ActionListener<ReplicationJobRefreshLookupJoinsResponse> afterExecution) {
        LOGGER.debug("onRefreshLookupJoinsOfReplicationJobAction refreshLookupJoinsAction={}, afterExecution={}", (Object)refreshLookupJoinsAction, afterExecution);
        this.client.execute((ActionType)ReplicationJobRefreshLookupJoinsAction.INSTANCE, (ActionRequest)new ReplicationJobRefreshLookupJoinsRequest(this.nodesInfo.getLocalNodeName(), refreshLookupJoinsAction), (ActionListener)new ActionListener<ReplicationJobRefreshLookupJoinsResponse>(){

            public void onResponse(ReplicationJobRefreshLookupJoinsResponse replicationJobRefreshLookupJoinsResponse) {
                if (replicationJobRefreshLookupJoinsResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobRefreshLookupJoinsResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the refresh lookup joins of replication job action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobRefreshLookupJoinsResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the refresh lookup joins of replication job action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void refreshLookupJoinsOfReplicationJobOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobRefreshLookupJoinsActionDTO refreshLookupJoinsAction) {
        LOGGER.debug("restartOfReplicationJobOnConnectedServers sendFromOpenSearchNode={}, refreshLookupJoinsAction={}", (Object)sendFromOpenSearchNode, (Object)refreshLookupJoinsAction);
        RefreshLookupJoinsOfReplicationJobWebsocketMessage refreshLookupJoinsOfReplicationJobWebsocketMessage = new RefreshLookupJoinsOfReplicationJobWebsocketMessage(refreshLookupJoinsAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)refreshLookupJoinsOfReplicationJobWebsocketMessage, null);
    }

    public void onRefreshLookupJoinsOfAllReplicationJobsAction(ReplicationJobsRefreshLookupJoinsActionDTO refreshLookupJoinsAction, final ActionListener<ReplicationJobsRefreshAllLookupJoinsResponse> afterExecution) {
        LOGGER.debug("onRefreshLookupJoinsOfAllReplicationJobsAction refreshLookupJoinsAction={}, afterExecution={}", (Object)refreshLookupJoinsAction, afterExecution);
        this.client.execute((ActionType)ReplicationJobsRefreshAllLookupJoinsAction.INSTANCE, (ActionRequest)new ReplicationJobsRefreshAllLookupJoinsRequest(this.nodesInfo.getLocalNodeName(), refreshLookupJoinsAction), (ActionListener)new ActionListener<ReplicationJobsRefreshAllLookupJoinsResponse>(){

            public void onResponse(ReplicationJobsRefreshAllLookupJoinsResponse replicationJobsRefreshAllLookupJoinsResponse) {
                if (replicationJobsRefreshAllLookupJoinsResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobsRefreshAllLookupJoinsResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the refresh lookup joins of all replication jobs to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobsRefreshAllLookupJoinsResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the refresh lookup joins of all replication jobs to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void refreshLookupJoinsOfAllReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobsRefreshLookupJoinsActionDTO refreshLookupJoinsAction) {
        LOGGER.debug("refreshLookupJoinsOfAllReplicationJobsOnConnectedServers sendFromOpenSearchNode={}, refreshLookupJoinsAction={}", (Object)sendFromOpenSearchNode, (Object)refreshLookupJoinsAction);
        RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage refreshLookupJoinsOfAllReplicationJobsWebsocketMessage = new RefreshLookupJoinsOfAllReplicationJobsWebsocketMessage(refreshLookupJoinsAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)refreshLookupJoinsOfAllReplicationJobsWebsocketMessage, null);
    }

    public void onClearLookupJoinCachesOfReplicationJobsAction(ReplicationJobsClearLookupJoinCachesActionDTO clearLookupJoinCachesAction, final ActionListener<ReplicationJobsClearLookupJoinCachesResponse> afterExecution) {
        LOGGER.debug("onClearLookupJoinCachesOfReplicationJobsAction clearLookupJoinCachesAction={}, afterExecution={}", (Object)clearLookupJoinCachesAction, afterExecution);
        this.client.execute((ActionType)ReplicationJobsClearLookupJoinCachesAction.INSTANCE, (ActionRequest)new ReplicationJobsClearLookupJoinCachesRequest(this.nodesInfo.getLocalNodeName(), clearLookupJoinCachesAction), (ActionListener)new ActionListener<ReplicationJobsClearLookupJoinCachesResponse>(){

            public void onResponse(ReplicationJobsClearLookupJoinCachesResponse replicationJobsClearLookupJoinCachesResponse) {
                if (replicationJobsClearLookupJoinCachesResponse.hasFailures()) {
                    OpenSearchException aggregatedException = replicationJobsClearLookupJoinCachesResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the clear lookup join caches of replication jobs action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)replicationJobsClearLookupJoinCachesResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the clear lookup join caches of replication jobs action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void clearLookupJoinCachesOfReplicationJobsOnConnectedServers(String sendFromOpenSearchNode, ReplicationJobsClearLookupJoinCachesActionDTO clearLookupJoinCachesAction) {
        LOGGER.debug("clearLookupJoinCachesOfReplicationJobsOnConnectedServers sendFromOpenSearchNode={}, clearLookupJoinCachesAction={}", (Object)sendFromOpenSearchNode, (Object)clearLookupJoinCachesAction);
        ClearLookupJoinCachesOfReplicationJobsWebsocketMessage clearLookupJoinCachesOfReplicationJobsWebsocketMessage = new ClearLookupJoinCachesOfReplicationJobsWebsocketMessage(clearLookupJoinCachesAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)clearLookupJoinCachesOfReplicationJobsWebsocketMessage, null);
    }

    public void processReceivedWebsocketMessage(ReplicationJobStopAcknowledgementWebsocketMessage jobStoppedWebsocketMessage) {
        LOGGER.debug("processReceivedWebsocketMessage jobStoppedWebsocketMessage={}", (Object)jobStoppedWebsocketMessage);
        if (jobStoppedWebsocketMessage != null) {
            LOGGER.info("{}: Received a acknowledgement websocket message from the BPC server with the UUID '{}' that the replication job with the ID '{}' has been stopped.", (Object)jobStoppedWebsocketMessage.getTransactionId(), (Object)jobStoppedWebsocketMessage.getServerUUID(), (Object)jobStoppedWebsocketMessage.getJobId());
            ReplicationJobActionAcknowledgementDTO replicationJobActionAcknowledgement = new ReplicationJobActionAcknowledgementDTO(jobStoppedWebsocketMessage.getJobId(), jobStoppedWebsocketMessage.getServerUUID(), ReplicationJobActionAcknowledgementDTO.ReplicationJobAction.STOP, jobStoppedWebsocketMessage.getTransactionId(), jobStoppedWebsocketMessage.getSendedAtInUtc());
            this.informAllNodesAboutReplicationJobActionAcknowledgement(replicationJobActionAcknowledgement);
        }
    }

    public void processReceivedWebsocketMessage(ReplicationJobStartAcknowledgementWebsocketMessage jobStartedWebsocketMessage) {
        LOGGER.debug("processReceivedWebsocketMessage jobStartedWebsocketMessage={}", (Object)jobStartedWebsocketMessage);
        if (jobStartedWebsocketMessage != null) {
            LOGGER.info("{}: Received a acknowledgement websocket message from the BPC server with the UUID '{}' that the replication job with the ID '{}' has been started.", (Object)jobStartedWebsocketMessage.getTransactionId(), (Object)jobStartedWebsocketMessage.getServerUUID(), (Object)jobStartedWebsocketMessage.getJobId());
            ReplicationJobActionAcknowledgementDTO replicationJobActionAcknowledgement = new ReplicationJobActionAcknowledgementDTO(jobStartedWebsocketMessage.getJobId(), jobStartedWebsocketMessage.getServerUUID(), ReplicationJobActionAcknowledgementDTO.ReplicationJobAction.START, jobStartedWebsocketMessage.getTransactionId(), jobStartedWebsocketMessage.getSendedAtInUtc());
            this.informAllNodesAboutReplicationJobActionAcknowledgement(replicationJobActionAcknowledgement);
        }
    }

    public void processReceivedWebsocketMessage(ReplicationJobForcedStartAcknowledgementWebsocketMessage jobForcedStartedWebsocketMessage) {
        LOGGER.debug("processReceivedWebsocketMessage jobForcedStartedWebsocketMessage={}", (Object)jobForcedStartedWebsocketMessage);
        if (jobForcedStartedWebsocketMessage != null) {
            LOGGER.info("{}: Received a acknowledgement websocket message from the BPC server with the UUID '{}' that the replication job with the ID '{}' has been forced started.", (Object)jobForcedStartedWebsocketMessage.getTransactionId(), (Object)jobForcedStartedWebsocketMessage.getServerUUID(), (Object)jobForcedStartedWebsocketMessage.getJobId());
            ReplicationJobActionAcknowledgementDTO replicationJobActionAcknowledgement = new ReplicationJobActionAcknowledgementDTO(jobForcedStartedWebsocketMessage.getJobId(), jobForcedStartedWebsocketMessage.getServerUUID(), ReplicationJobActionAcknowledgementDTO.ReplicationJobAction.FORCED_START, jobForcedStartedWebsocketMessage.getTransactionId(), jobForcedStartedWebsocketMessage.getSendedAtInUtc());
            this.informAllNodesAboutReplicationJobActionAcknowledgement(replicationJobActionAcknowledgement);
        }
    }

    public void processReceivedWebsocketMessage(ReplicationJobRestartAcknowledgementWebsocketMessage jobRestartedWebsocketMessage) {
        LOGGER.debug("processReceivedWebsocketMessage jobRestartedWebsocketMessage={}", (Object)jobRestartedWebsocketMessage);
        if (jobRestartedWebsocketMessage != null) {
            LOGGER.info("{}: Received a acknowledgement websocket message from the BPC server with the UUID '{}' that the replication job with the ID '{}' has been re-started.", (Object)jobRestartedWebsocketMessage.getTransactionId(), (Object)jobRestartedWebsocketMessage.getServerUUID(), (Object)jobRestartedWebsocketMessage.getJobId());
            ReplicationJobActionAcknowledgementDTO replicationJobActionAcknowledgement = new ReplicationJobActionAcknowledgementDTO(jobRestartedWebsocketMessage.getJobId(), jobRestartedWebsocketMessage.getServerUUID(), ReplicationJobActionAcknowledgementDTO.ReplicationJobAction.RESTART, jobRestartedWebsocketMessage.getTransactionId(), jobRestartedWebsocketMessage.getSendedAtInUtc());
            this.informAllNodesAboutReplicationJobActionAcknowledgement(replicationJobActionAcknowledgement);
        }
    }

    private void informAllNodesAboutReplicationJobActionAcknowledgement(ReplicationJobActionAcknowledgementDTO replicationJobActionAcknowledgement) {
        LOGGER.debug("informAllNodesAboutReplicationJobActionAcknowledgement replicationJobActionAcknowledgement={}", (Object)replicationJobActionAcknowledgement);
        this.client.execute((ActionType)ReplicationJobActionAcknowledgedAction.INSTANCE, (ActionRequest)new ReplicationJobActionAcknowledgedRequest(this.nodesInfo.getLocalNodeName(), replicationJobActionAcknowledgement), (ActionListener)new ActionListener<ReplicationJobActionAcknowledgedResponse>(){

            public void onResponse(ReplicationJobActionAcknowledgedResponse replicationJobActionAcknowledgedResponse) {
                if (replicationJobActionAcknowledgedResponse.hasFailures()) {
                    LOGGER.error("Failed to broadcast a replication job action acknowledged message to all nodes.", (Throwable)replicationJobActionAcknowledgedResponse.createAggregatedException());
                } else {
                    LOGGER.debug("Done broadcasting a replication job action acknowledged message to all nodes. Response: {}", (Object)replicationJobActionAcknowledgedResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast a replication job action acknowledged message to all nodes.", (Throwable)ex);
            }
        });
    }

    public void processReplicationJobActionAcknowledgement(String sendFromOpenSearchNode, ReplicationJobActionAcknowledgementDTO replicationJobActionAcknowledgement) {
        LOGGER.debug("processReplicationJobActionAcknowledgement sendFromOpenSearchNode={}, replicationJobActionAcknowledgement={}", (Object)sendFromOpenSearchNode, (Object)replicationJobActionAcknowledgement);
        this.nodesInfo.ifThisNodeIsTheMasterNodeOrElse(() -> this._processReplicationJobActionAcknowledgement(sendFromOpenSearchNode, replicationJobActionAcknowledgement), () -> LOGGER.debug("Skipping, the received replication job action acknowledgements must be processed on the master node only."));
    }

    public void _processReplicationJobActionAcknowledgement(String sendFromOpenSearchNode, ReplicationJobActionAcknowledgementDTO replicationJobActionAcknowledgement) {
        LOGGER.debug("_processReplicationJobActionAcknowledgement sendFromOpenSearchNode={}, replicationJobActionAcknowledgement={}", (Object)sendFromOpenSearchNode, (Object)replicationJobActionAcknowledgement);
        if (replicationJobActionAcknowledgement != null) {
            String replicationJobId = replicationJobActionAcknowledgement.getReplicationJobId();
            String acknowledgedOnServerUUID = replicationJobActionAcknowledgement.getAcknowledgedOnServerUUID();
            ReplicationJobActionAcknowledgementDTO.ReplicationJobAction action = replicationJobActionAcknowledgement.getAction();
            String transactionId = replicationJobActionAcknowledgement.getTransactionId();
            if (action == ReplicationJobActionAcknowledgementDTO.ReplicationJobAction.STOP) {
                this.currentReplicationJobs.setReplicationJobStateToStopped(replicationJobId, acknowledgedOnServerUUID);
            }
            if (action == ReplicationJobActionAcknowledgementDTO.ReplicationJobAction.START) {
                this.currentReplicationJobs.setReplicationJobStateToStarted(replicationJobId, acknowledgedOnServerUUID);
            }
        }
    }

    public ReplicationJobsWithRuntimeStatsFromAllServersDTO getReplicationJobStatsFromConnectedServers(String sendFromOpenSearchNode, ReplicationJobStatsGetActionDTO replicationJobStatsGetAction) {
        LOGGER.debug("getReplicationJobStatsFromConnectedServers sendFromOpenSearchNode={}, replicationJobStatsGetAction={}", (Object)sendFromOpenSearchNode, (Object)replicationJobStatsGetAction);
        final String communicationId = replicationJobStatsGetAction.getCommunicationId();
        ReplicationJobStatsRequestWebsocketMessage requestWebsocketMessage = new ReplicationJobStatsRequestWebsocketMessage(communicationId);
        try {
            this.connections.sendWebsocketMessage((WebsocketMessage)requestWebsocketMessage, null, new BpcConnections.PreSendWebsocketMessagesCallback(){

                @Override
                public void goingToSendNumberOfWebsocketMessages(int numberOfWebsocketMessages) {
                    Manager.this.replicationJobStatsRequestsCoordinator.prepareFor(communicationId, numberOfWebsocketMessages);
                }
            }, new BpcConnections.PostSendWebsocketMessagesCallback(){

                @Override
                public void websocketMessagesSent(int successful, int failed) {
                    Manager.this.replicationJobStatsRequestsCoordinator.updateForSentWebsocketMessages(communicationId, successful, failed);
                }
            });
            this.replicationJobStatsRequestsCoordinator.await(communicationId);
            List<ReplicationJobsWithRuntimeStatsFromServerDTO> replicationJobStatsAsList = this.replicationJobStatsRequestsCoordinator.getAndRemove(communicationId);
            ReplicationJobsWithRuntimeStatsFromAllServersDTO replicationJobStatsFromAllConnectedServers = new ReplicationJobsWithRuntimeStatsFromAllServersDTO();
            for (ReplicationJobsWithRuntimeStatsFromServerDTO replicationJobsWithRuntimeStatsFromServerDTO : replicationJobStatsAsList) {
                replicationJobStatsFromAllConnectedServers.add(replicationJobsWithRuntimeStatsFromServerDTO);
            }
            return replicationJobStatsFromAllConnectedServers;
        }
        catch (Exception ex) {
            this.replicationJobStatsRequestsCoordinator.remove(communicationId);
            throw new OpenSearchException((Throwable)ex);
        }
    }

    public void processReceivedReplicationJobStatsResponseWebsocketMessage(ReplicationJobStatsResponseWebsocketMessage replicationJobStatsResponseWebsocketMessage) {
        LOGGER.debug("processReceivedReplicationJobStatsResponseWebsocketMessage replicationJobStatsResponseWebsocketMessage={}", (Object)replicationJobStatsResponseWebsocketMessage);
        if (replicationJobStatsResponseWebsocketMessage != null) {
            this.replicationJobStatsRequestsCoordinator.handleReceivedDTO(replicationJobStatsResponseWebsocketMessage.getCommunicationId(), replicationJobStatsResponseWebsocketMessage.getReplicationJobStats());
        }
    }

    public BackupJobInfosDTO getBackupJobInfosFromConnectedMasterServer(String sendFromOpenSearchNode, BackupJobInfosGetActionDTO backupJobInfosGetAction) {
        LOGGER.debug("getBackupJobInfosFromConnectedMasterServer sendFromOpenSearchNode={}, backupJobInfosGetAction={}", (Object)sendFromOpenSearchNode, (Object)backupJobInfosGetAction);
        final String communicationId = backupJobInfosGetAction.getCommunicationId();
        BackupJobInfosRequestWebsocketMessage requestWebsocketMessage = new BackupJobInfosRequestWebsocketMessage(communicationId);
        try {
            this.connections.sendWebsocketMessage((WebsocketMessage)requestWebsocketMessage, null, new BpcConnections.PreSendWebsocketMessagesCallback(){

                @Override
                public void goingToSendNumberOfWebsocketMessages(int numberOfWebsocketMessages) {
                    Manager.this.backupJobInfosRequestsCoordinator.prepareFor(communicationId, numberOfWebsocketMessages);
                }
            }, new BpcConnections.PostSendWebsocketMessagesCallback(){

                @Override
                public void websocketMessagesSent(int successful, int failed) {
                    Manager.this.backupJobInfosRequestsCoordinator.updateForSentWebsocketMessages(communicationId, successful, failed);
                }
            });
            this.backupJobInfosRequestsCoordinator.await(communicationId);
            List<BackupJobInfosDTO> receivedBackupJobInfos = this.backupJobInfosRequestsCoordinator.getAndRemove(communicationId);
            if (receivedBackupJobInfos != null && !receivedBackupJobInfos.isEmpty()) {
                return receivedBackupJobInfos.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            this.backupJobInfosRequestsCoordinator.remove(communicationId);
            throw new OpenSearchException((Throwable)ex);
        }
    }

    public void processReceivedBackupJobInfosResponseWebsocketMessage(BackupJobInfosResponseWebsocketMessage backupJobInfosResponseWebsocketMessage) {
        LOGGER.debug("processReceivedBackupJobInfosResponseWebsocketMessage backupJobInfosResponseWebsocketMessage={}", (Object)backupJobInfosResponseWebsocketMessage);
        if (backupJobInfosResponseWebsocketMessage != null) {
            this.backupJobInfosRequestsCoordinator.handleReceivedDTO(backupJobInfosResponseWebsocketMessage.getCommunicationId(), backupJobInfosResponseWebsocketMessage.getBackupJobInfos());
        }
    }

    public void onBackupJobDeleteAction(BackupJobDeleteActionDTO deleteAction, final ActionListener<BackupJobDeleteResponse> afterExecution) {
        LOGGER.debug("onBackupJobDeleteAction deleteAction={}, afterExecution={}", (Object)deleteAction, afterExecution);
        this.client.execute((ActionType)BackupJobDeleteAction.INSTANCE, (ActionRequest)new BackupJobDeleteRequest(this.nodesInfo.getLocalNodeName(), deleteAction), (ActionListener)new ActionListener<BackupJobDeleteResponse>(){

            public void onResponse(BackupJobDeleteResponse backupJobDeleteResponse) {
                if (backupJobDeleteResponse.hasFailures()) {
                    OpenSearchException aggregatedException = backupJobDeleteResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the delete a backup job action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)backupJobDeleteResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the delete a backup job action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void deleteBackupJobOnBpcMasterServer(String sendFromOpenSearchNode, BackupJobDeleteActionDTO deleteAction) {
        LOGGER.debug("deleteBackupJobOnBpcMasterServer sendFromOpenSearchNode={}, deleteAction={}", (Object)sendFromOpenSearchNode, (Object)deleteAction);
        BackupJobDeleteWebsocketMessage backupJobDeleteWebsocketMessage = new BackupJobDeleteWebsocketMessage(deleteAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)backupJobDeleteWebsocketMessage, null);
    }

    public BackupSnapshotInfoDTO startBackupJobOnConnectedBpcMasterServer(String sendFromOpenSearchNode, BackupJobStartActionDTO backupJobStartAction) {
        LOGGER.debug("startBackupJobOnConnectedBpcMasterServer sendFromOpenSearchNode={}, backupJobStartAction={}", (Object)sendFromOpenSearchNode, (Object)backupJobStartAction);
        final String communicationId = backupJobStartAction.getCommunicationId();
        BackupJobStartWebsocketMessage backupJobStartWebsocketMessage = new BackupJobStartWebsocketMessage(communicationId, backupJobStartAction);
        try {
            this.connections.sendWebsocketMessage((WebsocketMessage)backupJobStartWebsocketMessage, null, new BpcConnections.PreSendWebsocketMessagesCallback(){

                @Override
                public void goingToSendNumberOfWebsocketMessages(int numberOfWebsocketMessages) {
                    Manager.this.backupJobStartRequestsCoordinator.prepareFor(communicationId, numberOfWebsocketMessages);
                }
            }, new BpcConnections.PostSendWebsocketMessagesCallback(){

                @Override
                public void websocketMessagesSent(int successful, int failed) {
                    Manager.this.backupJobStartRequestsCoordinator.updateForSentWebsocketMessages(communicationId, successful, failed);
                }
            });
            this.backupJobStartRequestsCoordinator.await(communicationId);
            List<BackupSnapshotInfoDTO> receivedBackupSnapshotInfos = this.backupJobStartRequestsCoordinator.getAndRemove(communicationId);
            if (receivedBackupSnapshotInfos != null && !receivedBackupSnapshotInfos.isEmpty()) {
                return receivedBackupSnapshotInfos.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            this.backupJobStartRequestsCoordinator.remove(communicationId);
            throw new OpenSearchException((Throwable)ex);
        }
    }

    public void processReceivedBackupSnapshotCreatedInfoWebsocketMessage(BackupSnapshotCreatedInfoWebsocketMessage backupSnapshotCreatedInfoWebsocketMessage) {
        LOGGER.debug("processReceivedBackupSnapshotCreatedInfoWebsocketMessage backupSnapshotCreatedInfoWebsocketMessage={}", (Object)backupSnapshotCreatedInfoWebsocketMessage);
        if (backupSnapshotCreatedInfoWebsocketMessage != null) {
            this.backupJobStartRequestsCoordinator.handleReceivedDTO(backupSnapshotCreatedInfoWebsocketMessage.getCommunicationId(), backupSnapshotCreatedInfoWebsocketMessage.getBackupSnapshotInfo());
        }
    }

    public void onBackupJobScheduleAction(BackupJobScheduleActionDTO scheduleAction, final ActionListener<BackupJobScheduleResponse> afterExecution) {
        LOGGER.debug("onBackupJobScheduleAction scheduleAction={}, afterExecution={}", (Object)scheduleAction, afterExecution);
        this.client.execute((ActionType)BackupJobScheduleAction.INSTANCE, (ActionRequest)new BackupJobScheduleRequest(this.nodesInfo.getLocalNodeName(), scheduleAction), (ActionListener)new ActionListener<BackupJobScheduleResponse>(){

            public void onResponse(BackupJobScheduleResponse backupJobScheduleResponse) {
                if (backupJobScheduleResponse.hasFailures()) {
                    OpenSearchException aggregatedException = backupJobScheduleResponse.createAggregatedException();
                    LOGGER.error("Failed to broadcast the schedule a backup job action to all nodes.", (Throwable)aggregatedException);
                    afterExecution.onFailure((Exception)aggregatedException);
                } else {
                    afterExecution.onResponse((Object)backupJobScheduleResponse);
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to broadcast the delete a backup job action to all nodes.", (Throwable)ex);
                afterExecution.onFailure(ex);
            }
        });
    }

    public void scheduleBackupJobOnBpcMasterServer(String sendFromOpenSearchNode, BackupJobScheduleActionDTO scheduleAction) {
        LOGGER.debug("scheduleBackupJobOnBpcMasterServer sendFromOpenSearchNode={}, scheduleAction={}", (Object)sendFromOpenSearchNode, (Object)scheduleAction);
        BackupJobScheduleWebsocketMessage backupJobScheduleWebsocketMessage = new BackupJobScheduleWebsocketMessage(scheduleAction);
        this.connections.sendWebsocketMessage((WebsocketMessage)backupJobScheduleWebsocketMessage, null);
    }

    private class ReplicationJobsOrchestrationCheckerRunnable
    implements Runnable {
        private final Logger LOGGER = Loggers.getLogger(ReplicationJobsOrchestrationCheckerRunnable.class, (String[])new String[]{"os-bpc-plugin"});

        private ReplicationJobsOrchestrationCheckerRunnable() {
        }

        @Override
        public void run() {
            this.LOGGER.debug("Running ...");
            if (!Manager.this.connections.hasEntries()) {
                if (!Manager.this.currentReplicationJobs.isEmpty()) {
                    Manager.this.currentReplicationJobs.clear();
                    Manager.this.connectionsLastUpdatedProcessedByChecker = -1L;
                    Manager.this.queuedReplicationJobs = null;
                    this.LOGGER.debug("Nothing to do ... there are no BPC connections (cleared the replication jobs)");
                } else {
                    this.LOGGER.debug("Nothing to do ... there are no BPC connections");
                }
                return;
            }
            Manager.this.nodesInfo.ifThisNodeIsTheMasterNodeOrElse(() -> {
                this.doTheOrchestration(true);
                this.transferReplicationJobsToOtherNodes(true);
            }, () -> this.LOGGER.debug("Nothing to do ... only the master node runs the replication jobs orchestration"));
        }

        private void transferReplicationJobsToOtherNodes(boolean thisIsTheMasterNode) {
            this.LOGGER.debug("transferReplicationJobsToOtherNodes thisIsTheMasterNode={}", (Object)thisIsTheMasterNode);
            if (!thisIsTheMasterNode) {
                this.LOGGER.debug("Nothing to do ... only the master node sends the replication jobs to all other nodes");
                return;
            }
            if (Manager.this.transferReplicationJobsToOtherNodesRunning) {
                this.LOGGER.debug("Nothing to do ... a replication jobs transfer is already running");
            } else {
                Manager.this.transferReplicationJobsToOtherNodesRunning = true;
                List<DiscoveryNode> allOtherNodes = Manager.this.nodesInfo.getAllOtherNodes();
                if (allOtherNodes == null || allOtherNodes.isEmpty()) {
                    this.LOGGER.debug("Nothing to do ... there are no other nodes beside the master node to send the replication jobs to");
                    Manager.this.transferReplicationJobsToOtherNodesRunning = false;
                    return;
                }
                final long replicationJobsLastModifiedTimestamp = Manager.this.currentReplicationJobs.getLastModifiedTimestamp();
                if (Manager.this.replicationJobsTransferredTimestamp == replicationJobsLastModifiedTimestamp) {
                    this.LOGGER.debug("Nothing to do ... the replication jobs are not modified");
                    Manager.this.transferReplicationJobsToOtherNodesRunning = false;
                    return;
                }
                List<ReplicationJob> replicationJobsWithTemporaryState = Manager.this.currentReplicationJobs.getReplicationJobsByStates(List.of(ReplicationJob.State.STARTING, ReplicationJob.State.STOPPING));
                if (!replicationJobsWithTemporaryState.isEmpty()) {
                    this.LOGGER.debug("Nothing to do ... there are still some replication jobs with a temporary state like STARTING and STOPPING");
                    Manager.this.transferReplicationJobsToOtherNodesRunning = false;
                    return;
                }
                Manager.this.sendReplicationJobsToAllOtherNodes(Manager.this.currentReplicationJobs, allOtherNodes, new ActionListener<ReplicationJobsSetModelResponse>(){

                    public void onResponse(ReplicationJobsSetModelResponse replicationJobsSetModelResponse) {
                        if (replicationJobsSetModelResponse.hasFailures()) {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication jobs to all nodes.", (Throwable)replicationJobsSetModelResponse.createAggregatedException());
                        } else {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.debug("Done broadcasting the replication jobs to all nodes. Response: {}", (Object)replicationJobsSetModelResponse);
                            Manager.this.replicationJobsTransferredTimestamp = replicationJobsLastModifiedTimestamp;
                        }
                        Manager.this.transferReplicationJobsToOtherNodesRunning = false;
                    }

                    public void onFailure(Exception ex) {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to send the replication jobs to all nodes.", (Throwable)ex);
                        Manager.this.transferReplicationJobsToOtherNodesRunning = false;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTheOrchestration(boolean thisIsTheMasterNode) {
            this.LOGGER.debug("doTheOrchestration thisIsTheMasterNode={}", (Object)thisIsTheMasterNode);
            if (Manager.this.replicationJobsOrchestrationRunning) {
                this.LOGGER.debug("Nothing to do ... an replication jobs orchestration is already running");
            } else {
                Manager.this.replicationJobsOrchestrationRunning = true;
                try {
                    if (Manager.this.queuedReplicationJobs != null) {
                        ReplicationJobs replicationJobsToProcess = Manager.this.queuedReplicationJobs;
                        Manager.this.queuedReplicationJobs = null;
                        this.processReplicationJobs(replicationJobsToProcess, thisIsTheMasterNode);
                    } else {
                        long connectionsLastUpdated = Manager.this.connections.getLastUpdated();
                        if (connectionsLastUpdated == -1L) {
                            this.LOGGER.debug("Nothing to do ... the BPC connections are not initialized yet");
                            return;
                        }
                        if (connectionsLastUpdated == Manager.this.connectionsLastUpdatedProcessedByChecker) {
                            this.LOGGER.debug("Nothing to do ... the BPC connections are already processed");
                            return;
                        }
                        long millisecondsPassedSinceLastConnectionUpdate = System.currentTimeMillis() - connectionsLastUpdated;
                        if (millisecondsPassedSinceLastConnectionUpdate < 15000L) {
                            this.LOGGER.debug("Nothing to do ... it is too early to run an replication jobs orchestration. Gets done in {} seconds.", (Object)((15000L - millisecondsPassedSinceLastConnectionUpdate) / 1000L));
                            return;
                        }
                        this.redistributeReplicationJobsOnChangedConnections(thisIsTheMasterNode);
                        Manager.this.connectionsLastUpdatedProcessedByChecker = connectionsLastUpdated;
                    }
                }
                catch (Throwable t) {
                    this.LOGGER.error("Failed to perform the replication jobs orchestration check.", t);
                }
                finally {
                    Manager.this.replicationJobsOrchestrationRunning = false;
                }
            }
        }

        private void redistributeReplicationJobsOnChangedConnections(boolean thisIsTheMasterNode) {
            this.LOGGER.debug("redistributeReplicationJobsOnChangedConnections thisIsTheMasterNode={}", (Object)thisIsTheMasterNode);
            if (!thisIsTheMasterNode) {
                return;
            }
            Set<String> connectedServers = Manager.this.connections.getUUIDsOfServers();
            final Set<String> serversThatCanBeUsed = Manager.this.connections.getUUIDsOfServersThatCanBeUsedForReplication();
            final ReplicationJobsOrchestrator orchestrator = new ReplicationJobsOrchestrator(Manager.this.currentReplicationJobs);
            orchestrator.updateStateOfReplicationJobsOfNoLongerConnectedServers(connectedServers);
            if (orchestrator.areJobsEquallyDistributed(serversThatCanBeUsed)) {
                this.LOGGER.debug("Nothing to do ... the replication jobs are already equally distributed.");
                return;
            }
            this.LOGGER.info("{}: Orchestrator starts to redistribute replication jobs due to changed connections.", (Object)orchestrator.getTransactionId());
            final ReplicationJobStopActions stopActions = orchestrator.getReplicationJobStopActions(serversThatCanBeUsed);
            Manager.this.client.execute((ActionType)ReplicationJobStopActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStopActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), stopActions), (ActionListener)new ActionListener<ReplicationJobStopActionsResponse>(){

                public void onResponse(ReplicationJobStopActionsResponse replicationJobStopActionsResponse) {
                    if (replicationJobStopActionsResponse.hasFailures()) {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)replicationJobStopActionsResponse.createAggregatedException());
                    } else {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.debug("Done broadcasting the replication job stop actions to all nodes. Response: {}", (Object)replicationJobStopActionsResponse);
                    }
                    Manager.this.currentReplicationJobs.updateWithStopActions(stopActions);
                    final ReplicationJobStartActions startActions = orchestrator.getReplicationJobStartActions(serversThatCanBeUsed);
                    Manager.this.client.execute((ActionType)ReplicationJobStartActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStartActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), startActions), (ActionListener)new ActionListener<ReplicationJobStartActionsResponse>(){

                        public void onResponse(ReplicationJobStartActionsResponse replicationJobStartActionsResponse) {
                            if (replicationJobStartActionsResponse.hasFailures()) {
                                ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)replicationJobStartActionsResponse.createAggregatedException());
                            } else {
                                ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.debug("Done broadcasting the replication job start actions to all nodes. Response: {}", (Object)replicationJobStartActionsResponse);
                            }
                            Manager.this.currentReplicationJobs.updateWithStartActions(startActions);
                        }

                        public void onFailure(Exception ex) {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)ex);
                        }
                    });
                }

                public void onFailure(Exception ex) {
                    ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)ex);
                }
            });
        }

        private void processReplicationJobs(final ReplicationJobs latestJobs, boolean thisIsTheMasterNode) {
            this.LOGGER.debug("processReplicationJobs latestJobs={}, thisIsTheMasterNode={}", (Object)latestJobs, (Object)thisIsTheMasterNode);
            if (!thisIsTheMasterNode) {
                return;
            }
            Set<String> connectedServers = Manager.this.connections.getUUIDsOfServers();
            final Set<String> serversThatCanBeUsed = Manager.this.connections.getUUIDsOfServersThatCanBeUsedForReplication();
            final ReplicationJobsOrchestrator orchestrator = new ReplicationJobsOrchestrator(Manager.this.currentReplicationJobs);
            this.LOGGER.info("{}: Orchestrator starts to redistribute replication jobs.", (Object)orchestrator.getTransactionId());
            orchestrator.updateStateOfReplicationJobsOfNoLongerConnectedServers(connectedServers);
            final ReplicationJobStopActions stopActions = orchestrator.getReplicationJobStopActions(latestJobs, serversThatCanBeUsed);
            Manager.this.client.execute((ActionType)ReplicationJobStopActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStopActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), stopActions), (ActionListener)new ActionListener<ReplicationJobStopActionsResponse>(){

                public void onResponse(ReplicationJobStopActionsResponse replicationJobStopActionsResponse) {
                    if (replicationJobStopActionsResponse.hasFailures()) {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)replicationJobStopActionsResponse.createAggregatedException());
                    } else {
                        ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.debug("Done broadcasting the replication job stop actions to all nodes. Response: {}", (Object)replicationJobStopActionsResponse);
                    }
                    Manager.this.currentReplicationJobs.updateWithStopActions(stopActions);
                    Manager.this.currentReplicationJobs.updateWithLatestJobs(latestJobs);
                    final ReplicationJobStartActions startActions = orchestrator.getReplicationJobStartActions(latestJobs, serversThatCanBeUsed);
                    Manager.this.client.execute((ActionType)ReplicationJobStartActionsAction.INSTANCE, (ActionRequest)new ReplicationJobStartActionsRequest(Manager.this.nodesInfo.getLocalNodeName(), startActions), (ActionListener)new ActionListener<ReplicationJobStartActionsResponse>(){

                        public void onResponse(ReplicationJobStartActionsResponse replicationJobStartActionsResponse) {
                            if (replicationJobStartActionsResponse.hasFailures()) {
                                ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)replicationJobStartActionsResponse.createAggregatedException());
                            } else {
                                ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.debug("Done broadcasting the replication job start actions to all nodes. Response: {}", (Object)replicationJobStartActionsResponse);
                            }
                            Manager.this.currentReplicationJobs.updateWithStartActions(startActions);
                            Manager.this.currentReplicationJobs.updateWithLatestJobs(latestJobs);
                        }

                        public void onFailure(Exception ex) {
                            ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job start actions to all nodes.", (Throwable)ex);
                        }
                    });
                }

                public void onFailure(Exception ex) {
                    ReplicationJobsOrchestrationCheckerRunnable.this.LOGGER.error("Failed to broadcast the replication job stop actions to all nodes.", (Throwable)ex);
                }
            });
        }
    }
}

