/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.ingest;

import java.util.Map;
import org.opensearch.action.ingest.SimulateExecutionService;
import org.opensearch.action.ingest.SimulatePipelineRequest;
import org.opensearch.action.ingest.SimulatePipelineResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ingest.IngestService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class SimulatePipelineTransportAction
extends HandledTransportAction<SimulatePipelineRequest, SimulatePipelineResponse> {
    private final IngestService ingestService;
    private final SimulateExecutionService executionService;

    @Inject
    public SimulatePipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IngestService ingestService) {
        super("cluster:admin/ingest/pipeline/simulate", transportService, actionFilters, SimulatePipelineRequest::new);
        this.ingestService = ingestService;
        this.executionService = new SimulateExecutionService(threadPool, ingestService);
    }

    @Override
    protected void doExecute(Task task, SimulatePipelineRequest request, ActionListener<SimulatePipelineResponse> listener) {
        SimulatePipelineRequest.Parsed simulateRequest;
        Map source = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        try {
            simulateRequest = request.getId() != null ? SimulatePipelineRequest.parseWithPipelineId(request.getId(), source, request.isVerbose(), this.ingestService) : SimulatePipelineRequest.parse(source, request.isVerbose(), this.ingestService);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.executionService.execute(simulateRequest, listener);
    }
}

