/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ReplicationJobActionAcknowledgementDTO
implements OpenSearchPluginDTO {
    private final String replicationJobId;
    private final String acknowledgedOnServerUUID;
    private final ReplicationJobAction action;
    private final String transactionId;
    private final Instant timestampInUtc;

    public ReplicationJobActionAcknowledgementDTO(String replicationJobId, String acknowledgedOnServerUUID, ReplicationJobAction action, String transactionId, Instant timestampInUtc) {
        if (StringUtil.isNullOrEmpty((String)replicationJobId)) {
            throw new NullPointerException("'replicationJobId' must not be null or empty");
        }
        if (StringUtil.isNullOrEmpty((String)acknowledgedOnServerUUID)) {
            throw new NullPointerException("'acknowledgedOnServerUUID' must not be null or empty");
        }
        if (action == null) {
            throw new NullPointerException("'action' must not be null");
        }
        if (timestampInUtc == null) {
            throw new NullPointerException("'timestampInUtc' must not be null");
        }
        this.replicationJobId = replicationJobId;
        this.acknowledgedOnServerUUID = acknowledgedOnServerUUID;
        this.action = action;
        this.transactionId = transactionId;
        this.timestampInUtc = timestampInUtc;
    }

    public ReplicationJobActionAcknowledgementDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"replicationJobId", null), MapUtil.getValueAsString(actionMap, (String)"acknowledgedOnServerUUID", null), ReplicationJobAction.valueOf(MapUtil.getValueAsString(actionMap, (String)"action", null)), MapUtil.getValueAsString(actionMap, (String)"transactionId", null), MapUtil.getValueAsInstant(actionMap, (String)"timestamp", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(actionMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> actionMap) {
        MapUtil.checkForWellKnownKeys(actionMap, Set.of("replicationJobId", "acknowledgedOnServerUUID", "action", "transactionId", "timestamp"));
    }

    public ReplicationJobActionAcknowledgementDTO(StreamInput in) throws IOException {
        this.replicationJobId = in.readString();
        this.acknowledgedOnServerUUID = in.readString();
        this.action = (ReplicationJobAction)in.readEnum(ReplicationJobAction.class);
        this.transactionId = in.readOptionalString();
        this.timestampInUtc = in.readInstant();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.replicationJobId);
        out.writeString(this.acknowledgedOnServerUUID);
        out.writeEnum((Enum)this.action);
        out.writeOptionalString(this.transactionId);
        out.writeInstant(this.timestampInUtc);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("replicationJobId", this.replicationJobId);
        builder.field("acknowledgedOnServerUUID", this.acknowledgedOnServerUUID);
        builder.field("action", this.action.name());
        builder.field("transactionId", this.transactionId);
        builder.field("timestamp", TimestampUtil.formatAsIsoInstantString((Instant)this.timestampInUtc));
        builder.endObject();
        return builder;
    }

    public static ReplicationJobActionAcknowledgementDTO fromXContent(XContentParser parser) throws IOException {
        return new ReplicationJobActionAcknowledgementDTO(parser.map());
    }

    public String getReplicationJobId() {
        return this.replicationJobId;
    }

    public String getAcknowledgedOnServerUUID() {
        return this.acknowledgedOnServerUUID;
    }

    public ReplicationJobAction getAction() {
        return this.action;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Instant getTimestampInUtc() {
        return this.timestampInUtc;
    }

    public LocalDateTime getTimestampInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.timestampInUtc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobActionAcknowledgementDTO that = (ReplicationJobActionAcknowledgementDTO)o;
        return Objects.equals(this.replicationJobId, that.replicationJobId) && Objects.equals(this.acknowledgedOnServerUUID, that.acknowledgedOnServerUUID) && this.action == that.action && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.timestampInUtc, that.timestampInUtc);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.replicationJobId, this.acknowledgedOnServerUUID, this.action, this.transactionId, this.timestampInUtc});
    }

    public String toString() {
        return "ReplicationJobActionAcknowledgementDTO{replicationJobId='" + this.replicationJobId + "', acknowledgedOnServerUUID='" + this.acknowledgedOnServerUUID + "', action=" + this.action + ", transactionId='" + this.transactionId + "', timestampInUtc=" + this.timestampInUtc + "}";
    }

    public static enum ReplicationJobAction {
        START,
        STOP,
        FORCED_START,
        RESTART;

    }
}

