/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.bundle.watchdog;

import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.Dictionary;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class Watchdog {
    private static final Logger LOGGER = LogManager.getLogger(Watchdog.class);
    private static final String PID = "de.virtimo.bpc.core.watchdog";
    private static final String SETTING_INITIAL_WATCHDOG_DELAY_IN_SECONDS = "initialWatchdogDelayInSeconds";
    private static final long DEFAULT_INITIAL_WATCHDOG_DELAY_IN_SECONDS = 90L;
    private static final long MINIMUM_INITIAL_WATCHDOG_DELAY_IN_SECONDS = 30L;
    private static final String SETTING_WATCHDOG_INTERVAL_IN_SECONDS = "watchdogIntervalInSeconds";
    private static final long DEFAULT_WATCHDOG_INTERVAL_IN_SECONDS = 30L;
    private static final long MINIMUM_WATCHDOG_INTERVAL_IN_SECONDS = 15L;
    private static final String SETTING_SYMBOLIC_NAME_OF_BUNDLE = "symbolicNameOfBundle";
    private static final String DEFAULT_SYMBOLIC_NAME_OF_BUNDLE = "de.virtimo.bpc.bpc-be-core";
    private boolean watchdogRunning;
    private final BundleConfig bundleConfig;
    private final BundleContext bundleContext;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;

    public Watchdog(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.watchdogRunning = false;
        this.bundleConfig = this.createBundleConfig();
        this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryWithNamePrefix("core-bundle-watchdog"));
        this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createRunnable(), this.bundleConfig.initialWatchdogDelayInSeconds(), this.bundleConfig.watchdogIntervalInSeconds(), TimeUnit.SECONDS);
    }

    public void destroy() {
        LOGGER.info("destroy");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOGGER.info("Running core bundle watchdog cancelled");
            } else {
                LOGGER.warn("Could not cancel the running core bundle watchdog");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleConfig createBundleConfig() {
        LOGGER.info("createBundleConfig");
        long initialWatchdogDelayInSeconds = 90L;
        long watchdogIntervalInSeconds = 30L;
        String symbolicNameOfBundle = DEFAULT_SYMBOLIC_NAME_OF_BUNDLE;
        ServiceReference reference = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
        if (reference != null) {
            ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(reference);
            try {
                Dictionary properties;
                Configuration configuration = configurationAdmin.getConfiguration(PID);
                if (configuration != null && (properties = configuration.getProcessedProperties(null)) != null) {
                    if (properties.get(SETTING_INITIAL_WATCHDOG_DELAY_IN_SECONDS) != null) {
                        initialWatchdogDelayInSeconds = Long.parseLong(String.valueOf(properties.get(SETTING_INITIAL_WATCHDOG_DELAY_IN_SECONDS)));
                    }
                    if (properties.get(SETTING_WATCHDOG_INTERVAL_IN_SECONDS) != null) {
                        watchdogIntervalInSeconds = Long.parseLong(String.valueOf(properties.get(SETTING_WATCHDOG_INTERVAL_IN_SECONDS)));
                    }
                    if (properties.get(SETTING_SYMBOLIC_NAME_OF_BUNDLE) != null) {
                        symbolicNameOfBundle = String.valueOf(properties.get(SETTING_SYMBOLIC_NAME_OF_BUNDLE));
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to read the backend core watch configuration (PID=de.virtimo.bpc.core.watchdog).", (Throwable)ex);
            }
            finally {
                this.bundleContext.ungetService(reference);
            }
        }
        if (initialWatchdogDelayInSeconds < 30L) {
            LOGGER.warn("Self protection, please use a proper value for 'initialWatchdogDelayInSeconds'. " + initialWatchdogDelayInSeconds + " is too small. Set it for you to 30.");
            initialWatchdogDelayInSeconds = 30L;
        }
        if (watchdogIntervalInSeconds < 15L) {
            LOGGER.warn("Self protection, please use a proper value for 'watchdogIntervalInSeconds'. " + watchdogIntervalInSeconds + " is too small. Set it for you to 15.");
            watchdogIntervalInSeconds = 15L;
        }
        return new BundleConfig(initialWatchdogDelayInSeconds, watchdogIntervalInSeconds, symbolicNameOfBundle);
    }

    private Runnable createRunnable() {
        LOGGER.info("createRunnable");
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Watchdog.this.watchdogRunning) {
                        Watchdog.this.watchdogRunning = true;
                        Bundle bundle = Watchdog.this.getBundleBySymbolicName(Watchdog.this.bundleConfig.symbolicNameOfBundle());
                        if (bundle != null) {
                            if (bundle.getState() == 4) {
                                LOGGER.warn("Watchdog tries to start the backend core bundle (" + Watchdog.this.bundleConfig.symbolicNameOfBundle() + ") which is currently in state RESOLVED.");
                                bundle.start(1);
                            } else {
                                LOGGER.info("Watchdog is not hungry, the backend core bundle (" + Watchdog.this.bundleConfig.symbolicNameOfBundle() + ") is currently not in state RESOLVED.");
                            }
                        } else {
                            LOGGER.info("Watchdog sleeping, there is no backend core bundle with the symbolic name: " + Watchdog.this.bundleConfig.symbolicNameOfBundle());
                        }
                    } else {
                        LOGGER.info("Watchdog is busy, there is already a watchdog running.");
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to perform the core bundle watchdog run.", t);
                }
                finally {
                    Watchdog.this.watchdogRunning = false;
                }
            }
        };
    }

    private Bundle getBundleBySymbolicName(String symbolicName) {
        if (symbolicName != null) {
            try {
                for (Bundle bundle : this.bundleContext.getBundles()) {
                    if (!symbolicName.equals(bundle.getSymbolicName())) continue;
                    return bundle;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to get the core bundle by the symbolic name: " + this.bundleConfig.symbolicNameOfBundle(), (Throwable)ex);
            }
        }
        return null;
    }

    private record BundleConfig(long initialWatchdogDelayInSeconds, long watchdogIntervalInSeconds, String symbolicNameOfBundle) {
    }
}

