/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupCreationException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupIndexNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryCreationException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfosDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionEntryDTO;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.StreamingOutput;

public interface BackupManager {
    public BackupJobInfosDTO getBackupJobInfos() throws ServiceNotFoundException;

    public Set<String> getIdentifiersOfBackupJobs() throws ServiceNotFoundException;

    public void scheduleBackupJobs(List<BackupJobScheduleActionEntryDTO> var1) throws ServiceNotFoundException, JsonGenerationException;

    public void deleteBackupJob(String var1) throws ServiceNotFoundException, JsonGenerationException;

    public List<BackupSnapshotInfo> getAllBackups() throws ServiceNotFoundException, BackupRepositoryNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo getBackupInfo(String var1) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo startBackupJob(String var1) throws ServiceNotFoundException, JsonGenerationException, SystemException;

    public BackupSnapshotInfo createBackup(SnapshotName var1, Set<String> var2) throws BackupRepositoryNotFoundException, BackupRepositoryCreationException, BackupCreationException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo createBackupForBackupJob(BackupJob var1) throws BackupRepositoryNotFoundException, BackupRepositoryCreationException, ServiceNotFoundException, ModuleNotFoundException, OpenSearchRelatedException;

    public BackupSnapshotInfo deleteBackup(String var1) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException;

    public BackupActivatedInfo activateBackup(String var1) throws BackupRepositoryNotFoundException, BackupNotFoundException, BackupConflictException, BackupIndexNotFoundException, ServiceNotFoundException, OpenSearchRelatedException;

    public BackupRestoredInfo restoreBackup(String var1, String var2) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException;

    public StreamingOutput downloadSnapshotContent(String var1) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException;

    public GlobalConfig exportBpcConfiguration(String var1) throws BackupException, BackupConflictException, ServiceNotFoundException, OpenSearchRelatedException;

    public Integer getLowestSupportedModelVersionOfBpcConfigurationIndex();

    public Integer getModelVersionOfBpcConfigurationIndexForThisCoreVersion();

    public void sortSnapshotInfosByStartTime(List<BackupSnapshotInfo> var1, boolean var2);
}

