/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.backendconnections;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.backendconnections.BackendConnectionsInstanceType;
import de.virtimo.bpc.backendconnections.BackendConnectionsModuleInstance;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackendConnectionsModule
extends AbstractInstantiableModule {
    private static final Logger LOGGER = LogManager.getLogger(BackendConnectionsModule.class);
    public static final String MODULE_ID = "backendconnection";
    private String defaultInstanceType = null;
    private Map<String, BackendConnectionsInstanceType> supportedInstanceTypes = new HashMap<String, BackendConnectionsInstanceType>();

    public BackendConnectionsModule(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/backendconnections/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return "Backend Connections";
    }

    @Override
    public String[] getSupportedInstanceTypes() {
        return this.supportedInstanceTypes.keySet().toArray(new String[0]);
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        throw new IllegalArgumentException("Please implement the getDefaultInstanceConfiguration(instanceType) method");
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration(String instanceType) {
        LOGGER.info("getDefaultInstanceConfiguration instanceType={}", (Object)instanceType);
        BackendConnectionsInstanceType backendConnectionsInstanceType = StringUtil.isNullOrEmpty(instanceType) || "none".equalsIgnoreCase(instanceType) ? this.supportedInstanceTypes.get(this.defaultInstanceType) : this.supportedInstanceTypes.get(instanceType);
        return backendConnectionsInstanceType.getDefaultInstanceConfiguration(this.getModuleId());
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return BackendConnectionsModuleInstance.class;
    }

    public void setAsSupportedInstanceType(BackendConnectionsInstanceType instanceType) {
        LOGGER.info("setAsSupportedInstanceType instanceType={}", (Object)instanceType);
        if (instanceType != null) {
            if (StringUtil.isNullOrEmpty(this.defaultInstanceType)) {
                this.defaultInstanceType = instanceType.getName();
            }
            this.supportedInstanceTypes.put(instanceType.getName(), instanceType);
        }
    }
}

