/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import com.fasterxml.jackson.databind.type.TypeFactory;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auditlog.AuditLogService;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.deployment.DeploymentManager;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerPlaceholder;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.AutoCreateModuleInstancesService;
import de.virtimo.bpc.api.service.BomCollectorService;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.ExtOpenSearchService;
import de.virtimo.bpc.api.service.FlowService;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.api.service.InternationalizationService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.api.service.StorageService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.BasicAuthHttpContext;
import de.virtimo.bpc.core.CoreBundleConfigurationImpl;
import de.virtimo.bpc.core.CoreBundleServiceImpl;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.PrometheusExports;
import de.virtimo.bpc.core.ViewConfigurationValidator;
import de.virtimo.bpc.core.auditlog.AuditLogServiceImpl;
import de.virtimo.bpc.core.auditlog.OpenSearchAuditLogger;
import de.virtimo.bpc.core.auth.ClientSessionManagerImpl;
import de.virtimo.bpc.core.auth.ClientSessionsChecker;
import de.virtimo.bpc.core.auth.ClientSessionsEventFilter;
import de.virtimo.bpc.core.auth.ClientSessionsMetricsCollector;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.core.auth.CsrfTokenServiceImpl;
import de.virtimo.bpc.core.auth.IdentityProviderBackendConnectionValidator;
import de.virtimo.bpc.core.auth.IdentityProviderConnectionTester;
import de.virtimo.bpc.core.auth.IdentityProviderInstanceType;
import de.virtimo.bpc.core.auth.IdentityProviderSettingsValidator;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.auth.IpPinningServiceImpl;
import de.virtimo.bpc.core.autocreate.AutoCreateModuleInstancesServiceImpl;
import de.virtimo.bpc.core.backup.BackupManagerImpl;
import de.virtimo.bpc.core.bom.BomCollectorServiceImpl;
import de.virtimo.bpc.core.datalock.DataLockService;
import de.virtimo.bpc.core.datalock.DataLockServiceImpl;
import de.virtimo.bpc.core.db.DataSourceConnectionTester;
import de.virtimo.bpc.core.db.DataSourceInstanceType;
import de.virtimo.bpc.core.db.DataSourcesSettingValidator;
import de.virtimo.bpc.core.db.DatabaseManagerImpl;
import de.virtimo.bpc.core.deployment.DeploymentImporter;
import de.virtimo.bpc.core.deployment.DeploymentManagerImpl;
import de.virtimo.bpc.core.deployment.DeploymentSystemConnectionTester;
import de.virtimo.bpc.core.deployment.DeploymentSystemInstanceType;
import de.virtimo.bpc.core.deployment.DeploymentSystemSettingsValidator;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.fewrapper.FeWrapperService;
import de.virtimo.bpc.core.fewrapper.FeWrapperServiceImpl;
import de.virtimo.bpc.core.frontendlogging.FrontendLoggingManager;
import de.virtimo.bpc.core.frontendlogging.FrontendLoggingManagerImpl;
import de.virtimo.bpc.core.httpproxy.HttpProxyConnectionTester;
import de.virtimo.bpc.core.httpproxy.HttpProxyInstanceType;
import de.virtimo.bpc.core.httpproxy.HttpProxyServiceImpl;
import de.virtimo.bpc.core.indeximporter.IndexImporter;
import de.virtimo.bpc.core.internationalization.InternationalizationServiceImpl;
import de.virtimo.bpc.core.license.LicenseChecker;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.LicenseServiceImpl;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManagerImpl;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationManagerImpl;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceHandler;
import de.virtimo.bpc.core.opensearch.ModuleManagerImpl;
import de.virtimo.bpc.core.opensearch.PasswordEncryptorService;
import de.virtimo.bpc.core.opensearch.PasswordEncryptorServiceImpl;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchBpcPluginEventFilter;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchBpcPluginManagerImpl;
import de.virtimo.bpc.core.percolators.PercolatorsChecker;
import de.virtimo.bpc.core.percolators.PercolatorsManagerImpl;
import de.virtimo.bpc.core.performance.PerformanceMeasurementManager;
import de.virtimo.bpc.core.performance.PerformanceMeasurementManagerImpl;
import de.virtimo.bpc.core.replicator.OpenSearchSettingsValidator;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.replicator.ReplicationManagerImpl;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.ReplicationModuleInstanceSettingValidator;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogService;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogServiceImpl;
import de.virtimo.bpc.core.replicator.tailsync.logger.TailsyncLogService;
import de.virtimo.bpc.core.replicator.tailsync.logger.TailsyncLogServiceImpl;
import de.virtimo.bpc.core.resource.BpcNewCookieHeaderProvider;
import de.virtimo.bpc.core.service.CoreModuleUpdatedEventFilter;
import de.virtimo.bpc.core.service.ErrorResponseServiceImpl;
import de.virtimo.bpc.core.service.EventManagerImpl;
import de.virtimo.bpc.core.service.ExtOpenSearchServiceImpl;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.core.service.IndexCleanupServiceImpl;
import de.virtimo.bpc.core.service.MaintenanceModeAcknowledgedEventFilter;
import de.virtimo.bpc.core.service.MetricsService;
import de.virtimo.bpc.core.service.MetricsServiceImpl;
import de.virtimo.bpc.core.service.OpenSearchServiceImpl;
import de.virtimo.bpc.core.service.QuartzSchedulerService;
import de.virtimo.bpc.core.service.QuartzSchedulerServiceImpl;
import de.virtimo.bpc.core.storage.StorageServiceImpl;
import de.virtimo.bpc.core.websocket.BpcWebsocketServlet;
import de.virtimo.bpc.externalContent.ExternalContentModule;
import de.virtimo.bpc.flow.FlowConnectionTester;
import de.virtimo.bpc.flow.FlowModule;
import de.virtimo.bpc.flow.FlowServiceImpl;
import de.virtimo.bpc.flow.instanceTypes.IguasuInstanceType;
import de.virtimo.bpc.flow.instanceTypes.InubitInstanceType;
import de.virtimo.bpc.htmlContent.HtmlContentModule;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstanceSettingsValidator;
import de.virtimo.bpc.module.DefaultModuleConfigurations;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.module.simple.SimpleSettingValueImpl;
import de.virtimo.bpc.util.BpcKeyStore;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.ObjectMapperPool;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class BpcActivator
implements BundleActivator {
    private static final Logger LOGGER = LogManager.getLogger(BpcActivator.class);
    private BundleContext bundleContext;
    private PercolatorsChecker percolatorsChecker;
    private ClientSessionsChecker clientSessionsChecker;
    private LicenseChecker licenseChecker;
    private DeploymentImporter deploymentImporter;
    private IndexImporter indexImporter;
    private ServiceRegistration<DatabaseManager> databaseManagerRegistration;
    private ServiceRegistration<BackupManager> backupManagerRegistration;
    private ServiceRegistration<FeWrapperService> feModuleWrapperRegistration;
    private ServiceRegistration<EventManager> eventManagerRegistration;
    private ServiceRegistration<OpenSearchService> openSearchServiceRegistration;
    private ServiceRegistration<OpenSearchBpcPluginManager> openSearchBpcPluginManagerRegistration;
    private ServiceRegistration<PasswordEncryptorService> passwordEncryptorServiceRegistration;
    private ServiceRegistration<ModuleManager> moduleManagerRegistration;
    private ServiceRegistration<ClientSessionManager> clientSessionManagerRegistration;
    private ServiceRegistration<CoreBundleConfiguration> coreBundleConfigurationRegistration;
    private ServiceRegistration<AuditLogService> auditLogServiceRegistration;
    private ServiceRegistration<PercolatorsManager> percolatorsManagerRegistration;
    private ServiceRegistration<ReplicationManager> replicationManagerRegistration;
    private ServiceRegistration<LookupJoinsManager> lookupJoinsManagerRegistration;
    private ServiceRegistration<CoreBundleService> coreBundleServiceRegistration;
    private ServiceRegistration<DeploymentManager> deploymentManagerRegistration;
    private ServiceRegistration<PerformanceMeasurementManager> performanceMeasurementManagerRegistration;
    private ServiceRegistration<FrontendLoggingManager> frontendLoggingManagerRegistration;
    private ServiceRegistration<AutoCreateModuleInstancesService> autoCreateModuleInstancesServiceRegistration;
    private ServiceRegistration<ReplicationJobsLogService> replicationJobsLogServiceRegistration;
    private ServiceRegistration<TailsyncLogService> tailsyncLogServiceRegistration;
    private ServiceRegistration<LicenseService> licenseServiceRegistration;
    private ServiceRegistration<HttpProxyService> httpProxyServiceRegistration;
    private ServiceRegistration<MetricsService> metricsServiceRegistration;
    private ServiceRegistration<IndexCleanupService> indexCleanupServiceRegistration;
    private ServiceRegistration<InternationalizationService> internationalizationServiceRegistration;
    private ServiceRegistration<NotificationManager> notificationManagerRegistration;
    private ServiceRegistration<ErrorResponseService> errorResponseServiceRegistration;
    private ServiceRegistration<FlowService> flowServiceRegistration;
    private ServiceRegistration<BomCollectorService> bomCollectorServiceRegistration;
    private ServiceRegistration<StorageService> storageServiceRegistration;
    private ServiceRegistration<DataLockService> dataLockServiceRegistration;
    private ServiceRegistration<ExtOpenSearchService> extOpenSearchServiceRegistration;
    private ServiceRegistration<IpPinningService> ipPinningServiceRegistration;
    private ServiceRegistration<CsrfTokenService> csrfTokenServiceRegistration;
    private ServiceRegistration<QuartzSchedulerService> quartzSchedulerServiceRegistration;
    private ServiceTracker<HttpService, HttpService> httpServiceTracker;

    public BpcActivator() {
        LOGGER.info("********** BpcActivator **********");
        System.setProperty("io.netty.allocator.type", "unpooled");
        BpcNewCookieHeaderProvider.setAsUglyWorkaround();
    }

    public void start(final BundleContext bundleContext) throws Exception {
        LOGGER.info("{}: START ({})", (Object)bundleContext.getBundle().getSymbolicName(), (Object)bundleContext);
        try {
            long startTimestamp = System.currentTimeMillis();
            this.bundleContext = bundleContext;
            LOGGER.info("Registering DatabaseManager START");
            this.databaseManagerRegistration = bundleContext.registerService(DatabaseManager.class, (Object)new DatabaseManagerImpl(bundleContext), null);
            LOGGER.info("Registering DatabaseManager DONE");
            LOGGER.info("Registering CoreBundleConfiguration START");
            final CoreBundleConfigurationImpl coreBundleConfiguration = new CoreBundleConfigurationImpl(bundleContext);
            this.coreBundleConfigurationRegistration = bundleContext.registerService(CoreBundleConfiguration.class, (Object)coreBundleConfiguration, null);
            LOGGER.info("Version: " + coreBundleConfiguration.getCoreVersion());
            LOGGER.info("Registering CoreBundleConfiguration DONE");
            LOGGER.info("Registering CoreBundleService START");
            this.coreBundleServiceRegistration = bundleContext.registerService(CoreBundleService.class, (Object)new CoreBundleServiceImpl(bundleContext), null);
            LOGGER.info("Registering CoreBundleService DONE");
            LOGGER.info("Registering QuartzSchedulerService START");
            this.quartzSchedulerServiceRegistration = bundleContext.registerService(QuartzSchedulerService.class, (Object)new QuartzSchedulerServiceImpl(bundleContext), null);
            LOGGER.info("Registering QuartzSchedulerService DONE");
            LOGGER.info("Registering EventManager START");
            this.eventManagerRegistration = bundleContext.registerService(EventManager.class, (Object)new EventManagerImpl(bundleContext, coreBundleConfiguration.getServerUUID()), null);
            LOGGER.info("Registering EventManager DONE");
            LOGGER.info("Registering OpenSearchService START");
            OpenSearchService openSearchService = OpenSearchServiceImpl.create(bundleContext, coreBundleConfiguration);
            this.openSearchServiceRegistration = bundleContext.registerService(OpenSearchService.class, (Object)openSearchService, null);
            LOGGER.info("Registering OpenSearchService DONE");
            LOGGER.info("Waiting for OpenSearch to be in an ready state ...");
            if (!openSearchService.waitForOpenSearch(30, null)) {
                LOGGER.error("OpenSearch is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
                throw new Exception("OpenSearch is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
            }
            LOGGER.info("Finished waiting for OpenSearch");
            if (openSearchService.existsIndex("bpc-configuration")) {
                LOGGER.info("Waiting for 'bpc-configuration' index to be in an ready state ...");
                if (!openSearchService.waitForOpenSearch(30, new String[]{"bpc-configuration"})) {
                    LOGGER.error("OpenSearch 'bpc-configuration' index is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
                    throw new Exception("OpenSearch 'bpc-configuration' index is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
                }
                LOGGER.info("Finished waiting for 'bpc-configuration' index");
                Setting indexCreationSettingsSetting = ModuleConfigurationPersistenceHandler.readModuleSetting(openSearchService, "_core", "noinstance", "indexCreationSettings");
                SimpleSettingValueImpl indexCreationSettingsSettingValue = new SimpleSettingValueImpl(indexCreationSettingsSetting);
                openSearchService.setDefaultIndexCreationSettings(indexCreationSettingsSettingValue.asMap(null));
                Setting indexDynamicTemplatesSetting = ModuleConfigurationPersistenceHandler.readModuleSetting(openSearchService, "_core", "noinstance", "indexDynamicTemplates");
                SimpleSettingValueImpl indexDynamicTemplatesSettingValue = new SimpleSettingValueImpl(indexDynamicTemplatesSetting);
                openSearchService.setDefaultDynamicTemplates(indexDynamicTemplatesSettingValue.asList(null));
            } else {
                ModuleConfiguration defaultCoreModuleConfiguration = ModuleConfigurationBuilder.newInstance().withModuleId("_core").addSortableGroupedSettingsFromFile(bundleContext.getBundle(), "defaults/core/default_module_settings.json").build();
                openSearchService.setDefaultIndexCreationSettings(defaultCoreModuleConfiguration.getSettingValue("indexCreationSettings").asMap(null));
                openSearchService.setDefaultDynamicTemplates(defaultCoreModuleConfiguration.getSettingValue("indexDynamicTemplates").asList(null));
                Setting indexTemplatesSetting = defaultCoreModuleConfiguration.getSetting("indexTemplates");
                openSearchService.refreshOpenSearchIndexTemplates(indexTemplatesSetting);
            }
            LOGGER.info("Preparing the managed indices provided by the core module");
            openSearchService.getManagedIndicesHandler().prepareManagedIndices(bundleContext.getBundle());
            LOGGER.info("Migrating OpenSearch Indices START");
            try {
                BpcIndicesMigrator indicesMigrator = new BpcIndicesMigrator(openSearchService);
                indicesMigrator.migrateBpcConfigurationIndex();
                indicesMigrator.migrateBpcNotificationIndex();
                indicesMigrator.migrateBpcAuditlogIndex();
            }
            catch (IndexMigrationException ex) {
                if (ex.isErrorCode(CoreErrorCode.INDEX_MIGRATION_NOT_ALLOWED_VERSION)) {
                    LOGGER.error("Starting BPC core failed: " + ex.getLocalizedMessage());
                    throw ex;
                }
                LOGGER.error("Could not migrate the indices.", (Throwable)ex);
            }
            LOGGER.info("Migrating OpenSearch Indices DONE");
            LOGGER.info("Registering ErrorResponseService START");
            this.errorResponseServiceRegistration = bundleContext.registerService(ErrorResponseService.class, (Object)new ErrorResponseServiceImpl(bundleContext), null);
            LOGGER.info("Registering ErrorResponseService DONE");
            LOGGER.info("Registering InternationalizationService START");
            this.internationalizationServiceRegistration = bundleContext.registerService(InternationalizationService.class, (Object)new InternationalizationServiceImpl(bundleContext), null);
            LOGGER.info("Registering InternationalizationService DONE");
            LOGGER.info("Registering BomCollectorService START");
            this.bomCollectorServiceRegistration = bundleContext.registerService(BomCollectorService.class, (Object)new BomCollectorServiceImpl(bundleContext), null);
            LOGGER.info("Registering BomCollectorService DONE");
            LOGGER.info("Registering NotificationManager START");
            this.notificationManagerRegistration = bundleContext.registerService(NotificationManager.class, (Object)new NotificationManagerImpl(bundleContext), null);
            LOGGER.info("Registering NotificationManager DONE");
            LOGGER.info("Registering license service START");
            this.licenseServiceRegistration = bundleContext.registerService(LicenseService.class, (Object)new LicenseServiceImpl(bundleContext), null);
            LOGGER.info("Registering license service DONE");
            LOGGER.info("Registering the IndexCleanupService START");
            this.indexCleanupServiceRegistration = bundleContext.registerService(IndexCleanupService.class, (Object)new IndexCleanupServiceImpl(bundleContext), null);
            LOGGER.info("Registering the IndexCleanupService DONE");
            LOGGER.info("Registering percolators manager START");
            this.percolatorsManagerRegistration = bundleContext.registerService(PercolatorsManager.class, (Object)new PercolatorsManagerImpl(bundleContext, coreBundleConfiguration.getServerUUID()), null);
            LOGGER.info("Registering percolators manager DONE");
            LOGGER.info("Registering LookupJoinsManager START");
            this.lookupJoinsManagerRegistration = bundleContext.registerService(LookupJoinsManager.class, (Object)new LookupJoinsManagerImpl(bundleContext), null);
            LOGGER.info("Registering LookupJoinsManager DONE");
            LOGGER.info("Registering DeploymentManager START");
            this.deploymentManagerRegistration = bundleContext.registerService(DeploymentManager.class, (Object)new DeploymentManagerImpl(bundleContext), null);
            LOGGER.info("Registering DeploymentManager DONE");
            LOGGER.info("Registering ReplicationJobsLogService START");
            this.replicationJobsLogServiceRegistration = bundleContext.registerService(ReplicationJobsLogService.class, (Object)new ReplicationJobsLogServiceImpl(bundleContext), null);
            LOGGER.info("Registering ReplicationJobsLogService DONE");
            LOGGER.info("Registering TailsyncLogService START");
            this.tailsyncLogServiceRegistration = bundleContext.registerService(TailsyncLogService.class, (Object)new TailsyncLogServiceImpl(bundleContext), null);
            LOGGER.info("Registering TailsyncLogService DONE");
            LOGGER.info("Registering ReplicationManager START");
            this.replicationManagerRegistration = bundleContext.registerService(ReplicationManager.class, (Object)new ReplicationManagerImpl(bundleContext), null);
            LOGGER.info("Registering ReplicationManager DONE");
            LOGGER.info("Registering PerformanceMeasurementManager START");
            this.performanceMeasurementManagerRegistration = bundleContext.registerService(PerformanceMeasurementManager.class, (Object)new PerformanceMeasurementManagerImpl(bundleContext, coreBundleConfiguration), null);
            LOGGER.info("Registering PerformanceMeasurementManager DONE");
            LOGGER.info("Registering FrontendLoggingManager START");
            this.frontendLoggingManagerRegistration = bundleContext.registerService(FrontendLoggingManager.class, (Object)new FrontendLoggingManagerImpl(bundleContext, coreBundleConfiguration), null);
            LOGGER.info("Registering FrontendLoggingManager DONE");
            LOGGER.info("Registering BackupManager START");
            this.backupManagerRegistration = bundleContext.registerService(BackupManager.class, (Object)new BackupManagerImpl(bundleContext), null);
            LOGGER.info("Registering BackupManager DONE");
            LOGGER.info("Registering AuditLogService START");
            AuditLogServiceImpl auditLogService = new AuditLogServiceImpl(bundleContext, coreBundleConfiguration);
            auditLogService.setAuditLogger(new OpenSearchAuditLogger(bundleContext, coreBundleConfiguration));
            this.auditLogServiceRegistration = bundleContext.registerService(AuditLogService.class, (Object)auditLogService, null);
            LOGGER.info("Registering AuditLogService DONE");
            LOGGER.info("Registering PasswordEncryptorService START");
            this.passwordEncryptorServiceRegistration = bundleContext.registerService(PasswordEncryptorService.class, (Object)new PasswordEncryptorServiceImpl(bundleContext), null);
            LOGGER.info("Registering PasswordEncryptorService DONE");
            LOGGER.info("Registering the ExtOpenSearchService START");
            this.extOpenSearchServiceRegistration = bundleContext.registerService(ExtOpenSearchService.class, (Object)new ExtOpenSearchServiceImpl(bundleContext), null);
            LOGGER.info("Registering the ExtOpenSearchService DONE");
            LOGGER.info("Registering ModuleManager START");
            ModuleManagerImpl moduleManager = new ModuleManagerImpl(bundleContext);
            moduleManager.setSettingValidator(new DataSourcesSettingValidator(bundleContext));
            moduleManager.setSettingValidator(new ReplicationModuleInstanceSettingValidator(bundleContext));
            moduleManager.setSettingValidator(new LogServiceModuleInstanceSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new DeploymentSystemSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new OpenSearchSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new ViewConfigurationValidator());
            moduleManager.setSettingValidator(new IdentityProviderSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new IdentityProviderBackendConnectionValidator(bundleContext));
            moduleManager.setConnectionTester(new DeploymentSystemConnectionTester());
            moduleManager.setConnectionTester(new DataSourceConnectionTester(bundleContext));
            moduleManager.setConnectionTester(new IdentityProviderConnectionTester(bundleContext));
            moduleManager.setConnectionTester(new HttpProxyConnectionTester(bundleContext));
            moduleManager.setConnectionTester(new FlowConnectionTester(bundleContext));
            this.moduleManagerRegistration = bundleContext.registerService(ModuleManager.class, (Object)moduleManager, null);
            LOGGER.info("Registering ModuleManager DONE");
            LOGGER.info("Registering AutoCreateModuleInstances START");
            this.autoCreateModuleInstancesServiceRegistration = bundleContext.registerService(AutoCreateModuleInstancesService.class, (Object)new AutoCreateModuleInstancesServiceImpl(bundleContext), null);
            LOGGER.info("Registering AutoCreateModuleInstances DONE");
            LOGGER.info("Init/register ModuleManager");
            CoreModule coreModule = null;
            try {
                LOGGER.info("Loading core module ...");
                coreModule = new CoreModule(moduleManager, bundleContext.getBundle());
                moduleManager.loadModule(coreModule);
                LOGGER.info("Loading backend connections module ...");
                BackendConnectionsModule backendConnectionsModule = new BackendConnectionsModule(moduleManager);
                backendConnectionsModule.setModuleBundle(bundleContext.getBundle());
                backendConnectionsModule.setAsSupportedInstanceType(new HttpProxyInstanceType());
                backendConnectionsModule.setAsSupportedInstanceType(new DeploymentSystemInstanceType());
                backendConnectionsModule.setAsSupportedInstanceType(new DataSourceInstanceType());
                backendConnectionsModule.setAsSupportedInstanceType(new IdentityProviderInstanceType());
                moduleManager.loadModule(backendConnectionsModule);
                LOGGER.info("Loading replication module ...");
                ReplicationModule replicationModule = new ReplicationModule(moduleManager);
                replicationModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(replicationModule);
                LOGGER.info("Loading log service module ...");
                LogServiceModule logServiceModule = new LogServiceModule(moduleManager, coreModule.getConfiguration().getSetting("defaultLogServiceIndicesBackup"));
                logServiceModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(logServiceModule);
                LOGGER.info("Loading external content module ...");
                ExternalContentModule externalContentModule = new ExternalContentModule(moduleManager);
                externalContentModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(externalContentModule);
                LOGGER.info("Loading HTML content module ...");
                HtmlContentModule htmlContentModule = new HtmlContentModule(moduleManager);
                htmlContentModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(htmlContentModule);
                LOGGER.info("Loading Flow module ...");
                FlowModule flowModule = new FlowModule(moduleManager);
                flowModule.setModuleBundle(bundleContext.getBundle());
                flowModule.setAsSupportedInstanceType(new IguasuInstanceType());
                flowModule.setAsSupportedInstanceType(new InubitInstanceType());
                moduleManager.loadModule(flowModule);
            }
            catch (Exception e) {
                LOGGER.error("Please STOP Me!", (Throwable)e);
                throw e;
            }
            LOGGER.info("Registering IpPinningService START");
            this.ipPinningServiceRegistration = bundleContext.registerService(IpPinningService.class, (Object)new IpPinningServiceImpl(bundleContext), null);
            LOGGER.info("Registering IpPinningService DONE");
            LOGGER.info("Registering CsrfTokenService START");
            this.csrfTokenServiceRegistration = bundleContext.registerService(CsrfTokenService.class, (Object)new CsrfTokenServiceImpl(bundleContext), null);
            LOGGER.info("Registering CsrfTokenService DONE");
            LOGGER.info("Registering DataLockService START");
            this.dataLockServiceRegistration = bundleContext.registerService(DataLockService.class, (Object)new DataLockServiceImpl(bundleContext), null);
            LOGGER.info("Registering DataLockService DONE");
            LOGGER.info("Registering StorageService START");
            this.storageServiceRegistration = bundleContext.registerService(StorageService.class, (Object)new StorageServiceImpl(bundleContext, coreModule.getConfiguration().getSetting("defaultStorageServiceIndicesBackup")), null);
            LOGGER.info("Registering StorageService DONE");
            LOGGER.info("Registering the HttpProxyService START");
            this.httpProxyServiceRegistration = bundleContext.registerService(HttpProxyService.class, (Object)new HttpProxyServiceImpl(bundleContext), null);
            LOGGER.info("Registering the HttpProxyService DONE");
            LOGGER.info("Registering the FlowService START");
            this.flowServiceRegistration = bundleContext.registerService(FlowService.class, (Object)new FlowServiceImpl(bundleContext), null);
            LOGGER.info("Registering the FlowService DONE");
            LOGGER.info("Starting LicenseChecker");
            this.licenseChecker = new LicenseChecker(bundleContext);
            this.licenseChecker.startChecker();
            LOGGER.info("Starting LicenseChecker DONE");
            LOGGER.info("Starting DeploymentImporter");
            this.deploymentImporter = new DeploymentImporter(bundleContext);
            this.deploymentImporter.startChecker();
            LOGGER.info("Starting DeploymentImporter DONE");
            LOGGER.info("Starting IndexImporter");
            this.indexImporter = new IndexImporter(bundleContext);
            this.indexImporter.startChecker();
            LOGGER.info("Starting IndexImporter DONE");
            LOGGER.info("Registering ClientSessionManager START");
            ClientSessionManagerImpl clientSessionManager = new ClientSessionManagerImpl(bundleContext, moduleManager, coreBundleConfiguration);
            clientSessionManager.addBlacklistEventFilter(new CoreModuleUpdatedEventFilter());
            clientSessionManager.addBlacklistEventFilter(new OpenSearchBpcPluginEventFilter());
            clientSessionManager.addBlacklistEventFilter(new ClientSessionsEventFilter());
            clientSessionManager.addBlacklistEventFilter(new MaintenanceModeAcknowledgedEventFilter());
            this.clientSessionManagerRegistration = bundleContext.registerService(ClientSessionManager.class, (Object)clientSessionManager, new Hashtable());
            LOGGER.info("Registering ClientSessionManager DONE");
            LOGGER.info("Starting ClientSessionsChecker");
            this.clientSessionsChecker = new ClientSessionsChecker(bundleContext);
            this.clientSessionsChecker.startChecker();
            LOGGER.info("Starting ClientSessionsChecker DONE");
            LOGGER.info("Registering the OpenSearch BPC Plugin Manager START");
            this.openSearchBpcPluginManagerRegistration = bundleContext.registerService(OpenSearchBpcPluginManager.class, (Object)new OpenSearchBpcPluginManagerImpl(bundleContext, coreBundleConfiguration), null);
            LOGGER.info("Registering the OpenSearch BPC Plugin Manager DONE");
            LOGGER.info("Registering the MetricsService START");
            MetricsServiceImpl metricsService = new MetricsServiceImpl(bundleContext);
            metricsService.registerCollector("sessions", new ClientSessionsMetricsCollector(bundleContext), TimeUnit.MINUTES.toSeconds(5L));
            this.metricsServiceRegistration = bundleContext.registerService(MetricsService.class, (Object)metricsService, null);
            LOGGER.info("Registering the MetricsService DONE");
            DefaultExports.initialize();
            PrometheusExports.register(bundleContext);
            this.httpServiceTracker = new ServiceTracker<HttpService, HttpService>(bundleContext, HttpService.class.getName(), null){

                public HttpService addingService(ServiceReference<HttpService> ref) {
                    HttpService httpService = (HttpService)bundleContext.getService(ref);
                    LOGGER.info("Registering WebsocketServlet START");
                    try {
                        httpService.registerServlet("/websocket", (Servlet)new BpcWebsocketServlet(bundleContext), null, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    LOGGER.info("Registering WebsocketServlet DONE");
                    LOGGER.info("Registering Prometheus Metrics Servlet START");
                    try {
                        String metricsBasicAuthUsername = coreBundleConfiguration.getSystemPropertyValueAsString("de.virtimo.bpc.metrics.basic_auth.username", "virtimo");
                        String metricsBasicAuthPassword = coreBundleConfiguration.getSystemPropertyValueAsString("de.virtimo.bpc.metrics.basic_auth.password", "HQucFPZgFzpDB3VQu8");
                        BasicAuthHttpContext basicAuthCheckContext = new BasicAuthHttpContext(metricsBasicAuthUsername, metricsBasicAuthPassword);
                        httpService.registerServlet("/metrics", (Servlet)new MetricsServlet(), null, (HttpContext)basicAuthCheckContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    LOGGER.info("Registering Prometheus Metrics Servlet DONE");
                    return httpService;
                }

                public void removedService(ServiceReference<HttpService> ref, HttpService httpService) {
                    try {
                        httpService.unregister("/metrics");
                        httpService.unregister("/websocket");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.httpServiceTracker.open();
            LOGGER.info("Starting PercolatorsChecker");
            this.percolatorsChecker = new PercolatorsChecker(bundleContext);
            this.percolatorsChecker.startChecker();
            LOGGER.info("Starting PercolatorsChecker DONE");
            LOGGER.info("Registering FeWrapperService START");
            this.feModuleWrapperRegistration = bundleContext.registerService(FeWrapperService.class, (Object)new FeWrapperServiceImpl(bundleContext), null);
            LOGGER.info("Registering FeWrapperService DONE");
            LOGGER.info(bundleContext.getBundle().getSymbolicName() + ": STARTED in " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimestamp) + " seconds");
        }
        catch (Throwable t) {
            this.cleanup(bundleContext);
            throw t;
        }
    }

    public void stop(BundleContext bundleContext) {
        LOGGER.info("{}: STOP ({})", (Object)bundleContext.getBundle().getSymbolicName(), (Object)bundleContext);
        this.cleanup(bundleContext);
        LOGGER.info("{}: STOPPED", (Object)bundleContext.getBundle().getSymbolicName());
    }

    private void cleanup(BundleContext bundleContext) {
        LOGGER.info("cleanup bundleContext={}", (Object)bundleContext);
        Checker.stop(this.indexImporter);
        Checker.stop(this.deploymentImporter);
        Checker.stop(this.percolatorsChecker);
        Checker.stop(this.clientSessionsChecker);
        Checker.stop(this.licenseChecker);
        LOGGER.info("Unregistering the BPC specific Prometheus exports");
        PrometheusExports.unregister();
        try {
            this.httpServiceTracker.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BpcService.unregister(bundleContext, this.extOpenSearchServiceRegistration, ExtOpenSearchService.class);
        BpcService.unregister(bundleContext, this.metricsServiceRegistration, MetricsService.class);
        BpcService.unregister(bundleContext, this.performanceMeasurementManagerRegistration, PerformanceMeasurementManager.class);
        BpcService.unregister(bundleContext, this.frontendLoggingManagerRegistration, FrontendLoggingManager.class);
        BpcService.unregister(bundleContext, this.deploymentManagerRegistration, DeploymentManager.class);
        BpcService.unregister(bundleContext, this.bomCollectorServiceRegistration, BomCollectorService.class);
        BpcService.unregister(bundleContext, this.internationalizationServiceRegistration, InternationalizationService.class);
        BpcService.unregister(bundleContext, this.notificationManagerRegistration, NotificationManager.class);
        BpcService.unregister(bundleContext, this.autoCreateModuleInstancesServiceRegistration, AutoCreateModuleInstancesService.class);
        BpcService.unregister(bundleContext, this.openSearchBpcPluginManagerRegistration, OpenSearchBpcPluginManager.class);
        BpcService.unregister(bundleContext, this.flowServiceRegistration, FlowService.class);
        BpcService.unregister(bundleContext, this.httpProxyServiceRegistration, HttpProxyService.class);
        BpcService.unregister(bundleContext, this.replicationJobsLogServiceRegistration, ReplicationJobsLogService.class);
        BpcService.unregister(bundleContext, this.tailsyncLogServiceRegistration, TailsyncLogService.class);
        BpcService.unregister(bundleContext, this.percolatorsManagerRegistration, PercolatorsManager.class);
        BpcService.unregister(bundleContext, this.clientSessionManagerRegistration, ClientSessionManager.class);
        BpcService.unregister(bundleContext, this.lookupJoinsManagerRegistration, LookupJoinsManager.class);
        BpcService.unregister(bundleContext, this.replicationManagerRegistration, ReplicationManager.class);
        BpcService.unregister(bundleContext, this.moduleManagerRegistration, ModuleManager.class);
        BpcService.unregister(bundleContext, this.passwordEncryptorServiceRegistration, PasswordEncryptorService.class);
        BpcService.unregister(bundleContext, this.auditLogServiceRegistration, AuditLogService.class);
        BpcService.unregister(bundleContext, this.backupManagerRegistration, BackupManager.class);
        BpcService.unregister(bundleContext, this.feModuleWrapperRegistration, FeWrapperService.class);
        BpcService.unregister(bundleContext, this.eventManagerRegistration, EventManager.class);
        BpcService.unregister(bundleContext, this.indexCleanupServiceRegistration, IndexCleanupService.class);
        BpcService.unregister(bundleContext, this.dataLockServiceRegistration, DataLockService.class);
        BpcService.unregister(bundleContext, this.ipPinningServiceRegistration, IpPinningService.class);
        BpcService.unregister(bundleContext, this.csrfTokenServiceRegistration, CsrfTokenService.class);
        BpcService.unregister(bundleContext, this.storageServiceRegistration, StorageService.class);
        BpcService.unregister(bundleContext, this.openSearchServiceRegistration, OpenSearchService.class);
        BpcService.unregister(bundleContext, this.databaseManagerRegistration, DatabaseManager.class);
        BpcService.unregister(bundleContext, this.coreBundleServiceRegistration, CoreBundleService.class);
        BpcService.unregister(bundleContext, this.coreBundleConfigurationRegistration, CoreBundleConfiguration.class);
        BpcService.unregister(bundleContext, this.licenseServiceRegistration, LicenseService.class);
        BpcService.unregister(bundleContext, this.errorResponseServiceRegistration, ErrorResponseService.class);
        BpcService.unregister(bundleContext, this.quartzSchedulerServiceRegistration, QuartzSchedulerService.class);
        ObjectMapperPool.destroySingleton();
        DefaultModuleConfigurations.destroySingleton();
        BpcTrustStore.destroySingleton();
        BpcKeyStore.destroySingleton();
        IdentityManagerPlaceholder.destroySingleton();
        BpcNewCookieHeaderProvider.removeUglyWorkaround();
        TypeFactory.defaultInstance().clearCache();
    }
}

