/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.core.license.License;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class GeneralMetricsCollector
extends Collector {
    private static final Logger LOGGER = LogManager.getLogger(GeneralMetricsCollector.class);
    private final BundleContext bundleContext;
    private final RuntimeMXBean runtimeMXBean;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<LicenseService> licenseServiceTracker;

    public GeneralMetricsCollector(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(bundleContext, LicenseService.class);
    }

    public void unregister() {
        LOGGER.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        LOGGER.info("collect");
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        mfs.addAll(this.createJvmUptimeMetrics());
        mfs.addAll(this.createMaintenanceModeMetrics());
        mfs.addAll(this.createBpcLicenseRelatedMetrics());
        mfs.addAll(this.createStatusOfBpcModulesMetrics());
        return mfs;
    }

    private List<Collector.MetricFamilySamples> createJvmUptimeMetrics() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_jvm_uptime_in_milliseconds", "Uptime of the BPC JVM in milliseconds.", (double)this.runtimeMXBean.getUptime()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }

    private List<Collector.MetricFamilySamples> createMaintenanceModeMetrics() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_maintenance_mode_enabled", "Status of the maintenance mode (1=enabled; 0=disabled)", coreBundleConfiguration.isMaintenanceModeEnabled() ? 1.0 : 0.0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }

    private List<Collector.MetricFamilySamples> createBpcLicenseRelatedMetrics() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            License license = this.licenseServiceTracker.getService().getLicense();
            double licenseStatus = 0.0;
            Long licenseExpiresInDays = null;
            LocalDate localLicenseExpirationDate = null;
            if (license != null) {
                if (license.isExpired()) {
                    licenseStatus = 2.0;
                    licenseExpiresInDays = 0L;
                } else {
                    licenseStatus = 1.0;
                    licenseExpiresInDays = license.getExpiresInDays();
                }
                localLicenseExpirationDate = license.getExpirationDate();
            }
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_license_status", "Status of the license (0=missing; 1=valid; 2=expired)", licenseStatus));
            if (licenseExpiresInDays != null) {
                mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_license_expires_in_days", "Number of days until the license expires", (double)licenseExpiresInDays.longValue()));
            }
            if (localLicenseExpirationDate != null) {
                long licenseExpiresOnUtcTimestampInMillis = localLicenseExpirationDate.atStartOfDay().atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
                mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_license_expires_on_utc_timestamp_millis", "UTC timestamp in millis when the license expires", (double)licenseExpiresOnUtcTimestampInMillis));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }

    private List<Collector.MetricFamilySamples> createStatusOfBpcModulesMetrics() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_modules_state", "Status of all BPC modules (1=working; 0=errors). It is in state error when at least one BPC bundle/module is in the Karaf state 'Resolved' or 'Failure`.", BpcBundleUtil.areAllBpcBundlesInWorkingState(this.bundleContext) ? 1.0 : 0.0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }
}

