/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.BpcIndexStateException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.decanter.api.marshaller.Marshaller;
import org.apache.karaf.decanter.appender.utils.EventFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.MDC;

@Component(name="de.virtimo.bpc.decanter.appender.opensearch", immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"event.topics=decanter/collect/*", "marshaller.target=(dataFormat=json)"})
public class OpenSearchDecanterAppender
implements EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchDecanterAppender.class);
    private static final String INDEX_ALIAS_NAME = "bpc-logs";
    private static final Object BPC_LOGS_INDEX_LOCK = new Object();
    @Reference
    public Marshaller marshaller;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public OpenSearchService oss;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public PercolatorsManager percolatorsManager;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public IndexCleanupService indexCleanupService;
    private Dictionary<String, Object> config;
    private boolean enabled;
    private int cleanupPeriodInMinutes;
    private String deleteEntriesOlderThan;
    private String dateFieldToDeleteEntries;
    private BulkProcessor bulkProcessor = null;
    private ExecutorService informClientsExecutorService;

    @Activate
    public void activate(ComponentContext context) {
        this.config = context.getProperties();
        this.enabled = Boolean.parseBoolean(String.valueOf(this.config.get("enabled")));
        this.cleanupPeriodInMinutes = Integer.parseInt(String.valueOf(this.config.get("cleanupPeriodInMinutes")));
        this.deleteEntriesOlderThan = String.valueOf(this.config.get("deleteEntriesOlderThan"));
        this.dateFieldToDeleteEntries = String.valueOf(this.config.get("dateFieldToDeleteEntries"));
        this.informClientsExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-logs-clients-informer"));
        this.startBpcLogsIndexCleanupTask();
    }

    @Deactivate
    public void deactivate() {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.close();
        }
        if (this.informClientsExecutorService != null) {
            this.informClientsExecutorService.shutdown();
        }
        this.stopBpcLogsIndexCleanupTask();
    }

    public void handleEvent(Event event) {
        try {
            if (EventFilter.match((Event)event, this.config)) {
                String jsonString = this.marshaller.marshal((Object)event);
                this.saveReceivedLogEvent(jsonString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReceivedLogEvent(String jsonString) throws ModuleNotFoundException, ServiceNotFoundException, OpenSearchRelatedException, BpcIndexStateException, IOException {
        Object object = BPC_LOGS_INDEX_LOCK;
        synchronized (object) {
            if (this.enabled && this.oss != null && jsonString != null) {
                MDC.put((String)"log_entries_initiator", (String)"OpenSearchDecanterAppender");
                try {
                    Map<String, Object> jsonMap = JsonUtil.getInstance().jsonStringAsMap(jsonString);
                    Map mdc = (Map)jsonMap.get("MDC");
                    if (!mdc.containsKey("log_entries_initiator")) {
                        BpcIndexState bpcLogsIndexState = this.oss.getIndexState(INDEX_ALIAS_NAME);
                        bpcLogsIndexState.prepareUsing(new BpcIndexCreateCallable(){

                            @Override
                            public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                                return oss.getManagedIndicesHandler().createManagedIndex(OpenSearchDecanterAppender.INDEX_ALIAS_NAME);
                            }
                        });
                        String indexName = bpcLogsIndexState.getIndexName();
                        this.cleanupLogEntry(jsonMap);
                        if (this.bulkProcessor == null) {
                            this.bulkProcessor = this.createBulkProcessor(this.oss);
                        }
                        this.bulkProcessor.add(new IndexRequest(indexName).source(jsonMap));
                    }
                }
                finally {
                    MDC.remove((String)"log_entries_initiator");
                }
            }
        }
    }

    private void cleanupLogEntry(Map<String, Object> jsonMap) {
        jsonMap.remove("name");
        jsonMap.remove("type");
        jsonMap.remove("component_name");
        jsonMap.remove("service_pid");
        jsonMap.remove("felix_fileinstall_filename");
        jsonMap.remove("osgi_ds_satisfying_condition_target");
        jsonMap.remove("component_id");
        jsonMap.remove("excluded_categories");
        jsonMap.remove("org_ops4j_pax_logging_appender_name");
        jsonMap.remove("loggerName");
        jsonMap.remove("loggerClass");
        jsonMap.remove("event_topics");
        jsonMap.remove("renderedMessage");
        jsonMap.put("@timestamp", String.valueOf(jsonMap.get("@timestamp")).replace(",", "."));
        String locClass = String.valueOf(jsonMap.get("loc_class"));
        jsonMap.put("loc_className", locClass.substring(locClass.lastIndexOf(".") + 1));
    }

    private BulkProcessor createBulkProcessor(final OpenSearchService oss) {
        LOGGER.info("createBulkProcessor oss=...");
        RestHighLevelClient osClient = oss.getClient();
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            @Override
            public void beforeBulk(long executionId, BulkRequest request) {
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, final BulkResponse bulkResponse) {
                try {
                    FutureTask<Exception> informClientsFutureTask = new FutureTask<Exception>(new Callable<Exception>(){

                        @Override
                        public Exception call() {
                            try {
                                OpenSearchDecanterAppender.this.percolatorsManager.informClientsAboutReplicatedData(oss, OpenSearchDecanterAppender.INDEX_ALIAS_NAME, bulkResponse);
                                return null;
                            }
                            catch (Exception ex) {
                                LOGGER.error(ex.getMessage(), (Throwable)ex);
                                return ex;
                            }
                        }
                    });
                    OpenSearchDecanterAppender.this.informClientsExecutorService.execute(informClientsFutureTask);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to inform the frontends about new performance data.", (Throwable)ex);
                }
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            }
        };
        return BulkProcessor.builder((request, bulkListener) -> osClient.bulkAsync((BulkRequest)request, RequestOptions.DEFAULT, (ActionListener<BulkResponse>)bulkListener), listener).setBulkActions(1000).setFlushInterval(TimeValue.timeValueSeconds(15L)).setConcurrentRequests(1).build();
    }

    private void stopBpcLogsIndexCleanupTask() {
        LOGGER.info("stopBpcLogsIndexCleanupTask");
        try {
            this.indexCleanupService.cancelAndRemoveScheduledDeleteTask(INDEX_ALIAS_NAME);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to stop/cancel the running cleanup task for the index 'bpc-logs'.", (Throwable)ex);
        }
    }

    private void startBpcLogsIndexCleanupTask() {
        LOGGER.info("startBpcLogsIndexCleanupTask");
        try {
            this.indexCleanupService.scheduleDeleteTask(INDEX_ALIAS_NAME, this.dateFieldToDeleteEntries, this.deleteEntriesOlderThan, this.cleanupPeriodInMinutes, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to schedule the index cleanup task for the index 'bpc-logs'.", (Throwable)ex);
        }
    }
}

