/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.apikey;

import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class APIKey {
    private final String key;
    private final String name;
    private final String description;
    private final String issuedOn;
    private final String issuedFor;
    private final String issuedBy;
    private final String expiresOn;
    private final Set<Organisation> assignedOrganisations;
    private final Set<Role> assignedRoles;
    private final Set<Right> assignedRights;

    public static String generateId(String apiKey) {
        return "API-" + StringUtil.toSHA1(apiKey).substring(0, 7);
    }

    public static APIKey of(String key, Map<String, Object> values) {
        return new APIKey(key, MapUtil.getValueAsString(values, "name", null), MapUtil.getValueAsString(values, "description", null), MapUtil.getValueAsString(values, "issuedOn", null), MapUtil.getValueAsString(values, "issuedFor", null), MapUtil.getValueAsString(values, "issuedBy", null), MapUtil.getValueAsString(values, "expiresOn", null), APIKey.createAssignedOrganisations(MapUtil.getValueAsObject(values, "assignedOrganisations", null)), APIKey.createAssignedRoles(MapUtil.getValueAsObject(values, "assignedRoles", null)), APIKey.createAssignedRights(MapUtil.getValueAsObject(values, "assignedRights", null)));
    }

    private static Set<Organisation> createAssignedOrganisations(Object assignedOrganisationsObject) {
        HashSet<Organisation> result = new HashSet<Organisation>();
        if (assignedOrganisationsObject instanceof List) {
            result.addAll(OrganisationFactory.getOrganisations((List)assignedOrganisationsObject));
        }
        return result;
    }

    private static Set<Role> createAssignedRoles(Object assignedRolesObject) {
        HashSet<Role> result = new HashSet<Role>();
        if (assignedRolesObject instanceof List) {
            result.addAll(RolesFactory.getRoles((List)assignedRolesObject));
        }
        return result;
    }

    private static Set<Right> createAssignedRights(Object assignedRightsObject) {
        HashSet<Right> result = new HashSet<Right>();
        if (assignedRightsObject instanceof List) {
            result.addAll(RightFactory.getRights((List)assignedRightsObject));
        }
        return result;
    }

    public APIKey(String key, String name, String description, String issuedOn, String issuedFor, String issuedBy, String expiresOn, Set<Organisation> assignedOrganisations, Set<Role> assignedRoles, Set<Right> assignedRights) {
        this.key = key;
        this.name = name;
        this.description = description;
        this.issuedOn = issuedOn;
        this.issuedFor = issuedFor;
        this.issuedBy = issuedBy;
        this.expiresOn = expiresOn;
        this.assignedOrganisations = assignedOrganisations;
        this.assignedRoles = assignedRoles;
        this.assignedRights = assignedRights;
    }

    public boolean isValid() {
        if (StringUtil.isNullOrEmpty(this.getKey())) {
            return false;
        }
        if (StringUtil.isNullOrEmpty(this.getIssuedOn())) {
            return false;
        }
        return !StringUtil.isNullOrEmpty(this.getExpiresOn());
    }

    public boolean isNotActive() {
        return this.isNotActive(ZonedDateTime.now());
    }

    public boolean isNotActive(ZonedDateTime currentDateTime) {
        return currentDateTime.isBefore(this.getIssuedOnAsDate());
    }

    public boolean isExpired() {
        return this.isExpired(ZonedDateTime.now());
    }

    public boolean isExpired(ZonedDateTime currentDateTime) {
        return currentDateTime.isAfter(this.getExpiresOnAsDate());
    }

    public String getId() {
        return APIKey.generateId(this.key);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIssuedOn() {
        return this.issuedOn;
    }

    public ZonedDateTime getIssuedOnAsDate() {
        return ZonedDateTime.parse(this.getIssuedOn());
    }

    public String getIssuedFor() {
        return this.issuedFor;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public String getExpiresOn() {
        return this.expiresOn;
    }

    public ZonedDateTime getExpiresOnAsDate() {
        return ZonedDateTime.parse(this.getExpiresOn());
    }

    public Date getExpirationDate() {
        return Date.from(this.getExpiresOnAsDate().withZoneSameInstant(ZoneId.systemDefault()).toInstant());
    }

    public Set<Organisation> getAssignedOrganisations() {
        return this.assignedOrganisations;
    }

    public Set<Role> getAssignedRoles() {
        return this.assignedRoles;
    }

    public Set<Right> getAssignedRights() {
        return this.assignedRights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIKey apiKey = (APIKey)o;
        return this.key.equals(apiKey.key) && Objects.equals(this.name, apiKey.name) && Objects.equals(this.description, apiKey.description) && Objects.equals(this.issuedOn, apiKey.issuedOn) && Objects.equals(this.issuedFor, apiKey.issuedFor) && Objects.equals(this.issuedBy, apiKey.issuedBy) && Objects.equals(this.expiresOn, apiKey.expiresOn) && Objects.equals(this.assignedOrganisations, apiKey.assignedOrganisations) && Objects.equals(this.assignedRoles, apiKey.assignedRoles) && Objects.equals(this.assignedRights, apiKey.assignedRights);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

