/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auditlog;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogService;
import de.virtimo.bpc.api.auditlog.AuditLogger;
import de.virtimo.bpc.core.auth.UserImpl;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class AuditLogServiceImpl
implements AuditLogService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(AuditLogServiceImpl.class);
    private static final AtomicInteger SEQ_COUNTER = new AtomicInteger(1);
    private final BundleContext bundleContext;
    private final Map<AuditLogger, AuditLogLevel> auditLoggers;
    private final ExecutorService executorService;
    private final CoreBundleConfiguration coreBundleConfiguration;
    private boolean shutdownInProgress = false;

    public AuditLogServiceImpl(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.bundleContext = bundleContext;
        this.coreBundleConfiguration = coreBundleConfiguration;
        this.auditLoggers = new HashMap<AuditLogger, AuditLogLevel>();
        this.executorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-auditlog"));
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        this.shutdownInProgress = true;
        for (AuditLogger auditLogger : this.auditLoggers.keySet()) {
            try {
                auditLogger.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Could not stop an audit logger.", (Throwable)ex);
            }
        }
        this.executorService.shutdown();
    }

    public AuditLogger getAuditLogger(String auditLoggerClazz) {
        LOGGER.info("getAuditLogger auditLoggerClazz={}", (Object)auditLoggerClazz);
        for (AuditLogger auditLogger : this.auditLoggers.keySet()) {
            if (!auditLogger.getClass().getName().equals(auditLoggerClazz)) continue;
            return auditLogger;
        }
        return null;
    }

    @Override
    public void setAuditLogger(AuditLogger auditLogger) {
        AuditLogLevel parsedAuditLogLevel;
        LOGGER.info("setAuditLogger auditLogger={}", (Object)auditLogger);
        AuditLogger existingAuditLogger = this.getAuditLogger(auditLogger.getClass().getName());
        if (existingAuditLogger != null) {
            this.auditLoggers.remove(existingAuditLogger);
        }
        String auditLoggerClazz = auditLogger.getClass().getName();
        AuditLogLevel auditLogLevel = auditLogger.getDefaultAuditLogLevel();
        String auditLogLevelSystemPropertyName = auditLoggerClazz + ".auditlog.level";
        LOGGER.info("{}: Trying to get the audit log level by using the system property name: {}", (Object)auditLogger.getClass().getSimpleName(), (Object)auditLogLevelSystemPropertyName);
        String auditLogLevelString = this.coreBundleConfiguration.getSystemPropertyValueAsString(auditLogLevelSystemPropertyName, null);
        if (auditLogLevelString != null && (parsedAuditLogLevel = AuditLogLevel.parse(auditLogLevelString)) != null) {
            auditLogLevel = parsedAuditLogLevel;
        }
        LOGGER.info("{}: Using the audit log level '{}'", (Object)auditLogger.getClass().getSimpleName(), (Object)auditLogLevel);
        this.auditLoggers.put(auditLogger, auditLogLevel);
    }

    @Override
    public void log(AuditLogLevel level, String originator, String action, String description, Object oldValues, Object newValues) {
        this.log(level, originator, action, description, oldValues, newValues, null);
    }

    @Override
    public void log(AuditLogLevel level, String originator, String action, String description, Object oldValues, Object newValues, Map<String, Object> externalReference) {
        if (this.shutdownInProgress) {
            LOGGER.warn("Audit logging is ignored while shutdown is in progress.");
            return;
        }
        String now = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        int seq = SEQ_COUNTER.getAndIncrement();
        if (seq == Integer.MAX_VALUE) {
            SEQ_COUNTER.set(1);
        }
        final HashMap<String, Object> logEntry = new HashMap<String, Object>();
        logEntry.put("level", level.getName());
        logEntry.put("originator", originator == null || originator.trim().length() == 0 ? "[UNKNOWN]" : originator);
        logEntry.put("action", action);
        logEntry.put("description", description);
        logEntry.put("old", this.convertForOpenSearchTextTypeField(oldValues));
        logEntry.put("new", this.convertForOpenSearchTextTypeField(newValues));
        logEntry.put("timestamp", now);
        logEntry.put("timestamp_seq", seq);
        logEntry.put("serverName", this.coreBundleConfiguration.getBpcName());
        logEntry.put("serverUUID", this.coreBundleConfiguration.getServerUUID());
        if (externalReference != null) {
            logEntry.put("externalReference", externalReference);
        }
        this.auditLoggers.forEach((logger, loggerLevel) -> {
            if (level.intValue() >= loggerLevel.intValue()) {
                FutureTask<Boolean> logDataFutureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        try {
                            FutureTask<Exception> postProcessingTask = logger.log(Arrays.asList(logEntry));
                            if (postProcessingTask != null) {
                                AuditLogServiceImpl.this.executorService.execute(postProcessingTask);
                            }
                            return Boolean.TRUE;
                        }
                        catch (Exception ex) {
                            LOGGER.error("Could not perform the audit log.", (Throwable)ex);
                            return Boolean.FALSE;
                        }
                    }
                });
                this.executorService.execute(logDataFutureTask);
            }
        });
    }

    private Object convertForOpenSearchTextTypeField(Object value) {
        if (value instanceof UserImpl || value instanceof Map) {
            try {
                return JsonUtil.getInstance().convertPojoToJsonString(value);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to convert a {} instance to a JSON string.", (Object)UserImpl.class.getSimpleName(), (Object)ex);
            }
        }
        return value;
    }
}

