/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auditlog.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogService;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auditlog.AuditLogException;
import de.virtimo.bpc.core.auditlog.resource.AuditLogData;
import de.virtimo.bpc.core.deeplink.Deeplink;
import de.virtimo.bpc.core.deeplink.monitor.MonitorInstanceInvestigator;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.flow.IguasuHelper;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.UriQueryUtil;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="auditlog")
@Tag(name="Audit Log API", description="The audit log collects information on user activities within the application.\nThese endpoints allow to post custom audit logs and to get a link to the monitor corresponding to the audit log.\n")
public class AuditLogEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(AuditLogEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<AuditLogService> auditLogServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public AuditLogEndpoint(BundleContext bundleContext) {
        LOGGER.info("AuditLogEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.auditLogServiceTracker = new BpcServicesTracker<AuditLogService>(this.bundleContext, AuditLogService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }

    private void doGlobalMaintenanceModeEnabledCheck() throws ServiceNotFoundException, AuditLogException {
        if (this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled()) {
            throw new AuditLogException((ErrorCode)CoreErrorCode.AUDITLOG_MAINTENANCE, "The core is currently in maintenance.");
        }
    }

    @OperationDescription(summary="Creates a new audit log entry.", description="To create a new audit log entry, send a JSON message with the following structure:\n\n[source,json]\n----\n{\n     \"level\": \"INFO\",\n     \"originator\": \"[INUBIT]\",\n     \"action\": \"TESTACTION\",\n     \"description\": \"Only a test\",\n     \"oldValues\": \"5\",\n     \"newValues\": \"10\",\n     \"externalReference\": {\n         \"workflow\": \"update_units\",\n         \"engine\": \"IS8\"\n     }\n}\n----\n\nHint: 'externalReference' is optional and must be a JSON object when used.\n\nFor calls from Iguasu the following HTTP headers are used and their values written to the following 'externalReference' object fields:\n\n!===\n!HTTP Header         !'externalReference' field\n\n!IGUASU-System-ID    !externalReference.system\n!IGUASU-Instance-ID  !externalReference.instance\n!IGUASU-Processor-ID !externalReference.processor\n!IGUASU-Service-ID   !externalReference.service\n!===\n")
    @POST
    @Path(value="/log")
    @BpcRoleOrRightRequired(role="AUDIT_LOG_USER", right="AUDIT_LOG_CREATE_ENTRY")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="The transferred data is not valid"), @ApiResponse(responseCode="401", description="Authentication could not be performed")})
    public Response log(@Context HttpHeaders hh, String json) {
        LOGGER.info("log");
        try {
            AuditLogData auditLogData;
            if (StringUtil.isNullOrEmpty(json)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No audit log data given");
            }
            this.doGlobalMaintenanceModeEnabledCheck();
            try {
                auditLogData = JsonUtil.getInstance().convertJsonStringToPojo(json, AuditLogData.class);
            }
            catch (IOException ex) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Could not convert the given data to a AuditLogData object. Invalid JSON structure?", ex);
            }
            ExternalReferenceData externalReferenceData = IguasuHelper.extractIguasuSpecificHeaderValues(hh);
            AuditLogService auditLogService = this.auditLogServiceTracker.getService();
            auditLogService.log(AuditLogLevel.parse(auditLogData.getLevel()), auditLogData.getOriginator(), auditLogData.getAction(), auditLogData.getDescription(), auditLogData.getOldValues(), auditLogData.getNewValues(), this.createExternalReference(auditLogData, externalReferenceData));
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create the audit log entry", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Map<String, Object> createExternalReference(AuditLogData auditLogData, ExternalReferenceData externalReferenceData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (auditLogData != null && auditLogData.getExternalReference() != null) {
            result.putAll(auditLogData.getExternalReference());
        }
        if (externalReferenceData != null && !externalReferenceData.isEmpty()) {
            result.putAll(externalReferenceData.asMap());
        }
        return result.isEmpty() ? null : result;
    }

    @OperationDescription(summary="Redirects the user to the monitor using the audit log OpenSearch index.", description="Redirects the user to the monitor using the audit log OpenSearch index.\n\nAll provided query params are used to build a monitor filter on fields of the 'externalReference' object.\n\nFor Iguasu the following query parameters can be used to access the HTTP header values when the entry has been created.\n\n!===\n!Query parameter !HTTP header\n\n!system    !IGUASU-System-ID\n!instance  !IGUASU-Instance-ID\n!processor !IGUASU-Processor-ID\n!service   !IGUASU-Service-ID\n!===\n")
    @GET
    @Path(value="/open/monitor")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="BPC deeplink could not be created"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    @ReturnDescription(value="The requested data as JSON.")
    public Response openMonitorPage(@Context HttpServletRequest req) {
        LOGGER.info("openMonitorPage");
        try {
            this.doGlobalMaintenanceModeEnabledCheck();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            CoreModule coreModule = this.getCoreModule();
            Set<String> monitorInstanceIDs = new MonitorInstanceInvestigator(moduleManager).getIDsOfMonitorInstancesUsingThisOpenSearchIndex("bpc-auditlog");
            Map<String, String> queryParams = UriQueryUtil.getQueryParams(req.getQueryString());
            String redirectUrl = new Deeplink(coreModule.getBpcFrontendUrl()).createMonitorRedirectUrl(monitorInstanceIDs, queryParams);
            return Response.ok().status(Response.Status.FOUND).header("Location", (Object)redirectUrl).build();
        }
        catch (Exception ex) {
            LOGGER.error("Creating the BPC deeplink and redirecting the user failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

