/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.jetbrains.annotations.NotNull;

public class ClientSessionImpl
implements ClientSession {
    private static final Logger LOGGER = LogManager.getLogger(ClientSessionImpl.class);
    private final String sessionId;
    private final String nonHijackableSessionId;
    private UserSession userSession;
    private long timesMillisSinceNoWebsocketSessionsExist;
    private final List<Session> websocketSessions;
    private WebsocketSessionState websocketSessionState;
    private static final Object WEBSOCKET_SESSIONS_LOCK = new Object();

    public ClientSessionImpl(String sessionId, UserSession userSession) {
        this.sessionId = sessionId;
        this.nonHijackableSessionId = UUIDGenerator.randomUUID();
        this.userSession = userSession;
        this.websocketSessions = new ArrayList<Session>();
        this.setWebsocketSessionState(WebsocketSessionState.NeverHadAWebsocketSession);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getNonHijackableSessionId() {
        return this.nonHijackableSessionId;
    }

    @Override
    public UserSession getUserSession() {
        return this.userSession;
    }

    @Override
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientSessionImpl that = (ClientSessionImpl)o;
        return this.sessionId.equals(that.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ArrayList<Session> getWebsocketSessions() {
        Object object = WEBSOCKET_SESSIONS_LOCK;
        synchronized (object) {
            return new ArrayList<Session>(this.websocketSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInactiveSinceMinutes(int minutes) {
        Object object = WEBSOCKET_SESSIONS_LOCK;
        synchronized (object) {
            return switch (this.websocketSessionState) {
                default -> throw new IncompatibleClassChangeError();
                case WebsocketSessionState.NeverHadAWebsocketSession -> false;
                case WebsocketSessionState.ThereAreWebsocketSessions -> false;
                case WebsocketSessionState.AllWebsocketSessionsAreGone -> this.timesMillisSinceNoWebsocketSessionsExist + TimeUnit.MINUTES.toMillis(minutes) < System.currentTimeMillis();
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWebsocketSession(Session websocketSession) {
        Object object = WEBSOCKET_SESSIONS_LOCK;
        synchronized (object) {
            if (websocketSession != null) {
                this.websocketSessions.add(websocketSession);
                this.setWebsocketSessionState(WebsocketSessionState.ThereAreWebsocketSessions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWebsocketSession(Session websocketSession) {
        Object object = WEBSOCKET_SESSIONS_LOCK;
        synchronized (object) {
            if (websocketSession != null && !this.websocketSessions.isEmpty()) {
                if (this.websocketSessions.remove(websocketSession)) {
                    LOGGER.info("WebsocketSession found and removed: {}", (Object)websocketSession);
                } else {
                    LOGGER.warn("WebsocketSession to remove NOT found: {}", (Object)websocketSession);
                }
                if (this.websocketSessions.isEmpty()) {
                    this.setWebsocketSessionState(WebsocketSessionState.AllWebsocketSessionsAreGone);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAndRemoveAllWebsocketSessions() {
        LOGGER.info("closeAndRemoveAllWebsocketSessions");
        Object object = WEBSOCKET_SESSIONS_LOCK;
        synchronized (object) {
            if (!this.websocketSessions.isEmpty()) {
                for (Session websocketSession : this.websocketSessions) {
                    if (websocketSession == null || !websocketSession.isOpen()) continue;
                    websocketSession.close();
                }
                this.websocketSessions.clear();
                this.setWebsocketSessionState(WebsocketSessionState.AllWebsocketSessionsAreGone);
            }
        }
    }

    private void setWebsocketSessionState(WebsocketSessionState state) {
        this.websocketSessionState = state;
        this.timesMillisSinceNoWebsocketSessionsExist = state == WebsocketSessionState.AllWebsocketSessionsAreGone ? System.currentTimeMillis() : -1L;
    }

    static enum WebsocketSessionState {
        NeverHadAWebsocketSession,
        ThereAreWebsocketSessions,
        AllWebsocketSessionsAreGone;

    }
}

